/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ets.manufacturer;

import com.tridiumX.knxnetIp.ets.BEtsImportableSubFileComponent;
import com.tridiumX.knxnetIp.ets.BEtsProjectFile;
import com.tridiumX.knxnetIp.ets.BEtsSubFileEntry;
import com.tridiumX.knxnetIp.ets.enums.BEtsAttributeTypeEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsNameSpaceEnum;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsApplicationProgram;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsApplicationProgramRef;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsHardware;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsHardware2Program;
import com.tridiumX.knxnetIp.xml.XmlChildImportSpec;
import com.tridiumX.knxnetIp.xml.XmlPropertyImportSpec;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="xmlNameSpace", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1), @NiagaraProperty(name="manufacturerRefId", type="String", defaultValue="KnxStrings.EMPTY_STRING", flags=1)})
public final class BEtsManufacturerData
extends BEtsImportableSubFileComponent {
    public static final Property xmlNameSpace = BEtsManufacturerData.newProperty((int)1, (String)"", null);
    public static final Property manufacturerRefId = BEtsManufacturerData.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BEtsManufacturerData.class);
    private static final XmlPropertyImportSpec[] XML_PROPERTY_SPECS = new XmlPropertyImportSpec[]{XmlPropertyImportSpec.make(xmlNameSpace, "KNX", "xmlns", BEtsAttributeTypeEnum.xs_string), XmlPropertyImportSpec.make(manufacturerRefId, "Manufacturer", "RefId", BEtsAttributeTypeEnum.knx_IDREF)};
    public static final XmlChildImportSpec[] XML_CHILDREN_SPECS = new XmlChildImportSpec[]{XmlChildImportSpec.make("Hardware", BEtsHardware.TYPE.getTypeName(), "Hardware"), XmlChildImportSpec.make("ApplicationProgram", BEtsApplicationProgram.TYPE.getTypeName(), "ApplicationPrograms")};

    public String getXmlNameSpace() {
        return this.getString(xmlNameSpace);
    }

    public void setXmlNameSpace(String v) {
        this.setString(xmlNameSpace, v, null);
    }

    public String getManufacturerRefId() {
        return this.getString(manufacturerRefId);
    }

    public void setManufacturerRefId(String v) {
        this.setString(manufacturerRefId, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getIdPropertyName() {
        return manufacturerRefId.getName();
    }

    @Override
    public XmlPropertyImportSpec[] getImportSpecs() {
        return XML_PROPERTY_SPECS;
    }

    @Override
    public XmlChildImportSpec[] getImportChildSpecs() {
        return XML_CHILDREN_SPECS;
    }

    @Override
    public String getFileNameInZip(BEtsNameSpaceEnum targetNamespace) {
        return "Hardware.xml";
    }

    @Override
    public BEtsSubFileEntry[] getSubFiles(BEtsProjectFile etsProjectFile) throws Exception {
        String[] hardware2ProgramIds = etsProjectFile.getHardware2ProgramIds();
        ArrayList<BEtsSubFileEntry> vSubFiles = new ArrayList<BEtsSubFileEntry>(1);
        for (String hardware2ProgramId : hardware2ProgramIds) {
            BEtsApplicationProgramRef[] applicationProgramRefs;
            String[] parts = TextUtil.split((String)hardware2ProgramId, (char)'_');
            if (!parts[0].equals(this.getManufacturerRefId())) continue;
            BEtsHardware hardware = (BEtsHardware)this.get(SlotPath.escape((String)(parts[0] + '_' + parts[1])));
            BEtsHardware2Program hardware2Program = (BEtsHardware2Program)hardware.get(SlotPath.escape((String)hardware2ProgramId));
            for (BEtsApplicationProgramRef appRef : applicationProgramRefs = (BEtsApplicationProgramRef[])hardware2Program.getChildren(BEtsApplicationProgramRef.class)) {
                String sApplicationProgramRefId = appRef.getRefId();
                if (sApplicationProgramRefId.equals("")) continue;
                BEtsSubFileEntry subFileEntry = new BEtsSubFileEntry();
                subFileEntry.childId = sApplicationProgramRefId;
                subFileEntry.fileNameInZip = sApplicationProgramRefId + ".xml";
                subFileEntry.etsType = BEtsApplicationProgram.TYPE;
                vSubFiles.add(subFileEntry);
            }
        }
        BEtsSubFileEntry[] subFileEntries = vSubFiles.toArray(new BEtsSubFileEntry[0]);
        if (log.isLoggable(Level.FINE)) {
            log.fine("subFileEntries.length = " + subFileEntries.length);
        }
        return subFileEntries;
    }
}

