/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.ets.job;

import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import com.tridiumX.knxnetIp.enums.BKnxComObjectSizeEnum;
import com.tridiumX.knxnetIp.ets.BEtsImportableComponent;
import com.tridiumX.knxnetIp.ets.BEtsProjectFile;
import com.tridiumX.knxnetIp.ets.EtsProjectImportUtil;
import com.tridiumX.knxnetIp.ets.EtsUtil;
import com.tridiumX.knxnetIp.ets.IEtsGroupRangesContainer;
import com.tridiumX.knxnetIp.ets.enums.BEtsComObjectPriorityEnum;
import com.tridiumX.knxnetIp.ets.enums.BEtsGroupAddressStyleEnum;
import com.tridiumX.knxnetIp.ets.job.BEtsProjectFileImportJob;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsApplicationProgram;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsApplicationProgramRef;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsHardware;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsHardware2Program;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsParameter;
import com.tridiumX.knxnetIp.ets.manufacturer.BEtsProduct;
import com.tridiumX.knxnetIp.ets.project.BEtsArea;
import com.tridiumX.knxnetIp.ets.project.BEtsComObjectInstanceRef;
import com.tridiumX.knxnetIp.ets.project.BEtsConnector;
import com.tridiumX.knxnetIp.ets.project.BEtsDeviceInstance;
import com.tridiumX.knxnetIp.ets.project.BEtsGroupAddress;
import com.tridiumX.knxnetIp.ets.project.BEtsGroupRange;
import com.tridiumX.knxnetIp.ets.project.BEtsInstallation;
import com.tridiumX.knxnetIp.ets.project.BEtsLine;
import com.tridiumX.knxnetIp.ets.project.BEtsProject;
import com.tridiumX.knxnetIp.ets.project.BEtsReceive;
import com.tridiumX.knxnetIp.ets.project.BEtsSegment;
import com.tridiumX.knxnetIp.wb.BImportedDevice;
import com.tridiumX.knxnetIp.wb.BImportedEtsProjectFile;
import com.tridiumX.knxnetIp.wb.BImportedPoint;
import com.tridiumX.knxnetIp.wb.BImportedPointGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;

public class EtsProjectInterpreter {
    protected HashMap<String, ArrayList<BEtsImportableComponent>> referersMap;
    protected int totalAddresses;
    protected int currentAddress;
    protected final BEtsProjectFile projectFile;
    protected final BEtsProjectFileImportJob job;
    protected static final Logger log = Logger.getLogger(BEtsProjectFile.TYPE.getModule().getModuleName() + ".etsImport");

    public EtsProjectInterpreter(BEtsProjectFile projectFile, BEtsProjectFileImportJob job) {
        this.projectFile = projectFile;
        this.job = job;
    }

    public void interpretEtsElementsAsImportedDevicesAndPoints(BEtsProjectFileImportJob job) throws Exception {
        BEtsProject[] projects;
        for (BEtsProject project : projects = (BEtsProject[])this.projectFile.getChildren(BEtsProject.class)) {
            if (!job.getJobState().isRunning()) {
                return;
            }
            BEtsGroupAddressStyleEnum etsGroupAddressStyle = project.getGroupAddressStyle();
            BKnxAddressStyleEnum groupAddressStyle = BKnxAddressStyleEnum.make((int)etsGroupAddressStyle.getOrdinal());
            job.getImportedEtsProjectFile().setGroupAddressStyle(groupAddressStyle);
            BEtsInstallation[] installations = (BEtsInstallation[])project.getChildren(BEtsInstallation.class);
            if (installations.length > 0) {
                for (BEtsInstallation installation : installations) {
                    this.totalAddresses += EtsProjectInterpreter.countGroupAddresses(installation);
                    job.getImportedEtsProjectFile().setGroupAddressCount(this.totalAddresses);
                }
                for (BEtsInstallation installation : installations) {
                    if (!job.getJobState().isRunning()) {
                        return;
                    }
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Processing installation " + installation.getName() + " at slotpath : " + installation.getSlotPath());
                    }
                    this.interpretTopology(installation, job);
                    this.preFetchReferers(installation);
                    this.interpretGroupRangesAsImportedPoints(0, groupAddressStyle, installation, job.getImportedEtsProjectFile().getImportedPoints(), job);
                }
                continue;
            }
            throw new Exception("No 'Installations' found in Project '" + project.getProjectName() + "'.");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void interpretGroupRangesAsImportedPoints(int iDepth, BKnxAddressStyleEnum groupAddressStyle, IEtsGroupRangesContainer parentGroupRange, BImportedPointGroup parentPointGroup, BEtsProjectFileImportJob job) throws Exception {
        try {
            BEtsGroupRange[] aGroupRanges;
            BImportedEtsProjectFile importedFile = job.getImportedEtsProjectFile();
            if (importedFile != null && importedFile.getMaxGroupDepth() < iDepth + 1) {
                importedFile.setMaxGroupDepth(iDepth + 1);
            }
            if ((aGroupRanges = parentGroupRange.getGroupRanges()) == null) return;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Processing group ranges, aGroupRanges.length = \"" + aGroupRanges.length + '\"');
            }
            for (int k = 0; k < aGroupRanges.length; ++k) {
                if (!job.getJobState().isRunning()) {
                    return;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Processing group range number " + k + " which is at slotpath " + aGroupRanges[k].getSlotPath());
                }
                String knxId = "";
                try {
                    BEtsGroupRange knxGroupRange = aGroupRanges[k];
                    knxId = knxGroupRange.getGroupRangeId();
                    BImportedPointGroup importedPointGroup = BImportedPointGroup.make(knxId, iDepth, knxGroupRange.getGroupRangeName());
                    String sGroupRangeName = SlotPath.escape((String)importedPointGroup.getGroupName());
                    if (parentPointGroup.get(sGroupRangeName) != null) {
                        sGroupRangeName = sGroupRangeName + SlotPath.escape((String)(" (" + knxGroupRange.getRangeStart() + " - " + knxGroupRange.getRangeEnd() + ")"));
                    }
                    if (parentPointGroup.get(sGroupRangeName) != null) {
                        sGroupRangeName = sGroupRangeName + SlotPath.escape((String)(" {Id = '" + knxGroupRange.getGroupRangeId() + "'}"));
                    }
                    parentPointGroup.add(sGroupRangeName, (BValue)importedPointGroup);
                    job.logMessage("Group - '" + SlotPath.unescape((String)sGroupRangeName) + '\'');
                    this.interpretGroupRangesAsImportedPoints(iDepth + 1, groupAddressStyle, knxGroupRange, importedPointGroup, job);
                    this.interpretGroupAddressesAsImportedPoints(iDepth + 1, groupAddressStyle, knxGroupRange, importedPointGroup, job);
                    continue;
                }
                catch (Exception ex) {
                    String sErr = EtsProjectImportUtil.interpretGroupRangeError("interpretGroupRangesAsImportedPoints", "looping through the 'GroupRanges' of an 'IEtsGroupRangesContainer'", knxId, iDepth, parentGroupRange);
                    if (job.getImportProblemReports().add(sErr + "\n\r" + ex)) return;
                }
            }
            return;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new Exception("There was a problem in 'interpretGroupRangesAsImportedPoints' where iDepth = '" + iDepth + "' & parentGroupRange = '" + parentGroupRange.toString() + "'.", t);
        }
    }

    private void interpretGroupAddressesAsImportedPoints(int iDepth, BKnxAddressStyleEnum groupAddressStyle, BEtsGroupRange knxGroupRange, BImportedPointGroup importedPointGroup, BEtsProjectFileImportJob job) throws Exception {
        BEtsGroupAddress[] aGroupAddresses = (BEtsGroupAddress[])knxGroupRange.getChildren(BEtsGroupAddress.class);
        for (int i = 0; i < aGroupAddresses.length; ++i) {
            if (!job.getJobState().isRunning()) {
                return;
            }
            String exExtra = "";
            try {
                exExtra = exExtra + "/n/ri = '" + i + "'";
                BEtsGroupAddress groupAddress = aGroupAddresses[i];
                String addressKnxId = groupAddress.getGroupAddressId();
                exExtra = exExtra + "/n/raddressKnxId = '" + addressKnxId + "'";
                BEtsImportableComponent[] referers = this.getReferers(addressKnxId);
                String dataPointType = groupAddress.getDatapointType();
                BImportedPoint importedPoint = BImportedPoint.make(addressKnxId, iDepth, groupAddress.getGroupAddressName(), groupAddressStyle, groupAddress.getAddress());
                if (referers.length > 0) {
                    BKnxComObjectSizeEnum comObjectSize = BKnxComObjectSizeEnum.unknownSize;
                    BEtsComObjectPriorityEnum priority = BEtsComObjectPriorityEnum.DEFAULT;
                    boolean sendNotReceive = true;
                    boolean isActive = false;
                    boolean readFlag = false;
                    boolean writeFlag = false;
                    boolean communicationFlag = false;
                    boolean transmitFlag = false;
                    boolean updateFlag = false;
                    boolean readOnInitFlag = false;
                    for (BEtsImportableComponent referer : referers) {
                        BEtsComObjectPriorityEnum connectorPriority;
                        if (referer instanceof BEtsReceive) {
                            sendNotReceive = false;
                        }
                        BEtsComObjectInstanceRef instanceRef = EtsProjectInterpreter.getInstanceRef(referer);
                        BKnxComObjectSizeEnum connectorSize = instanceRef.getObjectSize(this.projectFile);
                        if (comObjectSize.equals((Object)BKnxComObjectSizeEnum.unknownSize)) {
                            comObjectSize = connectorSize;
                        } else if (!connectorSize.equals((Object)BKnxComObjectSizeEnum.unknownSize) && !connectorSize.equals((Object)comObjectSize)) {
                            throw new IllegalStateException("Different 'ComObjectSize's found for GroupAddress " + addressKnxId);
                        }
                        if (dataPointType.equals("")) {
                            dataPointType = instanceRef.getDatapointType(this.projectFile);
                        }
                        if ((connectorPriority = instanceRef.getPriority(this.projectFile)).getOrdinal() > priority.getOrdinal()) {
                            priority = connectorPriority;
                        }
                        isActive |= instanceRef.getIsActive();
                        readFlag |= instanceRef.getReadFlag(this.projectFile);
                        writeFlag |= instanceRef.getWriteFlag(this.projectFile);
                        communicationFlag |= instanceRef.getCommunicationFlag(this.projectFile);
                        transmitFlag |= instanceRef.getTransmitFlag(this.projectFile);
                        updateFlag |= instanceRef.getUpdateFlag(this.projectFile);
                        readOnInitFlag |= instanceRef.getReadOnInitFlag(this.projectFile);
                    }
                    importedPoint.setComObjectSize(comObjectSize);
                    importedPoint.setPriority(priority);
                    importedPoint.setSendNotReceive(sendNotReceive);
                    importedPoint.setIsActive(isActive);
                    importedPoint.setReadFlag(readFlag);
                    importedPoint.setWriteFlag(writeFlag);
                    importedPoint.setCommunicationFlag(communicationFlag);
                    importedPoint.setTransmitFlag(transmitFlag);
                    importedPoint.setUpdateFlag(updateFlag);
                    importedPoint.setReadOnInitFlag(readOnInitFlag);
                    exExtra = exExtra + "/n/rdataPointType = '" + dataPointType + "'";
                    importedPoint.setDataValueTypeId(dataPointType);
                    String sGroupAddressName = SlotPath.escape((String)importedPoint.getPointName());
                    if (importedPointGroup.get(sGroupAddressName) != null) {
                        sGroupAddressName = sGroupAddressName + SlotPath.escape((String)(" (" + groupAddress.getAddress() + ")"));
                    }
                    if (importedPointGroup.get(sGroupAddressName) != null) {
                        sGroupAddressName = sGroupAddressName + SlotPath.escape((String)(" {Id = '" + groupAddress.getGroupAddressId() + "'}"));
                    }
                    importedPointGroup.add(sGroupAddressName, (BValue)importedPoint);
                    String safeName = SlotPath.unescape((String)sGroupAddressName);
                    EtsProjectInterpreter.objectSizeCheck(importedPoint, job, safeName);
                    job.logMessage(String.format("Processed GroupAddress - '%s'", safeName));
                } else if (job.includeUnassociatedGroupAdresses()) {
                    EtsProjectImportUtil.addUnassociatedGroupAddressToGroup(importedPointGroup, importedPoint, groupAddress, groupAddressStyle, job);
                }
                this.incrementProgress(job);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                String sErr = EtsProjectImportUtil.interpretGroupRangeError("interpretGroupAddressesAsImportedPoints", "looping through the 'aGroupAddresses' of a 'BEtsGroupRange'", knxGroupRange.getGroupRangeId(), iDepth, knxGroupRange);
                sErr = sErr + " exExtra = " + exExtra;
                if (job.getImportProblemReports().add(sErr + "\n\r" + ex)) break;
            }
        }
    }

    public BEtsImportableComponent[] getReferers(String knxId) throws Exception {
        try {
            ArrayList<BEtsImportableComponent> al;
            if (!knxId.equals("") && (al = this.referersMap.get(knxId)) != null) {
                BEtsImportableComponent[] a = new BEtsImportableComponent[al.size()];
                return al.toArray(a);
            }
            return new BEtsImportableComponent[0];
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    private static BEtsComObjectInstanceRef getInstanceRef(BEtsImportableComponent referer) {
        if (referer instanceof BEtsConnector) {
            return (BEtsComObjectInstanceRef)((BEtsConnector)referer.as(BEtsConnector.class)).getParent();
        }
        if (referer instanceof BEtsComObjectInstanceRef) {
            return (BEtsComObjectInstanceRef)referer.as(BEtsComObjectInstanceRef.class);
        }
        throw new BajaRuntimeException("Unrecognized referer type: " + referer.getClass().getSimpleName());
    }

    private static void objectSizeCheck(BImportedPoint importedPoint, BEtsProjectFileImportJob job, String pointName) {
        if (importedPoint.getComObjectSize().equals((Object)BKnxComObjectSizeEnum.unknownSize)) {
            String warning = String.format("WARN - Unable to determine object size for - '%s'", pointName);
            BKnxComObjectSizeEnum defaultForDataType = EtsProjectImportUtil.getDefaultObjectSizeForDataType(importedPoint.getDataValueTypeId());
            if (!defaultForDataType.equals((Object)BKnxComObjectSizeEnum.unknownSize)) {
                importedPoint.setComObjectSize(defaultForDataType);
                warning = warning + ", using default for datatype: " + defaultForDataType;
            }
            job.logMessage(warning);
        }
    }

    private static int countGroupAddresses(IEtsGroupRangesContainer parentGroupRange) {
        int iCount = 0;
        if (parentGroupRange instanceof BEtsGroupRange) {
            iCount += ((BEtsGroupAddress[])((BEtsGroupRange)parentGroupRange).getChildren(BEtsGroupAddress.class)).length;
        }
        for (BEtsGroupRange range : parentGroupRange.getGroupRanges()) {
            iCount += EtsProjectInterpreter.countGroupAddresses(range);
        }
        return iCount;
    }

    private void interpretTopology(BEtsInstallation installation, BEtsProjectFileImportJob job) throws Exception {
        BEtsArea[] areas;
        for (BEtsArea area : areas = (BEtsArea[])installation.getChildren(BEtsArea.class)) {
            BEtsLine[] lines;
            for (BEtsLine line : lines = (BEtsLine[])area.getChildren(BEtsLine.class)) {
                this.searchLine(line);
            }
        }
    }

    protected void searchLine(BEtsLine line) throws Exception {
        BEtsSegment[] segments;
        for (BEtsSegment segment : segments = (BEtsSegment[])line.getChildren(BEtsSegment.class)) {
            this.searchDeviceInstances(segment, line);
        }
    }

    protected void searchDeviceInstances(BEtsImportableComponent parentComponent, BEtsLine currentLine) throws Exception {
        BEtsDeviceInstance[] deviceInstances;
        for (BEtsDeviceInstance deviceInstance : deviceInstances = (BEtsDeviceInstance[])parentComponent.getChildren(BEtsDeviceInstance.class)) {
            BValue product;
            String hardwareToProgramRefId = deviceInstance.getHardware2ProgramRefId();
            BEtsHardware2Program hardware2Program = this.getHardware2Program(hardwareToProgramRefId);
            BEtsHardware hardware = (BEtsHardware)hardware2Program.getParent();
            BEtsApplicationProgramRef[] applicationProgramRefs = (BEtsApplicationProgramRef[])hardware2Program.getChildren(BEtsApplicationProgramRef.class);
            if (applicationProgramRefs.length <= 0) continue;
            BEtsApplicationProgramRef applicationProgramRef = applicationProgramRefs[0];
            BEtsApplicationProgram applicationProgram = (BEtsApplicationProgram)this.projectFile.getReferee(applicationProgramRef.getRefId());
            String maskVersion = applicationProgram.getMaskVersion();
            boolean isIpDevice = false;
            if (hardware.getIsIpEnabled()) {
                isIpDevice = true;
            } else {
                BEtsParameter[] parameters;
                for (BEtsParameter parameter : parameters = (BEtsParameter[])applicationProgram.getChildren(BEtsParameter.class)) {
                    String sName = parameter.getParameterName().toLowerCase();
                    if (EtsUtil.parameterIsIpDevice(sName)) {
                        isIpDevice = true;
                        break;
                    }
                    String sText = parameter.getText().toLowerCase();
                    if (!EtsUtil.parameterIsIpDevice(sText)) continue;
                    isIpDevice = true;
                    break;
                }
            }
            if (!isIpDevice) continue;
            BImportedDevice importedDevice = new BImportedDevice();
            importedDevice.setKnxId(deviceInstance.getDeviceInstanceId());
            importedDevice.setIndividualDeviceAddress(BIndividualDeviceAddress.make((int)((BEtsArea)currentLine.getParent()).getAddress(), (int)currentLine.getAddress(), (int)deviceInstance.getAddress()));
            String deviceName = deviceInstance.getDeviceInstanceName();
            if (deviceName.equals("") && (product = hardware.get(SlotPath.escape((String)deviceInstance.getProductRefId()))) instanceof BEtsProduct) {
                deviceName = ((BEtsProduct)product).getText();
            }
            if (deviceName.equals("")) {
                deviceName = importedDevice.getIndividualDeviceAddress().getFriendlyAddress();
            }
            importedDevice.setDeviceName(deviceName);
            importedDevice.setMaskVersion(maskVersion);
            if (!importedDevice.isValid()) continue;
            BValue existingDeviceSlot = this.job.getImportedEtsProjectFile().getImportedDevices().get(SlotPath.escape((String)importedDevice.getDeviceName()));
            if (existingDeviceSlot != null) {
                importedDevice.setDeviceName(importedDevice.getIndividualDeviceAddress().getFriendlyAddress() + " " + importedDevice.getDeviceName());
            }
            this.job.getImportedEtsProjectFile().getImportedDevices().add(SlotPath.escape((String)(importedDevice.getDeviceName() + (existingDeviceSlot == null ? "" : " - " + importedDevice.getKnxId()))), (BValue)importedDevice);
        }
    }

    public BEtsHardware2Program getHardware2Program(String hardwareToProgramRefId) {
        try {
            BEtsImportableComponent result = this.projectFile.getReferee(hardwareToProgramRefId);
            if (result instanceof BEtsHardware2Program) {
                return (BEtsHardware2Program)result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void preFetchReferers(BEtsInstallation installation) {
        this.referersMap = new HashMap(this.totalAddresses);
        String groupAddressPrefix = ((BEtsProject)installation.getParent()).getProjectId() + "-" + installation.getInstallationId() + "_";
        EtsProjectInterpreter.applyToAll(installation, BEtsComObjectInstanceRef.class, ref -> {
            String[] groupAddressLinks;
            for (String groupAddressLink : groupAddressLinks = TextUtil.split((String)ref.getGroupAddressLinks(), (char)' ')) {
                String key = groupAddressPrefix + groupAddressLink;
                if (!this.referersMap.containsKey(key)) {
                    ArrayList al = new ArrayList();
                    this.referersMap.put(key, al);
                }
                this.referersMap.get(key).add((BEtsImportableComponent)ref);
            }
        });
    }

    private void incrementProgress(BEtsProjectFileImportJob job) {
        if (job != null) {
            job.updateProgress(++this.currentAddress * 100 / this.totalAddresses);
        }
    }

    public static <T> void applyToAll(BEtsImportableComponent source, Class<T> targetType, Consumer<T> task) {
        BEtsImportableComponent[] children;
        for (BEtsImportableComponent child : children = (BEtsImportableComponent[])source.getChildren(BEtsImportableComponent.class)) {
            if (child.getClass().isAssignableFrom(targetType)) {
                task.accept(child);
                continue;
            }
            EtsProjectInterpreter.applyToAll(child, targetType, task);
        }
    }
}

