/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.Utils;

public class TextReporter
extends TestListenerAdapter {
    private final int m_verbose;
    private final String m_testName;

    public TextReporter(String testName, int verbose) {
        this.m_testName = testName;
        this.m_verbose = verbose;
    }

    @Override
    public void onFinish(ITestContext context) {
        if (this.m_verbose >= 2) {
            this.logResults();
        }
    }

    private static List<ITestNGMethod> resultsToMethods(List<ITestResult> results) {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>(results.size());
        for (ITestResult tr : results) {
            result.add(tr.getMethod());
        }
        return result;
    }

    private void logResults() {
        String stackTrace;
        Throwable ex;
        for (ITestResult tr : this.getConfigurationFailures()) {
            ex = tr.getThrowable();
            stackTrace = "";
            if (ex != null && this.m_verbose >= 2) {
                stackTrace = Utils.shortStackTrace(ex, false);
            }
            this.logResult("FAILED CONFIGURATION", Utils.detailedMethodName(tr.getMethod(), false), tr.getMethod().getDescription(), stackTrace, tr.getParameters(), tr.getMethod().getConstructorOrMethod().getParameterTypes());
        }
        for (ITestResult tr : this.getConfigurationSkips()) {
            this.logResult("SKIPPED CONFIGURATION", Utils.detailedMethodName(tr.getMethod(), false), tr.getMethod().getDescription(), null, tr.getParameters(), tr.getMethod().getConstructorOrMethod().getParameterTypes());
        }
        for (ITestResult tr : this.getPassedTests()) {
            this.logResult("PASSED", tr, null);
        }
        for (ITestResult tr : this.getFailedTests()) {
            ex = tr.getThrowable();
            stackTrace = "";
            if (ex != null && this.m_verbose >= 2) {
                stackTrace = Utils.shortStackTrace(ex, false);
            }
            this.logResult("FAILED", tr, stackTrace);
        }
        Iterator<ITestResult> iterator = this.getSkippedTests().iterator();
        while (iterator.hasNext()) {
            ITestResult tr;
            Throwable throwable = (tr = iterator.next()).getThrowable();
            this.logResult("SKIPPED", tr, throwable != null ? Utils.shortStackTrace(throwable, false) : null);
        }
        List<ITestNGMethod> ft = TextReporter.resultsToMethods(this.getFailedTests());
        StringBuilder logBuf = new StringBuilder("\n===============================================\n");
        logBuf.append("    ").append(this.m_testName).append("\n");
        logBuf.append("    Tests run: ").append(Utils.calculateInvokedMethodCount(this.getAllTestMethods())).append(", Failures: ").append(Utils.calculateInvokedMethodCount(ft)).append(", Skips: ").append(Utils.calculateInvokedMethodCount(TextReporter.resultsToMethods(this.getSkippedTests())));
        int confFailures = this.getConfigurationFailures().size();
        int confSkips = this.getConfigurationSkips().size();
        if (confFailures > 0 || confSkips > 0) {
            logBuf.append("\n").append("    Configuration Failures: ").append(confFailures).append(", Skips: ").append(confSkips);
        }
        logBuf.append("\n===============================================\n");
        this.logResult("", logBuf.toString());
    }

    private void logResult(String status, ITestResult tr, String stackTrace) {
        this.logResult(status, tr.getName(), tr.getMethod().getDescription(), stackTrace, tr.getParameters(), tr.getMethod().getConstructorOrMethod().getParameterTypes());
    }

    private void logResult(String status, String message) {
        StringBuilder buf = new StringBuilder();
        if (Utils.isStringNotBlank(status)) {
            buf.append(status).append(": ");
        }
        buf.append(message);
        System.out.println(buf);
    }

    private void logResult(String status, String name, String description, String stackTrace, Object[] params, Class<?>[] paramTypes) {
        int i;
        StringBuilder msg = new StringBuilder(name);
        if (null != params && params.length > 0) {
            msg.append("(");
            if (params.length != paramTypes.length) {
                msg.append(name).append(": Wrong number of arguments were passed by ").append("the Data Provider: found ").append(params.length).append(" but ").append("expected ").append(paramTypes.length).append(")");
            } else {
                for (i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(Utils.toString(params[i], paramTypes[i]));
                }
                msg.append(")");
            }
        }
        if (!Utils.isStringEmpty(description)) {
            msg.append("\n");
            for (i = 0; i < status.length() + 2; ++i) {
                msg.append(" ");
            }
            msg.append(description);
        }
        if (!Utils.isStringEmpty(stackTrace)) {
            msg.append("\n").append(stackTrace);
        }
        this.logResult(status, msg.toString());
    }
}

