/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IInvokedMethod;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlSuite;

public class EmailableReporter
implements IReporter {
    private static final Logger L = Logger.getLogger(EmailableReporter.class);
    private PrintWriter m_out;
    private int m_row;
    private Integer m_testIndex;
    private int m_methodIndex;
    private String fileName = "emailable-report.html";
    private static final String JVM_ARG = "emailable.report.name";

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void generateReport(List<XmlSuite> xml, List<ISuite> suites, String outdir) {
        try {
            this.m_out = this.createWriter(outdir);
        }
        catch (IOException e) {
            L.error("output file", e);
            return;
        }
        this.startHtml(this.m_out);
        this.generateSuiteSummaryReport(suites);
        this.generateMethodSummaryReport(suites);
        this.generateMethodDetailReport(suites);
        this.endHtml(this.m_out);
        this.m_out.flush();
        this.m_out.close();
    }

    protected PrintWriter createWriter(String outdir) throws IOException {
        new File(outdir).mkdirs();
        String jvmArg = System.getProperty(JVM_ARG);
        if (jvmArg != null && !jvmArg.trim().isEmpty()) {
            this.fileName = jvmArg;
        }
        return new PrintWriter(Files.newBufferedWriter(new File(outdir, this.fileName).toPath(), StandardCharsets.UTF_8, new OpenOption[0]));
    }

    protected void generateMethodSummaryReport(List<ISuite> suites) {
        this.m_methodIndex = 0;
        this.startResultSummaryTable();
        int testIndex = 1;
        for (ISuite suite : suites) {
            if (suites.size() > 1) {
                this.titleRow(suite.getName(), 5);
            }
            Map<String, ISuiteResult> r = suite.getResults();
            for (ISuiteResult r2 : r.values()) {
                ITestContext testContext = r2.getTestContext();
                String testName = testContext.getName();
                this.m_testIndex = testIndex;
                this.resultSummary(suite, testContext.getFailedConfigurations(), testName, "failed", " (configuration methods)");
                this.resultSummary(suite, testContext.getFailedTests(), testName, "failed", "");
                this.resultSummary(suite, testContext.getSkippedConfigurations(), testName, "skipped", " (configuration methods)");
                this.resultSummary(suite, testContext.getSkippedTests(), testName, "skipped", "");
                this.resultSummary(suite, testContext.getPassedTests(), testName, "passed", "");
                ++testIndex;
            }
        }
        this.m_out.println("</table>");
    }

    protected void generateMethodDetailReport(List<ISuite> suites) {
        this.m_methodIndex = 0;
        for (ISuite suite : suites) {
            Map<String, ISuiteResult> r = suite.getResults();
            for (ISuiteResult r2 : r.values()) {
                ITestContext testContext = r2.getTestContext();
                if (r.values().size() > 0) {
                    this.m_out.println("<h1>" + testContext.getName() + "</h1>");
                }
                this.resultDetail(testContext.getFailedConfigurations());
                this.resultDetail(testContext.getFailedTests());
                this.resultDetail(testContext.getSkippedConfigurations());
                this.resultDetail(testContext.getSkippedTests());
                this.resultDetail(testContext.getPassedTests());
            }
        }
    }

    private void resultSummary(ISuite suite, IResultMap tests, String testname, String style, String details) {
        if (!tests.getAllResults().isEmpty()) {
            StringBuilder buff = new StringBuilder();
            String lastClassName = "";
            int mq = 0;
            int cq = 0;
            for (ITestNGMethod method : this.getMethodSet(tests, suite)) {
                ++this.m_row;
                ++this.m_methodIndex;
                ITestClass testClass = method.getTestClass();
                String className = testClass.getName();
                if (mq == 0) {
                    String id = this.m_testIndex == null ? null : "t" + Integer.toString(this.m_testIndex);
                    this.titleRow(testname + " &#8212; " + style + details, 5, id);
                    this.m_testIndex = null;
                }
                if (!className.equalsIgnoreCase(lastClassName)) {
                    if (mq > 0) {
                        this.m_out.print("<tr class=\"" + style + (++cq % 2 == 0 ? "even" : "odd") + "\"><td");
                        if (mq > 1) {
                            this.m_out.print(" rowspan=\"" + mq + "\"");
                        }
                        this.m_out.println(">" + lastClassName + "</td>" + buff);
                    }
                    mq = 0;
                    buff.setLength(0);
                    lastClassName = className;
                }
                Set<ITestResult> resultSet = tests.getResults(method);
                long end = Long.MIN_VALUE;
                long start = Long.MAX_VALUE;
                for (ITestResult testResult : tests.getResults(method)) {
                    if (testResult.getEndMillis() > end) {
                        end = testResult.getEndMillis();
                    }
                    if (testResult.getStartMillis() >= start) continue;
                    start = testResult.getStartMillis();
                }
                if (++mq > 1) {
                    buff.append("<tr class=\"").append(style).append(cq % 2 == 0 ? "odd" : "even").append("\">");
                }
                String description = method.getDescription();
                String testInstanceName = resultSet.toArray(new ITestResult[0])[0].getTestName();
                buff.append("<td><a href=\"#m").append(this.m_methodIndex).append("\">").append(this.qualifiedName(method)).append(" ");
                if (description != null && !description.isEmpty()) {
                    buff.append("(\"").append(description).append("\")");
                }
                buff.append("</a>");
                if (testInstanceName != null) {
                    buff.append("<br>(").append(testInstanceName).append(")");
                }
                buff.append("</td>").append("<td class=\"numi\">").append(resultSet.size()).append("</td>").append("<td>").append(start).append("</td>").append("<td class=\"numi\">").append(end - start).append("</td>").append("</tr>");
            }
            if (mq > 0) {
                this.m_out.print("<tr class=\"" + style + (++cq % 2 == 0 ? "even" : "odd") + "\"><td");
                if (mq > 1) {
                    this.m_out.print(" rowspan=\"" + mq + "\"");
                }
                this.m_out.println(">" + lastClassName + "</td>" + buff);
            }
        }
    }

    private void startResultSummaryTable() {
        this.tableStart("methodOverview", "summary");
        this.m_out.println("<tr><th>Class</th><th>Method</th><th># of<br/>Scenarios</th><th>Start</th><th>Time<br/>(ms)</th></tr>");
        this.m_row = 0;
    }

    private String qualifiedName(ITestNGMethod method) {
        StringBuilder addon = new StringBuilder();
        String[] groups = method.getGroups();
        int length = groups.length;
        if (length > 0 && !"basic".equalsIgnoreCase(groups[0])) {
            addon.append("(");
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    addon.append(", ");
                }
                addon.append(groups[i]);
            }
            addon.append(")");
        }
        return "<b>" + method.getMethodName() + "</b> " + addon;
    }

    private void resultDetail(IResultMap tests) {
        for (ITestResult result : tests.getAllResults()) {
            ITestNGMethod method = result.getMethod();
            ++this.m_methodIndex;
            String cname = method.getTestClass().getName();
            this.m_out.println("<h2 id=\"m" + this.m_methodIndex + "\">" + cname + ":" + method.getMethodName() + "</h2>");
            this.generateForResult(result, method);
            this.m_out.println("<p class=\"totop\"><a href=\"#summary\">back to summary</a></p>");
        }
    }

    private void generateForResult(ITestResult ans, ITestNGMethod method) {
        boolean hasThrowable;
        List<String> msgs;
        boolean hasParameters;
        Object[] parameters = ans.getParameters();
        boolean bl = hasParameters = parameters != null && parameters.length > 0;
        if (hasParameters) {
            this.tableStart("result", null);
            this.m_out.print("<tr class=\"param\">");
            for (int x = 1; x <= parameters.length; ++x) {
                this.m_out.print("<th>Parameter #" + x + "</th>");
            }
            this.m_out.println("</tr>");
            this.m_out.print("<tr class=\"param stripe\">");
            for (Object p : parameters) {
                this.m_out.println("<td>" + Utils.escapeHtml(Utils.toString(p)) + "</td>");
            }
            this.m_out.println("</tr>");
        }
        boolean hasReporterOutput = !(msgs = Reporter.getOutput(ans)).isEmpty();
        Throwable exception = ans.getThrowable();
        boolean bl2 = hasThrowable = exception != null;
        if (hasReporterOutput || hasThrowable) {
            if (hasParameters) {
                this.m_out.print("<tr><td");
                if (parameters.length > 1) {
                    this.m_out.print(" colspan=\"" + parameters.length + "\"");
                }
                this.m_out.println(">");
            } else {
                this.m_out.println("<div>");
            }
            if (hasReporterOutput) {
                if (hasThrowable) {
                    this.m_out.println("<h3>Test Messages</h3>");
                }
                for (String line : msgs) {
                    this.m_out.println(line + "<br/>");
                }
            }
            if (hasThrowable) {
                boolean wantsMinimalOutput;
                boolean bl3 = wantsMinimalOutput = ans.getStatus() == 1;
                if (hasReporterOutput) {
                    this.m_out.println("<h3>" + (wantsMinimalOutput ? "Expected Exception" : "Failure") + "</h3>");
                }
                this.generateExceptionReport(exception, method);
            }
            if (hasParameters) {
                this.m_out.println("</td></tr>");
            } else {
                this.m_out.println("</div>");
            }
        }
        if (hasParameters) {
            this.m_out.println("</table>");
        }
    }

    protected void generateExceptionReport(Throwable exception, ITestNGMethod method) {
        this.m_out.print("<div class=\"stacktrace\">");
        this.m_out.print(Utils.shortStackTrace(exception, true));
        this.m_out.println("</div>");
    }

    private Collection<ITestNGMethod> getMethodSet(IResultMap tests, ISuite suite) {
        List<Object> r = Lists.newArrayList();
        List<IInvokedMethod> invokedMethods = suite.getAllInvokedMethods();
        for (IInvokedMethod im : invokedMethods) {
            if (!tests.getAllMethods().contains(im.getTestMethod())) continue;
            r.add(im);
        }
        Arrays.sort(r.toArray(new IInvokedMethod[r.size()]), new TestSorter());
        List<ITestNGMethod> result = Lists.newArrayList();
        for (IInvokedMethod iInvokedMethod : r) {
            result.add(iInvokedMethod.getTestMethod());
        }
        for (ITestNGMethod iTestNGMethod : tests.getAllMethods()) {
            if (result.contains(iTestNGMethod)) continue;
            result.add(iTestNGMethod);
        }
        return result;
    }

    public void generateSuiteSummaryReport(List<ISuite> suites) {
        this.tableStart("testOverview", null);
        this.m_out.print("<tr>");
        this.tableColumnStart("Test");
        this.tableColumnStart("Methods<br/>Passed");
        this.tableColumnStart("Scenarios<br/>Passed");
        this.tableColumnStart("# skipped");
        this.tableColumnStart("# failed");
        this.tableColumnStart("Total<br/>Time");
        this.tableColumnStart("Included<br/>Groups");
        this.tableColumnStart("Excluded<br/>Groups");
        this.m_out.println("</tr>");
        DecimalFormat formatter = new DecimalFormat("#,##0.0");
        int qty_tests = 0;
        int qty_pass_m = 0;
        int qty_pass_s = 0;
        int qty_skip = 0;
        int qty_fail = 0;
        long time_start = Long.MAX_VALUE;
        long time_end = Long.MIN_VALUE;
        this.m_testIndex = 1;
        for (ISuite suite : suites) {
            if (suites.size() > 1) {
                this.titleRow(suite.getName(), 8);
            }
            Map<String, ISuiteResult> tests = suite.getResults();
            for (ISuiteResult r : tests.values()) {
                ++qty_tests;
                ITestContext overview = r.getTestContext();
                this.startSummaryRow(overview.getName());
                int q = this.getMethodSet(overview.getPassedTests(), suite).size();
                qty_pass_m += q;
                this.summaryCell(q, Integer.MAX_VALUE);
                q = overview.getPassedTests().size();
                qty_pass_s += q;
                this.summaryCell(q, Integer.MAX_VALUE);
                q = this.getMethodSet(overview.getSkippedTests(), suite).size();
                qty_skip += q;
                this.summaryCell(q, 0);
                q = this.getMethodSet(overview.getFailedTests(), suite).size();
                qty_fail += q;
                this.summaryCell(q, 0);
                time_start = Math.min(overview.getStartDate().getTime(), time_start);
                time_end = Math.max(overview.getEndDate().getTime(), time_end);
                this.summaryCell(formatter.format((double)(overview.getEndDate().getTime() - overview.getStartDate().getTime()) / 1000.0) + " seconds", true);
                this.summaryCell(overview.getIncludedGroups());
                this.summaryCell(overview.getExcludedGroups());
                this.m_out.println("</tr>");
                Integer n = this.m_testIndex;
                Integer n2 = this.m_testIndex = Integer.valueOf(this.m_testIndex + 1);
            }
        }
        if (qty_tests > 1) {
            this.m_out.println("<tr class=\"total\"><td>Total</td>");
            this.summaryCell(qty_pass_m, Integer.MAX_VALUE);
            this.summaryCell(qty_pass_s, Integer.MAX_VALUE);
            this.summaryCell(qty_skip, 0);
            this.summaryCell(qty_fail, 0);
            this.summaryCell(formatter.format((double)(time_end - time_start) / 1000.0) + " seconds", true);
            this.m_out.println("<td colspan=\"2\">&nbsp;</td></tr>");
        }
        this.m_out.println("</table>");
    }

    private void summaryCell(String[] val) {
        StringBuilder b = new StringBuilder();
        for (String v : val) {
            b.append(v).append(" ");
        }
        this.summaryCell(b.toString(), true);
    }

    private void summaryCell(String v, boolean isGood) {
        this.m_out.print("<td class=\"numi" + (isGood ? "" : "_attn") + "\">" + v + "</td>");
    }

    private void startSummaryRow(String label) {
        ++this.m_row;
        this.m_out.print("<tr" + (this.m_row % 2 == 0 ? " class=\"stripe\"" : "") + "><td style=\"text-align:left;padding-right:2em\"><a href=\"#t" + this.m_testIndex + "\">" + label + "</a></td>");
    }

    private void summaryCell(int v, int maxexpected) {
        this.summaryCell(String.valueOf(v), v <= maxexpected);
    }

    private void tableStart(String cssclass, String id) {
        this.m_out.println("<table cellspacing=\"0\" cellpadding=\"0\"" + (cssclass != null ? " class=\"" + cssclass + "\"" : " style=\"padding-bottom:2em\"") + (id != null ? " id=\"" + id + "\"" : "") + ">");
        this.m_row = 0;
    }

    private void tableColumnStart(String label) {
        this.m_out.print("<th>" + label + "</th>");
    }

    private void titleRow(String label, int cq) {
        this.titleRow(label, cq, null);
    }

    private void titleRow(String label, int cq, String id) {
        this.m_out.print("<tr");
        if (id != null) {
            this.m_out.print(" id=\"" + id + "\"");
        }
        this.m_out.println("><th colspan=\"" + cq + "\">" + label + "</th></tr>");
        this.m_row = 0;
    }

    protected void startHtml(PrintWriter out) {
        out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\">");
        out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\">");
        out.println("<head>");
        out.println("<meta charset='utf-8'>");
        out.println("<title>TestNG Report</title>");
        out.println("<style type=\"text/css\">");
        out.println("table {margin-bottom:10px;border-collapse:collapse;empty-cells:show}");
        out.println("td,th {border:1px solid #009;padding:.25em .5em}");
        out.println(".result th {vertical-align:bottom}");
        out.println(".param th {padding-left:1em;padding-right:1em}");
        out.println(".param td {padding-left:.5em;padding-right:2em}");
        out.println(".stripe td,.stripe th {background-color: #E6EBF9}");
        out.println(".numi,.numi_attn {text-align:right}");
        out.println(".total td {font-weight:bold}");
        out.println(".passedodd td {background-color: #0A0}");
        out.println(".passedeven td {background-color: #3F3}");
        out.println(".skippedodd td {background-color: #CCC}");
        out.println(".skippedodd td {background-color: #DDD}");
        out.println(".failedodd td,.numi_attn {background-color: #F33}");
        out.println(".failedeven td,.stripe .numi_attn {background-color: #D00}");
        out.println(".stacktrace {white-space:pre;font-family:monospace}");
        out.println(".totop {font-size:85%;text-align:center;border-bottom:2px solid #000}");
        out.println("</style>");
        out.println("</head>");
        out.println("<body>");
    }

    protected void endHtml(PrintWriter out) {
        out.println("</body></html>");
    }

    private static final class TestSorter
    implements Comparator<IInvokedMethod> {
        private TestSorter() {
        }

        @Override
        public int compare(IInvokedMethod o1, IInvokedMethod o2) {
            return (int)(o1.getDate() - o2.getDate());
        }
    }
}

