/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.testng.collections.Lists;

public class ReflectionHelper {
    public static Method[] getLocalMethods(Class<?> clazz) {
        Method[] result;
        Method[] declaredMethods = ReflectionHelper.excludingMain(clazz);
        List<Method> defaultMethods = ReflectionHelper.getDefaultMethods(clazz);
        if (defaultMethods != null) {
            result = new Method[declaredMethods.length + defaultMethods.size()];
            System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
            int index = declaredMethods.length;
            Iterator<Method> iterator = defaultMethods.iterator();
            while (iterator.hasNext()) {
                Method defaultMethod;
                result[index] = defaultMethod = iterator.next();
                ++index;
            }
        } else {
            List prunedMethods = Lists.newArrayList();
            for (Method declaredMethod : declaredMethods) {
                if (declaredMethod.isBridge()) continue;
                prunedMethods.add(declaredMethod);
            }
            result = prunedMethods.toArray(new Method[prunedMethods.size()]);
        }
        return result;
    }

    public static Method[] excludingMain(Class<?> clazz) {
        Method[] declaredMethods = clazz.getDeclaredMethods();
        LinkedList<Method> pruned = new LinkedList<Method>();
        for (Method declaredMethod : declaredMethods) {
            if ("main".equals(declaredMethod.getName()) && ReflectionHelper.isStaticVoid(declaredMethod) && ReflectionHelper.acceptsStringArray(declaredMethod)) continue;
            pruned.add(declaredMethod);
        }
        return pruned.toArray(new Method[pruned.size()]);
    }

    public static <T extends Annotation> T findAnnotation(Class<?> typedTestClass, Class<T> annotation) {
        if (typedTestClass == null || annotation == null) {
            return null;
        }
        T ignore = null;
        for (Class<?> testClass = typedTestClass; testClass != Object.class && (ignore = (T)testClass.getAnnotation(annotation)) == null; testClass = testClass.getSuperclass()) {
        }
        return ignore;
    }

    private static boolean isStaticVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE) && Modifier.isStatic(method.getModifiers());
    }

    private static boolean acceptsStringArray(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 0) {
            return false;
        }
        Class<?> paramType = paramTypes[0];
        return paramType.isArray() && paramType.isInstance(new String[0]);
    }

    private static List<Method> getDefaultMethods(Class<?> clazz) {
        LinkedList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new LinkedList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }
}

