/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.collections.Pair;

public class DynamicGraph<T> {
    private final Collection<T> m_nodesReady;
    private final Collection<T> m_nodesRunning;
    private final Collection<T> m_nodesFinished;
    private final ListMultiMap<T, Edge<T>> m_edges = Maps.newListMultiMap();
    private final ListMultiMap<T, Edge<T>> m_allEdges = Maps.newListMultiMap();

    public DynamicGraph() {
        this.m_nodesFinished = Sets.newLinkedHashSet();
        this.m_nodesReady = Sets.newLinkedHashSet();
        this.m_nodesRunning = Sets.newLinkedHashSet();
    }

    public boolean addNode(T node) {
        return this.m_nodesReady.add(node);
    }

    public void addEdge(int weight, T from, T to) {
        this.addEdges(Collections.singletonList(new Edge(weight, from, to)));
    }

    public void addEdge(int weight, T from, T ... tos) {
        this.addEdge(weight, from, (Iterable<T>)Arrays.asList(tos));
    }

    public void addEdge(int weight, T from, Iterable<T> tos) {
        List<Edge<T>> edges = Lists.newArrayList();
        for (T to : tos) {
            edges.add(new Edge(weight, from, to));
        }
        this.addEdges(edges);
    }

    private void addEdges(List<Edge<T>> edges) {
        for (Edge<T> edge : edges) {
            Edge<T> existingEdge = DynamicGraph.getNode(this.m_edges, edge);
            if (existingEdge != null && ((Edge)existingEdge).weight == ((Edge)edge).weight) {
                throw new IllegalStateException("Circular dependency: " + ((Edge)edge).from + " <-> " + ((Edge)edge).to);
            }
            if (existingEdge == null || ((Edge)existingEdge).weight < ((Edge)edge).weight) {
                this.m_edges.put(((Edge)edge).from, edge);
            }
            this.m_allEdges.put(((Edge)edge).from, edge);
        }
    }

    private static <T> Edge<T> getNode(ListMultiMap<T, Edge<T>> edges, Edge<T> edge) {
        for (Edge e : (List)edges.get(((Edge)edge).to)) {
            if (!e.to.equals(((Edge)edge).from)) continue;
            return e;
        }
        return null;
    }

    public List<T> getFreeNodes() {
        List edges;
        List<Object> result = Lists.newArrayList();
        for (T node : this.m_nodesReady) {
            if (!((List)this.m_edges.get(node)).isEmpty() && !this.getUnfinishedNodes(node).isEmpty()) continue;
            result.add(node);
        }
        if (result.isEmpty()) {
            int lowestPriority = this.getLowestEdgePriority(this.m_nodesReady);
            for (Object node : this.m_nodesReady) {
                for (Object unode : this.getUnfinishedNodes(node)) {
                    if (!this.m_nodesRunning.contains(unode)) continue;
                    return Collections.emptyList();
                }
                edges = (List)this.m_edges.get(node);
                if (!DynamicGraph.hasAllEdgesWithLevel(edges, lowestPriority)) continue;
                result.add(node);
            }
        }
        List finalResult = Lists.newArrayList();
        for (Object node : result) {
            edges = (List)this.m_edges.get(node);
            boolean canAdd = true;
            for (Edge edge : edges) {
                if (!result.contains(edge.to)) continue;
                canAdd = false;
            }
            if (!canAdd) continue;
            finalResult.add(node);
        }
        return finalResult;
    }

    private int getLowestEdgePriority(Collection<T> nodes) {
        if (nodes.isEmpty()) {
            return 0;
        }
        Integer lowerPriority = null;
        for (T node : nodes) {
            for (Edge edge : (List)this.m_edges.get(node)) {
                if (lowerPriority == null) {
                    lowerPriority = edge.weight;
                    continue;
                }
                lowerPriority = lowerPriority < edge.weight ? lowerPriority : edge.weight;
            }
        }
        return lowerPriority == null ? 0 : lowerPriority;
    }

    private static <T> boolean hasAllEdgesWithLevel(List<Edge<T>> edges, int level) {
        for (Edge<T> edge : edges) {
            if (((Edge)edge).weight == level) continue;
            return false;
        }
        return true;
    }

    private Collection<? extends T> getUnfinishedNodes(T node) {
        Set result = Sets.newHashSet();
        for (Edge edge : (List)this.m_edges.get(node)) {
            if (!this.m_nodesReady.contains(edge.to) && !this.m_nodesRunning.contains(edge.to)) continue;
            result.add(edge.to);
        }
        return result;
    }

    public void setStatus(Collection<T> nodes, Status status) {
        for (T n : nodes) {
            this.setStatus(n, status);
        }
    }

    public void setStatus(T node, Status status) {
        switch (status) {
            case RUNNING: {
                this.m_nodesReady.remove(node);
                this.m_nodesRunning.add(node);
                break;
            }
            case FINISHED: {
                this.m_nodesReady.remove(node);
                this.m_nodesRunning.remove(node);
                this.m_nodesFinished.add(node);
                this.m_edges.removeAll(node);
                List<Pair> edgesToRemove = Lists.newArrayList();
                for (Map.Entry entry : this.m_edges.entrySet()) {
                    for (Edge edge : (List)entry.getValue()) {
                        if (!edge.to.equals(node)) continue;
                        edgesToRemove.add(new Pair(entry.getKey(), edge));
                    }
                }
                for (Pair pair : edgesToRemove) {
                    for (Edge edge : (List)this.m_allEdges.get(node)) {
                        Edge pedge = (Edge)pair.second();
                        Edge<T> existingEdge = DynamicGraph.getNode(this.m_edges, new Edge(0, pedge.from, edge.to));
                        if (existingEdge != null && ((Edge)existingEdge).weight <= pedge.weight || !this.m_nodesReady.contains(edge.to) || pedge.from.equals(edge.to)) continue;
                        if (edge.weight > pedge.weight) {
                            this.addEdge(edge.weight, (T)pedge.from, (T)edge.to);
                            continue;
                        }
                        this.addEdge(pedge.weight, (T)pedge.from, (T)edge.to);
                    }
                    this.m_edges.remove((T)pair.first(), (Edge<T>)pair.second());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported status: " + (Object)((Object)status));
            }
        }
    }

    public int getNodeCount() {
        int result = this.m_nodesReady.size() + this.m_nodesRunning.size() + this.m_nodesFinished.size();
        return result;
    }

    public int getNodeCountWithStatus(Status status) {
        switch (status) {
            case READY: {
                return this.m_nodesReady.size();
            }
            case RUNNING: {
                return this.m_nodesRunning.size();
            }
            case FINISHED: {
                return this.m_nodesFinished.size();
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        StringBuilder result = new StringBuilder("[DynamicGraph ");
        result.append("\n  Ready:" + this.m_nodesReady);
        result.append("\n  Running:" + this.m_nodesRunning);
        result.append("\n  Finished:" + this.m_nodesFinished);
        result.append("\n  Edges:\n");
        for (Map.Entry es : this.m_edges.entrySet()) {
            result.append("     " + es.getKey() + "\n");
            for (Edge t : (List)es.getValue()) {
                result.append("        " + t.to + "\n");
            }
        }
        result.append("]");
        return result.toString();
    }

    private String getName(T t) {
        String s = t.toString();
        int n1 = s.lastIndexOf(46) + 1;
        int n2 = s.indexOf(40);
        return s.substring(n1, n2);
    }

    public String toDot() {
        String color;
        String FREE = "[style=filled color=yellow]";
        String RUNNING = "[style=filled color=green]";
        String FINISHED = "[style=filled color=grey]";
        StringBuilder result = new StringBuilder("digraph g {\n");
        List<T> freeNodes = this.getFreeNodes();
        for (T n : this.m_nodesReady) {
            color = freeNodes.contains(n) ? FREE : "";
            result.append("  " + this.getName(n) + color + "\n");
        }
        for (T n : this.m_nodesRunning) {
            color = freeNodes.contains(n) ? FREE : RUNNING;
            result.append("  " + this.getName(n) + color + "\n");
        }
        for (T n : this.m_nodesFinished) {
            result.append("  " + this.getName(n) + FINISHED + "\n");
        }
        result.append("\n");
        for (List edges : this.m_edges.values()) {
            for (Edge edge : edges) {
                String dotted = this.m_nodesFinished.contains(edge.from) ? "style=dotted" : "";
                result.append("  " + this.getName(edge.from) + " -> " + this.getName(edge.to) + " [dir=back " + dotted + "]\n");
            }
        }
        result.append("}\n");
        return result.toString();
    }

    public ListMultiMap<T, Edge<T>> getEdges() {
        return this.m_edges;
    }

    static class Edge<T> {
        private final T from;
        private final T to;
        private final int weight;

        private Edge(int weight, T from, T to) {
            this.from = from;
            this.to = to;
            this.weight = weight;
        }

        T getFrom() {
            return this.from;
        }

        T getTo() {
            return this.to;
        }
    }

    public static enum Status {
        READY,
        RUNNING,
        FINISHED;

    }
}

