/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import org.testng.IConfigurable;
import org.testng.IConfigurationListener;
import org.testng.IExecutionListener;
import org.testng.IHookable;
import org.testng.ITestObjectFactory;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.IConfiguration;
import org.testng.internal.annotations.DefaultAnnotationTransformer;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.JDK15AnnotationFinder;

public class Configuration
implements IConfiguration {
    private IAnnotationFinder m_annotationFinder;
    private ITestObjectFactory m_objectFactory;
    private IHookable m_hookable;
    private IConfigurable m_configurable;
    private final Map<Class<? extends IExecutionListener>, IExecutionListener> m_executionListeners = Maps.newHashMap();
    private final Map<Class<? extends IConfigurationListener>, IConfigurationListener> m_configurationListeners = Maps.newHashMap();

    public Configuration() {
        this.init(new JDK15AnnotationFinder(new DefaultAnnotationTransformer()));
    }

    public Configuration(IAnnotationFinder finder) {
        this.init(finder);
    }

    private void init(IAnnotationFinder finder) {
        this.m_annotationFinder = finder;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder() {
        return this.m_annotationFinder;
    }

    @Override
    public void setAnnotationFinder(IAnnotationFinder finder) {
        this.m_annotationFinder = finder;
    }

    @Override
    public ITestObjectFactory getObjectFactory() {
        return this.m_objectFactory;
    }

    @Override
    public void setObjectFactory(ITestObjectFactory factory) {
        this.m_objectFactory = factory;
    }

    @Override
    public IHookable getHookable() {
        return this.m_hookable;
    }

    @Override
    public void setHookable(IHookable h) {
        this.m_hookable = h;
    }

    @Override
    public IConfigurable getConfigurable() {
        return this.m_configurable;
    }

    @Override
    public void setConfigurable(IConfigurable c) {
        this.m_configurable = c;
    }

    @Override
    public List<IExecutionListener> getExecutionListeners() {
        return Lists.newArrayList(this.m_executionListeners.values());
    }

    @Override
    public void addExecutionListener(IExecutionListener l) {
        if (!this.m_executionListeners.keySet().contains(l.getClass())) {
            this.m_executionListeners.put(l.getClass(), l);
        }
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        return Lists.newArrayList(this.m_configurationListeners.values());
    }

    @Override
    public void addConfigurationListener(IConfigurationListener cl) {
        this.m_configurationListeners.put(cl.getClass(), cl);
    }
}

