/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.authn.BAuthenticationService;
import com.tridium.fox.sys.BFoxService;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.jetty.BJettyWebServer;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.testng.TestUtil;
import com.tridium.ui.NullUiEnv;
import com.tridium.ui.UiEnv;
import java.lang.reflect.Field;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BRoleService;
import javax.baja.security.BPermissions;
import javax.baja.security.BPermissionsMap;
import javax.baja.sync.BProxyComponentSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTestNgStation;
import javax.baja.test.TestException;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;
import org.eclipse.jetty.server.Server;
import org.testng.Assert;

@NiagaraType
public abstract class BStationTestBase
extends BTestNgStation {
    @Generated
    public static final Type TYPE = Sys.loadType(BStationTestBase.class);
    protected static final String TEST_VISITOR_USER = "TestVisitor";
    public static final String TEST_DELIMITED_USER = "username";
    public static final String TEST_DELIMITED_PASS = "user:password1";

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BFoxSession connect(String userName, String password) throws Exception {
        return (BFoxSession)super.connect(userName, password, 3);
    }

    @Override
    protected void configureTestStation(BStation station, String stationName, int webPort, int foxPort) throws Exception {
        this.makeDefaultAuthFoxServices = false;
        BServiceContainer services = station.getServices();
        services.add("AuthenticationService", (BValue)this.makeAuthService());
        services.add("FoxService", (BValue)this.makeFoxService(foxPort));
        super.configureTestStation(station, stationName, webPort, foxPort);
    }

    protected BAuthenticationService makeAuthService() {
        BAuthenticationService authService = new BAuthenticationService();
        authService.get("authenticationSchemes");
        return authService;
    }

    public BComponent makeFoxService(int foxPort) throws Exception {
        BFoxService foxSvc = new BFoxService();
        foxSvc.set("foxsCert", (BValue)BString.make((String)"default"));
        foxSvc.getCertAliasAndPassword().resetAliasAndPassword();
        foxSvc.getFoxPort().setPublicServerPort(foxPort);
        return foxSvc;
    }

    @Override
    public BComponent makeRoleService() throws Exception {
        BRoleService roleService = new BRoleService();
        this.addRole(roleService, "TestSuper", BPermissionsMap.SUPER_USER);
        this.addRole(roleService, "TestAdmin", BStationTestBase.map(new BPermissions[]{BPermissions.make((String)"rwiRWI")}));
        this.addRole(roleService, "TestOperator", BStationTestBase.map(new BPermissions[]{BPermissions.make((String)"rwi")}));
        this.addRole(roleService, TEST_VISITOR_USER, BStationTestBase.map(new BPermissions[]{BPermissions.make((String)"r")}));
        this.addRole(roleService, TEST_DELIMITED_USER, BPermissionsMap.SUPER_USER);
        return roleService;
    }

    @Override
    public BComponent makeUserService() throws Exception {
        BUserService userService = new BUserService();
        this.addUser(userService, "TestSuper");
        this.addUser(userService, "TestAdmin");
        this.addUser(userService, "TestOperator");
        this.addUser(userService, TEST_VISITOR_USER);
        this.addUser(userService, TEST_DELIMITED_USER, TEST_DELIMITED_PASS);
        return userService;
    }

    protected BFoxSession connect(String userName, String password, int maxAttempts) throws Exception {
        return (BFoxSession)super.connect(userName, password, maxAttempts);
    }

    protected BOrd localOrd(String query) {
        return BOrd.make((String)String.format("local:|%s", query));
    }

    protected BOrd remoteOrd(String query) {
        return BOrd.make((String)String.format("local:|fox:%d|%s", this.foxPort, query));
    }

    protected BOrd remoteSlotPath(String slotPath) {
        return BOrd.make((String)String.format("local:|fox:%d|station:|slot:%s", this.foxPort, slotPath));
    }

    protected BOrd localSlotPath(String slotPath) {
        return BOrd.make((String)String.format("local:|station:|slot:%s", slotPath));
    }

    protected void sync() throws Exception {
        ((BProxyComponentSpace)BOrd.make((String)String.format("local:|fox:%d|station:", this.foxPort)).get().as(BProxyComponentSpace.class)).sync();
    }

    protected void pause(int ms) {
        try {
            System.out.println("      Pausing " + ms + "ms...");
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            throw new TestException(e.toString());
        }
    }

    protected void waitForWebServerStart() {
        Server jettyServer;
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue(TestUtil.waitFor(() -> this.getWebService().getWebServer() != null, 10000L, 100L), "Failed to start Jetty webserver in a timely manner");
        BJettyWebServer jettyWebServer = (BJettyWebServer)this.getWebService().getWebServer();
        Assert.assertTrue(TestUtil.waitFor(() -> "started".equalsIgnoreCase(jettyWebServer.getServerState()), 10000L, 100L), "Failed to start Jetty webserver in a timely manner");
        try {
            Field jettyField = BJettyWebServer.class.getDeclaredField("jetty");
            jettyField.setAccessible(true);
            jettyServer = (Server)jettyField.get(jettyWebServer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't get value of jetty", e);
        }
        Assert.assertTrue(TestUtil.waitFor(() -> ((Server)jettyServer).isRunning(), 10000L, 100L), "Failed to start Jetty webserver in a timely manner");
    }

    protected void startWebServer() {
        Server jettyServer;
        this.getWebService().setEnabled(true);
        try {
            Thread.sleep(2500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertTrue(TestUtil.waitFor(() -> this.getWebService().getWebServer() != null, 10000L, 100L), "Failed to start Jetty webserver in a timely manner");
        BJettyWebServer jettyWebServer = (BJettyWebServer)this.getWebService().getWebServer();
        Assert.assertTrue(TestUtil.waitFor(() -> "started".equalsIgnoreCase(jettyWebServer.getServerState()), 10000L, 100L), "Failed to start Jetty webserver in a timely manner");
        try {
            Field jettyField = BJettyWebServer.class.getDeclaredField("jetty");
            jettyField.setAccessible(true);
            jettyServer = (Server)jettyField.get(jettyWebServer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't get value of jetty", e);
        }
        Assert.assertTrue(TestUtil.waitFor(() -> ((Server)jettyServer).isRunning(), 10000L, 100L), "Failed to start Jetty webserver in a timely manner");
    }

    protected void stopWebServer() {
        Server jettyServer;
        BJettyWebServer jettyWebServer = (BJettyWebServer)this.getWebService().getWebServer();
        try {
            Field jettyField = BJettyWebServer.class.getDeclaredField("jetty");
            jettyField.setAccessible(true);
            jettyServer = (Server)jettyField.get(jettyWebServer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("can't get value of jetty", e);
        }
        this.getWebService().setEnabled(false);
        try {
            Thread.sleep(2500L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (jettyServer != null && !TestUtil.waitFor(() -> !jettyServer.isRunning(), 10000L, 100L)) {
            jettyServer.destroy();
            Assert.fail("Failed to stop the Jetty WebServer in a timely fashion");
        }
        if (jettyWebServer != null && !TestUtil.waitFor(() -> "stopped".equalsIgnoreCase(jettyWebServer.getServerState()), 10000L, 100L)) {
            Assert.fail("Failed to stop the Jetty WebServer in a timely fashion");
        }
    }

    protected BFoxService getFoxService() {
        return (BFoxService)this.getServices().get("FoxService");
    }

    protected BAuthenticationService getAuthService() {
        return (BAuthenticationService)this.getServices().get("AuthenticationService");
    }

    protected BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getDrivers().get("NiagaraNetwork");
    }

    protected BUser getTestVisitorUser() {
        BUserService userService = BUserService.getService();
        return userService.getUser(TEST_VISITOR_USER);
    }

    public static boolean hasUi() {
        UiEnv uiEnv = UiEnv.get();
        return uiEnv != null && !(uiEnv instanceof NullUiEnv);
    }

    protected String getBaseURI() {
        return "http://localhost:" + this.webPort + '/';
    }
}

