/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.driverUpgrade.wizard.BChooseBackupFilenameStep;
import com.tridium.driverUpgrade.wizard.BConnectStep;
import com.tridium.driverUpgrade.wizard.BFinishStep;
import com.tridium.driverUpgrade.wizard.BFirstStep;
import com.tridium.driverUpgrade.wizard.BProcessBogStep;
import com.tridium.driverUpgrade.wizard.BSecondStep;
import com.tridium.driverUpgrade.wizard.BThirdStep;
import com.tridium.driverUpgrade.wizard.BUpgradeReviewStep;
import com.tridium.driverUpgrade.wizard.BUpgradeWizardStep;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.license.LicenseInfo;
import com.tridium.platform.ui.BDaemonCnxHandler;
import com.tridium.workbench.nav.BFoxCnxHandler;
import javax.baja.file.BDirectory;
import javax.baja.file.FilePath;
import javax.baja.fox.BFoxProxySession;
import javax.baja.gx.Size;
import javax.baja.naming.BHost;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class UpgradeWizardModel
extends WizardModel
implements ICancelHint {
    private static final int DEFAULT_PLATFORM_PORT = 3011;
    private static final int DEFAULT_STATION_PORT = 1911;
    public BWidget owner;
    public Context cx;
    public boolean canceled = false;
    public BUpgradeWizardStep currentStep;
    public BHost host;
    public BDaemonCnxHandler platformCnxHandler;
    public BFoxCnxHandler stationCnxHandler;
    public BICredentials platformCredentials;
    public BIUserCredentials stationCredentials;
    public BDaemonPlatform platform = null;
    public FilePath backupPath = null;
    public Array<String> upgrades = new Array(String.class);
    public InstallScenario solution = null;
    public InstallScenario upgradeSolution = null;
    public BDirectory[] stationDirs = null;
    public int selectedStation = 0;
    public BBogFile bogFile = null;
    protected BDaemonSession daemonSession = null;
    String brandId = null;
    Array<LicenseInfo> currentLicenses = new Array(LicenseInfo.class);
    Version currentLicenseVersion = null;
    boolean skipLicense = false;
    boolean canSkipLicense = true;
    public static final Lexicon LEX = Lexicon.make((String)"driverUpgrade");
    public static final Version NIAGARA_VERSION = new Version("3.6");

    public UpgradeWizardModel(BWidget owner, Context cx) throws Exception {
        this.owner = owner;
        this.cx = cx;
        BFirstStep first = new BFirstStep(this);
        this.currentStep = first;
        BSecondStep second = new BSecondStep(this);
        first.setStepAfterSection(second);
        BThirdStep third = new BThirdStep(this);
        second.setStepAfterSection(third);
        BConnectStep connect = new BConnectStep(this);
        third.setStepAfterSection(connect);
        BChooseBackupFilenameStep backup = new BChooseBackupFilenameStep(this);
        connect.setStepAfterSection(backup);
        BProcessBogStep process = new BProcessBogStep(this);
        backup.setStepAfterSection(process);
        BUpgradeReviewStep review = new BUpgradeReviewStep(this);
        process.setStepAfterSection(review);
        BFinishStep finish = new BFinishStep(this);
        review.setStepAfterSection(finish);
    }

    public Context getContext() {
        return this.cx;
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public BUpgradeWizardStep getCurrentStep() {
        return this.currentStep;
    }

    public void back() {
        try {
            if (!this.getCurrentStep().checkBack()) {
                return;
            }
            BUpgradeWizardStep step = this.getCurrentStep().priorStep;
            if (step != null && this.getCurrentStep().exit(1)) {
                while (step != null && step.isSkipped()) {
                    step = step.priorStep;
                }
                if (step != null) {
                    this.update(step);
                    step.enter();
                }
            }
        }
        catch (Throwable t) {
            BDialog.error((BWidget)this.getWizard(), (String)LEX.getText("UpgradeWizard.error.dlgTitle"), (Object)LEX.getText("UpgradeWizard.error.dlgMessage"), (Throwable)t);
        }
    }

    public String getTitle() {
        return LEX.getText("UpgradeWizard.title");
    }

    public void init() {
        BUpgradeWizardStep step = this.currentStep;
        while (step != null && step.isSkipped()) {
            step = step.nextStep;
        }
        this.update(step);
        step.enter();
    }

    public void next() {
        if (!this.getCurrentStep().checkNext()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    BUpgradeWizardStep step;
                    if (UpgradeWizardModel.this.owner != null) {
                        UpgradeWizardModel.this.owner.enterBusy();
                    }
                    if ((step = UpgradeWizardModel.this.getCurrentStep().nextStep) != null && UpgradeWizardModel.this.getCurrentStep().exit(2)) {
                        while (step != null && step.isSkipped()) {
                            step = step.nextStep;
                        }
                        if (step != null) {
                            step.enter();
                            UpgradeWizardModel.this.update(step);
                        }
                    }
                }
                catch (Throwable t) {
                    BDialog.error((BWidget)UpgradeWizardModel.this.getWizard(), (String)LEX.getText("UpgradeWizard.error.dlgTitle"), (Object)LEX.getText("UpgradeWizard.error.dlgMessage"), (Throwable)t);
                }
                finally {
                    if (UpgradeWizardModel.this.owner != null) {
                        UpgradeWizardModel.this.owner.exitBusy();
                    }
                }
            }
        }.start();
    }

    public boolean cancel() {
        return (!this.getCurrentStep().showCancelPrompt() || BDialog.confirm((BWidget)this.getWizard(), (String)LEX.getText("UpgradeWizard.cancel.title"), (Object)LEX.getText("UpgradeWizard.cancel.message")) == 4) && this.getCurrentStep().cancel();
    }

    public BFoxSession foxSession() {
        return this.foxSession(this.host, this.stationCnxHandler.getPort(), this.stationCnxHandler.isSecure(), this.stationCredentials);
    }

    public BFoxSession foxSession(BHost host, int port, boolean useFoxs, BIUserCredentials credentials) {
        return (BFoxSession)BFoxProxySession.make((BHost)host, (int)port, (boolean)useFoxs, (BIUserCredentials)credentials);
    }

    public boolean isValidSecurityLicense(LicenseInfo info) {
        return UpgradeWizardModel.isValidSecurityLicense(info, this.platform.getHostId());
    }

    public static boolean isValidSecurityLicense(LicenseInfo info, String hostId) {
        return info != null && info.vendorLicense.getVendor().equalsIgnoreCase("tridium") && info.vendorLicense.getVersion().compareTo(NIAGARA_VERSION) >= 0 && info.vendorLicense.getFeature("entSecurity") != null && info.vendorLicense.getFeature("intrusion") != null && info.vendorLicense.getHostId().equals(hostId);
    }

    public boolean finish() {
        return this.getCurrentStep().exit(4);
    }

    public void update(BUpgradeWizardStep step) {
        this.currentStep = step;
        this.update((BWidget)step, step.getMode());
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(680.0, 480.0);
    }

    public int getDefaultPlatformPort() {
        return 3011;
    }

    public int getDefaultStationPort() {
        return 1911;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public BDirectory getDirToUpgrade() {
        return this.stationDirs[this.selectedStation];
    }
}

