/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.driverUpgrade.wizard;

import com.tridium.driverUpgrade.wizard.BUpgradeWizardStep;
import com.tridium.driverUpgrade.wizard.UpgradeTaskDetailPane;
import com.tridium.driverUpgrade.wizard.UpgradeWizardModel;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.InstallScenario;
import com.tridium.install.installable.BFileInstallable;
import com.tridium.install.installable.BInstallable;
import com.tridium.install.installable.InstallableRegistry;
import com.tridium.install.installable.LocalInstallableRegistry;
import com.tridium.platform.daemon.BAppSurrogate;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.OSUpdateMessage;
import com.tridium.platform.daemon.task.CancelableDaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.BTextOutputPane;
import java.net.SocketException;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BJobState;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;

@NiagaraType
public class BFinishStep
extends BUpgradeWizardStep {
    @Generated
    public static final Type TYPE = Sys.loadType(BFinishStep.class);
    protected FinishTasks finishTasks;
    protected int mode;
    protected boolean succeeded;
    protected static FilePath NEPTUNE_BACKUP_PATH = new FilePath("!temp/neptuneBackup.zip");
    protected static FilePath STATION_BACKUP_PATH = new FilePath("!temp/stationBackup.bog");
    boolean mustReboot = false;
    boolean mustInstallOs = false;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFinishStep() {
    }

    public BFinishStep(UpgradeWizardModel wizardModel) {
        super(wizardModel);
    }

    @Override
    public String getSectionName() {
        return "finish";
    }

    @Override
    public String getStepName() {
        return "finish";
    }

    @Override
    public boolean showCancelPrompt() {
        return this.finishTasks.isRunning();
    }

    @Override
    public boolean cancel() {
        if (this.finishTasks.isRunning()) {
            this.finishTasks.cancel();
            return false;
        }
        return true;
    }

    @Override
    public void enter() {
        this.finishTasks = new FinishTasks();
        this.setContent(this.finishTasks.getPane());
        new Thread(this.finishTasks).start();
    }

    @Override
    public boolean exit(int direction) {
        return !this.finishTasks.isRunning();
    }

    @Override
    public void checkMode() {
        if (this.finishTasks.isRunning()) {
            this.setMode(0);
        } else {
            if (this.succeeded) {
                this.finishTasks.setBottomContentLabel(LEX.getText("UpgradeWizard.finish.success.bottomContent"));
            }
            this.setMode(4);
        }
    }

    private void setMode(int value) {
        if (this.mode != value) {
            this.mode = value;
            if (this.wizardModel.getCurrentStep() == this) {
                this.wizardModel.update(this.mode);
            }
        }
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    protected class Dots
    extends Thread {
        private boolean dotCanceled = false;
        private boolean dotRunning = true;
        private int i = 0;
        private BTextOutputPane log;

        public Dots(BTextOutputPane log) {
            this.log = log;
        }

        @Override
        public void run() {
            while (!this.dotCanceled) {
                try {
                    Thread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.i >= 60) {
                    this.log.append("\n");
                    this.i = 0;
                }
                ++this.i;
                this.log.append(".");
            }
            this.log.append("\n");
            this.dotRunning = false;
        }

        public synchronized void cancel() {
            this.dotCanceled = true;
            while (this.dotRunning) {
                try {
                    Thread.sleep(300L);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    protected class FinishTasks
    extends UpgradeTaskDetailPane
    implements DaemonSessionTaskListener {
        private String lastText;
        private boolean isRunning = false;
        private BDaemonSession platformSession = null;
        private BAppSurrogate[] apps;
        protected UpgradeTaskDetailPane.TaskItem installTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.installTask"));
        protected UpgradeTaskDetailPane.TaskItem updateOsTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.updateOsTask"));
        protected UpgradeTaskDetailPane.TaskItem rebootTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.rebootTask"));
        protected UpgradeTaskDetailPane.TaskItem restartTask = new UpgradeTaskDetailPane.TaskItem(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.restartTask"));

        public FinishTasks() {
            if ((BFinishStep.this.getWizardModel().solution.getProcessingFlags() & 0x20000L) > 0L) {
                BFinishStep.this.mustInstallOs = true;
                BFinishStep.this.mustReboot = true;
            }
            if ((BFinishStep.this.getWizardModel().solution.getProcessingFlags() & 0x10000L) > 0L) {
                BFinishStep.this.mustReboot = true;
            }
            this.init();
        }

        @Override
        public void run() {
            if (this.isRunning) {
                return;
            }
            this.isRunning = true;
            try {
                this.platformSession = BFinishStep.this.getWizardModel().platform.getDaemonSession();
                if (!this.installUpgrade()) {
                    return;
                }
                if (BFinishStep.this.mustInstallOs && !this.installOs()) {
                    return;
                }
                if (!this.restart(BFinishStep.this.mustReboot)) {
                    return;
                }
                BFinishStep.this.succeeded = true;
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.success") + '\n');
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.success.bottomContent")));
            }
            catch (ICancelHint.CanceledException ce) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.canceled") + '\n');
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.canceled")));
                this.updateCurrentItemState(BJobState.canceled);
            }
            catch (Throwable t) {
                this.updateCurrentItemState(BJobState.failed);
                this.setBottomContent((BWidget)new BLabel(BUpgradeWizardStep.LEX.getText("UpgradeWizard.failed")));
                t.printStackTrace();
                this.getLog().append(t);
                this.getLog().append("\n");
            }
            finally {
                this.isRunning = false;
                BFinishStep.this.checkMode();
            }
        }

        private boolean installUpgrade() throws Exception {
            this.setCurrentItem(this.installTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.commitInstall") + '\n');
            this.apps = BAppSurrogate.stopAllApps((BDaemonSession)this.platformSession, null, (ICancelHint)this, (DaemonSessionTaskListener)this);
            BInstallable[] ia = new BInstallable[]{new BFileInstallable((BIFile)BFinishStep.this.getWizardModel().bogFile, BFinishStep.this.getWizardModel().getDirToUpgrade().getFilePath())};
            InstallScenario solution = BFinishStep.this.getWizardModel().solution.solve((DaemonSessionTaskListener)this, null, null, ia, (InstallableRegistry)LocalInstallableRegistry.getInstance());
            if (!solution.canCommit()) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.install.fail") + '\n');
                this.updateCurrentItemState(BJobState.failed);
                return false;
            }
            try {
                solution.commit((DaemonSessionTaskListener)this, (ICancelHint)this);
            }
            catch (Exception e) {
                this.getLog().append("Error installing upgrades:" + e.getMessage());
                this.updateCurrentItemState(BJobState.failed);
                return false;
            }
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.install.done") + '\n');
            this.updateCurrentItemState(BJobState.success);
            return true;
        }

        private boolean installOs() throws Exception {
            this.setCurrentItem(this.updateOsTask, BJobState.running);
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.updateOs") + '\n');
            if (BFinishStep.this.getWizardModel().daemonSession.getHostProperties().supportsServlet("osupdate")) {
                BFinishStep.this.getWizardModel().daemonSession.sendMessage((DaemonMessage)OSUpdateMessage.getInstance(), 90000);
            }
            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.updateOs.done") + '\n');
            this.updateCurrentItemState(BJobState.success);
            return true;
        }

        protected boolean restart(boolean forceReboot) throws Exception {
            this.setCurrentItem(this.rebootTask, BJobState.running);
            String sessionTimestamp = this.platformSession.getHostProperties().getSessionTimestamp();
            if (forceReboot || !this.platformSession.getHostProperties().getAllowStationRestart()) {
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.reboot") + '\n');
                this.platformSession.sendRebootRequest();
                this.platformSession.getHostProperties().reset();
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.reconnectPlatform") + '\n');
                Dots d = new Dots(this.getLog());
                d.start();
                while (!this.isCanceled()) {
                    try {
                        this.platformSession.reloadHostProperties(15000);
                        if (this.platformSession.getHostProperties().getSessionTimestamp().equals(sessionTimestamp)) {
                            Thread.sleep(500L);
                            continue;
                        }
                        Thread.sleep(3000L);
                        BFinishStep.this.getWizardModel().platform = BRemoteDaemonPlatform.make((BDaemonSession)this.platformSession, (DaemonSessionTaskListener)this);
                        break;
                    }
                    catch (SocketException socketException) {
                    }
                    catch (Exception e) {
                        this.getLog().append((Throwable)e);
                        this.updateCurrentItemState(BJobState.failed);
                        d.cancel();
                        return false;
                    }
                }
                d.cancel();
                this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.reconnectStation") + '\n');
            }
            this.updateCurrentItemState(BJobState.success);
            this.setCurrentItem(this.restartTask, BJobState.running);
            this.apps = BAppSurrogate.makeAll((Type)BStationSurrogate.TYPE, (BDaemonSession)this.platformSession);
            int appNdx = BFinishStep.this.getWizardModel().selectedStation;
            Dots d = new Dots(this.getLog());
            d.start();
            while (!this.isCanceled()) {
                try {
                    switch (this.apps[appNdx].getAppStatus().getOrdinal()) {
                        case 0: {
                            this.apps[appNdx].updateSettings(true, true);
                            this.apps[appNdx].startAppAsync();
                            break;
                        }
                        case 2: {
                            d.cancel();
                            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.reconnectSuccess") + '\n');
                            this.updateCurrentItemState(BJobState.success);
                            return true;
                        }
                        case 4: 
                        case 6: {
                            d.cancel();
                            this.getLog().append(BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.stationFailed") + '\n');
                            this.updateCurrentItemState(BJobState.failed);
                            return false;
                        }
                    }
                    Thread.sleep(1000L);
                    this.apps[appNdx].poll();
                }
                catch (Exception e) {
                    this.getLog().append((Throwable)e);
                    this.updateCurrentItemState(BJobState.failed);
                    d.cancel();
                    return false;
                }
            }
            throw new IllegalStateException();
        }

        @Override
        public String getItemListHeading() {
            return BUpgradeWizardStep.LEX.getText("UpgradeWizard.finish.heading");
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        @Override
        public void cancel() {
            super.cancel();
            BFinishStep.this.checkMode();
        }

        @Override
        public UpgradeTaskDetailPane.TaskItem[] makeTaskItems() {
            Array a = new Array(UpgradeTaskDetailPane.TaskItem.class);
            a.add((Object)this.installTask);
            if (BFinishStep.this.mustInstallOs) {
                a.add((Object)this.updateOsTask);
            }
            a.add((Object)this.rebootTask);
            a.add((Object)this.restartTask);
            return (UpgradeTaskDetailPane.TaskItem[])a.trim();
        }

        public void taskStarted(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
        }

        public void taskUpdated(DaemonSessionTask task) {
            if (this.lastText == null || !task.getMessage().equals(this.lastText)) {
                this.getLog().append(task.getMessage() + "\n");
                this.lastText = task.getMessage();
            }
            if (task instanceof CancelableDaemonSessionTask && !((CancelableDaemonSessionTask)task).isCancelEnabled()) {
                this.setCancelEnabled(false);
            }
        }

        public void taskFinished(DaemonSessionTask task) {
        }
    }
}

