/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import com.tridium.kitControl.BKitNumeric;
import com.tridium.kitControl.enums.BRaiseLowerFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="out", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=267), @NiagaraProperty(name="in", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=10, facets={@Facet(value="BFacets.make(BFacets.MIN, BDouble.make(MIN_IN_VALUE), BFacets.MAX, BDouble.make(MAX_IN_VALUE))")}), @NiagaraProperty(name="cancelSynchronizationOfflimits", type="boolean", defaultValue="false"), @NiagaraProperty(name="lastValidIn", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=7, facets={@Facet(value="BFacets.make(BFacets.MIN, BDouble.make(MIN_IN_VALUE), BFacets.MAX, BDouble.make(MAX_IN_VALUE))")}), @NiagaraProperty(name="virtualPosition", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BDouble.make(MIN_IN_VALUE), BFacets.MAX, BDouble.make(MAX_IN_VALUE))")}), @NiagaraProperty(name="raise", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=259), @NiagaraProperty(name="lower", type="BStatusBoolean", defaultValue="new BStatusBoolean()", flags=259), @NiagaraProperty(name="function", type="BRaiseLowerFunction", defaultValue="BRaiseLowerFunction.offState", flags=259), @NiagaraProperty(name="deadBand", type="double", defaultValue="0.5", facets={@Facet(value="BFacets.make(BFacets.MIN, BDouble.make(0.0), BFacets.MAX, BDouble.make(5.0))")}), @NiagaraProperty(name="driveTime", type="BRelTime", defaultValue="BRelTime.make(60000)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.make(1000))")}), @NiagaraProperty(name="midnightResetEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="midnightResetTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT.timeOfDay(23, 55, 00, 00)", flags=4, facets={@Facet(value="BFacets.make(BFacets.SHOW_DATE, BBoolean.FALSE, BFacets.SHOW_TIME, BBoolean.TRUE)")})})
@NiagaraActions(value={@NiagaraAction(name="finishMoving", flags=20), @NiagaraAction(name="update", flags=20), @NiagaraAction(name="reset", flags=16)})
public final class BRaiseLower
extends BKitNumeric
implements BIStatus,
BINumeric {
    private static final double MAX_IN_VALUE = 100.0;
    private static final double MIN_IN_VALUE = 0.0;
    @Generated
    public static final Property out = BRaiseLower.newProperty((int)267, (BValue)new BStatusNumeric(), null);
    @Generated
    public static final Property in = BRaiseLower.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0), (String)"max", (BIDataValue)BDouble.make((double)100.0)));
    @Generated
    public static final Property cancelSynchronizationOfflimits = BRaiseLower.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property lastValidIn = BRaiseLower.newProperty((int)7, (BValue)new BStatusNumeric(), (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0), (String)"max", (BIDataValue)BDouble.make((double)100.0)));
    @Generated
    public static final Property virtualPosition = BRaiseLower.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0), (String)"max", (BIDataValue)BDouble.make((double)100.0)));
    @Generated
    public static final Property raise = BRaiseLower.newProperty((int)259, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property lower = BRaiseLower.newProperty((int)259, (BValue)new BStatusBoolean(), null);
    @Generated
    public static final Property function = BRaiseLower.newProperty((int)259, (BValue)BRaiseLowerFunction.offState, null);
    @Generated
    public static final Property deadBand = BRaiseLower.newProperty((int)0, (double)0.5, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0), (String)"max", (BIDataValue)BDouble.make((double)5.0)));
    @Generated
    public static final Property driveTime = BRaiseLower.newProperty((int)0, (BValue)BRelTime.make((long)60000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.make((long)1000L)));
    @Generated
    public static final Property midnightResetEnabled = BRaiseLower.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property midnightResetTime = BRaiseLower.newProperty((int)4, (BValue)BAbsTime.DEFAULT.timeOfDay(23, 55, 0, 0), (BFacets)BFacets.make((String)"showDate", (BIDataValue)BBoolean.FALSE, (String)"showTime", (BIDataValue)BBoolean.TRUE));
    @Generated
    public static final Action finishMoving = BRaiseLower.newAction((int)20, null);
    @Generated
    public static final Action update = BRaiseLower.newAction((int)20, null);
    @Generated
    public static final Action reset = BRaiseLower.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRaiseLower.class);
    private static final double HALF = 0.5;
    private static final double RAISE_STATE_OUT_VALUE = 10.0;
    private static final double STATIC_STATE_OUT_VALUE = 7.0;
    private static final double LOWER_STATE_OUT_VALUE = 4.0;
    private static final double OFF_STATE_OUT_VALUE = 0.0;
    private Clock.Ticket driveTimeTicket = null;
    private BRelTime driveTimePeriod = BRelTime.DEFAULT;
    private double newVirtualPosition = 0.0;
    private BRelTime lastVirtualPositionTime = BRelTime.DEFAULT;
    private static final Logger LOGGER = Logger.getLogger("kitControl.raiseLower");
    private Clock.Ticket resetTicket = null;
    private static final BIcon icon = BIcon.std((String)"control/control.png");

    @Generated
    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    @Generated
    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getIn() {
        return (BStatusNumeric)this.get(in);
    }

    @Generated
    public void setIn(BStatusNumeric v) {
        this.set(in, (BValue)v, null);
    }

    @Generated
    public boolean getCancelSynchronizationOfflimits() {
        return this.getBoolean(cancelSynchronizationOfflimits);
    }

    @Generated
    public void setCancelSynchronizationOfflimits(boolean v) {
        this.setBoolean(cancelSynchronizationOfflimits, v, null);
    }

    @Generated
    public BStatusNumeric getLastValidIn() {
        return (BStatusNumeric)this.get(lastValidIn);
    }

    @Generated
    public void setLastValidIn(BStatusNumeric v) {
        this.set(lastValidIn, (BValue)v, null);
    }

    @Generated
    public double getVirtualPosition() {
        return this.getDouble(virtualPosition);
    }

    @Generated
    public void setVirtualPosition(double v) {
        this.setDouble(virtualPosition, v, null);
    }

    @Generated
    public BStatusBoolean getRaise() {
        return (BStatusBoolean)this.get(raise);
    }

    @Generated
    public void setRaise(BStatusBoolean v) {
        this.set(raise, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getLower() {
        return (BStatusBoolean)this.get(lower);
    }

    @Generated
    public void setLower(BStatusBoolean v) {
        this.set(lower, (BValue)v, null);
    }

    @Generated
    public BRaiseLowerFunction getFunction() {
        return (BRaiseLowerFunction)this.get(function);
    }

    @Generated
    public void setFunction(BRaiseLowerFunction v) {
        this.set(function, (BValue)v, null);
    }

    @Generated
    public double getDeadBand() {
        return this.getDouble(deadBand);
    }

    @Generated
    public void setDeadBand(double v) {
        this.setDouble(deadBand, v, null);
    }

    @Generated
    public BRelTime getDriveTime() {
        return (BRelTime)this.get(driveTime);
    }

    @Generated
    public void setDriveTime(BRelTime v) {
        this.set(driveTime, (BValue)v, null);
    }

    @Generated
    public boolean getMidnightResetEnabled() {
        return this.getBoolean(midnightResetEnabled);
    }

    @Generated
    public void setMidnightResetEnabled(boolean v) {
        this.setBoolean(midnightResetEnabled, v, null);
    }

    @Generated
    public BAbsTime getMidnightResetTime() {
        return (BAbsTime)this.get(midnightResetTime);
    }

    @Generated
    public void setMidnightResetTime(BAbsTime v) {
        this.set(midnightResetTime, (BValue)v, null);
    }

    @Generated
    public void finishMoving() {
        this.invoke(finishMoving, null, null);
    }

    @Generated
    public void update() {
        this.invoke(update, null, null);
    }

    @Generated
    public void reset() {
        this.invoke(reset, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.getMidnightResetEnabled()) {
            this.startResetTimer(BAbsTime.now());
        }
        this.update();
    }

    public void stopped() throws Exception {
        this.stopResetTimer();
        this.stopAndUpdateVirtualPosition();
    }

    public void changed(Property prop, Context cx) {
        if (this.isRunning()) {
            if (prop.equals(BKitNumeric.propagateFlags)) {
                BStatus s = this.propagate(this.getLastValidIn().getStatus());
                this.getOut().setStatus(s);
                this.getRaise().setStatus(s);
                this.getLower().setStatus(s);
            } else if (prop.equals(midnightResetEnabled) || prop.equals(midnightResetTime)) {
                if (this.getMidnightResetEnabled()) {
                    this.startResetTimer(BAbsTime.now());
                } else {
                    this.stopResetTimer();
                }
            } else if (prop.equals(in)) {
                double deadBand = this.getDeadBand();
                double inValue = this.getIn().getValue();
                if (inValue > 100.0) {
                    inValue = 100.0;
                } else if (inValue < 0.0) {
                    inValue = 0.0;
                }
                if (Math.abs(this.getLastValidIn().getValue() - inValue) > 0.5 * deadBand) {
                    this.getLastValidIn().setValue(this.getIn().getValue());
                    this.getLastValidIn().setStatus(this.getIn().getStatus());
                }
            } else if (prop.equals(lastValidIn) && !this.getFunction().equals((Object)BRaiseLowerFunction.resetLowerState) && !this.getFunction().equals((Object)BRaiseLowerFunction.resetRaiseState)) {
                BStatus s = this.propagate(this.getLastValidIn().getStatus());
                this.getOut().setStatus(s);
                this.getRaise().setStatus(s);
                this.getLower().setStatus(s);
                this.update();
            }
        }
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)out)) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }

    public void doUpdate() {
        LOGGER.fine("Update in progress");
        this.stopAndUpdateVirtualPosition();
        double delta = 0.0;
        BRaiseLowerFunction newFunctionState = BRaiseLowerFunction.staticState;
        if (!this.getFunction().equals((Object)BRaiseLowerFunction.resetLowerState) && !this.getFunction().equals((Object)BRaiseLowerFunction.resetRaiseState)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Input: " + this.getLastValidIn().getValue() + " Virtual: " + this.getVirtualPosition());
            }
            if (this.getLastValidIn().getValue() >= 100.0) {
                newFunctionState = BRaiseLowerFunction.resetRaiseState;
            } else if (this.getLastValidIn().getValue() <= 0.0) {
                newFunctionState = BRaiseLowerFunction.resetLowerState;
            } else {
                delta = this.getLastValidIn().getValue() - this.getVirtualPosition();
                if (delta > 0.0) {
                    newFunctionState = BRaiseLowerFunction.raiseState;
                } else if (delta < 0.0) {
                    newFunctionState = BRaiseLowerFunction.lowerState;
                }
            }
            this.changeFunctionState(newFunctionState);
        } else {
            newFunctionState = this.getFunction();
        }
        if (!this.getFunction().equals((Object)BRaiseLowerFunction.staticState)) {
            BRelTime timePeriod;
            if (newFunctionState.equals((Object)BRaiseLowerFunction.resetLowerState) || newFunctionState.equals((Object)BRaiseLowerFunction.resetRaiseState)) {
                long resetDriveTime = this.getCancelSynchronizationOfflimits() ? this.getDriveTime().getMillis() : this.getDriveTime().getMillis() * 2L;
                timePeriod = BRelTime.make((long)resetDriveTime);
            } else {
                timePeriod = BRelTime.make((long)((long)((double)this.getDriveTime().getMillis() / 100.0 * Math.abs(delta))));
            }
            this.lastVirtualPositionTime = BRelTime.make((long)Clock.ticks());
            this.newVirtualPosition = this.getLastValidIn().getValue();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Activating timer for drive time: " + timePeriod);
            }
            this.driveTimePeriod = timePeriod;
            this.driveTimeTicket = Clock.schedule((BComponent)this, (BRelTime)timePeriod, (Action)finishMoving, null);
        }
    }

    private void stopAndUpdateVirtualPosition() {
        if (this.driveTimeTicket != null && !this.lastVirtualPositionTime.equals((Object)BRelTime.DEFAULT)) {
            BRelTime timePeriod = this.driveTimePeriod;
            this.driveTimeTicket.cancel();
            this.driveTimeTicket = null;
            long timeDiff = Clock.ticks() - this.lastVirtualPositionTime.getMillis();
            double oldVirtualPosition = this.getVirtualPosition();
            double delta = this.newVirtualPosition - oldVirtualPosition;
            double calcVirtualPosition = oldVirtualPosition + (double)timeDiff / (double)timePeriod.getMillis() * delta;
            if (calcVirtualPosition < 0.0) {
                calcVirtualPosition = 0.0;
            } else if (calcVirtualPosition > 100.0) {
                calcVirtualPosition = 100.0;
            }
            this.setVirtualPosition(calcVirtualPosition);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("After stop and update on raise vp = " + this.getVirtualPosition());
            }
            this.lastVirtualPositionTime = BRelTime.DEFAULT;
            this.newVirtualPosition = 0.0;
        }
    }

    private void changeFunctionState(BRaiseLowerFunction functionState) {
        this.setFunction(functionState);
        BStatus newStatus = this.propagate(this.getLastValidIn().getStatus());
        this.getRaise().setStatus(newStatus);
        this.getLower().setStatus(newStatus);
        this.getOut().setStatus(newStatus);
        if (functionState.equals((Object)BRaiseLowerFunction.lowerState) || functionState.equals((Object)BRaiseLowerFunction.resetLowerState)) {
            this.getRaise().setValue(false);
            this.getLower().setValue(true);
            this.getOut().setValue(4.0);
        } else if (functionState.equals((Object)BRaiseLowerFunction.raiseState) || functionState.equals((Object)BRaiseLowerFunction.resetRaiseState)) {
            this.getRaise().setValue(true);
            this.getLower().setValue(false);
            this.getOut().setValue(10.0);
        } else {
            this.getRaise().setValue(false);
            this.getLower().setValue(false);
            if (functionState.equals((Object)BRaiseLowerFunction.offState)) {
                this.getOut().setValue(0.0);
            } else {
                this.getOut().setValue(7.0);
            }
        }
    }

    public void doFinishMoving() {
        LOGGER.fine("Finish moving called");
        boolean processUpdate = false;
        if (this.getFunction().equals((Object)BRaiseLowerFunction.resetLowerState)) {
            this.setVirtualPosition(0.0);
            processUpdate = this.getLastValidIn().getValue() > 0.0;
        } else if (this.getFunction().equals((Object)BRaiseLowerFunction.resetRaiseState)) {
            this.setVirtualPosition(100.0);
            processUpdate = this.getLastValidIn().getValue() < 100.0;
        } else {
            this.setVirtualPosition(this.newVirtualPosition);
        }
        this.changeFunctionState(BRaiseLowerFunction.staticState);
        this.lastVirtualPositionTime = BRelTime.DEFAULT;
        this.newVirtualPosition = 0.0;
        this.driveTimeTicket = null;
        if (processUpdate) {
            this.doUpdate();
        }
    }

    private void startResetTimer(BAbsTime date) {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
        }
        BAbsTime resetTime = this.getMidnightResetTime();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Next reset time: " + resetTime);
        }
        BAbsTime newDateTime = date.timeOfDay(resetTime.getHour(), resetTime.getMinute(), resetTime.getSecond(), 0);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Next reset event: " + newDateTime);
        }
        this.resetTicket = Clock.schedule((BComponent)this, (BAbsTime)newDateTime, (Action)reset, null);
    }

    private void stopResetTimer() {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
            this.resetTicket = null;
        }
    }

    public void doReset() {
        this.startResetTimer(BAbsTime.now().nextDay());
        this.changeFunctionState(BRaiseLowerFunction.resetLowerState);
        this.update();
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public double getNumeric() {
        return this.getOut().getValue();
    }

    public BFacets getNumericFacets() {
        return this.getFacets();
    }
}

