/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl;

import com.tridium.kitControl.BLoopPoint;
import java.util.Map;
import javax.baja.alarm.ext.offnormal.BTwoStateAlgorithm;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="errorLimit", type="double", defaultValue="0"), @NiagaraProperty(name="deadband", type="double", defaultValue="0"), @NiagaraProperty(name="lowDiffLimitEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="lowDiffLimit", type="double", defaultValue="0")})
public class BLoopAlarmAlgorithm
extends BTwoStateAlgorithm {
    @Generated
    public static final Property errorLimit = BLoopAlarmAlgorithm.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property deadband = BLoopAlarmAlgorithm.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property lowDiffLimitEnabled = BLoopAlarmAlgorithm.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property lowDiffLimit = BLoopAlarmAlgorithm.newProperty((int)0, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLoopAlarmAlgorithm.class);
    private static final BFormat HIGH_DIFF_LIMIT_FORMAT = BFormat.make((String)BFormat.getLexiconPattern((String)"kitControl", (String)"loopAlarmAlgorithm.highDiffLimit", null));
    private static final BFormat LOW_AND_HIGH_DIFF_LIMIT_FORMAT = BFormat.make((String)BFormat.getLexiconPattern((String)"kitControl", (String)"loopAlarmAlgorithm.lowAndHighDiffLimit", null));

    @Generated
    public double getErrorLimit() {
        return this.getDouble(errorLimit);
    }

    @Generated
    public void setErrorLimit(double v) {
        this.setDouble(errorLimit, v, null);
    }

    @Generated
    public double getDeadband() {
        return this.getDouble(deadband);
    }

    @Generated
    public void setDeadband(double v) {
        this.setDouble(deadband, v, null);
    }

    @Generated
    public boolean getLowDiffLimitEnabled() {
        return this.getBoolean(lowDiffLimitEnabled);
    }

    @Generated
    public void setLowDiffLimitEnabled(boolean v) {
        this.setBoolean(lowDiffLimitEnabled, v, null);
    }

    @Generated
    public double getLowDiffLimit() {
        return this.getDouble(lowDiffLimit);
    }

    @Generated
    public void setLowDiffLimit(double v) {
        this.setDouble(lowDiffLimit, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final Object fw(int x, Object a, Object b, Object c, Object d) {
        switch (x) {
            case 11: {
                this.fwStarted();
                break;
            }
            case 2: {
                this.fwChanged((Property)a);
            }
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        this.setErrorLimitDisplayName();
    }

    private void fwChanged(Property property) {
        if (this.isRunning() && property.equals(lowDiffLimitEnabled)) {
            this.setErrorLimitDisplayName();
        }
    }

    private void setErrorLimitDisplayName() {
        BFormat format = this.getDisplayNameFormat(errorLimit);
        if (format == null || format.equals((Object)HIGH_DIFF_LIMIT_FORMAT) || format.equals((Object)LOW_AND_HIGH_DIFF_LIMIT_FORMAT)) {
            format = this.getLowDiffLimitEnabled() ? HIGH_DIFF_LIMIT_FORMAT : LOW_AND_HIGH_DIFF_LIMIT_FORMAT;
            this.setDisplayName(errorLimit, format, null);
        }
    }

    public boolean isGrandparentLegal(BComponent grandparent) {
        return grandparent instanceof BLoopPoint;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)deadband) || slot.equals((Object)errorLimit) || slot.equals((Object)lowDiffLimit)) {
            BLoopPoint point = (BLoopPoint)this.getParentPoint();
            if (point == null) {
                return BFacets.DEFAULT;
            }
            BFacets facets = point.getInputFacets();
            BUnit unit = (BUnit)facets.getFacet("units");
            if (unit != null) {
                facets = BFacets.make((BFacets)facets, (String)"units", (BIDataValue)unit.getDifferentialUnit());
            }
            return facets;
        }
        return super.getSlotFacets(slot);
    }

    protected boolean isNormal(BStatusValue out) {
        double lowDiffLimit;
        BLoopPoint loopPt = (BLoopPoint)this.getParentPoint();
        double error = loopPt.getSetpoint().getValue() - loopPt.getControlledVariable().getValue();
        double highDiffLimit = this.getErrorLimit();
        double d = lowDiffLimit = this.getLowDiffLimitEnabled() ? -this.getLowDiffLimit() : -this.getErrorLimit();
        if (this.isCurrentOffnormal()) {
            return error < highDiffLimit - this.getDeadband() && error > lowDiffLimit + this.getDeadband();
        }
        return error < highDiffLimit && error > lowDiffLimit;
    }

    public void writeAlarmData(BStatusValue out, Map map) {
        BLoopPoint loopPt = (BLoopPoint)this.getParentPoint();
        map.put("controlledValue", BString.make((String)loopPt.getControlledVariable().valueToString((Context)loopPt.getInputFacets())));
        map.put("status", BString.make((String)out.getStatus().toString(null)));
        map.put("setptValue", BString.make((String)loopPt.getSetpoint().valueToString((Context)loopPt.getInputFacets())));
        map.put("deadband", BString.make((String)BDouble.toString((double)this.getDeadband(), (Context)loopPt.getInputFacets())));
        map.put("highDiffLimit", BString.make((String)BDouble.toString((double)this.getErrorLimit(), (Context)loopPt.getInputFacets())));
        map.put("lowDiffLimit", BString.make((String)BDouble.toString((double)(this.getLowDiffLimitEnabled() ? this.getLowDiffLimit() : this.getErrorLimit()), (Context)loopPt.getInputFacets())));
    }
}

