/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.email.alarm;

import com.tridium.alarm.ack.BAlarmAcknowledger;
import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.email.BEmail;
import javax.baja.email.BEmailHeader;
import javax.baja.email.BTextPart;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraAction(name="received", parameterType="BEmail", defaultValue="new BEmail()", flags=24)
public final class BEmailAlarmAcknowledger
extends BAlarmAcknowledger {
    @Generated
    public static final Action received = BEmailAlarmAcknowledger.newAction((int)24, (BValue)new BEmail(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BEmailAlarmAcknowledger.class);
    private static final String replyToRegExp = "(alarm\\.)([A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12})";
    private static final String uuidRegExp = "()([A-Fa-f0-9]{8}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{4}-[A-Fa-f0-9]{12})";
    private static final BIcon icon = BIcon.make((BIcon)BIcon.std((String)"email.png"), (BIcon)BIcon.std((String)"badges/new.png"));

    @Generated
    public void received(BEmail parameter) {
        this.invoke(received, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action == received) {
            this.post((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void doReceived(BEmail email) {
        BAlarmRecord record;
        BUuid uuid;
        Pattern replyToPattern;
        Pattern uuidPattern;
        if (this.getStatus().isDisabled()) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Processing received email: " + email.getSubject());
        }
        this.incTotalMessagesReceivedToday();
        try {
            uuidPattern = Pattern.compile(uuidRegExp);
            replyToPattern = Pattern.compile(replyToRegExp);
        }
        catch (PatternSyntaxException e) {
            this.doFail(e.getMessage());
            return;
        }
        BEmailHeader[] replyToHeader = email.getHeaders().getHeader("In-Reply-To");
        Matcher uuidMatcher = uuidPattern.matcher(email.getSubject());
        Object replyMatcher = null;
        if (replyToHeader.length > 0) {
            replyMatcher = replyToPattern.matcher(replyToHeader[0].getValue());
        }
        if (replyToHeader.length > 0 && ((Matcher)replyMatcher).find()) {
            uuid = BUuid.make((String)((Matcher)replyMatcher).group(2));
        } else if (uuidMatcher.find()) {
            uuid = BUuid.make((String)uuidMatcher.group(2));
        } else if (email.getBody() instanceof BTextPart && uuidMatcher.reset(((BTextPart)email.getBody()).getText()).find()) {
            uuid = BUuid.make((String)uuidMatcher.group(2));
        } else {
            log.fine("Unable to find UUID in message content.");
            this.doFail("Unable to find UUID in message content.");
            return;
        }
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        try {
            AlarmDbConnection conn = alarmService.getAlarmDb().getDbConnection(null);
            replyMatcher = null;
            try {
                record = conn.getRecord(uuid);
            }
            catch (Throwable throwable) {
                replyMatcher = throwable;
                throw throwable;
            }
            finally {
                if (conn != null) {
                    if (replyMatcher != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)replyMatcher).addSuppressed(throwable);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (IOException ioe) {
            log.log(Level.SEVERE, "Unable to read alarm record.", ioe);
            this.doFail("Unable to read alarm record.");
            return;
        }
        if (record == null) {
            log.fine("Unable to find specified record in alarm database.");
            this.doFail("Unable to find specified record in alarm database.");
            return;
        }
        BAlarmClass alarmClass = alarmService.lookupAlarmClass(record.getAlarmClass());
        BUser user = null;
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser[] users = (BUser[])userService.getChildren(BUser.class);
        for (int i = 0; i < users.length; ++i) {
            if (!users[i].getEmail().equalsIgnoreCase(email.getFrom().getAddress())) continue;
            if (!users[i].getEnabled()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("User '" + users[i].getUsername() + "' is disabled.");
                }
                this.doFail("User '" + users[i].getUsername() + "' is disabled.");
                return;
            }
            if (!users[i].getPermissionsFor((BIProtected)alarmClass).hasAdminWrite()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("User '" + users[i].getUsername() + "' does not have permissions for alarm class '" + alarmClass.getName() + "'.");
                }
                this.doFail("User '" + users[i].getUsername() + "' does not have permissions for alarm class '" + alarmClass.getName() + "'.");
                return;
            }
            user = users[i];
            break;
        }
        if (user == null) {
            log.fine("User not found for '" + email.getFrom().getAddress() + "'.");
            this.doFail("User not found for '" + email.getFrom().getAddress() + "'.");
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Alarm acknowledged by user " + user.getUsername());
        }
        this.ackAlarm(uuid, user.getUsername());
    }
}

