/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.model;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionType;
import com.tridium.util.graph.Digraph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.baja.nre.util.Array;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;

public abstract class SortingUtil {
    public static BIOrionApp[] sortApps(BOrionDatabase db, BIOrionApp[] unsorted) {
        HashMap<BTypeSpec, BIOrionApp> typeToApp = new HashMap<BTypeSpec, BIOrionApp>();
        for (int i = 0; i < unsorted.length; ++i) {
            OrionType[] at = unsorted[i].getOrionTypes();
            if (at == null) continue;
            for (int j = 0; j < at.length; ++j) {
                typeToApp.put(at[j].getTypeSpec(), unsorted[i]);
            }
        }
        HashMap<BIOrionApp, HashSet<BIOrionApp>> edges = new HashMap<BIOrionApp, HashSet<BIOrionApp>>();
        for (Map.Entry entry : typeToApp.entrySet()) {
            OrionType t = (OrionType)((BTypeSpec)entry.getKey()).getResolvedType();
            BIOrionApp ta = (BIOrionApp)entry.getValue();
            Property[] props = t.getProperties();
            for (int j = 0; j < props.length; ++j) {
                BOrionTypeId targetTypeId;
                OrionType r;
                BIOrionApp ra;
                if (props[j].getType() != BRef.TYPE || ta == (ra = (BIOrionApp)typeToApp.get((r = db.getType(targetTypeId = ((BRef)props[j].getDefaultValue()).getTargetOrionTypeId())).getTypeSpec()))) continue;
                HashSet<BIOrionApp> to = (HashSet<BIOrionApp>)edges.get(ra);
                if (to == null) {
                    to = new HashSet<BIOrionApp>();
                    edges.put(ra, to);
                }
                to.add(ta);
            }
        }
        Digraph dg = new Digraph();
        for (Map.Entry entry : edges.entrySet()) {
            BIOrionApp ta = (BIOrionApp)entry.getKey();
            Set to = (Set)entry.getValue();
            for (BIOrionApp ra : to) {
                dg.addEdge((Object)ta, (Object)ra);
            }
        }
        Array result = new Array(BIOrionApp.class);
        for (int i = 0; i < unsorted.length; ++i) {
            BIOrionApp app = unsorted[i];
            if (dg.hasVertex((Object)app)) continue;
            result.add((Object)app);
        }
        List sorted = dg.topologicalSortList();
        for (int i = 0; i < sorted.size(); ++i) {
            result.add(sorted.get(i));
        }
        return (BIOrionApp[])result.trim();
    }

    public static OrionType[] sortTypes(BOrionDatabase db, OrionType[] unsorted) {
        HashSet<BTypeSpec> members = new HashSet<BTypeSpec>();
        for (int i = 0; i < unsorted.length; ++i) {
            members.add(unsorted[i].getTypeSpec());
        }
        Digraph dg = new Digraph();
        for (int i = 0; i < unsorted.length; ++i) {
            OrionType t = unsorted[i];
            Property[] props = t.getProperties();
            for (int j = 0; j < props.length; ++j) {
                BOrionTypeId targetTypeId;
                OrionType r;
                if (props[j].getType() != BRef.TYPE || !members.contains((r = db.getType(targetTypeId = ((BRef)props[j].getDefaultValue()).getTargetOrionTypeId())).getTypeSpec())) continue;
                dg.addEdge((Object)r.getTypeSpec(), (Object)t.getTypeSpec());
            }
        }
        Array result = new Array(OrionType.class);
        for (int i = 0; i < unsorted.length; ++i) {
            OrionType t = unsorted[i];
            if (dg.hasVertex((Object)t.getTypeSpec())) continue;
            result.add((Object)t);
        }
        List sorted = dg.topologicalSortList();
        for (int i = 0; i < sorted.size(); ++i) {
            result.add((Object)((OrionType)((BTypeSpec)sorted.get(i)).getResolvedType()));
        }
        return (OrionType[])result.trim();
    }
}

