/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.nre.util.LegacyStorageUtil;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.model.DynamicOrionProperty;
import com.tridium.orion.priv.model.DynamicOrionType;
import com.tridium.orion.sql.PropertyValue;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.io.BIContextEncodable;
import javax.baja.io.ValueDocDecoder;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

public class OrionInput {
    private static final Logger log = Logger.getLogger("orion");
    private XIn in;
    private BOrionDatabase db;
    private HashMap<BOrionTypeId, OrionType> types = new HashMap();
    private OrionType lastType;
    private Context passwordContext = null;
    private boolean isLegacyConnection = false;

    public OrionInput(InputStream input, Context passwordContext) throws Exception {
        this((BOrionDatabase)null, input, passwordContext);
    }

    public OrionInput(BOrionDatabase db, InputStream input, Context passwordContext) throws Exception {
        this.db = db;
        this.in = new XIn(XParser.make((InputStream)input));
        this.passwordContext = passwordContext;
    }

    public OrionInput(OrionSession session, InputStream input, Context passwordContext) throws Exception {
        this(session == null ? null : session.getOrionDatabase(), input, passwordContext);
        this.passwordContext = passwordContext;
    }

    public void close() {
        try {
            this.in.close();
        }
        catch (Exception ex) {
            throw new OrionException("Cannot close input.", ex);
        }
    }

    public int readIntElem(String elemName, String attrName) throws Exception {
        int nodeType = this.in.next();
        if (nodeType != 1) {
            throw new OrionException("Expecting start of " + elemName + ".");
        }
        XElem pElem = this.in.elem();
        if (!pElem.name().equals(elemName)) {
            throw new OrionException("Expecting start of " + elemName + ".");
        }
        int size = pElem.geti(attrName);
        nodeType = this.in.next();
        if (nodeType != 2 || !this.in.elem().name().equals(elemName)) {
            throw new OrionException("Expecting end of " + elemName + ".");
        }
        return size;
    }

    public BIOrionObject readObject() throws Exception {
        return this.readObject(false);
    }

    public BIOrionObject readUpdate() throws Exception {
        return this.readObject(true);
    }

    private BIOrionObject readObject(boolean update) throws Exception {
        int nodeType = this.in.next();
        if (nodeType == -1) {
            return null;
        }
        while (nodeType == 1 && (this.in.elem().name().equals("type") || this.in.elem().name().equals("association"))) {
            this.in.push();
            this.readType();
            nodeType = this.in.next();
        }
        if (nodeType != 1) {
            throw new OrionException("Expecting start of object.");
        }
        XElem objElem = this.in.elem();
        if (!objElem.name().equals("obj")) {
            throw new OrionException("Expecting start of object.");
        }
        BOrionTypeId typeId = BOrionTypeId.make(objElem.get("type"));
        OrionType type = null;
        type = this.lastType != null && typeId.equals((Object)this.lastType.getOrionTypeId()) ? this.lastType : this.types.get((Object)typeId);
        if (type == null) {
            throw new OrionException("Unrecognized type: " + (Object)((Object)typeId));
        }
        nodeType = this.in.next();
        BIOrionObject obj = (BIOrionObject)type.getInstance();
        while (nodeType == 1) {
            XElem elem = this.in.elem();
            if (elem.name().equals("p")) {
                this.in.push();
                this.readProperty(type, obj, update);
            }
            nodeType = this.in.next();
        }
        if (nodeType != 2 || !this.in.elem().name().equals("obj")) {
            throw new OrionException("Expecting end of obj element.");
        }
        if (this.db != null) {
            obj.setOrionDatabase(this.db);
        }
        return obj;
    }

    private void readProperty(OrionType type, BIOrionObject obj, boolean update) throws Exception {
        int nodeType = this.in.next();
        if (nodeType != 1) {
            throw new OrionException("Expecting start of property.");
        }
        XElem pElem = this.in.elem();
        if (!pElem.name().equals("p")) {
            throw new OrionException("Expecting start of property.");
        }
        String name = pElem.get("n");
        Property p = type.getProperty(name);
        if (p != null) {
            Object value = null;
            if (p.getDefaultValue() instanceof BSimple) {
                boolean resolved;
                BSimple def = (BSimple)p.getDefaultValue();
                if (def instanceof BIContextEncodable) {
                    if (this.isLegacyConnection()) {
                        BPassword decodePassword = BPassword.make((String)LegacyStorageUtil.decode((String)pElem.get("v")));
                        value = decodePassword;
                    } else {
                        value = (BSimple)((BIContextEncodable)def).decodeFromString(pElem.get("v"), this.passwordContext);
                    }
                } else {
                    value = (BSimple)def.decodeFromString(pElem.get("v"));
                }
                if (def.getType() == BRef.TYPE && (resolved = pElem.get("r", "false").equals("true"))) {
                    BIOrionObject target = this.readResolved(update);
                    value = BRef.make(target);
                }
            } else {
                value = ValueDocDecoder.unmarshal((String)pElem.get("v"));
            }
            if (update) {
                obj.set(p, (BValue)value);
                obj.setModified(p, true);
            } else {
                obj.init(p, (BValue)value);
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Property not found for type: " + type.toString() + "." + name);
        }
        nodeType = this.in.next();
        if (nodeType != 2 || !this.in.elem().name().equals("p")) {
            throw new OrionException("Expecting end of property element.");
        }
    }

    private BIOrionObject readResolved(boolean update) throws Exception {
        int nodeType = this.in.next();
        if (nodeType != 1) {
            throw new OrionException("Expecting start of resolved ref.");
        }
        XElem pElem = this.in.elem();
        if (!pElem.name().equals("resolved")) {
            throw new OrionException("Expecting start of resolved ref.");
        }
        BIOrionObject resolvedObj = this.readObject(update);
        nodeType = this.in.next();
        if (nodeType != 2 || !this.in.elem().name().equals("resolved")) {
            throw new OrionException("Expecting end of resolved ref.");
        }
        return resolvedObj;
    }

    public OrionType readType() throws Exception {
        int nodeType = this.in.next();
        if (nodeType == -1) {
            return null;
        }
        if (nodeType != 1) {
            throw new IllegalStateException("Expecting start of type element.");
        }
        XElem typeElem = this.in.elem();
        String typeElemName = typeElem.name();
        if (!typeElemName.equals("type") && !typeElemName.equals("association")) {
            throw new IllegalStateException("Expecting start of type element.");
        }
        BOrionTypeId typeId = BOrionTypeId.make(typeElem.get("id"));
        BOrionTypeId superType = null;
        Array props = new Array(Property.class);
        HashMap<String, Property> dupCheck = new HashMap<String, Property>();
        int flags = 0;
        if (typeElem.get("abstract", "false").equals("true")) {
            flags |= 1;
        }
        if (typeElem.get("final", "false").equals("true")) {
            flags |= 2;
        }
        int next = -1;
        block6: do {
            next = this.in.next();
            switch (next) {
                case 1: {
                    Property newProp;
                    String startName = this.in.elem().name();
                    if (startName.equals("superType")) {
                        if (superType != null) {
                            throw new IllegalStateException("superType is already defined: " + (Object)((Object)superType));
                        }
                        this.in.push();
                        superType = this.readSuperType();
                        break;
                    }
                    if (startName.equals("property")) {
                        this.in.push();
                        newProp = this.readPropertyDef(typeId);
                        if (newProp == null) continue block6;
                        if (dupCheck.get(newProp.getName()) != null) {
                            throw new IllegalStateException("Duplicate slot (" + newProp.getName() + ") defined for type " + (Object)((Object)typeId) + ".");
                        }
                        props.add((Object)newProp);
                        dupCheck.put(newProp.getName(), newProp);
                        break;
                    }
                    if (startName.equals("ref")) {
                        this.in.push();
                        newProp = this.readRefDef(typeId);
                        if (dupCheck.get(newProp.getName()) != null) {
                            throw new IllegalStateException("Duplicate slot (" + newProp.getName() + ") defined for type " + (Object)((Object)typeId) + ".");
                        }
                        props.add((Object)newProp);
                        dupCheck.put(newProp.getName(), newProp);
                        break;
                    }
                    throw new IllegalStateException("Unexpected element: " + startName);
                }
                case 2: {
                    String endName = this.in.elem().name();
                    if (!endName.equals(typeElemName)) {
                        throw new IllegalStateException("Expecting end of " + typeElemName + " element.");
                    }
                    OrionType type = null;
                    type = typeElemName.equals("type") ? new DynamicOrionType(typeId, superType, flags, (Property[])props.trim()) : new DynamicOrionType(typeId, superType, flags | 4, (Property[])props.trim());
                    if (!typeId.isDynamic()) {
                        Type localType = null;
                        try {
                            localType = Sys.getType((String)typeId.getTypeSpec().toString());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (localType != null) {
                            type = (OrionType)localType;
                        }
                    }
                    this.lastType = type;
                    return type;
                }
                default: {
                    throw new IllegalStateException("Unexpected node type: " + nodeType);
                }
            }
        } while (next != -1);
        throw new IllegalStateException("Unexpected EOF.");
    }

    private BOrionTypeId readSuperType() throws Exception {
        int nodeType = this.in.next();
        if (nodeType != 1) {
            throw new IllegalStateException("Expecting start of superType element.");
        }
        XElem superTypeElem = this.in.elem();
        if (!superTypeElem.name().equals("superType")) {
            throw new IllegalStateException("Expecting start of superType element.");
        }
        String typeId = superTypeElem.get("id");
        nodeType = this.in.next();
        if (nodeType != 2 || !this.in.elem().name().equals("superType")) {
            throw new IllegalStateException("Expecting end of superType element.");
        }
        return BOrionTypeId.make(typeId);
    }

    private Property readPropertyDef(BOrionTypeId typeId) throws Exception {
        int nodeType = this.in.next();
        if (nodeType != 1) {
            throw new IllegalStateException("Expecting start of property element.");
        }
        XElem propElem = this.in.elem();
        if (!propElem.name().equals("property")) {
            throw new IllegalStateException("Expecting start of property element.");
        }
        String name = propElem.get("name");
        Type propType = null;
        Object def = null;
        BFacets facets = null;
        Object refTypeId = null;
        String typeSpec = propElem.get("type");
        try {
            propType = ((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(typeSpec)).getResolvedType();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Type '" + typeSpec + "' not found for property: " + typeId.toString() + "." + name);
            }
            if ((nodeType = this.in.next()) != 2 || !this.in.elem().name().equals("property")) {
                throw new IllegalStateException("Expecting end of property element.");
            }
            return null;
        }
        def = propType == BAbsTime.TYPE ? BAbsTime.make((long)Long.parseLong(propElem.get("def"))) : PropertyValue.decodeValueFromString(propType, propElem.get("def"), this.passwordContext, this.isLegacyConnection());
        facets = (BFacets)BFacets.DEFAULT.decodeFromString(propElem.get("facets", ""));
        nodeType = this.in.next();
        if (nodeType != 2 || !this.in.elem().name().equals("property")) {
            throw new IllegalStateException("Expecting end of property element.");
        }
        return new DynamicOrionProperty(name, propType, (BValue)def, facets, 0);
    }

    private Property readRefDef(BOrionTypeId typeId) throws Exception {
        int nodeType = this.in.next();
        if (nodeType != 1) {
            throw new IllegalStateException("Expecting start of ref element.");
        }
        XElem refElem = this.in.elem();
        if (!refElem.name().equals("ref")) {
            throw new IllegalStateException("Expecting start of ref element.");
        }
        String name = refElem.get("name");
        BOrionTypeId targetTypeId = BOrionTypeId.make(refElem.get("target"));
        BFacets facets = (BFacets)BFacets.DEFAULT.decodeFromString(refElem.get("facets", ""));
        nodeType = this.in.next();
        if (nodeType == 1 && this.in.elem().name().equals("inverse")) {
            this.in.push();
            facets = BFacets.make((BFacets)facets, (BFacets)this.readInverse());
            nodeType = this.in.next();
        }
        if ((nodeType = this.in.type()) != 2 || !this.in.elem().name().equals("ref")) {
            throw new IllegalStateException("Expecting end of ref element.");
        }
        return new DynamicOrionProperty(name, BRef.TYPE, (BValue)BRef.make(targetTypeId), facets, 0);
    }

    private BFacets readInverse() throws Exception {
        int nodeType = this.in.next();
        if (nodeType != 1) {
            throw new IllegalStateException("Expecting start of inverse element.");
        }
        XElem iElem = this.in.elem();
        if (!iElem.name().equals("inverse")) {
            throw new IllegalStateException("Expecting start of inverse element.");
        }
        String name = iElem.get("name");
        nodeType = this.in.next();
        if (nodeType != 2 || !this.in.elem().name().equals("inverse")) {
            throw new IllegalStateException("Expecting end of inverse element.");
        }
        return BFacets.make((String)"inverse", (String)name);
    }

    public void setLegacyConnection(boolean legacyConnection) {
        this.isLegacyConnection = legacyConnection;
    }

    public boolean isLegacyConnection() {
        return this.isLegacyConnection;
    }

    private class XIn {
        private XParser xparser;
        private boolean pushed = false;

        public XIn(XParser xparser) {
            this.xparser = xparser;
        }

        public int next() throws Exception {
            if (this.pushed) {
                this.pushed = false;
                return this.xparser.type();
            }
            return this.xparser.next();
        }

        public int type() {
            return this.xparser.type();
        }

        public XElem elem() {
            return this.xparser.elem();
        }

        public XText text() {
            return this.xparser.text();
        }

        public void push() {
            this.pushed = true;
        }

        public void close() {
            this.xparser.close();
        }
    }
}

