/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.fox;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BOrionChannel;
import com.tridium.orion.priv.fox.FoxOrionSession;
import com.tridium.orion.sql.BatchStatement;
import javax.baja.nre.util.Array;

public abstract class FoxBatch
implements BatchStatement {
    protected final FoxOrionSession session;
    protected final BOrionChannel channel;
    protected final OrionType type;
    protected final Array arr;
    protected int chunkSize;

    public FoxBatch(FoxOrionSession session, BOrionChannel channel, OrionType type) {
        this.session = session;
        this.channel = channel;
        this.type = type;
        this.arr = new Array(type.getTypeClass());
    }

    @Override
    public void add(BIOrionObject object) {
        if (!object.getOrionType().equals(this.type)) {
            throw new OrionException("Type mismatch: object type (" + object.getOrionType() + ")  is not the same as the batch type (" + this.type + ").");
        }
        this.arr.add((Object)object);
    }

    @Override
    public BIOrionObject get(int index) {
        return (BIOrionObject)this.arr.get(index);
    }

    @Override
    public int size() {
        return this.arr.size();
    }

    @Override
    public void clear() {
        this.arr.clear();
    }

    @Override
    public OrionType getOrionType() {
        return this.type;
    }

    @Override
    public void setChunkSize(int chunkSize) {
        if (chunkSize < 0) {
            throw new OrionException("Invalid chunkSize of '" + chunkSize + "'.  The chunkSize must be >= 0.");
        }
        this.chunkSize = chunkSize;
    }

    @Override
    public int getChunkSize() {
        return this.chunkSize;
    }
}

