/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.orion.priv.db.sql;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.db.DbCursor;
import com.tridium.orion.priv.db.DbOrionSession;
import com.tridium.orion.priv.db.TableDefinition;
import com.tridium.orion.priv.db.sql.Scan;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.rdb.jdbc.RdbmsPreparedStatement;
import java.sql.SQLException;
import javax.baja.sys.Property;

public class LinkedScan
extends Scan {
    public LinkedScan(DbOrionSession session) {
        super(session);
    }

    public OrionCursor linkedScan(BIOrionObject obj, OrionType linkType, OrionType scanType) {
        OrionType objType = obj.getOrionType();
        TableDefinition objDef = TableDefinition.get(this.db, objType);
        TableDefinition linkDef = TableDefinition.get(this.db, linkType);
        TableDefinition scanDef = TableDefinition.get(this.db, scanType);
        Property[] ko = objType.getKey();
        if (ko.length != 1) {
            throw new OrionException("Type " + objType + " must have exactly one key property.");
        }
        Property objKey = ko[0];
        String sql = this.makeLinkScanSql(objDef, linkDef, scanDef, objType, linkType, scanType, scanDef.getTableName(), linkDef.getTableName(), objDef.getTableName(), objKey.getName());
        try {
            PropertyValue[] pv = new PropertyValue[]{new PropertyValue(objKey, obj.get(objKey))};
            RdbmsPreparedStatement prep = this.session.makeStatement(this.db, this.conn, sql);
            this.loadPreparedSelect(objDef, pv, prep);
            return new DbCursor(this.session, scanType, prep.executeQuery(), false, false);
        }
        catch (SQLException e) {
            throw new OrionException(e);
        }
    }

    private String makeLinkScanSql(TableDefinition objDef, TableDefinition linkDef, TableDefinition scanDef, OrionType objType, OrionType linkType, OrionType scanType, String scan, String link, String obj, String objKey) {
        Property[] ka = scanType.getKey();
        if (ka.length != 1) {
            throw new OrionException("Type " + scanType + " must have exactly one key property.");
        }
        String scanKey = ka[0].getName();
        String linkScan = this.findLinkage(linkType, scanType).getName();
        String linkObj = this.findLinkage(linkType, objType).getName();
        return this.makeSqlForType(scanDef).toString() + " INNER JOIN " + link + " ON " + scan + "." + scanKey + " = " + link + "." + linkScan + " INNER JOIN " + obj + " ON " + link + "." + linkObj + " = " + obj + "." + objKey + " WHERE " + obj + "." + objKey + " = ?";
    }

    private Property findLinkage(OrionType linkType, OrionType keyType) {
        Property[] props = linkType.getProperties();
        Property link = null;
        for (int i = 0; i < props.length; ++i) {
            BRef ref;
            BOrionTypeId targetTypeId;
            OrionType targetType;
            if (!props[i].getType().is(BRef.TYPE) || !keyType.is(targetType = this.db.getType(targetTypeId = (ref = (BRef)props[i].getDefaultValue()).getTargetOrionTypeId()))) continue;
            if (link == null) {
                link = props[i];
                continue;
            }
            throw new OrionException("More than one link property found on " + linkType + " for " + keyType);
        }
        if (link == null) {
            throw new OrionException("Could not find link property on " + linkType + " for key " + keyType);
        }
        return link;
    }
}

