/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nc.ui.history;

import com.tridium.nc.history.BCloudHistoryDeviceExt;
import com.tridium.nc.history.BCloudHistoryExportLearnConfig;
import com.tridium.nc.ui.ConfirmedInvokeActionCommand;
import com.tridium.nc.ui.history.BCloudHistoryExportManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.ui.history.ArchiveManagerController;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;

public class CloudHistoryExportController
extends ArchiveManagerController {
    private static final Logger log = Logger.getLogger("ncloud.history");
    private static final Lexicon lex = Lexicon.make(CloudHistoryExportController.class);
    private final BCloudHistoryExportManager manager;
    private final MgrController.MgrCommand historyLearn;

    CloudHistoryExportController(BCloudHistoryExportManager manager) {
        super((BArchiveManager)manager);
        this.manager = manager;
        this.historyLearn = new HistoryLearn((BWidget)manager);
        this.historyLearn.setFlags(7);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        MgrController.IMgrCommand[] cmds = super.makeCommands();
        cmds[cmds.length - 1] = this.historyLearn;
        return cmds;
    }

    private MgrController.IMgrCommand[] makeCloudHistoryCommands() {
        return new MgrController.IMgrCommand[]{this.historyLearn};
    }

    public BWidget makeActionBar() {
        MgrController.IMgrCommand[] cmds1 = super.makeCommands();
        MgrController.IMgrCommand[] cmds2 = this.makeCloudHistoryCommands();
        BEdgePane pane = new BEdgePane();
        pane.setTop(this.makeActionPane(cmds1));
        pane.setCenter((BWidget)new BBorderPane(this.makeActionPane(cmds2)));
        return pane;
    }

    class HistoryLearn
    extends MgrController.MgrCommand {
        HistoryLearn(BWidget owner) {
            super(owner, lex, "historyLearn");
        }

        public CommandArtifact doInvoke() {
            try {
                BComponent comp = CloudHistoryExportController.this.manager.getTarget();
                if (comp instanceof BIArchiveFolder) {
                    BIArchiveFolder folder = (BIArchiveFolder)comp;
                    BCloudHistoryDeviceExt deviceExt = (BCloudHistoryDeviceExt)folder.getDeviceExt();
                    Action learnAction = deviceExt.getAction("learnHistories");
                    BCloudHistoryExportLearnConfig arg = new BCloudHistoryExportLearnConfig();
                    arg.setBeginExportTime(BAbsTime.now());
                    ConfirmedInvokeActionCommand cmd = new ConfirmedInvokeActionCommand((BWidget)CloudHistoryExportController.this.manager, (BComponent)deviceExt, learnAction, (BValue)arg, lex.getText("historyLearn.confirm"), lex.getText("historyLearn.message"));
                    cmd.doInvoke();
                }
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Exception invoking Cloud History Learn:" + e, log.isLoggable(Level.FINE) ? e : null);
            }
            return null;
        }
    }
}

