/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.niagaraSystemIndex;

import com.tridium.fox.sys.UnreachableStationException;
import com.tridium.nd.sysdef.BReachableStationInfo;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.niagaraSystemIndex.BAbstractSystemIndexDeviceExt;
import com.tridium.niagaraSystemIndex.BReachableStationsSystemIndexMonitor;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.IllegalChildException;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"niagaraDriver:ReachableStationInfo"})})
@NiagaraProperty(name="usedByLastGlobalIndexAttempt", type="boolean", defaultValue="false", flags=1)
public final class BReachableStationSystemIndexDeviceExt
extends BAbstractSystemIndexDeviceExt
implements BIMixIn,
BIRestrictedComponent {
    @Generated
    public static final Property usedByLastGlobalIndexAttempt = BReachableStationSystemIndexDeviceExt.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BReachableStationSystemIndexDeviceExt.class);
    private static final Logger LOG = Logger.getLogger("systemIndex");
    private volatile BStatus reachableStatus = BStatus.ok;

    @Generated
    public boolean getUsedByLastGlobalIndexAttempt() {
        return this.getBoolean(usedByLastGlobalIndexAttempt);
    }

    @Generated
    public void setUsedByLastGlobalIndexAttempt(boolean v) {
        this.setBoolean(usedByLastGlobalIndexAttempt, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public String getStationName() {
        return this.getReachableStationInfo().getStationName();
    }

    @Override
    protected BReachableStationInfo getReachableStationInfo() {
        return (BReachableStationInfo)this.getParent();
    }

    @Override
    protected BStatus getReachableStationStatus() {
        return this.reachableStatus;
    }

    @Override
    protected void globalIndexSucceeded() {
        block4: {
            this.reachableStatus = BStatus.ok;
            try {
                String stationName = this.getStationName();
                Map infosForReachableStation = BReachableStations.findAllReachableStations((BObject)this, (boolean)false, (boolean)true, (boolean)true, null, (String[])new String[]{stationName});
                for (BReachableStationInfo info : (List)infosForReachableStation.get(stationName)) {
                    SlotCursor props = info.getProperties();
                    while (props.next(BReachableStationSystemIndexDeviceExt.class)) {
                        BReachableStationSystemIndexDeviceExt deviceExt = (BReachableStationSystemIndexDeviceExt)props.get();
                        if (deviceExt == this) continue;
                        deviceExt.setUsedByLastGlobalIndexAttempt(false);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.log(Level.WARNING, "Unexpected exception while updating 'UsedByLastGlobalIndexAttempt' properties initiated by: " + this.toPathString(), e);
            }
        }
        this.setUsedByLastGlobalIndexAttempt(true);
    }

    @Override
    protected void globalIndexFailed(Throwable reason) {
        this.reachableStatus = UnreachableStationException.extractUnoperationalStationException((Throwable)reason).isPresent() ? BStatus.down : BStatus.ok;
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            BReachableStationSystemIndexDeviceExt.updateReachableStationMonitor((BComplex)this);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (Sys.getStation().isRunning()) {
            BReachableStationSystemIndexDeviceExt.updateReachableStationMonitor((BComplex)this);
        }
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (globalIndexState.equals(property) || globalIndexStatus.equals(property) || globalIndexLastSuccess.equals(property) || acceptsGlobalIndexRequests.equals(property) || usedByLastGlobalIndexAttempt.equals(property)) {
            BReachableStationSystemIndexDeviceExt.updateReachableStationMonitor((BComplex)this);
        }
    }

    static void updateReachableStationMonitor(BComplex deviceExt) {
        block4: {
            if (!(deviceExt instanceof BReachableStationSystemIndexDeviceExt)) {
                return;
            }
            BReachableStationSystemIndexDeviceExt reachableDeviceExt = (BReachableStationSystemIndexDeviceExt)deviceExt;
            try {
                BReachableStations container = reachableDeviceExt.getReachableStationInfo().getReachableStationsContainer();
                BReachableStationsSystemIndexMonitor monitor = (BReachableStationsSystemIndexMonitor)container.get("niagaraSystemIndex_ReachableStationsSystemIndexMonitor");
                if (monitor == null) {
                    monitor = ((BReachableStationsSystemIndexMonitor[])container.getChildren(BReachableStationsSystemIndexMonitor.class))[0];
                }
                monitor.asyncUpdate();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINEST)) break block4;
                LOG.log(Level.FINEST, "Unexpected exception processing reachable station monitor update for " + reachableDeviceExt.getReachableStationInfo().toPathString(), e);
            }
        }
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)cx).getText("niagaraSystemIndex.deviceExt");
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        if (!parent.getType().is(BReachableStationInfo.TYPE)) {
            throw new IllegalParentException("baja", "IllegalParentException.parentAndChild", new Object[]{parent.getType(), this.getType()});
        }
        SlotCursor slots = parent.getProperties();
        while (slots.next(BReachableStationSystemIndexDeviceExt.class)) {
            if (slots.get() == this) continue;
            throw new IllegalChildException("baja", "IllegalExtraRestrictedComponent", new Object[]{this.getType(), parent.getType()});
        }
    }
}

