/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platLon;

import com.tridium.platLon.BLonPlatformService;
import com.tridium.sys.Nre;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BLonPlatformServiceNpsdk
extends BLonPlatformService {
    @Generated
    public static final Type TYPE = Sys.loadType(BLonPlatformServiceNpsdk.class);
    private boolean nativesLoaded = false;
    private static final int MAX_HANDLE = 3;
    private FileInputStream[] in = new FileInputStream[4];
    private FileOutputStream[] out = new FileOutputStream[4];
    private String[] devNames = new String[4];
    private boolean usesFileIo = true;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isValidPlatform() {
        String lonlibPath = Nre.getNiagaraHome() + File.separator + "bin" + File.separator + "liblonnpsdk.so";
        return AccessController.doPrivileged(() -> new File(lonlibPath).exists());
    }

    protected boolean loadLibraries() {
        if (this.nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading lonnpsdk native library");
                System.loadLibrary("lonnpsdk");
                this.nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load lonnpsdk native library", e);
            }
            return this.nativesLoaded;
        });
    }

    @Override
    public int driverInit(String deviceName) throws Exception {
        if (!this.loadLibraries()) {
            log.severe("Could not load lonnpsdk natives");
            throw new Exception("Could not load lonnpsdk natives");
        }
        String filePath = this.getDeviceFilePath0();
        if (filePath == null) {
            log.fine("Lon device file path not defined for file I/O, using native I/O");
            this.usesFileIo = false;
            return this.driverInitForNativeIO(deviceName);
        }
        log.fine("Lon device file path: " + filePath);
        this.usesFileIo = true;
        File driver = new File(filePath + File.separator + deviceName);
        if (driver.exists()) {
            log.fine("Found Lon device file: " + filePath + File.separator + deviceName);
            return this.driverInitForFileIO(deviceName);
        }
        log.severe("Could not find Lon device file: " + filePath + File.separator + deviceName);
        throw new Exception("Could not open Lon device file: " + filePath + File.separator + deviceName);
    }

    protected int driverInitForFileIO(String deviceName) throws Exception {
        int handle = -1;
        for (int i = 0; i < this.devNames.length; ++i) {
            if (this.devNames[i] == null || this.devNames[i].length() == 0) {
                handle = i;
                this.devNames[i] = deviceName;
                break;
            }
            if (!this.devNames[i].equals(deviceName)) continue;
            return i;
        }
        if (handle == -1) {
            throw new BajaException("All available Lon ports in use");
        }
        String prefix = this.getDeviceFilePath0();
        File driver = new File(prefix + File.separator + deviceName);
        this.in[handle] = new FileInputStream(driver);
        this.out[handle] = new FileOutputStream(driver);
        return handle;
    }

    protected int driverInitForNativeIO(String deviceName) throws Exception {
        if (!this.loadLibraries()) {
            log.severe("Could not load lonnpsdk natives");
            throw new Exception("Could not load lonnpsdk natives");
        }
        log.fine("Initializing native I/O for Lon device " + deviceName);
        int ldvHandle = this.ldvOpen0(deviceName);
        if (ldvHandle == -1) {
            log.severe("Could not open Lon device " + deviceName + " for native I/O");
            throw new Exception("Unable to open Lon device " + deviceName);
        }
        log.fine("Native I/O Lon device " + deviceName + " handle = " + ldvHandle);
        return ldvHandle;
    }

    @Override
    public void write(int handle, byte[] netBytes, int msgLen) throws Exception {
        if (log.isLoggable(Level.FINE)) {
            byte[] msg = new byte[msgLen];
            System.arraycopy(netBytes, 0, msg, 0, msgLen);
            String sb = "BLonPlatformServiceNpsdk.write: handle=" + handle + " usesFileIo=" + this.usesFileIo + " msgLen=" + msgLen + "\n" + TextUtil.bytesToHexString((byte[])msg);
            log.fine(sb);
        }
        if (this.usesFileIo) {
            this.out[handle].write(netBytes, 0, msgLen);
        } else {
            this.ldvWrite0(handle, netBytes, msgLen);
        }
    }

    @Override
    public boolean read(int handle, byte[] buf) throws Exception {
        int rc;
        int bytesRead;
        if (this.usesFileIo ? (bytesRead = this.in[handle].read(buf)) == -1 : (rc = this.ldvRead0(handle, buf)) == -1 || rc == 0) {
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            int len = buf[1] + 2;
            byte[] msg = new byte[len];
            System.arraycopy(buf, 0, msg, 0, len);
            String sb = "BLonPlatformServiceNpsdk.read: handle=" + handle + " usesFileIo=" + this.usesFileIo + " msgLen=" + len + "\n" + TextUtil.bytesToHexString((byte[])msg);
            log.fine(sb);
        }
        return true;
    }

    @Override
    public void close(int ldvHandle) {
        try {
            if (ldvHandle >= 0) {
                this.ldvClose0(ldvHandle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private native String getDeviceFilePath0();

    private native int ldvOpen0(String var1);

    private native int ldvRead0(int var1, byte[] var2) throws Exception;

    private native void ldvWrite0(int var1, byte[] var2, int var3) throws Exception;

    private native void ldvClose0(int var1) throws Exception;
}

