/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.dashboard;

import com.tridium.json.JSONObject;
import com.tridium.json.JSONTokener;
import com.tridium.json.JSONUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.security.BPermissions;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserService;
import javax.baja.util.ExecutorUtil;

@NiagaraType
@NiagaraProperty(name="lastClear", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=7)
@NiagaraActions(value={@NiagaraAction(name="clearMyDashboards", flags=136), @NiagaraAction(name="clearAllDashboards", flags=136), @NiagaraAction(name="readDashboard", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BString", flags=260), @NiagaraAction(name="writeDashboard", parameterType="BString", defaultValue="BString.DEFAULT", flags=260)})
public final class BDashboardService
extends BAbstractService {
    @Generated
    public static final Property lastClear = BDashboardService.newProperty((int)7, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Action clearMyDashboards = BDashboardService.newAction((int)136, null);
    @Generated
    public static final Action clearAllDashboards = BDashboardService.newAction((int)136, null);
    @Generated
    public static final Action readDashboard = BDashboardService.newAction((int)260, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action writeDashboard = BDashboardService.newAction((int)260, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDashboardService.class);
    private static final int jsonIndent = AccessController.doPrivileged(() -> Integer.getInteger("niagara.dashboards.indent", 0));
    private static final BIcon icon = BIcon.std((String)"braces.png");
    private static final String dashboardsKey = "dashboards";
    private static final String indexFileName = "index.json";
    private static final String fileKey = "file";
    private static final Logger LOG = Logger.getLogger("dashboard");
    private Subscriber userSubscriber;
    private ScheduledExecutorService executorSrv;
    private volatile ScheduledFuture<?> userRemovedFuture;

    @Generated
    public BAbsTime getLastClear() {
        return (BAbsTime)this.get(lastClear);
    }

    @Generated
    public void setLastClear(BAbsTime v) {
        this.set(lastClear, (BValue)v, null);
    }

    @Generated
    public void clearMyDashboards() {
        this.invoke(clearMyDashboards, null, null);
    }

    @Generated
    public void clearAllDashboards() {
        this.invoke(clearAllDashboards, null, null);
    }

    @Generated
    public BString readDashboard(BString parameter) {
        return (BString)this.invoke(readDashboard, (BValue)parameter, null);
    }

    @Generated
    public void writeDashboard(BString parameter) {
        this.invoke(writeDashboard, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public BIcon getIcon() {
        return icon;
    }

    public BPermissions getPermissions(Context cx) {
        return BPermissions.make((int)(super.getPermissions(cx).getMask() | 4));
    }

    public void serviceStarted() throws Exception {
        this.executorSrv = ExecutorUtil.newSingleThreadBackgroundScheduledExecutor((String)"DashboardSrvThread", (long)1L, (TimeUnit)TimeUnit.MINUTES);
        BDirectory home = BFileSystem.INSTANCE.getProtectedStationHome();
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        this.userSubscriber = Subscriber.make(arg_0 -> this.lambda$serviceStarted$3((BIFile)home, arg_0));
        this.executorSrv.submit(() -> this.lambda$serviceStarted$4((BIFile)home));
        this.userSubscriber.subscribe((BComponent)userService);
    }

    public void serviceStopped() throws Exception {
        if (this.userSubscriber != null) {
            this.userSubscriber.unsubscribeAll();
        }
        if (this.executorSrv != null) {
            ExecutorUtil.shutdown((ExecutorService)this.executorSrv);
        }
    }

    private void userRenamed(BIFile home, String oldUserName, String newUserName) {
        AccessController.doPrivileged(() -> {
            try {
                home.getFileSpace().move(home.getFilePath().merge(String.format("%s/%s", dashboardsKey, SlotPath.escape((String)oldUserName))), home.getFilePath().merge(String.format("%s/%s", dashboardsKey, SlotPath.escape((String)newUserName))));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    private void deleteOldUserDirs(BIFile home) {
        AccessController.doPrivileged(() -> {
            try {
                BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
                BIDirectory dashboardsDir = (BIDirectory)BOrd.make((OrdQuery)home.getFilePath().merge(dashboardsKey)).get();
                Arrays.stream(dashboardsDir.listFiles()).filter(file -> userService.getUser(SlotPath.unescape((String)file.getFileName())) == null).forEach(file -> {
                    try {
                        file.delete();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        });
    }

    public BString doReadDashboard(BString id, Context cx) throws Exception {
        return this.invokeAndWait(() -> Optional.of(this.readDashboard(id, BFileSystem.INSTANCE.getProtectedStationHome(), cx))).orElse(BString.DEFAULT);
    }

    private BString readDashboard(BString id, BDirectory home, Context cx) throws Exception {
        BDashboardService.validateContext(cx);
        String userName = SlotPath.escape((String)cx.getUser().getUsername());
        BDashboardService.logFine("read", id.toString(), userName);
        try {
            return AccessController.doPrivileged(() -> {
                String relativePath = String.format("%s/%s/%s", dashboardsKey, userName, indexFileName);
                BIFile indexJson = (BIFile)BOrd.make((OrdQuery)home.getFilePath().merge(relativePath)).get();
                BString res = BString.DEFAULT;
                try (InputStreamReader reader = new InputStreamReader(indexJson.getInputStream());){
                    JSONObject root = new JSONObject(new JSONTokener((Reader)reader));
                    String fileName = JSONUtil.getString((JSONObject)root.getJSONObject(dashboardsKey).getJSONObject(id.toString()), (String)fileKey);
                    String path = String.format("%s/%s", indexJson.getFilePath().getParent().getBody(), fileName);
                    BIFile dashboardFile = (BIFile)BOrd.make((OrdQuery)new FilePath(path)).get();
                    try (InputStreamReader dbReader = new InputStreamReader(dashboardFile.getInputStream());){
                        JSONObject json = new JSONObject(new JSONTokener((Reader)dbReader));
                        res = BString.make((String)json.toString());
                    }
                }
                return res;
            });
        }
        catch (Exception err) {
            return BString.DEFAULT;
        }
    }

    public void doWriteDashboard(BString jsonStr, Context cx) throws Exception {
        this.invokeAndWait(() -> {
            this.writeDashboard(jsonStr, BFileSystem.INSTANCE.getProtectedStationHome(), cx);
            return Optional.empty();
        });
    }

    private void writeDashboard(BString jsonStr, BDirectory home, Context cx) throws Exception {
        BDashboardService.validateContext(cx);
        String userName = SlotPath.escape((String)cx.getUser().getUsername());
        JSONObject json = new JSONObject(jsonStr.toString());
        String id = JSONUtil.getString((JSONObject)json, (String)"id");
        BDashboardService.logFine("write", id, userName);
        JSONObject data = json.getJSONObject("data");
        try {
            AccessController.doPrivileged(() -> {
                JSONObject idObj;
                JSONObject dashboardsObj;
                String contents;
                JSONObject obj;
                BIFile userDir;
                BFileSpace space = home.getFileSpace();
                BIFile dashboardsDir = space.getChild((BIFile)home, dashboardsKey);
                if (dashboardsDir == null) {
                    dashboardsDir = space.makeDir(home.getFilePath().merge(dashboardsKey));
                }
                if ((userDir = space.getChild(dashboardsDir, userName)) == null) {
                    userDir = space.makeDir(dashboardsDir.getFilePath().merge(userName));
                }
                String fileName = "";
                BIFile indexFile = space.getChild(userDir, indexFileName);
                if (indexFile == null) {
                    indexFile = space.makeFile(userDir.getFilePath().merge(indexFileName));
                }
                JSONObject jSONObject = obj = (contents = FileUtil.readString((Reader)new InputStreamReader(indexFile.getInputStream()))).isEmpty() ? new JSONObject() : new JSONObject(contents);
                if (!obj.has(dashboardsKey)) {
                    obj.put(dashboardsKey, (Object)new JSONObject());
                }
                if (!(dashboardsObj = obj.getJSONObject(dashboardsKey)).has(id)) {
                    dashboardsObj.put(id, (Object)new JSONObject());
                }
                if ((idObj = dashboardsObj.getJSONObject(id)).has(fileKey)) {
                    fileName = JSONUtil.getString((JSONObject)idObj, (String)fileKey);
                } else {
                    int i = 0;
                    while (fileName.isEmpty()) {
                        String fn = "db" + i + ".json";
                        if (space.getChild(userDir, fn) == null) {
                            fileName = fn;
                        }
                        ++i;
                    }
                    idObj.put(fileKey, (Object)fileName);
                }
                try (OutputStream out = indexFile.getOutputStream();){
                    out.write(obj.toString(jsonIndent).getBytes("UTF-8"));
                }
                BIFile dbFile = space.getChild(userDir, fileName);
                if (dbFile != null) {
                    dbFile.delete();
                }
                dbFile = space.makeFile(userDir.getFilePath().merge(fileName));
                try (OutputStream out = dbFile.getOutputStream();){
                    out.write(data.toString(jsonIndent).getBytes("UTF-8"));
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public void doClearMyDashboards(Context cx) throws Exception {
        this.invokeAndWait(() -> {
            this.clearMyDashboards(BFileSystem.INSTANCE.getProtectedStationHome(), cx);
            return Optional.empty();
        });
    }

    private void clearMyDashboards(BDirectory home, Context cx) throws Exception {
        BDashboardService.validateContext(cx);
        String userName = SlotPath.escape((String)cx.getUser().getUsername());
        try {
            AccessController.doPrivileged(() -> {
                BIFile userDir;
                BFileSpace space = home.getFileSpace();
                BIFile dashboardsDir = space.getChild((BIFile)home, dashboardsKey);
                if (dashboardsDir != null && (userDir = space.getChild(dashboardsDir, userName)) != null) {
                    userDir.delete();
                    this.setLastClear(BAbsTime.now());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public void doClearAllDashboards(Context cx) throws Exception {
        this.invokeAndWait(() -> {
            this.clearAllDashboards(BFileSystem.INSTANCE.getProtectedStationHome(), cx);
            return Optional.empty();
        });
    }

    private void clearAllDashboards(BDirectory home, Context cx) throws Exception {
        BDashboardService.validateContext(cx);
        if (!cx.getUser().getPermissions().isSuperUser()) {
            throw new LocalizableRuntimeException("dashboard", "needsSuperUserPermissions");
        }
        try {
            AccessController.doPrivileged(() -> {
                BFileSpace space = home.getFileSpace();
                BIFile dashboardsDir = space.getChild((BIFile)home, dashboardsKey);
                if (dashboardsDir != null) {
                    BIFile[] userDirs;
                    for (BIFile dir : userDirs = ((BIDirectory)dashboardsDir).listFiles()) {
                        dir.delete();
                    }
                    this.setLastClear(BAbsTime.now());
                }
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    private static void validateContext(Context cx) throws Exception {
        if (cx == null) {
            throw new Exception("Action must have user Context!");
        }
        BUser user = cx.getUser();
        if (user == null || !user.isMounted() || !(user.getParent() instanceof BUserService)) {
            throw new Exception("Invalid user");
        }
    }

    private <R> Optional<R> invokeAndWait(OptionalCheckedSupplier<R> supplier) throws Exception {
        if (this.executorSrv == null || this.executorSrv.isShutdown()) {
            return Optional.empty();
        }
        try {
            return this.executorSrv.submit(() -> {
                try {
                    return supplier.get();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }).get();
        }
        catch (InterruptedException | CancellationException exception) {
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t == null || !(t instanceof Exception)) {
                throw e;
            }
            throw (Exception)t;
        }
        return Optional.empty();
    }

    private static void logFine(String operation, String id, String username) {
        if (LOG.isLoggable(Level.FINE)) {
            try {
                id = SlotPath.unescape((String)id);
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOG.fine(operation + ": " + id + '/' + username);
        }
    }

    private /* synthetic */ void lambda$serviceStarted$4(BIFile home) {
        this.deleteOldUserDirs(home);
    }

    private /* synthetic */ void lambda$serviceStarted$3(BIFile home, BComponentEvent event) {
        if (event.getId() == 5 && event.getSlot().equals((Object)BUserService.userEvent)) {
            BUserEvent userEvent = (BUserEvent)event.getValue();
            if (this.executorSrv.isShutdown()) {
                return;
            }
            if (userEvent.getId() == 3) {
                this.executorSrv.submit(() -> this.userRenamed(home, userEvent.getOldName(), userEvent.getUserName()));
            } else if (userEvent.getId() == 1) {
                this.executorSrv.submit(() -> {
                    if (this.userRemovedFuture != null) {
                        this.userRemovedFuture.cancel(false);
                    }
                    if (this.executorSrv.isShutdown()) {
                        return;
                    }
                    this.userRemovedFuture = this.executorSrv.schedule(() -> this.deleteOldUserDirs(home), 10L, TimeUnit.SECONDS);
                });
            }
        }
    }

    @FunctionalInterface
    private static interface OptionalCheckedSupplier<R> {
        public Optional<R> get() throws Exception;
    }
}

