/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import com.tridium.ui.util.LayoutUtil;
import javax.baja.bacnet.datatypes.BBacnetBitString;
import javax.baja.bacnet.util.BacnetBitStringUtil;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BExpandablePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetBitString"})})
public class BBacnetBitStringFE
extends BWbFieldEditor
implements BWbFieldEditor.IDialogContentProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetBitStringFE.class);
    BTextField summary = new BTextField("", 25, false);
    BGridPane editPane = new BGridPane(3);
    BExpandablePane expander = new BExpandablePane((BWidget)this.summary, (BWidget)this.editPane);
    BCheckBox[] cboxes;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetBitStringFE() {
        this.setContent((BWidget)this.expander);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        BBacnetBitString bs = (BBacnetBitString)value;
        String[] tags = BacnetBitStringUtil.getTags((Context)cx);
        int bslen = bs.length();
        int tagslen = tags.length;
        if (this.cboxes == null || this.cboxes.length != bslen) {
            this.cboxes = new BCheckBox[bslen];
            this.editPane.removeAll();
            for (int i = 0; i < bslen; ++i) {
                String tag = "bit" + i;
                if (i < tagslen) {
                    tag = tags[i];
                }
                this.cboxes[i] = new BCheckBox(tag, bs.getBit(i));
                this.editPane.add(tag, (BValue)this.cboxes[i], null);
                this.cboxes[i].setEnabled(!this.isReadonly());
                this.linkTo((BComponent)this.cboxes[i], (Slot)BCheckBox.actionPerformed, (Slot)setModified);
            }
        } else {
            for (int i = 0; i < bslen; ++i) {
                this.cboxes[i].setSelected(bs.getBit(i));
            }
        }
        this.summary.setText(bs.toString());
        this.summary.setVisibleColumns(bs.toString().length());
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        boolean[] bits = new boolean[this.cboxes.length];
        for (int i = 0; i < this.cboxes.length; ++i) {
            bits[i] = this.cboxes[i].isSelected();
        }
        BBacnetBitString bs = BBacnetBitString.make((boolean[])bits);
        this.summary.setText(bs.getActiveTags(cx));
        return bs;
    }

    public BWidget getDialogContent() {
        this.expander.setExpanded(true);
        return LayoutUtil.getScrollablePaneForDialogEditor((BWidget)new BBorderPane((BWidget)this));
    }
}

