/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusCommandCodes;
import com.tridium.mbus.enums.BMbusFunction;
import com.tridium.mbus.enums.BMbusNumberType;
import com.tridium.mbus.enums.BMbusOrthogonalDescription;
import com.tridium.mbus.enums.BMbusUnit;
import com.tridium.mbus.enums.BMbusVifCodes;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.mspec.BManuSpecDefElement;
import com.tridium.mbus.point.BMbusPointDeviceExt;
import com.tridium.mbus.point.BMbusPollGroup;
import com.tridium.mbus.utils.MbusDataDecoderIEC870;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="mbusUnit", type="BMbusUnit", defaultValue="BMbusUnit.none"), @NiagaraProperty(name="description", type="String", defaultValue=""), @NiagaraProperty(name="orthogonalDescription", type="BMbusOrthogonalDescription", defaultValue="BMbusOrthogonalDescription.none"), @NiagaraProperty(name="numberType", type="BMbusNumberType", defaultValue="BMbusNumberType.notKnown"), @NiagaraProperty(name="messageSlotNumber", type="int", defaultValue="0"), @NiagaraProperty(name="recordNumber", type="int", defaultValue="0"), @NiagaraProperty(name="function", type="BMbusFunction", defaultValue="BMbusFunction.instantaneous"), @NiagaraProperty(name="cycleNumber", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="storageNumber", type="int", defaultValue="0", flags=4), @NiagaraProperty(name="exponent", type="int", defaultValue="1"), @NiagaraProperty(name="manuSpecDefElementOrd", type="BOrd", defaultValue="BOrd.NULL", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, BString.make(\"mbus:DualComponentOrdFE\"), \"parentType\", BString.make(\"mbus:ManuSpecDef\"), \"childType\", BString.make(\"mbus:ManuSpecDefElement\"))")}), @NiagaraProperty(name="mbusDifCode", type="BMbusCommandCodes", defaultValue="BMbusCommandCodes.none", flags=4), @NiagaraProperty(name="mbusVifCode", type="BMbusVifCodes", defaultValue="BMbusVifCodes.none", flags=4), @NiagaraProperty(name="deviceMode", type="int", defaultValue="0", flags=1, facets={@Facet(value="BFacets.make(BFacets.FIELD_WIDTH, BInteger.make(2))")})})
@NiagaraAction(name="loadManuSpecData")
public final class BMbusProxyExt
extends BBasicProxyExt {
    @Generated
    public static final Property mbusUnit = BMbusProxyExt.newProperty((int)0, (BValue)BMbusUnit.none, null);
    @Generated
    public static final Property description = BMbusProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property orthogonalDescription = BMbusProxyExt.newProperty((int)0, (BValue)BMbusOrthogonalDescription.none, null);
    @Generated
    public static final Property numberType = BMbusProxyExt.newProperty((int)0, (BValue)BMbusNumberType.notKnown, null);
    @Generated
    public static final Property messageSlotNumber = BMbusProxyExt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property recordNumber = BMbusProxyExt.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property function = BMbusProxyExt.newProperty((int)0, (BValue)BMbusFunction.instantaneous, null);
    @Generated
    public static final Property cycleNumber = BMbusProxyExt.newProperty((int)4, (int)0, null);
    @Generated
    public static final Property storageNumber = BMbusProxyExt.newProperty((int)4, (int)0, null);
    @Generated
    public static final Property exponent = BMbusProxyExt.newProperty((int)0, (int)1, null);
    @Generated
    public static final Property manuSpecDefElementOrd = BMbusProxyExt.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"mbus:DualComponentOrdFE"), (String)"parentType", (BIDataValue)BString.make((String)"mbus:ManuSpecDef"), (String)"childType", (BIDataValue)BString.make((String)"mbus:ManuSpecDefElement")));
    @Generated
    public static final Property mbusDifCode = BMbusProxyExt.newProperty((int)4, (BValue)BMbusCommandCodes.none, null);
    @Generated
    public static final Property mbusVifCode = BMbusProxyExt.newProperty((int)4, (BValue)BMbusVifCodes.none, null);
    @Generated
    public static final Property deviceMode = BMbusProxyExt.newProperty((int)1, (int)0, (BFacets)BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)2)));
    @Generated
    public static final Action loadManuSpecData = BMbusProxyExt.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusProxyExt.class);
    private Object lastPollGroupCode = null;
    private BPollFrequency lastPollFrequency = null;

    @Generated
    public BMbusUnit getMbusUnit() {
        return (BMbusUnit)this.get(mbusUnit);
    }

    @Generated
    public void setMbusUnit(BMbusUnit v) {
        this.set(mbusUnit, (BValue)v, null);
    }

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public BMbusOrthogonalDescription getOrthogonalDescription() {
        return (BMbusOrthogonalDescription)this.get(orthogonalDescription);
    }

    @Generated
    public void setOrthogonalDescription(BMbusOrthogonalDescription v) {
        this.set(orthogonalDescription, (BValue)v, null);
    }

    @Generated
    public BMbusNumberType getNumberType() {
        return (BMbusNumberType)this.get(numberType);
    }

    @Generated
    public void setNumberType(BMbusNumberType v) {
        this.set(numberType, (BValue)v, null);
    }

    @Generated
    public int getMessageSlotNumber() {
        return this.getInt(messageSlotNumber);
    }

    @Generated
    public void setMessageSlotNumber(int v) {
        this.setInt(messageSlotNumber, v, null);
    }

    @Generated
    public int getRecordNumber() {
        return this.getInt(recordNumber);
    }

    @Generated
    public void setRecordNumber(int v) {
        this.setInt(recordNumber, v, null);
    }

    @Generated
    public BMbusFunction getFunction() {
        return (BMbusFunction)this.get(function);
    }

    @Generated
    public void setFunction(BMbusFunction v) {
        this.set(function, (BValue)v, null);
    }

    @Generated
    public int getCycleNumber() {
        return this.getInt(cycleNumber);
    }

    @Generated
    public void setCycleNumber(int v) {
        this.setInt(cycleNumber, v, null);
    }

    @Generated
    public int getStorageNumber() {
        return this.getInt(storageNumber);
    }

    @Generated
    public void setStorageNumber(int v) {
        this.setInt(storageNumber, v, null);
    }

    @Generated
    public int getExponent() {
        return this.getInt(exponent);
    }

    @Generated
    public void setExponent(int v) {
        this.setInt(exponent, v, null);
    }

    @Generated
    public BOrd getManuSpecDefElementOrd() {
        return (BOrd)this.get(manuSpecDefElementOrd);
    }

    @Generated
    public void setManuSpecDefElementOrd(BOrd v) {
        this.set(manuSpecDefElementOrd, (BValue)v, null);
    }

    @Generated
    public BMbusCommandCodes getMbusDifCode() {
        return (BMbusCommandCodes)this.get(mbusDifCode);
    }

    @Generated
    public void setMbusDifCode(BMbusCommandCodes v) {
        this.set(mbusDifCode, (BValue)v, null);
    }

    @Generated
    public BMbusVifCodes getMbusVifCode() {
        return (BMbusVifCodes)this.get(mbusVifCode);
    }

    @Generated
    public void setMbusVifCode(BMbusVifCodes v) {
        this.set(mbusVifCode, (BValue)v, null);
    }

    @Generated
    public int getDeviceMode() {
        return this.getInt(deviceMode);
    }

    @Generated
    public void setDeviceMode(int v) {
        this.setInt(deviceMode, v, null);
    }

    @Generated
    public void loadManuSpecData() {
        this.invoke(loadManuSpecData, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusProxyExt() {
        this.setFlags((Slot)deviceFacets, 1);
    }

    public BAbstractMbusNetwork getMbusNetwork() {
        return (BAbstractMbusNetwork)this.getNetwork();
    }

    public BMbusDevice getMbusDevice() {
        return (BMbusDevice)this.getDevice();
    }

    public BMbusPointDeviceExt getMbusPointDeviceExt() {
        return (BMbusPointDeviceExt)this.getDeviceExt();
    }

    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)deviceFacets, 4);
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)conversion, 4);
            this.setFlags((Slot)tuningPolicyName, 4);
            this.setFlags((Slot)mbusUnit, 4);
            this.setFlags((Slot)description, 4);
            this.setFlags((Slot)orthogonalDescription, 4);
            this.setFlags((Slot)numberType, 4);
            this.setFlags((Slot)messageSlotNumber, 4);
            this.setFlags((Slot)function, 4);
            this.setFlags((Slot)manuSpecDefElementOrd, 4);
            this.setFlags((Slot)mbusDifCode, 0);
            this.setFlags((Slot)mbusVifCode, 0);
            this.setFlags((Slot)writeValue, 0);
            this.setFlags((Slot)readValue, 4);
        } else {
            int precision = 0;
            if (this.getExponent() < 0) {
                precision = -this.getExponent();
            }
            BUnit unitHold = BMbusUnit.getNiagaraUnits(this.getMbusUnit());
            this.setDeviceFacets(BFacets.makeNumeric((BUnit)unitHold, (int)precision));
            this.setFlags((Slot)conversion, 0);
            this.setFlags((Slot)tuningPolicyName, 0);
            this.setFlags((Slot)function, 1);
            this.setFlags((Slot)manuSpecDefElementOrd, 0);
            this.setFlags((Slot)mbusDifCode, 4);
            this.setFlags((Slot)mbusVifCode, 4);
            this.setFlags((Slot)writeValue, 4);
            this.setFlags((Slot)readValue, 0);
            BOrd ord = this.getManuSpecDefElementOrd();
            if (ord.isNull()) {
                this.setFlags((Slot)mbusUnit, 1);
                this.setFlags((Slot)description, 1);
                this.setFlags((Slot)orthogonalDescription, 1);
                this.setFlags((Slot)numberType, 1);
                this.setFlags((Slot)messageSlotNumber, 1);
                this.setFlags((Slot)function, 1);
            } else {
                this.setFlags((Slot)mbusUnit, 4);
                this.setFlags((Slot)description, 4);
                this.setFlags((Slot)orthogonalDescription, 4);
                this.setFlags((Slot)numberType, 4);
                this.setFlags((Slot)messageSlotNumber, 4);
            }
        }
        this.loadManuSpecData();
        if (Sys.isStationStarted()) {
            this.getMbusDevice().optimiseReads();
        }
    }

    public void changed(Property property, Context context) {
        if (this.isRunning()) {
            if (property == manuSpecDefElementOrd) {
                this.loadManuSpecData();
            } else if (property == recordNumber) {
                this.getMbusDevice().optimiseReads();
            }
        }
        super.changed(property, context);
    }

    public void doLoadManuSpecData() throws Exception {
        BOrd ord = this.getManuSpecDefElementOrd();
        if (ord.isNull()) {
            if (this.getParentPoint().isWritablePoint()) {
                this.setFlags((Slot)mbusUnit, 4);
                this.setFlags((Slot)description, 4);
                this.setFlags((Slot)orthogonalDescription, 4);
                this.setFlags((Slot)numberType, 4);
                this.setFlags((Slot)messageSlotNumber, 4);
                this.setFlags((Slot)function, 4);
            } else {
                this.setFlags((Slot)mbusUnit, 1);
                this.setFlags((Slot)description, 1);
                this.setFlags((Slot)orthogonalDescription, 1);
                this.setFlags((Slot)numberType, 1);
                this.setFlags((Slot)messageSlotNumber, 1);
                this.setFlags((Slot)function, 1);
            }
            return;
        }
        this.setFlags((Slot)mbusUnit, 4);
        this.setFlags((Slot)description, 4);
        this.setFlags((Slot)orthogonalDescription, 4);
        this.setFlags((Slot)numberType, 4);
        this.setFlags((Slot)messageSlotNumber, 4);
        try {
            BManuSpecDefElement elementError = (BManuSpecDefElement)ord.get((BObject)this.getMbusNetwork());
            if (elementError == null) {
                this.readFail("Manufacturer Specific Data Ord not set up");
            }
        }
        catch (Exception e) {
            this.readFail("Failed to resolve Manufacturer Specific Data");
        }
    }

    public Type getDeviceExtType() {
        return BMbusPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        return BReadWriteMode.readWrite;
    }

    public Object getPollGroupCode() {
        if (this.isRunning()) {
            BMbusDevice device = (BMbusDevice)this.getDevice();
            String hold = Integer.valueOf(this.getDeviceMode() * 500).toString();
            if (device.getAddressMode().equals((Object)BMbusAddressing.primary)) {
                this.lastPollGroupCode = this.getNetwork().getHandle().toString() + "_" + Integer.valueOf(device.getPrimaryAddress()).toString() + hold + "P";
                return this.lastPollGroupCode;
            }
            if (device.getAddressMode().equals((Object)BMbusAddressing.secondary)) {
                this.lastPollGroupCode = this.getNetwork().getHandle().toString() + "_" + device.getSecondaryAddress() + hold + "S";
                return this.lastPollGroupCode;
            }
            this.lastPollGroupCode = this.getNetwork().getHandle().toString() + "_" + device.getSecondaryAddress() + device.getFabricationNumber() + hold + "E";
            return this.lastPollGroupCode;
        }
        return this.lastPollGroupCode;
    }

    public Type getPollGroupType() {
        return BMbusPollGroup.TYPE;
    }

    public BPollFrequency getPollFrequency() {
        if (this.isRunning()) {
            this.lastPollFrequency = this.getMbusDevice().getPollFrequency();
        }
        return this.lastPollFrequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint()) {
            byte[] valueBytes = MbusDataDecoderIEC870.encode(out, this.getMbusDifCode());
            byte[] outputBytes = null;
            if (valueBytes != null) {
                if (this.getMbusDifCode().getOrdinal() > 14) {
                    outputBytes = valueBytes;
                } else {
                    outputBytes = new byte[valueBytes.length + 2];
                    for (int i = 0; i < valueBytes.length; ++i) {
                        outputBytes[i + 2] = valueBytes[i];
                    }
                    outputBytes[0] = (byte)this.getMbusDifCode().getOrdinal();
                    outputBytes[1] = (byte)this.getMbusVifCode().getOrdinal();
                }
            }
            String writeCmdLock = "write" + this.getHandle() + Clock.ticks();
            BMbusDevice device = this.getMbusDevice();
            BAbstractMbusNetwork network = device.getMbusNetwork();
            try {
                long minRxTxTimes;
                if (device.getAddressMode() != BMbusAddressing.primary) {
                    MbusSndUdMessage message2 = new MbusSndUdMessage(device, network);
                    message2.setMessageBaudRate(device.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                    MbusResponseMessage mbusResp = (MbusResponseMessage)network.sendMBusSync(device.getTxTimingsReference(), writeCmdLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)device.getBaudRate()));
                    if (mbusResp != null && mbusResp.getCollisionDetected()) {
                        this.writeFail("Collision during secondary address selection");
                        network.unlockSends(writeCmdLock);
                        throw new Exception("Collision during secondary address selection");
                    }
                    device.setFcBitState(true);
                }
                if (valueBytes != null && outputBytes != null) {
                    MbusSndUdMessage message = new MbusSndUdMessage(this.getMbusDevice(), network, outputBytes);
                    message.setMessageBaudRate(device.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)device.getBaudRate());
                    network.sendMBusSync(device.getTxTimingsReference(), writeCmdLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)device.getBaudRate()));
                    this.writeOk(out);
                } else {
                    this.writeFail("Incorrect MBusDifCode or MBusVifCode Selection");
                }
                network.unlockSends(writeCmdLock);
            }
            catch (Throwable e) {
                network.unlockSends(writeCmdLock);
            }
            finally {
                network.unlockSends(writeCmdLock);
            }
        }
    }
}

