/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.basicdriver.message.Message;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.messages.MbusLongFrameMessage;
import com.tridium.mbus.messages.MbusReqUd2Message;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BMbusAssignAddressJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusAssignAddressJob.class);
    private BAbstractMbusNetwork network = null;
    private BMbusDevice device = null;
    private int address = 0;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusAssignAddressJob() {
    }

    public BMbusAssignAddressJob(BAbstractMbusNetwork network, int address, BMbusDevice device) {
        this.network = network;
        this.address = address;
        this.device = device;
    }

    public void run(Context cx) throws Exception {
        String commLock = "assignAddr" + this.getHandle();
        try {
            this.commProtectedRun(commLock, cx);
            this.network.unlockSends(commLock);
        }
        catch (Exception e) {
            this.network.unlockSends(commLock);
            throw e;
        }
        catch (Throwable t) {
            this.network.unlockSends(commLock);
            throw new Exception(t.getMessage());
        }
    }

    public void commProtectedRun(Object commLock, Context cx) throws Exception {
        if (this.address >= 0 && this.address < 250) {
            long minRxTxTimes;
            MbusLongFrameMessage message = new MbusLongFrameMessage();
            message.setMessageBaudRate(this.device.getBaudRate());
            message.setCFieldNoFcb(67);
            if (this.device == null) {
                message.setAField(254);
            } else {
                if (this.device.getAddressMode() != BMbusAddressing.primary) {
                    MbusSndUdMessage message2 = new MbusSndUdMessage(this.device, this.network);
                    message2.setMessageBaudRate(this.device.getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.device.getBaudRate());
                    MbusResponseMessage selectionRsp = (MbusResponseMessage)this.network.sendMBusSync(this.device.getTxTimingsReference(), commLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.device.getBaudRate()));
                    if (selectionRsp != null && selectionRsp.getCollisionDetected()) {
                        this.log().failed(MbusToolkit.getText("BMbusGeneral.busSelectionFailure") + " " + this.address);
                        this.setJobState(BJobState.failed);
                        throw new Exception("Bus collision detected on secondary address selection");
                    }
                    this.device.setFcBitState(true);
                    message.setAField(253);
                } else {
                    message.setAField(this.device.getPrimaryAddress());
                }
                if (this.device.getFcBitInUse()) {
                    message.setCFieldNoFcb(83);
                }
            }
            message.setCiField(81);
            byte[] data = new byte[]{1, 122, (byte)this.address};
            message.setBytes(data);
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.device.getBaudRate());
            Message rsp = this.network.sendMBusSync(this.device.getTxTimingsReference(), commLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.device.getBaudRate()));
            if (rsp != null && rsp.getSuccessfulResponse()) {
                this.log().success(MbusToolkit.getText("MbusAssignAddressJob.initialSuccess"));
            } else {
                this.log().message(MbusToolkit.getText("MbusAssignAddressJob.noConfirmationOfSuccess"));
            }
            MbusReqUd2Message message2 = new MbusReqUd2Message(this.address);
            message2.setMessageBaudRate(this.device.getBaudRate());
            minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.device.getBaudRate());
            rsp = this.network.sendMBusSync(this.device.getTxTimingsReference(), commLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.device.getBaudRate()));
            if (rsp != null) {
                this.log().success(MbusToolkit.getText("MbusAssignAddressJob.success") + " " + this.address);
                if (this.device != null) {
                    this.device.setPrimaryAddress(this.address);
                }
                this.setJobState(BJobState.success);
            } else {
                this.log().failed(MbusToolkit.getText("MbusAssignAddressJob.failed") + " " + this.address);
                this.setJobState(BJobState.failed);
            }
        } else {
            throw new Exception("Invalid address information!");
        }
    }

    public void success() {
        if (this.getJobState() == BJobState.success) {
            this.log().success("Job Success");
            this.complete(BJobState.success);
        } else {
            this.complete(BJobState.failed);
        }
    }
}

