/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.serial;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialBaudRate;
import javax.baja.serial.BSerialDataBits;
import javax.baja.serial.BSerialFlowControlMode;
import javax.baja.serial.BSerialParity;
import javax.baja.serial.BSerialStopBits;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.down", flags=3), @NiagaraProperty(name="portName", type="String", defaultValue="BSerialHelper.noPort", flags=64), @NiagaraProperty(name="baudRate", type="BBaudRate", defaultValue="BSerialBaudRate.baud9600"), @NiagaraProperty(name="dataBits", type="BSerialDataBits", defaultValue="BSerialDataBits.dataBits8"), @NiagaraProperty(name="stopBits", type="BSerialStopBits", defaultValue="BSerialStopBits.stopBit1"), @NiagaraProperty(name="parity", type="BSerialParity", defaultValue="BSerialParity.none"), @NiagaraProperty(name="flowControlMode", type="BSerialFlowControlMode", defaultValue="BSerialFlowControlMode.none")})
public class BSerialHelper
extends BComponent {
    public static final String noPort = "none";
    @Generated
    public static final Property status = BSerialHelper.newProperty((int)3, (BValue)BStatus.down, null);
    @Generated
    public static final Property portName = BSerialHelper.newProperty((int)64, (String)"none", null);
    @Generated
    public static final Property baudRate = BSerialHelper.newProperty((int)0, (BValue)BSerialBaudRate.baud9600, null);
    @Generated
    public static final Property dataBits = BSerialHelper.newProperty((int)0, (BValue)BSerialDataBits.dataBits8, null);
    @Generated
    public static final Property stopBits = BSerialHelper.newProperty((int)0, (BValue)BSerialStopBits.stopBit1, null);
    @Generated
    public static final Property parity = BSerialHelper.newProperty((int)0, (BValue)BSerialParity.none, null);
    @Generated
    public static final Property flowControlMode = BSerialHelper.newProperty((int)0, (BValue)BSerialFlowControlMode.none, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSerialHelper.class);
    private static final BIcon icon = BIcon.std((String)"connection.png");
    public static Logger log = Logger.getLogger("SerialHelper");
    private BISerialHelperParent host;
    private BISerialPort port = null;
    private boolean openPortFailure = false;
    private boolean portParamFailure = false;
    private boolean flowControlFailure = false;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getPortName() {
        return this.getString(portName);
    }

    @Generated
    public void setPortName(String v) {
        this.setString(portName, v, null);
    }

    @Generated
    public BBaudRate getBaudRate() {
        return (BBaudRate)this.get(baudRate);
    }

    @Generated
    public void setBaudRate(BBaudRate v) {
        this.set(baudRate, (BValue)v, null);
    }

    @Generated
    public BSerialDataBits getDataBits() {
        return (BSerialDataBits)this.get(dataBits);
    }

    @Generated
    public void setDataBits(BSerialDataBits v) {
        this.set(dataBits, (BValue)v, null);
    }

    @Generated
    public BSerialStopBits getStopBits() {
        return (BSerialStopBits)this.get(stopBits);
    }

    @Generated
    public void setStopBits(BSerialStopBits v) {
        this.set(stopBits, (BValue)v, null);
    }

    @Generated
    public BSerialParity getParity() {
        return (BSerialParity)this.get(parity);
    }

    @Generated
    public void setParity(BSerialParity v) {
        this.set(parity, (BValue)v, null);
    }

    @Generated
    public BSerialFlowControlMode getFlowControlMode() {
        return (BSerialFlowControlMode)this.get(flowControlMode);
    }

    @Generated
    public void setFlowControlMode(BSerialFlowControlMode v) {
        this.set(flowControlMode, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setSerialHelperParent(BISerialHelperParent host) {
        this.host = host;
    }

    public BISerialHelperParent getSerialHelperParent() {
        if (this.host != null) {
            return this.host;
        }
        return (BISerialHelperParent)this.getParent();
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BISerialHelperParent;
    }

    public BISerialPort open(String owner) throws Exception {
        BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
        ((BComponent)platSvc).lease();
        try {
            this.port = platSvc.openPort(this.getPortName(), owner);
        }
        catch (PortNotFoundException notPort) {
            String errMsg = "'" + this.getPortName() + "' not a valid comm port.";
            log.log(Level.SEVERE, errMsg, (Throwable)((Object)notPort));
            this.openPortFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw notPort;
        }
        catch (PortDeniedException deniedPort) {
            String errMsg = "Denied opening comm port '" + this.getPortName() + "'";
            log.log(Level.SEVERE, errMsg, (Throwable)((Object)deniedPort));
            this.openPortFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw deniedPort;
        }
        catch (Exception e) {
            String errMsg = "Exception opening comm port '" + this.getPortName() + "'";
            log.log(Level.SEVERE, errMsg, e);
            this.openPortFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw e;
        }
        this.openPortFailure = false;
        try {
            this.port.setSerialPortParams(this.getBaudRate(), this.getDataBits(), this.getStopBits(), this.getParity());
        }
        catch (UnsupportedOperationException unsupported) {
            String errMsg = "Unsupported comm parameter for " + this.getPortName();
            log.log(Level.SEVERE, errMsg, unsupported);
            this.portParamFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw unsupported;
        }
        catch (Exception e) {
            String errMsg = "Exception setting comm parameters for " + this.getPortName();
            log.log(Level.SEVERE, errMsg, e);
            this.portParamFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw e;
        }
        this.portParamFailure = false;
        try {
            this.port.setFlowControlMode(this.getFlowControlMode());
        }
        catch (UnsupportedOperationException unsupported) {
            String errMsg = "Unsupported comm parameter (flow control mode) for " + this.getPortName();
            log.log(Level.SEVERE, errMsg, unsupported);
            this.flowControlFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw unsupported;
        }
        catch (Exception e) {
            String errMsg = "Exception setting flow control mode for " + this.getPortName();
            log.log(Level.SEVERE, errMsg, e);
            this.flowControlFailure = true;
            this.computeStatus();
            if (this.port != null) {
                this.port.close();
            }
            throw e;
        }
        this.flowControlFailure = false;
        this.computeStatus();
        return this.port;
    }

    public void changed(Property property, Context context) {
        if (this.getSerialHelperParent() != null) {
            this.getSerialHelperParent().changed(property, context);
        }
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(portName)) {
            if (this.getPortName().equals(noPort)) {
                this.computeStatus();
            }
            this.getSerialHelperParent().reopenPort();
            return;
        }
        if (property.equals(dataBits) || property.equals(stopBits) || property.equals(parity) || property.equals(baudRate)) {
            if (this.port != null) {
                this.updatePortParms(this.getBaudRate(), this.getDataBits(), this.getStopBits(), this.getParity());
            }
        } else if (property.equals(flowControlMode)) {
            try {
                if (this.port != null) {
                    this.port.setFlowControlMode(this.getFlowControlMode());
                }
            }
            catch (UnsupportedOperationException unsupported) {
                log.log(Level.SEVERE, "Unsupported comm parameter", unsupported);
                this.flowControlFailure = true;
                this.computeStatus();
                throw new RuntimeException("Unsupported comm parameter");
            }
            this.flowControlFailure = false;
            this.computeStatus();
        } else {
            super.changed(property, context);
        }
    }

    private void updatePortParms(BBaudRate baud, BSerialDataBits dBits, BSerialStopBits sBits, BSerialParity parity) {
        try {
            this.port.setSerialPortParams(baud, dBits, sBits, parity);
        }
        catch (UnsupportedOperationException unsupported) {
            log.log(Level.SEVERE, "Unsupported comm parameter", unsupported);
            this.portParamFailure = true;
            this.computeStatus();
            throw new RuntimeException("Unsupported comm parameter");
        }
        this.portParamFailure = false;
        this.computeStatus();
    }

    private void computeStatus() {
        if (this.getPortName().equals(noPort)) {
            this.setStatus(BStatus.down);
            return;
        }
        if (this.openPortFailure || this.portParamFailure || this.flowControlFailure) {
            this.setStatus(BStatus.fault);
        } else {
            this.setStatus(BStatus.ok);
        }
    }

    public String toString(Context context) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPortName());
        sb.append(", ");
        sb.append(this.getBaudRate().getOrdinal());
        sb.append(", ");
        sb.append(this.getDataBits().getOrdinal());
        sb.append(", ");
        sb.append(this.getStopBits().getOrdinal());
        sb.append(", ");
        sb.append((Object)this.getParity());
        return sb.toString();
    }

    public BIcon getIcon() {
        return icon;
    }
}

