/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.videoDriver.security;

import com.tridium.videoDriver.security.AuthHeaderParser;
import com.tridium.videoDriver.security.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BHost;
import javax.baja.naming.BIpHost;
import javax.baja.net.HttpsConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.net.SocketFactory;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

@NiagaraType
@NiagaraSingleton
public class BDigestAuthMD5Client
extends BObject {
    @Generated
    public static final BDigestAuthMD5Client INSTANCE = new BDigestAuthMD5Client();
    @Generated
    public static final Type TYPE = Sys.loadType(BDigestAuthMD5Client.class);
    private static final Logger authClientLogger = Logger.getLogger("DigestAuthClient");
    private static final SecureRandom secureRandom = new SecureRandom();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static Map<String, String> getResponse(String username, String password, String urlString) {
        String authHeaderValue = null;
        Response response = null;
        try {
            URL url = new URL(urlString);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            response = INSTANCE.sendRequest(httpURLConnection, authHeaderValue);
            if (response.getResponseCode() == 401) {
                List<String> headerList = response.getHeaders().get("WWW-Authenticate");
                String wwwAuthHeader = null;
                for (int index = 0; index < headerList.size() && !(wwwAuthHeader = headerList.get(index).trim()).startsWith("Digest"); ++index) {
                }
                Map<String, String> wwwAuthHeaderParamMap = AuthHeaderParser.parseWWWAuthHeader(wwwAuthHeader);
                String clientNonce = INSTANCE.getClientNonce();
                authHeaderValue = INSTANCE.buildAuthorizationHeader(username, password, clientNonce, url.getPath(), wwwAuthHeaderParamMap);
                httpURLConnection = (HttpURLConnection)url.openConnection();
                response = INSTANCE.sendRequest(httpURLConnection, authHeaderValue);
            }
        }
        catch (Exception e) {
            response = new Response();
            authClientLogger.log(Level.FINE, e.getMessage(), e.toString());
            response.setResponseMessage(e.getMessage() + "::" + e.toString());
        }
        HashMap<String, String> responseMap = new HashMap<String, String>();
        responseMap.put("responseCode", "" + response.getResponseCode());
        responseMap.put("responseMessage", response.getResponseMessage());
        responseMap.put("token", response.getResponseBody());
        return responseMap;
    }

    public static Map<String, String> getHttpsResponse(String username, String password, String urlString) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        try {
            URL url = new URL(urlString);
            SSLSocketFactory defaultFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
            HttpsConnection httpsConn = new HttpsConnection((BHost)new BIpHost(url.getHost()), url.getPort(), url.toString(), (SocketFactory)defaultFactory);
            int responseCode = httpsConn.newRequest(url.toString());
            if (responseCode == 401) {
                String wwwAuthHeader = httpsConn.getResponseHeader("WWW-Authenticate");
                Map<String, String> wwwAuthHeaderParamMap = AuthHeaderParser.parseWWWAuthHeader(wwwAuthHeader);
                String clientNonce = INSTANCE.getClientNonce();
                String authHeaderValue = INSTANCE.buildAuthorizationHeader(username, password, clientNonce, url.getPath(), wwwAuthHeaderParamMap);
                httpsConn = new HttpsConnection((BHost)new BIpHost(url.getHost()), url.getPort(), url.toString(), (SocketFactory)defaultFactory);
                httpsConn.setRequestHeader("Authorization", authHeaderValue);
                responseCode = httpsConn.newRequest(url.toString());
            }
            responseMap.put("responseCode", "" + httpsConn.getStatusCode());
            responseMap.put("responseMessage", httpsConn.getStatusMessage());
            responseMap.put("token", "-1");
            if (responseCode == 200) {
                String inputLine;
                StringBuilder response = new StringBuilder();
                BufferedReader in = new BufferedReader(new InputStreamReader(httpsConn.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                responseMap.put("token", response.toString());
            }
        }
        catch (Exception e) {
            authClientLogger.log(Level.FINE, e.getMessage(), e.toString());
            responseMap.put("token", "-1");
            responseMap.put("responseCode", "-1");
            responseMap.put("responseMessage", e.getMessage() + "::" + e.toString());
        }
        return responseMap;
    }

    private String getClientNonce() {
        byte[] nonceBytes = new byte[16];
        secureRandom.nextBytes(nonceBytes);
        return ByteArrayUtil.toHexString((byte[])nonceBytes);
    }

    private String generateMd5HexDigest(String message) {
        String messageDigest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(message.getBytes("UTF-8"));
            messageDigest = ByteArrayUtil.toHexString((byte[])hash);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            authClientLogger.log(Level.SEVERE, e.getMessage(), e);
        }
        return messageDigest;
    }

    public String buildAuthorizationHeader(String username, String password, String cnonce, String uri, Map<String, String> wwwAuthHeaderParamMap) {
        StringBuilder authHeader = new StringBuilder();
        String nc = "00000001";
        String method = "GET";
        authHeader.append("Digest ");
        authHeader.append("username=").append("\"").append(username).append("\"").append(", ");
        authHeader.append("realm=").append("\"").append(wwwAuthHeaderParamMap.get("realm")).append("\"").append(", ");
        authHeader.append("nonce=").append("\"").append(wwwAuthHeaderParamMap.get("nonce")).append("\"").append(", ");
        authHeader.append("uri=").append("\"").append(uri).append("\"").append(", ");
        authHeader.append("algorithm=").append("MD5").append(", ");
        authHeader.append("qop=").append("auth").append(", ");
        authHeader.append("nc=").append(nc).append(", ");
        authHeader.append("cnonce=").append("\"").append(cnonce).append("\"").append(", ");
        authHeader.append("response=").append("\"").append(this.getClientResponseDigest(username, password, method, nc, cnonce, uri, wwwAuthHeaderParamMap)).append("\"");
        return authHeader.toString();
    }

    private String getClientResponseDigest(String username, String password, String method, String nonceCount, String cnonce, String digestURI, Map<String, String> wwwAuthHeaderParamMap) {
        String realm = wwwAuthHeaderParamMap.get("realm");
        String nonce = wwwAuthHeaderParamMap.get("nonce");
        String algorithm = wwwAuthHeaderParamMap.get("algorithm");
        String colon = ":";
        String HA1 = null;
        if (algorithm == null || algorithm.equals("MD5")) {
            HA1 = this.generateMd5HexDigest(username + colon + realm + colon + password);
        } else if (algorithm.equals("MD5-sess")) {
            HA1 = this.generateMd5HexDigest(this.generateMd5HexDigest(username + colon + realm + colon + password) + colon + nonce + colon + cnonce);
        }
        String HA2 = this.generateMd5HexDigest(method + colon + digestURI);
        String responseDigest = null;
        String qop = wwwAuthHeaderParamMap.get("qop");
        responseDigest = qop != null ? this.generateMd5HexDigest(HA1 + colon + nonce + colon + nonceCount + colon + cnonce + colon + qop + colon + HA2) : this.generateMd5HexDigest(HA1 + colon + nonce + colon + HA2);
        return responseDigest;
    }

    public Response sendRequest(HttpURLConnection httpURLConnection, String authHeaderValue) throws IOException {
        httpURLConnection.setRequestMethod("GET");
        if (authHeaderValue != null) {
            httpURLConnection.setRequestProperty("Authorization", authHeaderValue);
        }
        Response responseObj = new Response();
        responseObj.setResponseCode(httpURLConnection.getResponseCode());
        responseObj.setResponseMessage(httpURLConnection.getResponseMessage());
        responseObj.setHeaders(httpURLConnection.getHeaderFields());
        if (httpURLConnection.getResponseCode() == 200) {
            StringBuilder response = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));){
                String inputLine;
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
            }
            responseObj.setResponseBody(response.toString());
        }
        return responseObj;
    }
}

