/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSync.search;

import com.tridium.json.JSONObject;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.search.BResultsRequest;
import javax.baja.search.BSearchParams;
import javax.baja.search.BSearchResultSet;
import javax.baja.search.BSearchService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scope", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="neql", type="String", defaultValue=""), @NiagaraProperty(name="fields", type="String", defaultValue=""), @NiagaraProperty(name="columnString", type="String", defaultValue="", flags=4)})
public class BModelQuery
extends BComponent {
    public static final Property scope = BModelQuery.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property neql = BModelQuery.newProperty((int)0, (String)"", null);
    public static final Property fields = BModelQuery.newProperty((int)0, (String)"", null);
    public static final Property columnString = BModelQuery.newProperty((int)4, (String)"", null);
    public static final Type TYPE = Sys.loadType(BModelQuery.class);
    private Logger log;
    private static final String LOGGER_NAME = "fcModelSync";

    public BOrd getScope() {
        return (BOrd)this.get(scope);
    }

    public void setScope(BOrd v) {
        this.set(scope, (BValue)v, null);
    }

    public String getNeql() {
        return this.getString(neql);
    }

    public void setNeql(String v) {
        this.setString(neql, v, null);
    }

    public String getFields() {
        return this.getString(fields);
    }

    public void setFields(String v) {
        this.setString(fields, v, null);
    }

    public String getColumnString() {
        return this.getString(columnString);
    }

    public void setColumnString(String v) {
        this.setString(columnString, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSearchResultSet getNeqlResults(String neqlQuery) {
        BSearchService searchService = BSearchService.getService();
        BOrd searchRequest = BOrd.make((String)neqlQuery);
        BSearchParams searchParams = new BSearchParams(searchRequest, (BIObject)this.getScope());
        BOrd searchTaskOrd = searchService.search(searchParams);
        BSearchResultSet results = null;
        while (results == null || !results.getResultsComplete()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                this.getLog().log(Level.SEVERE, "InterruptedException in getNeqlResults: " + e.getMessage(), e);
                Thread.currentThread().interrupt();
            }
            BResultsRequest resultsRequest = BResultsRequest.make((BOrd)searchTaskOrd, (int)0, (int)-1);
            results = searchService.retrieveResults(resultsRequest);
        }
        return results;
    }

    public void extractFields(BComponent comp, String[] fields, JSONObject res) {
        Tags tags = comp.tags();
        for (String field : fields) {
            if (!field.contains(":")) continue;
            res.put(field.split(":")[1], (Object)this.getFieldValue(field, tags));
        }
    }

    public String getFieldValue(String field, Tags fromTags) {
        Id id;
        StringBuilder result = new StringBuilder();
        if (field.contains(":")) {
            String[] tg = field.split(":");
            id = Id.newId((String)tg[0], (String)tg[1]);
        } else {
            id = Id.newId((String)field);
        }
        Collection v = fromTags.getValues(id);
        if (v.isEmpty()) {
            result.append(BString.make((String)""));
        } else {
            v.forEach(m -> result.append(m));
        }
        return result.toString();
    }

    public Logger getLog() {
        if (null == this.log) {
            this.log = Logger.getLogger(LOGGER_NAME);
        }
        return this.log;
    }
}

