/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcModelSync.extractor;

import com.tridium.cloud.client.BCloudConnector;
import com.tridium.cloud.client.sentience.BSentienceConnectorImpl;
import com.tridium.fcModelSync.Constants;
import com.tridium.fcModelSync.driver.BHistorySourceDiscoverer;
import com.tridium.fcModelSync.driver.BModelRelationHandler;
import com.tridium.fcModelSync.extractor.BIModelExtractor;
import com.tridium.fcModelSync.job.BModelExtractJob;
import com.tridium.fcModelSync.search.BModelQuery;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.nc.BNiagaraCloudNetwork;
import com.tridium.nc.CloudUtilities;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import com.tridium.nc.history.BCloudHistoryDeviceExt;
import com.tridium.nc.history.BCloudHistoryExport;
import com.tridium.nc.point.BCloudPointDeviceExt;
import com.tridium.nc.point.BCloudProxyExt;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.BNNetwork;
import com.tridium.util.CompUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BDriverContainer;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BHistoryExt;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.search.BSearchResult;
import javax.baja.search.BSearchResultSet;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BMarker;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;
import javax.baja.tagdictionary.BTagDictionaryService;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scope", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="rootEntityTag", type="String", defaultValue=""), @NiagaraProperty(name="entityIdTag", type="String", defaultValue=""), @NiagaraProperty(name="entityTypeTag", type="String", defaultValue=""), @NiagaraProperty(name="entityRelations", type="String", defaultValue=""), @NiagaraProperty(name="modelAdditionalTags", type="String", defaultValue=""), @NiagaraProperty(name="isExportCloudOnlyPoints", type="boolean", defaultValue="false", flags=4), @NiagaraProperty(name="isIncludeTags", type="boolean", defaultValue="false"), @NiagaraProperty(name="proxyPointReferenceTag", type="String", defaultValue="")})
@NiagaraAction(name="extractModel", parameterType="BString", defaultValue="BString.make(\"\")")
public class BContextDiscoveryModelExtractor
extends BComponent
implements BIModelExtractor {
    public static final Property scope = BContextDiscoveryModelExtractor.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property rootEntityTag = BContextDiscoveryModelExtractor.newProperty((int)0, (String)"", null);
    public static final Property entityIdTag = BContextDiscoveryModelExtractor.newProperty((int)0, (String)"", null);
    public static final Property entityTypeTag = BContextDiscoveryModelExtractor.newProperty((int)0, (String)"", null);
    public static final Property entityRelations = BContextDiscoveryModelExtractor.newProperty((int)0, (String)"", null);
    public static final Property modelAdditionalTags = BContextDiscoveryModelExtractor.newProperty((int)0, (String)"", null);
    public static final Property isExportCloudOnlyPoints = BContextDiscoveryModelExtractor.newProperty((int)4, (boolean)false, null);
    public static final Property isIncludeTags = BContextDiscoveryModelExtractor.newProperty((int)0, (boolean)false, null);
    public static final Property proxyPointReferenceTag = BContextDiscoveryModelExtractor.newProperty((int)0, (String)"", null);
    public static final Action extractModel = BContextDiscoveryModelExtractor.newAction((int)0, (BValue)BString.make((String)""), null);
    public static final Type TYPE = Sys.loadType(BContextDiscoveryModelExtractor.class);
    BJob modelJob;
    public static final int JOB_LOG_UPDATE_GRANULARITY = 100;
    private final Set<String> processedIds = new HashSet<String>();
    private final HashMap<String, JSONObject> propBindingAndConceptsById = new HashMap();
    private final Map<String, Map<String, String>> attrIdByValMapsByAttrKey = new HashMap<String, Map<String, String>>();
    private int traverseCount;
    private final HashMap<String, String> cloudHistoryExtIdBySrcPtSlotPathMap = new HashMap();
    private final HashMap<String, String> cloudProxyExtByStationPointOrdMap = new HashMap();
    private final HashMap<String, String> stationPointOrdByCloudProxyExtMap = new HashMap();
    private final HashMap<String, String> cloudTagDictNamespacesMap = new HashMap();
    private final HashSet<String> cloudNamespacesSet = new HashSet();
    private final BModelQuery dbDriver = new BModelQuery();
    private String onboardedVia = "";
    private String systemId = "";
    private static final Pattern LABEL_PATTERN = Pattern.compile("label", 16);
    public static final BCloudHistoryExport[] EMPTY_CLOUD_HISTORY_EXPORTS_ARRAY = new BCloudHistoryExport[0];
    private static final Pattern GUID_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}");
    private static final Pattern CONCEPTS_REPLACE_PATTERN = Pattern.compile("[\u0000.{}&/()$\",;#:'%=><`\\[\\] \t\\\\]");
    private static final Pattern POINT_LABEL_ATTR_VALUE_REPLACE_PATTERN = Pattern.compile("\\s");
    public static final String ONBOARD_TYPE_FORGE = "Forge Connect";
    public static final String ONBOARD_TYPE_NIAGARA = "Niagara Cloud Connector";
    private static final Logger logger = Logger.getLogger("ModelExtractor");
    private static final Logger traversalLogger = Logger.getLogger("ModelExtractor.traversal");
    private static final Logger attributeLogger = Logger.getLogger("ModelExtractor.attribute");

    public BOrd getScope() {
        return (BOrd)this.get(scope);
    }

    public void setScope(BOrd v) {
        this.set(scope, (BValue)v, null);
    }

    public String getRootEntityTag() {
        return this.getString(rootEntityTag);
    }

    public void setRootEntityTag(String v) {
        this.setString(rootEntityTag, v, null);
    }

    public String getEntityIdTag() {
        return this.getString(entityIdTag);
    }

    public void setEntityIdTag(String v) {
        this.setString(entityIdTag, v, null);
    }

    public String getEntityTypeTag() {
        return this.getString(entityTypeTag);
    }

    public void setEntityTypeTag(String v) {
        this.setString(entityTypeTag, v, null);
    }

    public String getEntityRelations() {
        return this.getString(entityRelations);
    }

    public void setEntityRelations(String v) {
        this.setString(entityRelations, v, null);
    }

    public String getModelAdditionalTags() {
        return this.getString(modelAdditionalTags);
    }

    public void setModelAdditionalTags(String v) {
        this.setString(modelAdditionalTags, v, null);
    }

    public boolean getIsExportCloudOnlyPoints() {
        return this.getBoolean(isExportCloudOnlyPoints);
    }

    public void setIsExportCloudOnlyPoints(boolean v) {
        this.setBoolean(isExportCloudOnlyPoints, v, null);
    }

    public boolean getIsIncludeTags() {
        return this.getBoolean(isIncludeTags);
    }

    public void setIsIncludeTags(boolean v) {
        this.setBoolean(isIncludeTags, v, null);
    }

    public String getProxyPointReferenceTag() {
        return this.getString(proxyPointReferenceTag);
    }

    public void setProxyPointReferenceTag(String v) {
        this.setString(proxyPointReferenceTag, v, null);
    }

    public void extractModel(BString parameter) {
        this.invoke(extractModel, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void doExtractModel(BString siteName) {
        BModelExtractJob extractJob = new BModelExtractJob(this);
        extractJob.setSiteName(siteName.getString());
        BJobService jobService = (BJobService)Sys.getService((Type)BJobService.TYPE);
        jobService.submit((BJob)extractJob, null);
        this.modelJob = extractJob;
    }

    public void modelExtract(String siteName) throws Exception {
        Objects.requireNonNull(this.modelJob, "Must have a model job");
        File jsonLdFile = BContextDiscoveryModelExtractor.createJsonLd(siteName);
        try (FileWriter writer = new FileWriter(jsonLdFile);){
            JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
            this.extractSiteModel(siteName, jsonWriter);
            writer.flush();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage());
            this.modelJob.log().failed("fcModelSync", "modelExtract.jobFailed", (Throwable)e);
            throw e;
        }
        if (!this.modelJob.isAlive()) {
            this.modelJob.log().endFailed("fcModelSync", "modelExtract.jobCanceled", null);
        }
    }

    @Override
    public void setModelJob(BJob modelJob) {
        this.modelJob = modelJob;
    }

    @Override
    public File getModelFile(String siteName) throws Exception {
        Objects.requireNonNull(this.modelJob, "Must have a model job");
        File jsonLdFile = BContextDiscoveryModelExtractor.createJsonLd(siteName);
        logger.finer("Starting model extraction to model file " + jsonLdFile.getAbsolutePath());
        try (FileWriter writer = new FileWriter(jsonLdFile);){
            JSONWriter jsonWriter = new JSONWriter((Appendable)writer);
            this.extractSiteModel(siteName, jsonWriter);
            writer.flush();
            logger.finer("Site model extraction complete");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception creating Model File!", e);
            throw e;
        }
        return jsonLdFile;
    }

    private void extractSiteModel(String siteName, JSONWriter writer) {
        this.initCloudExports();
        writer.object();
        this.createSiteGraph(siteName, writer);
        this.createSiteContext(siteName, writer);
        writer.endObject();
        this.cleanup();
    }

    private void initCloudExports() {
        logger.finer("Collecting cloud proxy points and history exports");
        this.buildCloudPointExtPointList();
        this.buildCloudHistoryPointList();
        this.buildCloudTagDictNamespacesMap();
    }

    private static File createJsonLd(String siteName) {
        String jsonLdPath = Sys.getNiagaraSharedUserHome() + File.separator + siteName + ".jsonld";
        File jsonLDFile = new File(jsonLdPath);
        return jsonLDFile;
    }

    private void createSiteContext(String siteName, JSONWriter writer) {
        logger.finer("Creating site context for siteName '" + siteName + '\'');
        JSONObject siteNameCtxObject = new JSONObject();
        String encodedStationName = siteName.isEmpty() ? "Site" : BContextDiscoveryModelExtractor.urlEncode(siteName);
        String siteCtxName = String.format("http://www.honeywell.com/models/sites/%s/%s#", encodedStationName, "1.0");
        siteNameCtxObject.put("SiteContext", (Object)siteCtxName);
        this.cloudNamespacesSet.stream().filter(ns -> !ns.startsWith("hon")).forEach(ns -> {
            if (this.cloudTagDictNamespacesMap.containsKey(ns)) {
                siteNameCtxObject.put(ns, (Object)this.cloudTagDictNamespacesMap.get(ns));
            } else {
                siteNameCtxObject.put(ns, (Object)BContextDiscoveryModelExtractor.makeNamespaceUri(ns));
            }
        });
        JSONArray contextArray = new JSONArray();
        contextArray.put((Object)"context.jsonld");
        contextArray.put((Object)siteNameCtxObject);
        writer.key("@context").value((Object)contextArray);
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            logger.warning("URL encoding of \"" + value + "\" with \"" + StandardCharsets.UTF_8.name() + "\" not supported.");
            return value;
        }
    }

    private void createSiteGraph(String siteName, JSONWriter writer) {
        logger.finer("Creating site graph for siteName '" + siteName + '\'');
        writer.key("@graph").array().array();
        this.traverseFromRootEntity(writer);
        if (!this.processedIds.isEmpty()) {
            BContextDiscoveryModelExtractor.addOntologyRecord(siteName, writer);
        }
        writer.endArray().array();
        if (this.modelJob.isAlive()) {
            this.modelJob.log().message("fcModelSync", "modelExtract.writingMaps");
            logger.finer("Writing property bindings and attributes arrays");
            for (JSONObject jsonObject : this.propBindingAndConceptsById.values()) {
                writer.value((Object)jsonObject);
            }
            this.attrIdByValMapsByAttrKey.forEach((attrName, value1) -> value1.forEach((key, value) -> writer.value((Object)new JSONObject().put("@id", value).put("@type", (Object)"honsmw:Attribute").put("hasAttributeValue", key).put("hasAttributeName", attrName))));
        }
        writer.endArray().endArray();
    }

    private void cleanup() {
        this.processedIds.clear();
        this.propBindingAndConceptsById.clear();
        this.attrIdByValMapsByAttrKey.clear();
        this.cloudHistoryExtIdBySrcPtSlotPathMap.clear();
        this.cloudProxyExtByStationPointOrdMap.clear();
        this.stationPointOrdByCloudProxyExtMap.clear();
        this.cloudNamespacesSet.clear();
        this.cloudTagDictNamespacesMap.clear();
    }

    public void traverseFromRootEntity(JSONWriter writer) {
        String rootMsg = this.getLexicon().getText("modelSync.traverseModel.fromRoot", new Object[]{this.getRootEntityTag(), this.getScope()});
        logger.finer(rootMsg);
        this.modelJob.log().message(rootMsg);
        this.dbDriver.setScope(this.getScope());
        BSearchResultSet siteRes = this.dbDriver.getNeqlResults(this.getRootEntityTag());
        Iterator itS = siteRes.streamResults().iterator();
        this.traverseCount = 0;
        while (itS.hasNext()) {
            if (!this.modelJob.isAlive()) {
                logger.info("Stopping model extraction; model sync job canceled");
                this.modelJob.log().message("fcModelSync", "modelSyncJob.traverseModelFromRoot.canceled");
                return;
            }
            BObject obj = (BObject)itS.next();
            BComponent root = (BComponent)((BSearchResult)obj).getOrd().resolve().get();
            JSONObject rootRecord = this.getEntityRecord(root);
            this.traverseModel(root, rootRecord, writer);
        }
        String message = this.getLexicon().getText("modelSync.traverseCount.final", new Object[]{this.traverseCount});
        this.modelJob.log().message(message);
        traversalLogger.fine(message);
    }

    private void traverseModel(BComponent comp, JSONObject compJson, JSONWriter writer) {
        if (!this.modelJob.isAlive()) {
            logger.info("Stopping model extraction; model sync job canceled");
            this.modelJob.log().message("fcModelSync", "modelSync.traverseModel.canceled");
            return;
        }
        traversalLogger.finer(() -> String.format("Traversing model: comp=%s [compJson.itemCt=%s]", comp.getSlotPath(), compJson.length()));
        if (this.traverseCount % 100 == 0) {
            String message = this.getLexicon().getText("modelSync.traverseCount", new Object[]{this.traverseCount, comp.getSlotPath()});
            this.modelJob.log().message(message);
        }
        ++this.traverseCount;
        BNiagaraCloudNetwork ncNetwork = BNiagaraCloudNetwork.getNiagaraCloudNetwork();
        for (Relation rel : comp.relations().filter(r -> this.getEntityRelations().contains(r.getId().toString()), 1)) {
            if (!this.modelJob.isAlive()) break;
            Optional childOrd = rel.getEndpoint().getOrdToEntity();
            if (!childOrd.isPresent()) continue;
            BComponent child = (BComponent)((BOrd)childOrd.get()).resolve().get();
            if ((child instanceof BControlPoint || child instanceof BHistoryImport) && this.getIsExportCloudOnlyPoints() && !this.getIsCloudPoint(child)) {
                traversalLogger.finest(() -> String.format("Skipping child %s", child.getSlotPath()));
                continue;
            }
            Tags childTags = child.tags();
            if (!BContextDiscoveryModelExtractor.isComponentInModel(child, childTags)) continue;
            String childId = this.getComponentId(child);
            String relationId = BContextDiscoveryModelExtractor.getRelationId(rel.getId().toString());
            this.processRelation(ncNetwork, comp, relationId, compJson, childId);
            if (this.processedIds.contains(childId)) continue;
            JSONObject childJSONObject = this.getEntityRecord(child);
            this.updatePropertyBinding(child, childJSONObject);
            this.traverseModel(child, childJSONObject, writer);
        }
        writer.value((Object)compJson);
    }

    private boolean getIsCloudPoint(BComponent child) {
        return this.cloudProxyExtByStationPointOrdMap.get(child.getSlotPath().toString()) != null || this.cloudHistoryExtIdBySrcPtSlotPathMap.get(child.getSlotPath().toString()) != null;
    }

    public boolean deviceIsHealthy() {
        return !this.getCloudDevice().getStatus().isDown() && !this.getCloudDevice().getStatus().isDisabled() && !this.getCloudDevice().getStatus().isFault();
    }

    private static void updateRelation(String relationId, JSONObject parentJSON, String childEntityId) {
        JSONArray parentRelationRefArray = new JSONArray();
        if (parentJSON.has(relationId) && !relationId.equals("hasLocation")) {
            parentRelationRefArray = (JSONArray)parentJSON.get(relationId);
        }
        if (!relationId.equals("hasLocation")) {
            boolean containEntity = false;
            for (int entityIndex = 0; entityIndex < parentRelationRefArray.length(); ++entityIndex) {
                if (parentRelationRefArray.get(entityIndex) != childEntityId) continue;
                containEntity = true;
                break;
            }
            if (!containEntity) {
                parentRelationRefArray.put((Object)childEntityId);
                parentJSON.put(relationId, (Object)parentRelationRefArray);
            }
        } else {
            parentJSON.put("hasLocation", (Object)childEntityId);
        }
    }

    private static void updateDeviceRelation(BComponent parent, String relationId, JSONObject parentJSON, String childEntityId) {
        try {
            AgentList agents = parent.getAgents().filter(AgentFilter.is((Type)BModelRelationHandler.TYPE));
            if (agents.size() == 0) {
                logger.finest(() -> String.format("A ModelRelationHandler agent was not configured for %s, using default relation update", parent.getName()));
                BContextDiscoveryModelExtractor.updateRelation(relationId, parentJSON, childEntityId);
            } else if (agents.size() > 0) {
                AgentInfo info = agents.getDefault();
                BModelRelationHandler handler = (BModelRelationHandler)info.getInstance().as(BModelRelationHandler.class);
                handler.updateDeviceRelation(relationId, parentJSON, childEntityId);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to process the relation with a ModelRelationHandler agent, using default relation update for: " + parent.getName(), logger.isLoggable(Level.FINE) ? e : null);
            BContextDiscoveryModelExtractor.updateRelation(relationId, parentJSON, childEntityId);
        }
    }

    protected void processRelation(BNiagaraCloudNetwork ncNetwork, BComponent parent, String relationId, JSONObject parentJSON, String childEntityId) {
        if (parent instanceof BDevice && !relationId.equals("hasLocation") && ncNetwork.getUseDriverIdForPointId()) {
            BContextDiscoveryModelExtractor.updateDeviceRelation(parent, relationId, parentJSON, childEntityId);
        } else {
            BContextDiscoveryModelExtractor.updateRelation(relationId, parentJSON, childEntityId);
        }
    }

    private static void addOntologyRecord(String siteName, JSONWriter writer) {
        JSONObject entityObject = new JSONObject();
        entityObject.put("@id", (Object)siteName);
        entityObject.put("@type", (Object)"owl:Ontology");
        JSONArray imports = new JSONArray();
        imports.put((Object)"http://www.honeywell.com/models/sentiencemodelwriter/1.0");
        imports.put((Object)"http://www.honeywell.com/models/hospitality/propertyroles/1.0");
        imports.put((Object)"http://www.honeywell.com/models/hvac/propertyroles/1.0");
        imports.put((Object)"http://www.honeywell.com/models/lighting/propertyroles/1.0");
        entityObject.put("imports", (Object)imports);
        writer.value((Object)entityObject);
    }

    private void buildCloudHistoryPointList() {
        BCloudHistoryExport[] histories;
        for (BCloudHistoryExport history : histories = this.getCloudHistoryExports()) {
            try {
                String pointSlotPath;
                BIHistory historyFromDB;
                BObject historyObj;
                BHistoryId historyId = BContextDiscoveryModelExtractor.getHistoryId((BComponent)history);
                if (null == historyId || null == (historyObj = BContextDiscoveryModelExtractor.getHistorySourceFromHistory(historyFromDB = BContextDiscoveryModelExtractor.getHistoryFromId(historyId = historyId.fromShorthand(Sys.getStation().getStationName())))) || null == (pointSlotPath = this.getSourceSlotPathFromHistory(historyObj))) continue;
                this.cloudHistoryExtIdBySrcPtSlotPathMap.put(pointSlotPath, CloudUtilities.makePointId((BIHistory)historyFromDB).toLowerCase());
            }
            catch (NullPointerException exp) {
                logger.warning("Unable to find the history source : " + history.toString());
            }
        }
    }

    private void buildCloudPointExtPointList() {
        BCloudSentienceDevice cloudDevice = this.getCloudDevice();
        if (null != cloudDevice) {
            BControlPoint[] points;
            BCloudPointDeviceExt cloudPointDeviceExt = cloudDevice.getPoints();
            for (BControlPoint point : points = cloudPointDeviceExt.getPoints()) {
                BCloudProxyExt proxyExt = (BCloudProxyExt)point.getProxyExt();
                this.cloudProxyExtByStationPointOrdMap.put(proxyExt.getOrdPath().toString(), proxyExt.getPointId());
                this.stationPointOrdByCloudProxyExtMap.put(proxyExt.getPointId(), proxyExt.getOrdPath().toString());
            }
        }
    }

    private void buildCloudTagDictNamespacesMap() {
        try {
            BTagDictionaryService tagDictService = (BTagDictionaryService)Sys.getService((Type)BTagDictionaryService.TYPE);
            tagDictService.getTagDictionaries().forEach(td -> this.cloudTagDictNamespacesMap.put(td.getNamespace(), BContextDiscoveryModelExtractor.makeNamespaceUri(td.getDisplayName(Context.NULL))));
        }
        catch (ServiceNotFoundException ignore) {
            logger.fine("Tag Dictionary service is not available; skipping initialization of tag dictionary namespace map.");
        }
    }

    protected static String makeNamespaceUri(String name) {
        return String.format("http://www.honeywell.com/models/%s/tagdictionary#", BContextDiscoveryModelExtractor.urlEncode(name));
    }

    private void updatePropertyBinding(BComponent comp, JSONObject entityObject) {
        String pointId;
        String[] keys;
        JSONObject pointObject;
        traversalLogger.finer(() -> String.format("Update property binding for %s", comp.getSlotPath()));
        if (comp instanceof BControlPoint) {
            pointObject = this.createBindingRecord((BControlPoint)comp, this.getComponentId(comp), BContextDiscoveryModelExtractor.getSystemGuid());
        } else if (comp instanceof BHistoryImport) {
            pointObject = this.createBindingRecord((BHistoryImport)comp, this.getComponentId(comp), BContextDiscoveryModelExtractor.getSystemGuid());
        } else {
            traversalLogger.finer(() -> String.format("Update property binding complete for %s - not a control point or history import", comp.getSlotPath()));
            return;
        }
        entityObject.put("@type", (Object)"honsmw:Property");
        Iterator markerTagsIterator = comp.tags().filter(t -> t.getValue().toString().equals(BMarker.MARKER.toString()) && t.getId().hasDictionary()).iterator();
        JSONArray markerTagsArray = new JSONArray();
        while (markerTagsIterator.hasNext()) {
            Tag tag = (Tag)markerTagsIterator.next();
            String[] tagId = tag.getId();
            markerTagsArray.put((Object)BContextDiscoveryModelExtractor.getMarkerTag(tagId.toString(), "_"));
            this.cloudNamespacesSet.add(tagId.getDictionary());
        }
        if (markerTagsArray.length() > 0) {
            entityObject.put("isDescribedByTag", (Object)markerTagsArray);
        }
        if ((keys = JSONObject.getNames((JSONObject)pointObject)) != null) {
            for (String key : keys) {
                if (this.isAttribute(key)) {
                    this.updateCustomAttribute(key, pointObject.get(key).toString(), comp, entityObject);
                }
                if (!this.isEntityProperty(key)) continue;
                entityObject.put(key, (Object)pointObject.get(key).toString());
            }
        }
        if ((pointId = this.getForgePointExtId(comp)) != null) {
            this.updateCustomAttribute("PointId", pointId, comp, entityObject);
        }
        this.updateCustomAttribute("Label", POINT_LABEL_ATTR_VALUE_REPLACE_PATTERN.matcher(comp.getDisplayName(null)).replaceAll(""), comp, entityObject);
        this.updateCustomAttribute("hon:OnboardedVia", this.getOnboardedVia(this.getSystemId()), comp, entityObject);
        if (this.getIsIncludeTags()) {
            Tags tags = comp.tags();
            ArrayList<Id> multiTagList = new ArrayList<Id>();
            for (Tag tag : tags) {
                Id tagId = tag.getId();
                if (multiTagList.contains(tagId)) continue;
                if (tags.isMulti(tagId)) {
                    multiTagList.add(tagId);
                    this.addMultiTagAttribute(tags, tag, comp, entityObject);
                    continue;
                }
                this.addSingleTagAttribute(tag, comp, entityObject);
            }
        }
        traversalLogger.finer(() -> String.format("Update property binding complete for %s", comp.getSlotPath()));
        attributeLogger.fine(() -> String.format("Attributes Maps By Key size: %s; Property Binding Concepts Map size: %s", this.attrIdByValMapsByAttrKey.size(), this.propBindingAndConceptsById.size()));
        traversalLogger.finest(() -> String.format("Entity object: %s", entityObject));
    }

    protected JSONObject createBindingRecord(BControlPoint controlPoint, String pointId, String systemGuid) {
        traversalLogger.finer(() -> String.format("create binding record for controlPoint %s: pointId: %s", controlPoint.getSlotPath(), pointId));
        JSONObject point = new JSONObject();
        BFacets facets = controlPoint.getFacets();
        BValue unitsText = controlPoint.getProxyExt().get("units");
        if (unitsText != null) {
            point.put("isDescribedByUnitLabel", (Object)unitsText.toString(null));
            point.put("hon:Unit", (Object)unitsText.toString(null));
        } else {
            BUnit pointUnits = (BUnit)facets.get("units");
            if (pointUnits != null && !pointUnits.isNull()) {
                point.put("isDescribedByUnitLabel", (Object)pointUnits.toString());
                point.put("hon:Unit", (Object)pointUnits.encodeToString());
            }
        }
        point.putOpt("hon:TrueText", (Object)facets.get("trueText"));
        point.putOpt("hon:FalseText", (Object)facets.get("falseText"));
        point.putOpt("hon:MinValue", (Object)facets.get("min"));
        point.putOpt("hon:MaxValue", (Object)facets.get("max"));
        point.putOpt("hon:Precision", (Object)facets.get("precision"));
        this.addPropertyBinding(pointId, (BComponent)controlPoint, point, systemGuid);
        return point;
    }

    private JSONObject createBindingRecord(BHistoryImport historyImport, String pointId, String systemGuid) {
        traversalLogger.finer(() -> String.format("create binding record for historyImport %s: pointId: %s", historyImport.getSlotPath(), pointId));
        JSONObject point = new JSONObject();
        this.addPropertyBinding(pointId, (BComponent)historyImport, point, systemGuid);
        return point;
    }

    private void addPropertyBinding(String pointIdWithSiteName, BComponent controlPoint, JSONObject point, String systemGUID) {
        BEnumRange enumRange;
        JSONArray concepts;
        JSONObject propertyBinding = new JSONObject();
        String id = pointIdWithSiteName + "Binding";
        propertyBinding.put("@id", (Object)id);
        propertyBinding.put("@type", (Object)"honsmw:PropertyBinding");
        if (BContextDiscoveryModelExtractor.isValidGUID(systemGUID)) {
            propertyBinding.put("hasSystemGUID", (Object)systemGUID);
            propertyBinding.put("hasBindingToID", (Object)this.getCloudBindingId(controlPoint));
        }
        if (controlPoint instanceof BIEnum && (concepts = this.getConcepts(enumRange = (BEnumRange)((BIEnum)controlPoint).getEnumFacets().get("range"))).length() > 0) {
            propertyBinding.put("hasConcept", (Object)concepts);
        }
        if (propertyBinding.length() > 2) {
            this.propBindingAndConceptsById.put(id, propertyBinding);
            point.put("hasPropertyBinding", (Object)id);
        }
    }

    protected boolean isAttribute(String pointObjectKey) {
        return Constants.ATTRIBUTE_KEYS.contains(Objects.toString(pointObjectKey));
    }

    protected boolean isEntityProperty(String pointObjectKey) {
        return !Constants.ATTRIBUTE_KEYS.contains(Objects.toString(pointObjectKey));
    }

    private static String getAttributeKey(String attrKey) {
        return Constants.ATTRIBUTE_KEY_CONVERSION_MAP.getOrDefault(attrKey, attrKey);
    }

    private void updateCustomAttribute(String unconvertedAttrKey, String attributeValue, BComponent component, JSONObject componentObject) {
        String attributeKey = BContextDiscoveryModelExtractor.getAttributeKey(unconvertedAttrKey);
        String attrId = (String)this.attrIdByValMapsByAttrKey.getOrDefault(attributeKey, Collections.emptyMap()).get(attributeValue);
        if (attrId == null) {
            if (!this.attrIdByValMapsByAttrKey.containsKey(attributeKey)) {
                this.attrIdByValMapsByAttrKey.put(attributeKey, new HashMap());
            }
            attrId = this.getAttributeId(component, attributeKey);
            this.attrIdByValMapsByAttrKey.get(attributeKey).put(attributeValue, attrId);
        }
        JSONArray attributeArray = componentObject.has("hasAttribute") ? componentObject.getJSONArray("hasAttribute") : new JSONArray();
        attributeArray.put((Object)attrId);
        componentObject.put("hasAttribute", (Object)attributeArray);
    }

    private void addSingleTagAttribute(Tag tag, BComponent component, JSONObject componentObject) {
        try {
            String attrKey = tag.getId().toString();
            String attrValue = tag.getValue().encodeToString();
            this.updateCustomAttribute(attrKey, attrValue, component, componentObject);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "An error occurred while encoding tag: " + tag.getId(), e);
        }
    }

    private void addMultiTagAttribute(Tags tags, Tag tag, BComponent component, JSONObject componentObject) {
        try {
            Id id = tag.getId();
            String attrKey = id.toString();
            Collection values = tags.getValues(id);
            Iterator valuesIterator = values.iterator();
            StringBuilder attrDataValueBldr = new StringBuilder();
            while (valuesIterator.hasNext()) {
                BIDataValue value = (BIDataValue)valuesIterator.next();
                attrDataValueBldr.append(value.encodeToString());
                if (!valuesIterator.hasNext()) continue;
                attrDataValueBldr.append(',');
            }
            String attrValue = attrDataValueBldr.toString();
            this.updateCustomAttribute(attrKey, attrValue, component, componentObject);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "An error occurred while encoding multi-value tag: " + tag.getId(), e);
        }
    }

    protected String getAttributeId(BComponent component, String attributeKey) {
        return this.getComponentId(component) + "." + attributeKey;
    }

    private JSONArray getConcepts(BEnumRange enumRange) {
        JSONArray concepts = new JSONArray();
        if (null != enumRange) {
            int numberOfState = enumRange.getOrdinals().length;
            for (int state = 0; state < numberOfState; ++state) {
                int ordinal = enumRange.getOrdinals()[state];
                String tagText = enumRange.getDisplayTag(ordinal, null);
                tagText = CONCEPTS_REPLACE_PATTERN.matcher(tagText).replaceAll("");
                String id = "SiteContext:" + SlotPath.escape((String)(enumRange.toString() + "Enum" + tagText));
                JSONObject concept = new JSONObject();
                if (!this.propBindingAndConceptsById.containsKey(id)) {
                    concept.put("@id", (Object)id);
                    concept.put("@type", (Object)"honsmw:Concept");
                    concept.put("hasConceptID", (Object)String.valueOf(ordinal));
                    concept.put("hasConceptLabel", (Object)tagText);
                    this.propBindingAndConceptsById.put(id, concept);
                }
                concepts.put((Object)id);
            }
        }
        return concepts;
    }

    private static String getMarkerTag(String markerTag, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(markerTag, delimiter);
        if (tokenizer.countTokens() > 1) {
            StringBuilder builder = new StringBuilder();
            String tagNameSpace = tokenizer.nextToken();
            if (tagNameSpace.contains(":")) {
                tagNameSpace = tagNameSpace.substring(tagNameSpace.indexOf(":") + 1);
            }
            builder.append(tagNameSpace);
            builder.append(":");
            if (tokenizer.hasMoreTokens()) {
                builder.append(tokenizer.nextToken());
            }
            while (tokenizer.hasMoreTokens()) {
                builder.append(delimiter);
                builder.append(tokenizer.nextToken());
            }
            return builder.toString();
        }
        return markerTag;
    }

    private JSONObject getEntityRecord(BComponent component) {
        Property[] properties;
        String id = this.getComponentId(component);
        JSONObject entityObject = new JSONObject();
        entityObject.put("label", (Object)this.getTagValueFromProperty(component, "label", component.getDisplayName(null)));
        entityObject.put("@id", (Object)id);
        entityObject.put("@type", (Object)this.getTagValueFromProperty(component, entityTypeTag.getName(), BContextDiscoveryModelExtractor.getDefaultType(component)));
        for (Property property : properties = this.getDynamicPropertiesArray()) {
            String tagValue = this.getTagValueFromProperty(component, property.getName(), null);
            if (null == tagValue || tagValue.isEmpty()) continue;
            entityObject.put(property.getName(), (Object)tagValue);
        }
        if (!this.getModelAdditionalTags().isEmpty()) {
            String[] additionalTagFields = this.getModelAdditionalTags().split(";");
            this.dbDriver.extractFields(component, additionalTagFields, entityObject);
        }
        this.processedIds.add(id);
        return entityObject;
    }

    private String getTagValueFromProperty(BComponent component, String expectedPropertyName, String defaultValue) {
        Property property = this.getProperty(expectedPropertyName);
        if (property != null && !this.getString(property).isEmpty()) {
            String tagValue = this.dbDriver.getFieldValue(this.getString(property), component.tags());
            return tagValue.isEmpty() ? defaultValue : tagValue;
        }
        return defaultValue;
    }

    private String getComponentId(BComponent component) {
        String compId = "";
        if (BNiagaraCloudNetwork.getNiagaraCloudNetwork().getUseDriverIdForPointId()) {
            compId = ((BIDataValue)component.tags().get(CloudUtilities.CLOUD_ID_TAG).orElse(BString.DEFAULT)).toString();
        }
        if (compId.isEmpty()) {
            String componentIdTagName = entityIdTag.getName();
            compId = SlotPath.escape((String)this.getTagValueFromProperty(component, componentIdTagName, BContextDiscoveryModelExtractor.getDefaultId(component)));
        }
        return "SiteContext:" + compId;
    }

    private static boolean isComponentInModel(BComponent c, Tags ts) {
        return true;
    }

    private static String getDefaultType(BComponent root) {
        if (root instanceof BControlPoint) {
            return "honsmw:Property";
        }
        if (root instanceof BDevice || root instanceof BNDevice) {
            return "honcore:Controller";
        }
        if (root instanceof BDeviceNetwork || root instanceof BNNetwork) {
            return "honcore:LogicalController";
        }
        return root.getTypeDisplayName(null);
    }

    private static String getDefaultId(BComponent comp) {
        return comp.getSlotPath().toString();
    }

    private static String getRelationId(String relationIdWithNamespace) {
        String[] tokenized = relationIdWithNamespace.split(":");
        if (tokenized.length > 1) {
            return tokenized[1];
        }
        return relationIdWithNamespace;
    }

    private BCloudHistoryExport[] getCloudHistoryExports() {
        BCloudSentienceDevice cloudDevice = this.getCloudDevice();
        if (null != cloudDevice) {
            BCloudHistoryDeviceExt historyExt = cloudDevice.getHistories();
            return (BCloudHistoryExport[])CompUtil.getDescendants((BComponent)historyExt, BCloudHistoryExport.class);
        }
        return EMPTY_CLOUD_HISTORY_EXPORTS_ARRAY;
    }

    private static BHistoryDatabase getHistoryDatabase() {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        return service.getDatabase();
    }

    private static BIHistory getHistoryFromId(BHistoryId historyId) {
        try (HistoryDatabaseConnection conn = BContextDiscoveryModelExtractor.getHistoryDatabase().getDbConnection(null);){
            BIHistory historyFromDB;
            BIHistory bIHistory = historyFromDB = conn.getHistory(historyId);
            return bIHistory;
        }
    }

    private static BObject getHistorySourceFromHistory(BIHistory history) {
        try {
            BOrdList ordList = history.getConfig().getSource();
            if (ordList.size() == 0) {
                return null;
            }
            BOrd ord = ordList.get(ordList.size() - 1);
            return ord.get();
        }
        catch (UnresolvedException ure) {
            return null;
        }
    }

    private static BObject getHistorySourceFromId(BHistoryId historyId) {
        BIHistory history = BContextDiscoveryModelExtractor.getHistoryFromId(historyId);
        return BContextDiscoveryModelExtractor.getHistorySourceFromHistory(history);
    }

    private static BHistoryId getHistoryId(BComponent history) {
        BHistoryId historyId = null;
        if (history instanceof BCloudHistoryExport) {
            historyId = ((BCloudHistoryExport)history).getHistoryId();
        } else if (history instanceof BHistoryImport) {
            historyId = ((BHistoryImport)history).getHistoryId();
        }
        return historyId;
    }

    private String getSourceSlotPathFromHistory(BObject historyObj) {
        String pointSlotPath = null;
        try {
            if (historyObj instanceof BHistoryExt) {
                pointSlotPath = ((BHistoryExt)historyObj).getParentPoint().getSlotPath().toString();
            } else if (historyObj instanceof BHistoryImport) {
                pointSlotPath = this.findPointSlotPath((BHistoryImport)historyObj);
            }
            return pointSlotPath;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected String findPointSlotPath(BHistoryImport historyImport) {
        String pointSlotPath = null;
        AgentList agents = historyImport.getAgents().filter(AgentFilter.is((Type)BHistorySourceDiscoverer.TYPE));
        if (agents.size() > 0) {
            AgentInfo info = agents.getDefault();
            BHistorySourceDiscoverer discoverer = (BHistorySourceDiscoverer)info.getInstance().as(BHistorySourceDiscoverer.class);
            pointSlotPath = discoverer.getHistorySource(historyImport);
        }
        logger.finest(String.format("pointSlotPath for %s by agent: %s", historyImport, pointSlotPath));
        if (pointSlotPath == null) {
            pointSlotPath = historyImport.getSlotPath().toString();
            Iterator proxyPointReferenceTags = historyImport.tags().filter(t -> t.getId().toString().equals(this.getProxyPointReferenceTag())).iterator();
            if (proxyPointReferenceTags.hasNext()) {
                Tag tag = (Tag)proxyPointReferenceTags.next();
                if (this.cloudProxyExtByStationPointOrdMap.get(tag.getValue().toString()) != null) {
                    pointSlotPath = tag.getValue().toString();
                    logger.finest(() -> String.format("found proxyPtRefTag value '%s' in cloudProxyExtByStationPointOrdMap with value %s; setting pointSlotPath", tag.getValue().toString(), this.cloudProxyExtByStationPointOrdMap.get(tag.getValue().toString())));
                } else if (this.stationPointOrdByCloudProxyExtMap.get(tag.getValue().toString()) != null) {
                    pointSlotPath = tag.getValue().toString();
                    logger.finest(() -> String.format("found proxyPtRefTag value '%s' in stationPointOrdByCloudProxyExtMap with value %s; setting pointSlotPath", tag.getValue().toString(), this.cloudProxyExtByStationPointOrdMap.get(tag.getValue().toString())));
                }
            }
            logger.finest(String.format("No pointSlotPath for %s by agent; path by refTag: %s", historyImport, pointSlotPath));
        }
        return pointSlotPath;
    }

    public BCloudSentienceDevice getCloudDevice() {
        BDriverContainer driverContainer = (BDriverContainer)Sys.getService((Type)BDriverContainer.TYPE);
        BNiagaraCloudNetwork[] niagaraCloudNetwork = (BNiagaraCloudNetwork[])driverContainer.getChildren(BNiagaraCloudNetwork.class);
        if (niagaraCloudNetwork.length > 0) {
            BDevice[] devices;
            BNiagaraCloudNetwork network = niagaraCloudNetwork[0];
            for (BDevice device : devices = network.getDevices()) {
                if (!(device instanceof BCloudSentienceDevice)) continue;
                BCloudSentienceDevice sentienceDevice = (BCloudSentienceDevice)device;
                return sentienceDevice;
            }
        }
        return null;
    }

    private static String getSystemGuid() {
        BSentienceConnectorImpl[] connectorImpl;
        BCloudConnector cloudConnector = (BCloudConnector)Sys.getService((Type)BCloudConnector.TYPE);
        if (cloudConnector != null && (connectorImpl = (BSentienceConnectorImpl[])cloudConnector.getChildren(BSentienceConnectorImpl.class)).length > 0 && connectorImpl[0].getRegistrationState().getOrdinal() == 2) {
            return cloudConnector.getId();
        }
        return null;
    }

    protected String getSystemId() {
        if (!this.systemId.isEmpty()) {
            return this.systemId;
        }
        BCloudConnector cloudConnector = (BCloudConnector)Sys.getService((Type)BCloudConnector.TYPE);
        if (cloudConnector != null) {
            BSentienceConnectorImpl connectorImpl = (BSentienceConnectorImpl)cloudConnector.getConnectorImpl();
            this.systemId = connectorImpl.getSystemId();
        }
        return this.systemId;
    }

    private String getOnboardedVia(String systemId) {
        if (!this.onboardedVia.isEmpty()) {
            return this.onboardedVia;
        }
        if (systemId == null || systemId.isEmpty()) {
            logger.finest("OnboardedVia cannot be determined because System Id is null or blank.");
            this.onboardedVia = "";
        } else {
            this.onboardedVia = systemId.startsWith("GUID") ? ONBOARD_TYPE_FORGE : ONBOARD_TYPE_NIAGARA;
        }
        return this.onboardedVia;
    }

    private static String getForgeId(BHistoryId historyId) {
        HistoryDatabaseConnection conn = BContextDiscoveryModelExtractor.getHistoryDatabase().getDbConnection(null);
        BIHistory historyFromDB = conn.getHistory(historyId);
        return SlotPath.escape((String)("history:/" + historyFromDB.getId().toString()));
    }

    private String getForgePointExtId(BComponent controlPoint) {
        String slotPath = controlPoint.getSlotPath().toString();
        if (this.cloudProxyExtByStationPointOrdMap.containsKey(slotPath)) {
            return SlotPath.escape((String)this.cloudProxyExtByStationPointOrdMap.get(slotPath));
        }
        return null;
    }

    private String getCloudBindingId(BComponent controlPoint) {
        String slotPath = controlPoint.getSlotPath().toString();
        String bindingId = SlotPath.escape((String)slotPath);
        if (this.cloudHistoryExtIdBySrcPtSlotPathMap.containsKey(slotPath)) {
            bindingId = this.cloudHistoryExtIdBySrcPtSlotPathMap.get(slotPath);
        } else if (this.cloudProxyExtByStationPointOrdMap.containsKey(slotPath)) {
            bindingId = this.cloudProxyExtByStationPointOrdMap.get(slotPath).toLowerCase();
        }
        String finalBindingId = bindingId;
        logger.finest(() -> String.format("getCloudBindingId: component slotPath=%s; bindingId=%s", slotPath, finalBindingId));
        return bindingId;
    }

    private static boolean isValidGUID(String systemGUID) {
        return systemGUID != null && GUID_PATTERN.matcher(systemGUID).matches();
    }
}

