/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.backup;

import com.tridium.backup.BAxOfflineBackup;
import com.tridium.backup.BBackupChannel;
import com.tridium.file.types.bog.BBogFile;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.install.BDaemonPlatform;
import com.tridium.install.BDependency;
import com.tridium.install.BLocalDaemonPlatform;
import com.tridium.install.BModuleList;
import com.tridium.install.BRemoteDaemonPlatform;
import com.tridium.install.BVersion;
import com.tridium.install.installable.BModuleInstallable;
import com.tridium.install.installable.DistributionManifest;
import com.tridium.install.part.BBrandPart;
import com.tridium.install.part.BGenericPart;
import com.tridium.install.part.BNrePart;
import com.tridium.install.part.BOsPart;
import com.tridium.install.part.BPart;
import com.tridium.install.part.BVmPart;
import com.tridium.nre.platform.IPlatformProvider;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.nre.security.EncryptionKeySource;
import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.PBEDecryptingInputStream;
import com.tridium.nre.security.PBEEncodingInfo;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.nre.security.io.AESStreamEncryption;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.nre.security.io.PBEEncryptingInputStream;
import com.tridium.nre.util.BogTranscoderInputStream;
import com.tridium.platform.BHostIdStatus;
import com.tridium.platform.SystemFilePaths;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.BStationSurrogate;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.LocalSessionUtil;
import com.tridium.platform.daemon.NiagaraPlatformDaemon;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.GetDhcpdMessage;
import com.tridium.platform.daemon.message.GetIEEE8021XMessage;
import com.tridium.platform.daemon.message.UpdateStationMessage;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.sys.Nre;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.baja.data.BIDataValue;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocDecoder;
import javax.baja.job.BJob;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLog;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.platform.PlatformDaemon;
import javax.baja.platform.RemoteStation;
import javax.baja.platform.install.BVersionRelation;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.user.BUser;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.PatternFilter;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="excludeFiles", type="String", defaultValue="*.hdb;*.adb;*.lock;*backup*;console.*;config.bog.b*;config_backup*"), @NiagaraProperty(name="excludeDirectories", type="BOrdList", defaultValue="BOrdList.make(new BOrd[] { BOrd.make(\"file:^^history\"), BOrd.make(\"file:^^alarm\"), BOrd.make(\"file:^^webFileCache\") })", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE, BFacets.TARGET_TYPE, BString.make(\"baja:IDirectory\"))")}), @NiagaraProperty(name="offlineExcludeFiles", type="String", defaultValue="*.lock;*backup*;console.*;config.bog.b*;config_backup*"), @NiagaraProperty(name="offlineExcludeDirectories", type="BOrdList", defaultValue="BOrdList.NULL", facets={@Facet(value="BFacets.make(BFacets.MULTI_LINE, BBoolean.TRUE, BFacets.TARGET_TYPE, BString.make(\"baja:IDirectory\"))")})})
public class BBackupService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property excludeFiles = BBackupService.newProperty((int)0, (String)"*.hdb;*.adb;*.lock;*backup*;console.*;config.bog.b*;config_backup*", null);
    @Generated
    public static final Property excludeDirectories = BBackupService.newProperty((int)0, (BValue)BOrdList.make((BOrd[])new BOrd[]{BOrd.make((String)"file:^^history"), BOrd.make((String)"file:^^alarm"), BOrd.make((String)"file:^^webFileCache")}), (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    @Generated
    public static final Property offlineExcludeFiles = BBackupService.newProperty((int)0, (String)"*.lock;*backup*;console.*;config.bog.b*;config_backup*", null);
    @Generated
    public static final Property offlineExcludeDirectories = BBackupService.newProperty((int)0, (BValue)BOrdList.NULL, (BFacets)BFacets.make((String)"multiLine", (BIDataValue)BBoolean.TRUE, (String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    @Generated
    public static final Type TYPE = Sys.loadType(BBackupService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final BIcon icon = BIcon.std((String)"navOnly/backupService.png");
    public static Logger log = Logger.getLogger("backup");
    private final DateFormat logDateFormat = new SimpleDateFormat("HH:mm:ss dd-MMM-yy z");
    private static final String WORKSTATION_HOST_MODEL = "Workstation";
    private static final BOrd[] COMMON_PLATFORM_BACKUP = new BOrd[]{BOrd.make((String)"file:~daemon"), BOrd.make((String)"file:~etc"), BOrd.make((String)"file:~logging")};
    private static final BOrdList DEFAULT_SECURITY_BACKUP = BOrdList.make((BOrd)BOrd.make((String)"file:~security"));
    private static final BOrd[] WRITABLE_HOME_PLATFORM_BACKUP_ADDER = new BOrd[]{BOrd.make((String)"file:!defaults"), BOrd.make((String)"file:!etc"), BOrd.make((String)"file:!lexicon"), BOrd.make((String)"file:!lib"), BOrd.make((String)"file:!platform"), BOrd.make((String)"file:!security/policy")};
    private static final BOrd[] WRITABLE_LICENSE_WITH_WRITABLE_HOME_PLATFORM_BACKUP_ADDER = new BOrd[]{BOrd.make((OrdQuery)SystemFilePaths.getCertificatesDirPath((boolean)true, (boolean)true, (boolean)false)), BOrd.make((OrdQuery)SystemFilePaths.getLicensesDirPath((boolean)true, (boolean)true, (boolean)false)), BOrd.make((OrdQuery)SystemFilePaths.getSubscriptionDirPath((boolean)false))};
    private static final BOrd[] WRITABLE_LICENSE_WITH_READONLY_HOME_PLATFORM_BACKUP_ADDER = new BOrd[]{BOrd.make((OrdQuery)SystemFilePaths.getCertificatesDirPath((boolean)true, (boolean)true, (boolean)true)), BOrd.make((OrdQuery)SystemFilePaths.getLicensesDirPath((boolean)true, (boolean)true, (boolean)true)), BOrd.make((OrdQuery)SystemFilePaths.getSubscriptionDirPath((boolean)true))};
    private static final BOrd[] READONLY_LICENSE_WITH_WRITABLE_HOME_PLATFORM_BACKUP_ADDER = new BOrd[]{BOrd.make((OrdQuery)SystemFilePaths.getSubscriptionDirPath((boolean)false))};
    private static final BOrd[] READONLY_LICENSE_WITH_READONLY_HOME_PLATFORM_BACKUP_ADDER = new BOrd[]{BOrd.make((OrdQuery)SystemFilePaths.getSubscriptionDirPath((boolean)true))};
    private static final List<Pattern> TRIDIUM_LEGACY_PASSPHRASE_ENCRYPTED_PATHS = Stream.of(".*\\!platform\\/wifi\\/.+|.*\\!platform\\/ieee8021x\\/.+").map(Pattern::compile).collect(Collectors.toList());
    private static final List<Pattern> KEYRING_ENCRYPTED_STATION_PATHS = Stream.of(".*\\^\\^ldap\\/(?!krb5\\.conf$).+").map(Pattern::compile).collect(Collectors.toList());
    private static final List<Pattern> PASSPHRASE_ENCRYPTED_PATHS = new ArrayList<Pattern>();
    private static final ArrayList<BOrd> DYNAMIC_PLATFORM_BACKUP = new ArrayList();
    private static final String TITAN_OS_NAME_SUFFIX = "-n4-titan-am335x-hs";
    private static final String TITAN_OS_NAME_GLOB_SUFFIX = "-n4-titan-am335x*";
    private static final String ATLAS_SNAP_TRIDIUM_NIAGARA_NAME = "snap-tridium-niagara-arm64";
    private static final Set<String> UNKNOWN_VERSION_STRINGS = new HashSet<String>(Arrays.asList(new BVersion("0.0").toString()));
    public static final ICanceler NULL_CANCELER = () -> false;

    @Generated
    public String getExcludeFiles() {
        return this.getString(excludeFiles);
    }

    @Generated
    public void setExcludeFiles(String v) {
        this.setString(excludeFiles, v, null);
    }

    @Generated
    public BOrdList getExcludeDirectories() {
        return (BOrdList)this.get(excludeDirectories);
    }

    @Generated
    public void setExcludeDirectories(BOrdList v) {
        this.set(excludeDirectories, (BValue)v, null);
    }

    @Generated
    public String getOfflineExcludeFiles() {
        return this.getString(offlineExcludeFiles);
    }

    @Generated
    public void setOfflineExcludeFiles(String v) {
        this.setString(offlineExcludeFiles, v, null);
    }

    @Generated
    public BOrdList getOfflineExcludeDirectories() {
        return (BOrdList)this.get(offlineExcludeDirectories);
    }

    @Generated
    public void setOfflineExcludeDirectories(BOrdList v) {
        this.set(offlineExcludeDirectories, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.registerFoxChannel();
        try {
            Sys.getService((Type)BIDataRecoveryService.TYPE);
            BOrd newExclude = BOrd.make((String)"file:^^dataRecovery");
            boolean addToExclude = true;
            for (BOrd anOrdList : this.getExcludeDirectories().toArray()) {
                if (!anOrdList.equals((Object)newExclude)) continue;
                addToExclude = false;
                break;
            }
            if (addToExclude) {
                this.setExcludeDirectories(BOrdList.add((BOrdList)this.getExcludeDirectories(), (BOrd)newExclude));
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
    }

    void registerFoxChannel() {
        String foxChannelId = this.getFoxChannelId();
        if (BFoxChannelRegistry.getPrototype().get(foxChannelId) == null) {
            BFoxChannelRegistry.getPrototype().add(foxChannelId, (BValue)new BBackupChannel());
        } else {
            log.info("The Fox " + foxChannelId + " channel exists.");
        }
    }

    protected String getFoxChannelId() {
        return "backup";
    }

    private void checkUserAndAuditForBackup(Context cx) {
        this.checkUserAndAudit(this.getLexicon().get("backup"), cx);
    }

    private void checkUserAndAuditForRestore(Context cx) {
        this.checkUserAndAudit(this.getLexicon().get("restore"), cx);
    }

    private void checkUserAndAudit(String operation, Context cx) {
        Auditor auditor;
        String userName = "";
        if (cx != null && cx.getUser() != null) {
            BUser user = cx.getUser();
            user.check((BIProtected)this, BPermissions.adminWrite);
            userName = cx.getUser().getUsername();
        }
        if ((auditor = Nre.auditor) != null && this.isMounted() && !userName.isEmpty()) {
            auditor.audit(new AuditEvent("Invoked", this.getSlotPath().getBody(), operation, "", "", userName));
        }
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkContextForSuperUser((BIRestrictedComponent)this, (Context)cx);
    }

    public void restoreFiles(BIFile backupFile, Context cx) throws Exception {
        this.restoreFiles(backupFile, false, true, 1500L, cx);
    }

    @Deprecated
    public void restoreFiles(BIFile backupFile) throws Exception {
        this.restoreFiles(backupFile, null);
    }

    public void restoreFiles(BIFile backupFile, boolean ignoreDependencies, boolean deleteFile, Context cx) throws Exception {
        this.restoreFiles(backupFile, ignoreDependencies, deleteFile, 1500L, cx);
    }

    @Deprecated
    public void restoreFiles(BIFile backupFile, boolean ignoreDependencies, boolean deleteFile) throws Exception {
        this.restoreFiles(backupFile, ignoreDependencies, deleteFile, 1500L, null);
    }

    public void restoreFiles(BIFile backupFile, boolean ignoreDependencies, boolean deleteFile, long shutdownDelay, Context cx) throws Exception {
        this.checkUserAndAuditForRestore(cx);
        NiagaraBasicPermission restorePermission = new NiagaraBasicPermission("RESTORE_BACKUP");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)restorePermission);
        }
        AccessController.doPrivileged(() -> {
            log.info("Restoring from backup file " + backupFile.getFilePath().getBody());
            RestoreOp op = new RestoreOp(backupFile, ignoreDependencies, deleteFile, shutdownDelay);
            if (log.getLevel() != null) {
                op.logLevel = BBackupService.log.getLevel();
            }
            if (!op.ignoreDependencies) {
                this.verifyDependencies(op);
            }
            log.warning("Shutting down the station for file restore.  Please do not kill or reboot while the restore is in progress.");
            log.warning("The station will be restarted automatically once the restore completes.");
            new Thread(op).start();
            return null;
        });
    }

    @Deprecated
    public void restoreFiles(BIFile backupFile, boolean ignoreDependencies, boolean deleteFile, long shutdownDelay) throws Exception {
        this.restoreFiles(backupFile, ignoreDependencies, deleteFile, shutdownDelay, null);
    }

    private void doRestore(RestoreOp op) {
        String oldStationName = op.stationName;
        Runtime.getRuntime().addShutdownHook(new RestoreThread(op));
        try {
            BDaemonSession daemon = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
            NiagaraPlatformDaemon niagaraDaemon = NiagaraPlatformDaemon.make((BDaemonSession)daemon, (DaemonSessionTaskListener)DaemonSessionTaskListener.NULL_TASK_LISTENER);
            for (RemoteStation station : niagaraDaemon.getStationManager().getAllStations()) {
                if (!station.getName().equals(oldStationName)) continue;
                BStationSurrogate stationSurrogate = BStationSurrogate.make((BDaemonSession)daemon, (String)oldStationName);
                stationSurrogate.stopStation(null, null);
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: Could not commit platform changes.");
            ex.printStackTrace();
        }
    }

    private void verifyDependencies(RestoreOp op) throws Exception {
        log.info("Verifying backup file dependencies");
        Array unmet = new Array(BDependency.class);
        for (BDependency dep : op.manifest().getDependencies()) {
            if (op.daemonPlatform().meets(dep)) continue;
            unmet.add((Object)dep);
        }
        if (!unmet.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (int i = 0; i < unmet.size(); ++i) {
                message.append(' ').append(((BDependency)unmet.get(i)).toString());
            }
            throw new LocalizableRuntimeException("backup", "restore.error.unmetDeps", new Object[]{message});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreFiles(RestoreOp op) throws Exception {
        String newStationName = null;
        boolean anyErrors = false;
        op.consoleMessage("Cleaning original station folder:" + op.stationName);
        try {
            FilePath stationDir = new FilePath("~stations/" + op.stationName);
            BFileSystem.INSTANCE.delete(stationDir);
        }
        catch (Exception e) {
            op.consoleError("Cleaning original station folder failed", e);
            anyErrors = true;
        }
        boolean licenseReadonly = PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE.isLicenseReadonly();
        op.consoleMessage("Restoring files");
        try (SecretChars systemPassword = AccessController.doPrivileged(() -> ((IPlatformProvider)PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE).getSystemPassword());
             PBEEncodingKey encodingKey = op.manifest.getPBEEncodingInfo().makePBEKey(systemPassword);){
            Enumeration<? extends ZipEntry> eEntry = op.zipFile.entries();
            while (eEntry.hasMoreElements()) {
                InputStream in;
                ZipEntry entry = eEntry.nextElement();
                if (entry.getName().toLowerCase().startsWith("meta-inf")) continue;
                if (licenseReadonly && (entry.getName().toLowerCase().endsWith(".license") || entry.getName().toLowerCase().endsWith(".certificate"))) {
                    if (!op.isLoggable(Level.FINE)) continue;
                    op.consoleTrace("Skipping file '" + entry.getName() + "' because host licenses are read-only");
                    continue;
                }
                if (this.getPathForEntry(entry.getName(), op).getName().equals(".kr")) {
                    op.consoleMessage("Importing Key Ring Data");
                    in = op.zipFile.getInputStream(entry);
                    SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing().importKeyData(in, (int)entry.getSize(), (ISecretBytesSupplier)encodingKey);
                    continue;
                }
                in = null;
                OutputStream out = null;
                try {
                    BIFile outputFile = BFileSystem.INSTANCE.makeFile(this.getPathForEntry(entry.getName(), op));
                    op.consoleMessage("Restoring file " + outputFile.getFilePath().getBody() + "...");
                    out = outputFile.getOutputStream();
                    if (BBackupService.matchesAnyPattern(outputFile.getFilePath(), PASSPHRASE_ENCRYPTED_PATHS)) {
                        if (op.isLoggable(Level.FINE)) {
                            op.consoleTrace("Restore file '" + outputFile.getFilePath().getBody() + "' matched PASSPHRASE_ENCRYPTED_PATHS pattern");
                        }
                        in = new PBEDecryptingInputStream(op.zipFile.getInputStream(entry), encodingKey);
                    } else if (BBackupService.matchesAnyPattern(outputFile.getFilePath(), TRIDIUM_LEGACY_PASSPHRASE_ENCRYPTED_PATHS)) {
                        if (op.isLoggable(Level.FINE)) {
                            op.consoleTrace("Restore file '" + outputFile.getFilePath().getBody() + "' matched TRIDIUM_LEGACY_PASSPHRASE_ENCRYPTED_PATHS pattern");
                        }
                        in = new PBEDecryptingInputStream(op.zipFile.getInputStream(entry), encodingKey);
                    } else if (BBackupService.matchesAnyPattern(outputFile.getFilePath(), KEYRING_ENCRYPTED_STATION_PATHS)) {
                        if (op.isLoggable(Level.FINE)) {
                            op.consoleTrace("Restore file '" + outputFile.getFilePath().getBody() + "' matched KEYRING_ENCRYPTED_STATION_PATHS pattern");
                        }
                        in = AESStreamEncryption.pbeToKeyRing((InputStream)op.zipFile.getInputStream(entry), (PBEEncodingKey)encodingKey, (ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                    } else if (outputFile instanceof BBogFile) {
                        ValueDocDecoder.BogDecoderPlugin decoderPlugin = new ValueDocDecoder.BogDecoderPlugin(op.zipFile.getInputStream(entry));
                        decoderPlugin.readHeader();
                        BogPasswordObjectEncoder passwordObjectEncoder = decoderPlugin.getPasswordObjectEncoder();
                        if (passwordObjectEncoder != null && EncryptionKeySource.external.equals((Object)passwordObjectEncoder.getKeySource())) {
                            if (op.isLoggable(Level.FINE)) {
                                op.consoleTrace("Restore file '" + outputFile.getFilePath().getBody() + "' matched external EncryptionKeySource requirements");
                            }
                            in = new BogTranscoderInputStream(AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing()), op.zipFile.getInputStream(entry), !op.isLoggable(Level.FINEST), encodingKey, EncryptionKeySource.keyring);
                        } else {
                            in = op.zipFile.getInputStream(entry);
                        }
                    } else {
                        in = op.zipFile.getInputStream(entry);
                    }
                    if (in == null) {
                        if (outputFile instanceof BBogFile) {
                            throw new LocalizableRuntimeException("backup", "restore.error.noInputStreamBog", new Object[]{outputFile.getFilePath().getBody()});
                        }
                        throw new LocalizableRuntimeException("backup", "restore.error.noInputStream", new Object[]{outputFile.getFilePath().getBody()});
                    }
                    FileUtil.pipe((InputStream)in, (OutputStream)out);
                    FilePath outPath = outputFile.getFilePath();
                    if (!outPath.getName().equals("config.bog") || !outPath.getParent().getParent().getBody().equals("~stations") && !outPath.getParent().getParent().getBody().equals("/niagara/stations")) continue;
                    newStationName = outPath.getParent().getName();
                }
                catch (Exception e) {
                    op.consoleError("File copy failed", e);
                    anyErrors = true;
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (out == null) continue;
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            if (newStationName != null && op.stationName != null && !newStationName.equals(op.stationName)) {
                op.consoleMessage("stationName is changing from " + op.stationName + " to " + newStationName);
                BDaemonSession daemon = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
                BStationSurrogate station = BStationSurrogate.make((BDaemonSession)daemon, (String)op.stationName);
                boolean autoStart = station.getIsAutoStart();
                boolean autoRestart = station.getIsAutoRestart();
                daemon.sendMessage((DaemonMessage)new UpdateStationMessage());
                BStationSurrogate newStationSurrogate = BStationSurrogate.make((BDaemonSession)daemon, (String)newStationName);
                daemon.sendMessage((DaemonMessage)new UpdateStationMessage(newStationName, false, autoStart, autoRestart, true));
                if (Nre.getHostModel().equals(WORKSTATION_HOST_MODEL)) {
                    newStationSurrogate.startStationAsync();
                }
                daemon.sendMessage((DaemonMessage)new UpdateStationMessage(op.stationName, true, false, false, true));
                op.newStationName = newStationName;
            } else if (op.stationName != null && newStationName != null && newStationName.equals(op.stationName)) {
                op.consoleMessage("stationName is still " + op.stationName);
            } else {
                op.consoleMessage("unable to determine station name difference; oldName = '" + op.stationName + "', newName = '" + newStationName + "'");
            }
        }
        catch (Exception e) {
            op.consoleError("Station Name Analysis Failed", e);
            anyErrors = true;
        }
        if (anyErrors) {
            op.consoleWarning("Restore completed with errors");
        } else {
            op.consoleMessage("Restore completed successfully");
        }
    }

    private FilePath getPathForEntry(String entryPath, RestoreOp op) throws Exception {
        if (op.manifest().useAbsoluteElementPaths()) {
            return new FilePath('/' + entryPath);
        }
        int firstSlash = entryPath.indexOf(47);
        if (firstSlash > 0) {
            String relativePath = entryPath.substring(0, firstSlash);
            String body = entryPath.substring(firstSlash + 1);
            if ("niagara_home".equals(relativePath)) {
                return new FilePath('!' + body);
            }
            if ("niagara_user_home".equals(relativePath)) {
                return new FilePath('~' + body);
            }
        }
        return new FilePath('!' + entryPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(BJob job, OutputStream out, boolean close, Context cx) throws Exception {
        BLocalDaemonPlatform instance;
        this.checkUserAndAuditForBackup(cx);
        try {
            instance = AccessController.doPrivileged(BLocalDaemonPlatform::getInstance);
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        try (BackupOp backupOp = new BackupOp(job, BBackupService.makeCanceler(job), (BDaemonPlatform)instance);){
            this.zip(out, close, backupOp);
        }
        finally {
            try {
                if (close) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Deprecated
    public void zip(BJob job, OutputStream out, boolean close) throws Exception {
        this.zip(job, out, close, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(BJob job, PlatformDaemon platformDaemon, OutputStream out, boolean close, Context cx) throws Exception {
        block21: {
            this.checkUserAndAuditForBackup(cx);
            try {
                BRemoteDaemonPlatform daemonPlatform = ((NiagaraPlatformDaemon)platformDaemon).getDaemonPlatform(null);
                if (!daemonPlatform.getIsNiagara4() && daemonPlatform instanceof BRemoteDaemonPlatform) {
                    new BAxOfflineBackup().zip(job, daemonPlatform, out, close);
                    break block21;
                }
                try (BackupOp backupOp = new BackupOp(job, BBackupService.makeCanceler(job), (BDaemonPlatform)daemonPlatform);){
                    this.zip(out, close, backupOp);
                }
            }
            finally {
                try {
                    if (close) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @Deprecated
    public void zip(BJob job, PlatformDaemon platformDaemon, OutputStream out, boolean close) throws Exception {
        this.zip(job, platformDaemon, out, close, null);
    }

    public void zip(JobLog log, PlatformDaemon platformDaemon, OutputStream out, boolean close, Context cx) throws Exception {
        this.zip(log, NULL_CANCELER, platformDaemon, out, close, cx);
    }

    @Deprecated
    public void zip(JobLog log, PlatformDaemon platformDaemon, OutputStream out, boolean close) throws Exception {
        this.zip(log, NULL_CANCELER, platformDaemon, out, close, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zip(JobLog log, ICanceler canceler, PlatformDaemon platformDaemon, OutputStream out, boolean close, Context cx) throws Exception {
        block21: {
            this.checkUserAndAuditForBackup(cx);
            try {
                BRemoteDaemonPlatform daemonPlatform = ((NiagaraPlatformDaemon)platformDaemon).getDaemonPlatform(null);
                if (!daemonPlatform.getIsNiagara4() && daemonPlatform instanceof BRemoteDaemonPlatform) {
                    new BAxOfflineBackup().zip(log, canceler, daemonPlatform, out, close);
                    break block21;
                }
                try (BackupOp backupOp = new BackupOp(log, canceler, (BDaemonPlatform)daemonPlatform);){
                    this.zip(out, close, backupOp);
                }
            }
            finally {
                try {
                    if (close) {
                        out.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @Deprecated
    public void zip(JobLog log, ICanceler canceler, PlatformDaemon platformDaemon, OutputStream out, boolean close) throws Exception {
        this.zip(log, canceler, platformDaemon, out, close, null);
    }

    private void zip(OutputStream out, boolean close, BackupOp op) throws Exception {
        long t1 = Clock.millis();
        log.info("Backup starting...");
        if (op.log() != null) {
            op.log().message("Backup starting...");
        }
        op.zip = new ZipOutputStream(out);
        op.platform().checkSession();
        op.checkCanceled();
        this.processManifest(op);
        this.findPlatformBackupFiles(op);
        if (op.offline()) {
            this.findRemoteStationFiles(op);
        } else {
            this.findStationBackupFiles((BIFile)BFileSystem.INSTANCE.getProtectedStationHome(), Sys.getStation().getStationName(), op.files(), op);
        }
        try {
            this.addFilesToDist(op);
            if (op.log() != null) {
                op.log().start("Adding distribution manifest");
            }
            op.zip.putNextEntry(new ZipEntry("META-INF/dist.xml"));
            op.manifest().write((OutputStream)op.zip);
            if (op.log() != null) {
                op.log().endSuccess();
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.WARNING, "Exception occurred while adding files to backup distribution: " + e, e);
            } else {
                log.warning("Exception occurred while adding files to backup distribution: " + e);
            }
            throw e;
        }
        finally {
            op.zip.finish();
            if (close) {
                op.zip.flush();
                op.zip.close();
            }
        }
        if (op.log() != null) {
            op.log().success("Backup successful");
        }
        if (op.job() != null) {
            op.job().setProgress(100);
        }
        long t2 = Clock.millis();
        log.info("Finished backup, " + op.totalFilesCreated() + " files [" + (t2 - t1) + "ms]");
    }

    private void processManifest(BackupOp op) throws Exception {
        op.manifest().setInstallableName("backupdist");
        op.manifest().setInstallableVersion(new BVersion("Tridium", "0"));
        op.manifest().setBuildDate(BAbsTime.now());
        op.manifest().setBuildHost(Sys.getHostName());
        if (!op.platform().getAllowStationRestart()) {
            op.manifest().setRebootRequired(true);
        }
        op.manifest().setNoRunningApp(true);
        op.manifest().setUpdatedRuntimeProfilesEnabled(op.enabledRuntimeProfileNames());
        op.manifest().setTargetOs(op.platform().getOsPart());
        op.manifest().setHostId(op.platform().getHostId());
        op.manifest().setLicenseMode(this.getLicenseMode(op));
        op.manifest().setUseAbsoluteElementPaths(false);
        BTimeZone osTz = op.platform().getOsTimeZone();
        if (!osTz.isNull()) {
            op.manifest().setNewOsTimeZone(osTz);
        }
        op.manifest().addDir(op.manifest().getEntryPath(new FilePath("~stations")), true);
        op.manifest().addDir(op.manifest().getEntryPath(new FilePath("~lexicon")), true);
        if (op.offline()) {
            op.manifest().setDescription("Offline backup of host \"" + op.platform().getHostName() + "\"");
        } else {
            op.manifest().setDescription("Online backup of station \"" + Sys.getStation().getStationName() + "\" on \"" + Sys.getHostName() + "\"");
        }
        try {
            AccessController.doPrivileged(() -> {
                BIFile result = op.fileSpace().findFile(SystemFilePaths.getPlatformBogPath((boolean)op.platform().getIsNiagara4(), (boolean)op.platform().getIsNiagaraHomeReadonly()));
                if (result != null) {
                    op.manifest().setPlatformBog(result, false);
                }
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
        if (op.offline()) {
            op.manifest().setDaemonTcpIpSettings(op.session());
        } else {
            op.manifest().setStationTcpIpSettings();
        }
        if (op.offline()) {
            op.manifest().setPlatformUsers(op.session());
        } else {
            BDaemonSession daemon = AccessController.doPrivileged(LocalSessionUtil::getLocalSession);
            op.manifest().setPlatformUsers(daemon);
        }
        String modelName = op.platform().getModelPart().getPartName();
        boolean isTridiumAtlas = "ATLAS".equalsIgnoreCase(modelName);
        boolean isTridiumTitan = "TITAN".equalsIgnoreCase(modelName);
        BOsPart os = op.platform().getOsPart();
        if (UNKNOWN_VERSION_STRINGS.contains(os.getVersion().toString())) {
            throw new LocalizableRuntimeException("backup", "backup.error.badOS", new Object[]{os.getPartName()});
        }
        if (isTridiumTitan) {
            os.setPartName(os.getPartName().replace(TITAN_OS_NAME_SUFFIX, TITAN_OS_NAME_GLOB_SUFFIX));
        }
        BDependency osDependency = isTridiumAtlas ? new BDependency(os.getPartName(), BVersion.makeZero(), BVersionRelation.minimum, os.getType().getTypeSpec(), "") : this.getExactDependency((BPart)os);
        op.manifest().addDependency(osDependency);
        op.manifest().addDependency(this.getExactDependency((BPart)op.platform().getArchPart()));
        BNrePart nre = op.platform().getNrePart();
        if (nre.isNull()) {
            throw new LocalizableRuntimeException("backup", "backup.error.badNRE", new Object[]{nre.getPartName()});
        }
        BDependency nreDependency = this.getExactDependency((BPart)nre);
        if (isTridiumAtlas) {
            nreDependency.setSolverFiltersString("commissioning");
        }
        op.manifest().addDependency(nreDependency);
        BVmPart vm = op.platform().getVmPart();
        if (!(vm.isNull() || vm.getUnspecified() || isTridiumAtlas)) {
            op.manifest().addDependency(this.getExactDependency((BPart)vm));
        }
        SlotCursor c = op.platform().getOtherParts().getProperties();
        while (c.next(BPart.class)) {
            BDependency dependency;
            BPart part = (BPart)c.get();
            if (isTridiumAtlas && ATLAS_SNAP_TRIDIUM_NIAGARA_NAME.equals(part.getPartName())) continue;
            if (part instanceof BGenericPart && !part.getVersion().equivalent((Object)BVersion.ZERO) && part.isInstallable()) {
                dependency = this.getExactDependency(part);
                if (isTridiumAtlas) {
                    dependency.setSolverFiltersString("commissioning");
                }
            } else {
                dependency = new BDependency(part.getPartName(), BVersion.makeZero(), part.getType().getTypeSpec());
            }
            op.manifest().addDependency(dependency);
        }
        if (op.brandId() != null) {
            op.manifest().addDependency(this.getExactDependency((BPart)op.platform().getBrandPart()));
        }
        if (op.log() != null) {
            op.log().start("Analyzing modules");
        }
        BModuleList modules = op.platform().getModuleList();
        op.checkCanceled();
        modules.init();
        op.checkCanceled();
        SlotCursor c2 = modules.getModules().getProperties();
        while (c2.next(BModuleInstallable.class)) {
            BModuleInstallable mi = (BModuleInstallable)c2.get();
            op.manifest().addDependency(this.getExactDependency((BPart)mi.getModulePart()));
        }
        if (op.log() != null) {
            op.log().endSuccess();
        }
    }

    public BIFile[] listStationBackupFiles() {
        Array acc = new Array(FileTuple.class);
        this.findStationBackupFiles((BIFile)BFileSystem.INSTANCE.getProtectedStationHome(), Sys.getStation().getStationName(), (Array<FileTuple>)acc, null);
        return (BIFile[])acc.apply(BIFile.class, fileTuple -> ((FileTuple)fileTuple).file).trim();
    }

    private void findStationBackupFiles(BIFile stationHome, String stationName, Array<FileTuple> acc, BackupOp op) {
        BOrdList dirsToSplit;
        String filesToParse;
        if (op != null && op.offline()) {
            filesToParse = this.getOfflineExcludeFiles();
            dirsToSplit = this.getOfflineExcludeDirectories();
        } else {
            filesToParse = this.getExcludeFiles();
            dirsToSplit = this.getExcludeDirectories();
        }
        PatternFilter[] excludeFiles = PatternFilter.parseList((String)filesToParse, (String)";");
        TreeSet<FilePath> excludePaths = new TreeSet<FilePath>();
        for (BOrd excludeDir : dirsToSplit) {
            excludePaths.add(this.getStationFilePath(excludeDir));
        }
        this.listBackupFiles(stationHome, stationName, excludeFiles, excludePaths, acc);
    }

    private void findRemoteStationFiles(BackupOp op) {
        BDirectory stationsDir = (BDirectory)op.fileSpace().findFile(new FilePath("~stations"));
        if (stationsDir != null) {
            for (BIFile kid : stationsDir.listFiles()) {
                BDirectory stationDir;
                BBogFile configBog;
                if (!(kid instanceof BDirectory) || (configBog = (BBogFile)(stationDir = (BDirectory)kid).getNavChild("config.bog")) == null) continue;
                BBackupService backupService = null;
                try {
                    BComponent root = (BComponent)new ValueDocDecoder((BIFile)configBog).decodeDocument();
                    backupService = this.findUnmountedBackupService(root);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (backupService == null) {
                    backupService = new BBackupService();
                }
                backupService.findStationBackupFiles((BIFile)stationDir, stationDir.getFileName(), op.files(), op);
            }
        }
    }

    private void findPlatformBackupFiles(BackupOp op) throws Exception {
        BIFile file;
        String filesToParse = op.offline() ? this.getOfflineExcludeFiles() : this.getExcludeFiles();
        filesToParse = filesToParse + ";platform.bog;.data";
        PatternFilter[] excludeFiles = PatternFilter.parseList((String)filesToParse, (String)";");
        TreeSet<FilePath> excludePaths = new TreeSet<FilePath>();
        excludePaths.add(new FilePath("~security"));
        excludePaths.add(new FilePath("~stations"));
        for (BOrd platformOrd : op.platformBackupOrds()) {
            file = this.findFile(op, this.getPlatformFilePath(platformOrd, op));
            this.listBackupFiles(file, null, excludeFiles, excludePaths, op.files());
            if (!(file instanceof BDirectory)) continue;
            if (file.getFileName().equals("licenses") || file.getFileName().equals("certificates") || file.getFileName().equals("subscription")) {
                op.manifest().addDir(op.manifest().getEntryPath(file.getFilePath()), 0, false);
                continue;
            }
            if (BOrd.make((String)"file:!platform").equals((Object)BOrd.make((OrdQuery)file.getFilePath())) || DYNAMIC_PLATFORM_BACKUP.contains(BOrd.make((OrdQuery)file.getFilePath()))) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Preventing clean of platform directory '" + platformOrd + "'");
                }
                op.manifest().addDir(op.manifest().getEntryPath(file.getFilePath()), -1, false);
                continue;
            }
            op.manifest().addDir(op.manifest().getEntryPath(file.getFilePath()), -1, true);
        }
        excludePaths.clear();
        excludePaths.add(new FilePath("~security/licenses"));
        excludePaths.add(new FilePath("~security/certificates"));
        excludePaths.add(new FilePath("~security/subscription"));
        for (BOrd securityOrd : DEFAULT_SECURITY_BACKUP) {
            file = this.findFile(op, this.getPlatformFilePath(securityOrd, op));
            if (file == null) continue;
            this.listBackupFiles(file, null, new PatternFilter[]{new PatternFilter(".km*"), new PatternFilter(".sp*")}, excludePaths, op.files());
        }
    }

    private BIFile findFile(BackupOp op, FilePath path) throws Exception {
        return AccessController.doPrivileged(() -> op.fileSpace().findFile(path));
    }

    private void listBackupFiles(BIFile file, String stationName, PatternFilter[] excludeFiles, Set<FilePath> excludePaths, Array<FileTuple> acc) {
        BIFile[] files;
        if (file == null) {
            return;
        }
        if (!file.isDirectory()) {
            String name = file.getFileName();
            for (PatternFilter excludeFile : excludeFiles) {
                if (!excludeFile.accept(name)) continue;
                return;
            }
            acc.add((Object)new FileTuple(stationName, file));
            return;
        }
        if (excludePaths.contains(file.getFilePath())) {
            return;
        }
        BIDirectory fDir = (BIDirectory)file;
        for (BIFile dirFile : files = AccessController.doPrivileged(() -> ((BIDirectory)fDir).listFiles())) {
            this.listBackupFiles(dirFile, stationName, excludeFiles, excludePaths, acc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFilesToDist(BackupOp op) throws Exception {
        PBEEncodingKey localFileEncodingKey;
        if (op.fileSpace() instanceof BFileSystem) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Backup running with local file store, creating local file encoding key for protected files");
            }
            localFileEncodingKey = op.encodingInfo.makePBEKey(AccessController.doPrivileged(() -> ((IPlatformProvider)PlatformProviderHolder.PLATFORM_PROVIDER_INSTANCE).getSystemPassword()));
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Backup running with remote file store, using remote file encoding key for protected files");
            }
            localFileEncodingKey = null;
        }
        try {
            HashSet<String> zipEntries = new HashSet<String>();
            for (FileTuple file : (FileTuple[])op.files().trim()) {
                op.checkCanceled();
                BIFile f = file.file;
                InputStream in = null;
                if (!zipEntries.add(f.getFilePath().getBody())) {
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.fine("Backup solution generated duplicate entry '" + f.getFilePath().getBody() + "', skipping...");
                    continue;
                }
                if (f.getFilePath().getBody().equals("~security/.kr")) {
                    if (localFileEncodingKey != null) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Exporting Key Ring Data");
                        }
                        in = new ByteArrayInputStream(AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing().exportKeyData((ISecretBytesSupplier)localFileEncodingKey))){

                            @Override
                            public void close() {
                                Arrays.fill(this.buf, (byte)0);
                            }
                        };
                    }
                } else if (log.isLoggable(Level.FINE)) {
                    log.fine("Backing up file '" + f.getFilePath().getBody() + "'...");
                }
                if (in == null) {
                    in = AccessController.doPrivileged(() -> ((BIFile)f).getInputStream());
                    if (localFileEncodingKey != null) {
                        if (BBackupService.matchesAnyPattern(f.getFilePath(), PASSPHRASE_ENCRYPTED_PATHS)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Backup file '" + f.getFilePath().getBody() + "' matched PASSPHRASE_ENCRYPTED_PATHS pattern");
                            }
                            in = new PBEEncryptingInputStream(in, localFileEncodingKey);
                        } else if (BBackupService.matchesAnyPattern(f.getFilePath(), TRIDIUM_LEGACY_PASSPHRASE_ENCRYPTED_PATHS)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Backup file '" + f.getFilePath().getBody() + "' matched TRIDIUM_LEGACY_PASSPHRASE_ENCRYPTED_PATHS pattern");
                            }
                            in = new PBEEncryptingInputStream(in, localFileEncodingKey);
                        } else if (BBackupService.matchesAnyPattern(f.getFilePath(), KEYRING_ENCRYPTED_STATION_PATHS)) {
                            if (log.isLoggable(Level.FINE)) {
                                log.fine("Backup file '" + f.getFilePath().getBody() + "' matched KEYRING_ENCRYPTED_STATION_PATHS pattern");
                            }
                            in = AESStreamEncryption.keyRingToPBE((InputStream)in, (ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider(), (PBEEncodingKey)localFileEncodingKey);
                        } else if (f instanceof BBogFile) {
                            if (AccessController.doPrivileged(() -> ((BBogFile)((BBogFile)f)).usesKeyRingEncryption()).booleanValue()) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("Backup file '" + f.getFilePath().getBody() + "' matched external EncryptionKeySource requirements");
                                }
                                InputStream finalIn = in;
                                in = AccessController.doPrivileged(() -> new BogTranscoderInputStream(SecurityInitializer.getInstance().getSecurityInfoProvider().getKeyRing(), finalIn, !log.isLoggable(Level.FINEST), localFileEncodingKey, EncryptionKeySource.external, f.getFilePath().getBody()));
                            }
                        }
                    }
                }
                FilePath path = f.getFilePath();
                String entryPath = op.manifest().getEntryPath(path, file.stationName, true);
                if (op.log() != null) {
                    op.log().start("Writing : " + entryPath);
                }
                if (in == null) {
                    if (f instanceof BBogFile) {
                        throw new LocalizableRuntimeException("backup", "backup.error.noInputStreamBog", new Object[]{entryPath});
                    }
                    throw new LocalizableRuntimeException("backup", "backup.error.noInputStream", new Object[]{entryPath});
                }
                ZipEntry entry = new ZipEntry(entryPath);
                entry.setTime(AccessController.doPrivileged(() -> ((BIFile)f).getLastModified()).getMillis());
                op.zip.putNextEntry(entry);
                BajaFileUtil.pipe((InputStream)in, (OutputStream)op.zip);
                op.zip.closeEntry();
                in.close();
                op.notifyFileCreated();
                if (op.log() == null) continue;
                op.log().endSuccess();
            }
        }
        finally {
            if (localFileEncodingKey != null) {
                localFileEncodingKey.close();
            }
        }
    }

    private FilePath getPlatformFilePath(BOrd ord, BackupOp op) {
        OrdQuery[] q = ord.parse();
        for (int i = q.length - 1; i >= 0; --i) {
            if (!(q[i] instanceof FilePath)) continue;
            FilePath p = (FilePath)q[i];
            if (p.isStationHomeAbsolute() || p.isProtectedStationHomeAbsolute()) {
                throw new IllegalStateException(p.getBody() + " cannot be station home absolute");
            }
            if (op == null) {
                return p;
            }
            return op.manifest().getNormalFilePath(p, true);
        }
        return null;
    }

    private FilePath getStationFilePath(BOrd ord) {
        OrdQuery[] q = ord.parse();
        for (int i = q.length - 1; i >= 0; --i) {
            if (!(q[i] instanceof FilePath)) continue;
            FilePath p = (FilePath)q[i];
            if (!p.isStationHomeAbsolute() && !p.isProtectedStationHomeAbsolute()) {
                throw new IllegalStateException(p.getBody() + " cannot be station home absolute");
            }
            return p;
        }
        return null;
    }

    private BBackupService findUnmountedBackupService(BComponent component) {
        if (component instanceof BBackupService) {
            return (BBackupService)component;
        }
        SlotCursor c = component.getProperties();
        if (c.next(BBackupService.class)) {
            return (BBackupService)c.get();
        }
        c = component.getProperties();
        while (c.next(BComponent.class)) {
            BBackupService result = this.findUnmountedBackupService((BComponent)c.get());
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void restartStation(RestoreOp op) throws Exception {
        if (op.isRestartEnabled) {
            op.consoleMessage("Requesting station restart from niagarad");
            op.stationSurrogate().restartStationAsync(true);
        } else {
            op.consoleMessage("Requesting reboot from niagarad");
            op.daemonPlatform().getDaemonSession().sendForceRebootRequest();
        }
    }

    private BDependency getExactDependency(BPart part) {
        return new BDependency(part.getPartName(), part.getVersion(), BVersionRelation.exact, part.getType().getTypeSpec());
    }

    private String getLicenseMode(BackupOp op) {
        BHostIdStatus hostIdStatus = op.session().getHostProperties().getHostIdSettings().getHostIdStatus();
        return !hostIdStatus.isPerpetual() ? "Subscription" : hostIdStatus.toString();
    }

    public static ICanceler makeCanceler(BJob job) {
        return job == null ? NULL_CANCELER : new JobCanceler(job);
    }

    private static boolean matchesAnyPattern(FilePath input, List<Pattern> patterns) {
        if (input == null) {
            return false;
        }
        for (Pattern p : patterns) {
            if (!p.matcher(input.getBody()).matches()) continue;
            return true;
        }
        return false;
    }

    private static String daemonUriToAbsoluteFilePathBody(String daemonUriPath) {
        if (daemonUriPath.startsWith("/niagara/")) {
            return TextUtil.replace((String)daemonUriPath, (String)"/niagara/", (String)"!");
        }
        if (daemonUriPath.startsWith("/niagara_user/")) {
            return TextUtil.replace((String)daemonUriPath, (String)"/niagara_user/", (String)"~");
        }
        throw new IllegalArgumentException("Invalid daemonuri path '" + daemonUriPath + "'provided");
    }

    private void populatePlatformAndPassphraseProtectedPaths(BDaemonSession daemonSession) {
        if (daemonSession == null) {
            return;
        }
        DYNAMIC_PLATFORM_BACKUP.clear();
        PASSPHRASE_ENCRYPTED_PATHS.clear();
        BHostProperties hostProperties = daemonSession.getHostProperties();
        if (hostProperties.getIsNpsdk() && hostProperties.supportsServlet("ieee8021x")) {
            try {
                XElem ieee8021XmlSettingsElem = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new GetIEEE8021XMessage())).parse();
                if (ieee8021XmlSettingsElem.getb("readonly", false)) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Skipping 802.1X platform configuration backup, platform settings are read-only");
                    }
                } else {
                    XElem ieee8021xAdaptersElem = ieee8021XmlSettingsElem.elem("adapters");
                    if (ieee8021xAdaptersElem == null) {
                        throw new NullPointerException("XML attribute 'adapters' not defined");
                    }
                    HashSet<FilePath> uniqueFilePaths = new HashSet<FilePath>();
                    XElem[] ieee8021xAdapterElems = ieee8021xAdaptersElem.elems("adapter");
                    for (XElem ieee8021xAdapterElem : ieee8021xAdapterElems) {
                        String configurationFilePathString = ieee8021xAdapterElem.get("configuration_file");
                        String statusFilePathString = ieee8021xAdapterElem.get("status_file");
                        String pkiDirectoryPathString = ieee8021xAdapterElem.get("pki_certificates_directory");
                        configurationFilePathString = BBackupService.daemonUriToAbsoluteFilePathBody(configurationFilePathString);
                        statusFilePathString = BBackupService.daemonUriToAbsoluteFilePathBody(statusFilePathString);
                        pkiDirectoryPathString = BBackupService.daemonUriToAbsoluteFilePathBody(pkiDirectoryPathString);
                        FilePath configurationFilePathParent = new FilePath(configurationFilePathString).getParent();
                        FilePath statusFilePathParent = new FilePath(statusFilePathString).getParent();
                        FilePath pkiDirectoryPath = new FilePath(pkiDirectoryPathString);
                        uniqueFilePaths.add(configurationFilePathParent);
                        uniqueFilePaths.add(statusFilePathParent);
                        if (uniqueFilePaths.contains(pkiDirectoryPath.getParent())) continue;
                        uniqueFilePaths.add(pkiDirectoryPath);
                    }
                    for (FilePath uniqueFilePath : uniqueFilePaths) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Adding 802.1X platform path '" + uniqueFilePath.getBody() + "' to platform backup ord list");
                        }
                        DYNAMIC_PLATFORM_BACKUP.add(BOrd.make((OrdQuery)uniqueFilePath));
                        String pathRegex = ".*" + uniqueFilePath.getBody() + "/.+";
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Detecting 802.1X passphrase protected path '" + uniqueFilePath.getBody() + "' with regex '" + pathRegex + "'");
                        }
                        PASSPHRASE_ENCRYPTED_PATHS.add(Pattern.compile(pathRegex));
                    }
                }
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.WARNING, "Exception occurred while obtaining IEEE 802.1X platform Ord values, ignoring IEEE 802.1X platform Ords", exception);
                }
                log.warning("Exception occurred while obtaining IEEE 802.1X platform Ord values, ignoring IEEE 802.1X platform Ords: " + exception);
            }
        }
        if (hostProperties.getIsNpsdk() && hostProperties.supportsServlet("dhcpd")) {
            try {
                XElem dhcpdXmlSettingsElem = XParser.make((InputStream)daemonSession.getInputStream((DaemonMessage)new GetDhcpdMessage())).parse();
                HashSet<FilePath> uniqueFilePaths = new HashSet<FilePath>();
                String configurationFilePathString = dhcpdXmlSettingsElem.get("conf_file_path");
                String adaptersListFilePathString = dhcpdXmlSettingsElem.get("adapters_list_file_path");
                String leaseFilePathString = dhcpdXmlSettingsElem.get("lease_file_path");
                configurationFilePathString = BBackupService.daemonUriToAbsoluteFilePathBody(configurationFilePathString);
                adaptersListFilePathString = BBackupService.daemonUriToAbsoluteFilePathBody(adaptersListFilePathString);
                leaseFilePathString = BBackupService.daemonUriToAbsoluteFilePathBody(leaseFilePathString);
                FilePath configurationFilePathParent = new FilePath(configurationFilePathString).getParent();
                FilePath adaptersListFilePathParent = new FilePath(adaptersListFilePathString).getParent();
                FilePath leaseFilePathParent = new FilePath(leaseFilePathString).getParent();
                uniqueFilePaths.add(configurationFilePathParent);
                uniqueFilePaths.add(adaptersListFilePathParent);
                uniqueFilePaths.add(leaseFilePathParent);
                for (FilePath uniqueFilePath : uniqueFilePaths) {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Adding DHCP server platform path '" + uniqueFilePath.getBody() + "' to platform backup ord list");
                    }
                    DYNAMIC_PLATFORM_BACKUP.add(BOrd.make((OrdQuery)uniqueFilePath));
                }
            }
            catch (Exception exception) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.WARNING, "Exception occurred while obtaining DHCP server platform Ord values, ignoring DHCP server platform Ords", exception);
                }
                log.warning("Exception occurred while obtaining DHCP server platform Ord values, ignoring DHCP server platform Ords: " + exception);
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        BIFile[] files = this.listStationBackupFiles();
        out.w((Object)("<hr><b>List Station Backup Files [" + files.length + "]</b>"));
        out.w((Object)"<pre>");
        for (BIFile file : files) {
            out.w((Object)"  ").safe((Object)file.getOrdInSpace()).nl();
        }
        out.w((Object)"</pre>");
    }

    private static BOrdList defaultPlatformBackupOrds(boolean licenseReadonly, boolean niagaraHomeReadonly) {
        if (licenseReadonly && niagaraHomeReadonly) {
            return ReadonlyLicenseAndReadonlyHomePlatformBackup.ords;
        }
        if (licenseReadonly) {
            return ReadonlyLicenseAndWritableHomePlatformBackup.ords;
        }
        if (niagaraHomeReadonly) {
            return WritableLicenseAndReadonlyHomePlatformBackup.ords;
        }
        return WritableLicenseAndWritableHomePlatformBackup.ords;
    }

    static /* synthetic */ BOrd[] access$900() {
        return COMMON_PLATFORM_BACKUP;
    }

    static /* synthetic */ BOrd[] access$1000() {
        return WRITABLE_HOME_PLATFORM_BACKUP_ADDER;
    }

    static /* synthetic */ BOrd[] access$1100() {
        return WRITABLE_LICENSE_WITH_WRITABLE_HOME_PLATFORM_BACKUP_ADDER;
    }

    static /* synthetic */ BOrd[] access$1200() {
        return WRITABLE_LICENSE_WITH_READONLY_HOME_PLATFORM_BACKUP_ADDER;
    }

    static /* synthetic */ BOrd[] access$1300() {
        return READONLY_LICENSE_WITH_WRITABLE_HOME_PLATFORM_BACKUP_ADDER;
    }

    static /* synthetic */ BOrd[] access$1400() {
        return READONLY_LICENSE_WITH_READONLY_HOME_PLATFORM_BACKUP_ADDER;
    }

    private static class LocalEncodingInfo
    extends PBEEncodingInfo {
        private LocalEncodingInfo(String encodedValidator, String encodingSaltHex, int encodingIterationCount) throws IOException {
            super(encodedValidator, encodingSaltHex, encodingIterationCount);
        }

        /*
         * Exception decompiling
         */
        private static LocalEncodingInfo make() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public static class JobCanceler
    implements ICanceler {
        private final BJob job;

        public JobCanceler(BJob job) {
            this.job = job;
        }

        @Override
        public boolean isCanceled() {
            return !this.job.isAlive();
        }
    }

    public static interface ICanceler {
        public boolean isCanceled();
    }

    private class RestoreThread
    extends Thread {
        private final RestoreOp op;

        public RestoreThread(RestoreOp op) {
            this.op = op;
        }

        @Override
        public void run() {
            try {
                System.out.println();
                System.out.println();
                NiagaraBasicPermission restorePermission = new NiagaraBasicPermission("RESTORE_BACKUP");
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)restorePermission);
                }
                AccessController.doPrivileged(() -> {
                    BBackupService.this.restoreFiles(this.op);
                    this.op.zipFile.close();
                    if (this.op.deleteFile) {
                        this.op.consoleMessage("Deleting backup file");
                        this.op.backupFile.delete();
                        this.op.backupFile = null;
                    }
                    BBackupService.this.restartStation(this.op);
                    return null;
                });
            }
            catch (Exception e) {
                this.op.consoleError("Restore error", e);
            }
            finally {
                if (this.op.deleteFile && this.op.backupFile != null) {
                    try {
                        this.op.backupFile.delete();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private class RestoreOp
    implements Runnable {
        private DistributionManifest manifest = null;
        public ZipFile zipFile;
        public boolean ignoreDependencies;
        public boolean deleteFile;
        public BIFile backupFile;
        private final long shutdownDelay;
        private String stationName;
        public boolean isRestartEnabled;
        private String newStationName;
        private Level logLevel = Level.INFO;

        public RestoreOp(BIFile backupFile, boolean ignoreDependencies, boolean deleteFile, long shutdownDelay) throws Exception {
            this.backupFile = backupFile;
            this.ignoreDependencies = ignoreDependencies;
            this.deleteFile = deleteFile;
            this.shutdownDelay = shutdownDelay;
            if (Sys.getStation() != null) {
                this.stationName = Sys.getStation().getStationName();
            }
            if (!(backupFile.getStore() instanceof BLocalFileStore)) {
                throw new LocalizableRuntimeException("backup", "restore.error.backupNotLocal");
            }
            this.zipFile = new ZipFile(((BLocalFileStore)backupFile.getStore()).getLocalFile());
            this.manifest();
            this.daemonPlatform();
            BBackupService.this.populatePlatformAndPassphraseProtectedPaths(this.daemonPlatform().getDaemonSession());
            if (this.stationSurrogate() == null) {
                throw new LocalizableRuntimeException("backup", "restore.error.noSurrogate");
            }
            this.isRestartEnabled = this.stationSurrogate().isRestartEnabled();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.shutdownDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            BBackupService.this.doRestore(this);
        }

        public DistributionManifest manifest() throws Exception {
            if (this.manifest == null) {
                ZipEntry manifestEntry = this.zipFile.getEntry("META-INF/dist.xml");
                if (manifestEntry == null) {
                    manifestEntry = this.zipFile.getEntry("meta-inf/dist.xml");
                }
                if (manifestEntry == null) {
                    throw new LocalizableRuntimeException("backup", "restore.error.noManifest");
                }
                this.manifest = DistributionManifest.make((InputStream)this.zipFile.getInputStream(manifestEntry));
                if (!"backupdist".equals(this.manifest.getInstallableName())) {
                    throw new LocalizableRuntimeException("backup", "restore.error.invalidName");
                }
            }
            return this.manifest;
        }

        public BDaemonPlatform daemonPlatform() throws Exception {
            BLocalDaemonPlatform result;
            try {
                result = AccessController.doPrivileged(BLocalDaemonPlatform::getInstance);
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
            if (result == null) {
                throw new LocalizableRuntimeException("backup", "restore.error.noDaemonSession");
            }
            result.checkSession();
            return result;
        }

        public BStationSurrogate stationSurrogate() throws Exception {
            if (this.newStationName == null) {
                return BStationSurrogate.make((BDaemonSession)this.daemonPlatform().getDaemonSession(), (String)this.stationName);
            }
            return BStationSurrogate.make((BDaemonSession)this.daemonPlatform().getDaemonSession(), (String)this.newStationName);
        }

        public boolean isLoggable(Level requestedLevel) {
            return this.logLevel != null && requestedLevel.intValue() >= this.logLevel.intValue() && this.logLevel != Level.OFF;
        }

        public void consoleError(String message, Exception exception) {
            this.consoleLog(Level.SEVERE, message, exception);
        }

        public void consoleWarning(String message) {
            this.consoleLog(Level.WARNING, message, null);
        }

        public void consoleMessage(String message) {
            this.consoleLog(Level.INFO, message, null);
        }

        public void consoleTrace(String message) {
            this.consoleLog(Level.FINE, message, null);
        }

        public void consoleLog(Level severity, String message, Exception exception) {
            if (!this.isLoggable(severity)) {
                return;
            }
            if (severity == Level.SEVERE) {
                System.out.print("SEVERE [");
            } else if (severity == Level.WARNING) {
                System.out.print("WARNING [");
            } else if (severity == Level.INFO) {
                System.out.print("INFO [");
            } else if (severity == Level.CONFIG) {
                System.out.print("CONFIG [");
            } else if (severity == Level.FINE) {
                System.out.print("FINE [");
            } else if (severity == Level.FINER) {
                System.out.print("FINER [");
            } else if (severity == Level.FINEST) {
                System.out.print("FINEST [");
            }
            System.out.print(BBackupService.this.logDateFormat.format(new Date()));
            System.out.print("][backup] ");
            System.out.println(message);
            if (exception != null) {
                exception.printStackTrace();
            }
        }
    }

    private static class ReadonlyLicenseAndReadonlyHomePlatformBackup {
        public static final BOrdList ords = BOrdList.make((BOrd[])((BOrd[])Stream.of(Arrays.stream(BBackupService.access$900()), Arrays.stream(BBackupService.access$1400())).flatMap(s -> s).toArray(BOrd[]::new)));

        private ReadonlyLicenseAndReadonlyHomePlatformBackup() {
        }
    }

    private static class ReadonlyLicenseAndWritableHomePlatformBackup {
        public static final BOrdList ords = BOrdList.make((BOrd[])((BOrd[])Stream.of(Arrays.stream(BBackupService.access$900()), Arrays.stream(BBackupService.access$1000()), Arrays.stream(BBackupService.access$1300())).flatMap(s -> s).toArray(BOrd[]::new)));

        private ReadonlyLicenseAndWritableHomePlatformBackup() {
        }
    }

    private static class WritableLicenseAndReadonlyHomePlatformBackup {
        public static final BOrdList ords = BOrdList.make((BOrd[])((BOrd[])Stream.of(Arrays.stream(BBackupService.access$900()), Arrays.stream(BBackupService.access$1200())).flatMap(s -> s).toArray(BOrd[]::new)));

        private WritableLicenseAndReadonlyHomePlatformBackup() {
        }
    }

    private static class WritableLicenseAndWritableHomePlatformBackup {
        public static final BOrdList ords = BOrdList.make((BOrd[])((BOrd[])Stream.of(Arrays.stream(BBackupService.access$900()), Arrays.stream(BBackupService.access$1000()), Arrays.stream(BBackupService.access$1100())).flatMap(s -> s).toArray(BOrd[]::new)));

        private WritableLicenseAndWritableHomePlatformBackup() {
        }
    }

    private class BackupOp
    implements AutoCloseable {
        private final DistributionManifest manifest;
        private final PBEEncodingInfo encodingInfo;
        private final BDaemonPlatform platform;
        private final ICanceler canceler;
        private final Array<FileTuple> files = new Array(FileTuple.class);
        private BJob job = null;
        private JobLog log = null;
        private BFileSpace fileSpace = null;
        private int totalFilesCreated = 0;
        public ZipOutputStream zip = null;

        public BackupOp(BJob job, BDaemonPlatform platform) {
            this(job, BBackupService.makeCanceler(job), platform);
        }

        public BackupOp(BJob job, ICanceler canceler, BDaemonPlatform platform) {
            this(canceler, platform);
            this.job = job;
        }

        public BackupOp(JobLog log, ICanceler canceler, BDaemonPlatform platform) {
            this(canceler, platform);
            this.log = log;
        }

        private BackupOp(ICanceler canceler, BDaemonPlatform platform) {
            this.canceler = canceler == null ? NULL_CANCELER : canceler;
            this.platform = platform;
            if (platform == null) {
                throw new IllegalStateException("platform is unavailable");
            }
            this.encodingInfo = platform instanceof BRemoteDaemonPlatform ? DaemonClientEncodingInfo.make((BDaemonSession)platform.getDaemonSession()) : LocalEncodingInfo.make();
            this.manifest = DistributionManifest.make();
            this.manifest.setPBEEncodingInfo(this.encodingInfo);
        }

        public String brandId() {
            BBrandPart part = this.platform.getBrandPart();
            return part.isNull() ? null : part.getPartName();
        }

        public String enabledRuntimeProfileNames() {
            return this.platform().getEnabledRuntimeProfileNames();
        }

        public BDaemonSession session() {
            return this.platform().getDaemonSession();
        }

        public BFileSpace fileSpace() {
            if (this.fileSpace == null) {
                this.fileSpace = this.offline() ? new BCachedDaemonFileSpace(this.session(), true, false, false, null, null, (DaemonClientEncodingInfo)this.encodingInfo, new AutoCloseable[0]) : BFileSystem.INSTANCE;
            }
            return this.fileSpace;
        }

        public BJob job() {
            return this.job;
        }

        public JobLog log() {
            if (this.log == null && this.job != null) {
                this.log = this.job.log();
            }
            return this.log;
        }

        public BDaemonPlatform platform() {
            return this.platform;
        }

        public void checkCanceled() {
            if (this.canceler.isCanceled()) {
                throw new JobCancelException();
            }
            if (this.job != null) {
                this.job.heartbeat();
            }
        }

        public BOrdList platformBackupOrds() {
            Property p = BBackupService.this.getProperty("platformBackupFiles");
            if (p != null) {
                return (BOrdList)BBackupService.this.get(p);
            }
            BHostProperties hostProperties = this.session().getHostProperties();
            boolean licenseReadonly = hostProperties.getIsLicenseReadonly();
            boolean niagaraHomeReadonly = hostProperties.getIsNiagaraHomeReadonly();
            BOrdList platformBackupOrds = BBackupService.defaultPlatformBackupOrds(licenseReadonly, niagaraHomeReadonly);
            BBackupService.this.populatePlatformAndPassphraseProtectedPaths(this.session());
            for (BOrd dynamicOrd : DYNAMIC_PLATFORM_BACKUP) {
                platformBackupOrds = BOrdList.add((BOrdList)platformBackupOrds, (BOrd)dynamicOrd);
            }
            return platformBackupOrds;
        }

        public int totalFilesCreated() {
            return this.totalFilesCreated;
        }

        public void notifyFileCreated() {
            ++this.totalFilesCreated;
            if (this.job != null) {
                this.job.setProgress(10 + 90 * this.totalFilesCreated / this.files.size());
            }
        }

        public DistributionManifest manifest() {
            return this.manifest;
        }

        public Array<FileTuple> files() {
            return this.files;
        }

        public boolean offline() {
            return this.platform() instanceof BRemoteDaemonPlatform;
        }

        @Override
        public void close() {
            if (this.encodingInfo instanceof DaemonClientEncodingInfo) {
                ((DaemonClientEncodingInfo)this.encodingInfo).close();
            }
        }
    }

    private static class FileTuple {
        public BIFile file;
        public String stationName;

        public FileTuple(String stationName, BIFile file) {
            this.file = file;
            this.stationName = stationName;
        }
    }

    private static final class PlatformProviderHolder {
        private static final IPlatformProvider PLATFORM_PROVIDER_INSTANCE = AccessController.doPrivileged(PlatformUtil::getPlatformProvider);

        private PlatformProviderHolder() {
        }
    }
}

