/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.silk;

import com.tridium.silk.impl.Soap11Envelope;
import com.tridium.silk.impl.Soap11Fault;
import com.tridium.silk.impl.Soap12Envelope;
import com.tridium.silk.impl.Soap12Fault;
import java.io.InputStream;
import javax.baja.naming.OrdTarget;
import javax.baja.silk.SoapEnvelope;
import javax.baja.web.WebOp;
import javax.baja.xml.XElem;
import javax.baja.xml.XNs;
import javax.baja.xml.XParser;

public class SoapContext
extends OrdTarget {
    WebOp cx;
    String lang;
    SoapEnvelope response;
    SoapEnvelope request;

    public SoapContext(WebOp cx) throws Exception {
        super((OrdTarget)cx);
        this.cx = cx;
        this.request = SoapContext.parse((InputStream)cx.getRequest().getInputStream());
    }

    public String getLanguage() {
        if (this.lang == null) {
            return super.getLanguage();
        }
        return this.lang;
    }

    public SoapEnvelope getRequest() {
        return this.request;
    }

    public SoapEnvelope getResponse() {
        if (this.response == null) {
            this.response = this.request.newEnvelope();
        }
        return this.response;
    }

    public WebOp getWebOp() {
        return this.cx;
    }

    public void setLanguage(String lang) {
        this.lang = lang;
    }

    public void setResponse(SoapEnvelope response) {
        this.response = response;
    }

    protected static boolean isSoap11(XNs ns) {
        return ns.uri().equalsIgnoreCase(SoapEnvelope.SOAP_11.toString());
    }

    protected static boolean isSoap12(XNs ns) {
        return ns.uri().equalsIgnoreCase(SoapEnvelope.SOAP_12.toString());
    }

    public static SoapEnvelope parse(InputStream in) throws Exception {
        SoapEnvelope ret = null;
        XElem e = XParser.make((InputStream)in).parse(false);
        XNs ns = e.ns();
        if (SoapContext.isSoap11(ns)) {
            ret = new Soap11Envelope(e);
        } else if (SoapContext.isSoap12(ns)) {
            ret = new Soap12Envelope(e);
        }
        if (ret == null) {
            throw new IllegalArgumentException("Unrecognized namespace:" + ns);
        }
        if (ret.isFault()) {
            if (SoapContext.isSoap11(ns)) {
                ret = new Soap11Fault(ret.getRoot());
            } else if (SoapContext.isSoap12(ns)) {
                ret = new Soap12Fault(ret.getRoot());
            }
        }
        return ret;
    }
}

