/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.silk.impl;

import com.tridium.silk.impl.Soap11Fault;
import javax.baja.silk.SoapEnvelope;
import javax.baja.silk.SoapFault;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

public class Soap11Envelope
extends SoapEnvelope {
    public Soap11Envelope() {
        this.setRoot(new XElem("env", SOAP_11.toString(), this.getEnvelopeTag()));
    }

    public Soap11Envelope(XElem root) {
        this.setRoot(root);
    }

    @Override
    public SoapFault asFault() {
        if (!this.isFault()) {
            throw new IllegalStateException("Not a fault envelope");
        }
        return new Soap11Fault(this.envelope);
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public SoapEnvelope newEnvelope() {
        XElem root = new XElem(this.envelope.ns(), this.getEnvelopeTag());
        root.defineNs(this.envelope.ns());
        return new Soap11Envelope(root);
    }

    @Override
    public SoapFault newFault(String code, String subcode, String reason, XContent detail) {
        return new Soap11Fault(code, subcode, reason, detail);
    }

    @Override
    public SoapFault newReceiverFault(String subcode, String reason, Throwable detail) {
        return new Soap11Fault(Soap11Fault.CODE_SERVER, subcode, reason, (XContent)Soap11Envelope.toXml(detail));
    }

    @Override
    public SoapFault newSenderFault(String subcode, String reason, Throwable detail) {
        return new Soap11Fault(Soap11Fault.CODE_CLIENT, subcode, reason, (XContent)Soap11Envelope.toXml(detail));
    }
}

