/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.transport;

import com.tridium.platcrypto.signing.BApprovalState;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.transport.BISigningTransport;
import com.tridium.signing.transport.BSessionToken;
import com.tridium.util.CompUtil;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BX509Certificate;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="temporaryCodeExpirationPeriod", type="BRelTime", defaultValue="BRelTime.DAY", facets={@Facet(name="BFacets.MIN", value="BRelTime.SECOND")}), @NiagaraProperty(name="tokenExpirationPeriod", type="BRelTime", defaultValue="BRelTime.HOUR", facets={@Facet(name="BFacets.MIN", value="BRelTime.SECOND")}), @NiagaraProperty(name="expiredTokenLingerPeriod", type="BRelTime", defaultValue="BRelTime.HOUR", facets={@Facet(name="BFacets.MIN", value="BRelTime.SECOND")})})
@NiagaraAction(name="checkForExpiredTokens", flags=16)
public final class BSessionTokenStore
extends BComponent {
    @Generated
    public static final Property temporaryCodeExpirationPeriod = BSessionTokenStore.newProperty((int)0, (BValue)BRelTime.DAY, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property tokenExpirationPeriod = BSessionTokenStore.newProperty((int)0, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property expiredTokenLingerPeriod = BSessionTokenStore.newProperty((int)0, (BValue)BRelTime.HOUR, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Action checkForExpiredTokens = BSessionTokenStore.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSessionTokenStore.class);
    private static final BIcon icon = BIcon.std((String)"pointFolder.png");
    private static final BRelTime CHECK_EXPIRATION_INTERVAL = BRelTime.makeSeconds((int)30);
    private Clock.Ticket checkExpirationTicket;
    private CoalesceQueue queue;
    private Worker worker;

    @Generated
    public BRelTime getTemporaryCodeExpirationPeriod() {
        return (BRelTime)this.get(temporaryCodeExpirationPeriod);
    }

    @Generated
    public void setTemporaryCodeExpirationPeriod(BRelTime v) {
        this.set(temporaryCodeExpirationPeriod, (BValue)v, null);
    }

    @Generated
    public BRelTime getTokenExpirationPeriod() {
        return (BRelTime)this.get(tokenExpirationPeriod);
    }

    @Generated
    public void setTokenExpirationPeriod(BRelTime v) {
        this.set(tokenExpirationPeriod, (BValue)v, null);
    }

    @Generated
    public BRelTime getExpiredTokenLingerPeriod() {
        return (BRelTime)this.get(expiredTokenLingerPeriod);
    }

    @Generated
    public void setExpiredTokenLingerPeriod(BRelTime v) {
        this.set(expiredTokenLingerPeriod, (BValue)v, null);
    }

    @Generated
    public void checkForExpiredTokens() {
        this.invoke(checkForExpiredTokens, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPassword store(String requesterId, Map<String, String> metadata, BPassword existingTempCode) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        String slotName = SlotPath.escape((String)requesterId);
        BValue existing = this.get(slotName);
        if (existing instanceof BSessionToken) {
            BSessionToken sessionToken = (BSessionToken)existing;
            BSessionTokenStore.checkForExpiredToken(sessionToken);
            if (existingTempCode != null && !existingTempCode.isDefault() && !sessionToken.getState().equals((Object)BApprovalState.expired) && !sessionToken.getState().equals((Object)BApprovalState.rejected) && sessionToken.getTemporaryCode().validate(existingTempCode)) {
                sessionToken.setMetadata(SigningServiceUtils.convertMetadataToString(metadata));
                return sessionToken.getTemporaryCode();
            }
            if (sessionToken.getTemporaryCode().isDefault()) {
                BSessionToken.resetSessionToken(sessionToken, this.getTemporaryCodeExpirationPeriod(), metadata);
                return sessionToken.getTemporaryCode();
            }
            throw new LocalizableRuntimeException("signingService", "session.token.illegalDuplicateRequester", new Object[]{requesterId});
        }
        BSessionToken sessionToken = BSessionToken.makeUnapprovedSessionToken(this.getTemporaryCodeExpirationPeriod(), metadata);
        this.add(slotName, (BValue)sessionToken);
        return sessionToken.getTemporaryCode();
    }

    public BApprovalState getCurrentTokenState(String requesterId, BPassword temporaryCode) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        String slotName = SlotPath.escape((String)requesterId);
        BValue val = this.get(slotName);
        if (val instanceof BSessionToken) {
            BSessionToken sessionToken = (BSessionToken)val;
            BSessionTokenStore.checkForExpiredToken(sessionToken);
            if (sessionToken.getTemporaryCode().validate(temporaryCode)) {
                return sessionToken.getState();
            }
        }
        throw new SigningServiceException("signingService", "session.token.failureForRequester", requesterId);
    }

    public BSessionToken getSessionToken(String requesterId) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        String slotName = SlotPath.escape((String)requesterId);
        BValue val = this.get(slotName);
        if (val instanceof BSessionToken) {
            return (BSessionToken)val;
        }
        throw new SigningServiceException("signingService", "session.token.failureForRequester", requesterId);
    }

    public BPassword validateCode(String requesterId, BPassword temporaryCode) throws SigningServiceException {
        BSessionToken sessionToken;
        SigningServiceUtils.checkRequestPermitted();
        String slotName = SlotPath.escape((String)requesterId);
        BValue val = this.get(slotName);
        if (val instanceof BSessionToken && (sessionToken = (BSessionToken)val).getTemporaryCode().validate(temporaryCode)) {
            BSessionTokenStore.checkForExpiredToken(sessionToken);
            if (!sessionToken.getState().equals((Object)BApprovalState.approved)) {
                throw new SigningServiceException("signingService", "session.token.invalidStateForRequester", sessionToken.getState().getDisplayTag(null), requesterId);
            }
            return sessionToken.getToken();
        }
        throw new SigningServiceException("signingService", "session.token.failureForRequester", requesterId);
    }

    public boolean validateToken(String requesterId, BPassword token) throws SigningServiceException {
        BSessionToken sessionToken;
        SigningServiceUtils.checkRequestPermitted();
        String slotName = SlotPath.escape((String)requesterId);
        BValue val = this.get(slotName);
        if (val instanceof BSessionToken && (sessionToken = (BSessionToken)val).getToken().validate(token)) {
            BSessionTokenStore.checkForExpiredToken(sessionToken);
            if (!sessionToken.getState().equals((Object)BApprovalState.approved)) {
                throw new SigningServiceException("signingService", "session.token.invalidStateForRequester", sessionToken.getState().getDisplayTag(null), requesterId);
            }
            return true;
        }
        throw new SigningServiceException("signingService", "session.token.failureForRequester", requesterId);
    }

    boolean validateToken(String requesterId, BPassword token, BX509Certificate publicCert) throws SigningServiceException {
        BSessionToken sessionToken;
        SigningServiceUtils.checkRequestPermitted();
        String slotName = SlotPath.escape((String)requesterId);
        BValue val = this.get(slotName);
        if (val instanceof BSessionToken && (sessionToken = (BSessionToken)val).getToken().validate(token)) {
            BSessionTokenStore.checkForExpiredToken(sessionToken);
            if (!sessionToken.getState().equals((Object)BApprovalState.approved)) {
                throw new SigningServiceException("signingService", "session.token.invalidStateForRequester", sessionToken.getState().getDisplayTag(null), requesterId);
            }
            if (publicCert != null) {
                sessionToken.setPublicCert(publicCert);
            }
            return true;
        }
        throw new SigningServiceException("signingService", "session.token.failureForRequester", requesterId);
    }

    public void deleteToken(String requesterId) throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        CompUtil.removeIfPresent((BComponent)this, (String)SlotPath.escape((String)requesterId));
    }

    public void doCheckForExpiredTokens() {
        for (BSessionToken sessionToken : (BSessionToken[])this.getChildren(BSessionToken.class)) {
            if (sessionToken.getState().equals((Object)BApprovalState.expired)) {
                BAbsTime expirationTimestamp;
                BAbsTime bAbsTime = expirationTimestamp = !sessionToken.getProfile().isEmpty() && !sessionToken.getTokenExpiration().equals((Object)BAbsTime.DEFAULT) ? sessionToken.getTokenExpiration() : sessionToken.getTemporaryCodeExpiration();
                if (BAbsTime.now().getMillis() >= expirationTimestamp.add(this.getExpiredTokenLingerPeriod()).getMillis()) {
                    this.remove(sessionToken.getPropertyInParent());
                }
            }
            BSessionTokenStore.checkForExpiredToken(sessionToken);
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(checkForExpiredTokens)) {
            this.postAsyncWork((ICoalesceable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void started() throws Exception {
        this.stopped();
        this.queue = new CoalesceQueue();
        this.worker = new Worker((Worker.ITodo)this.queue);
        this.worker.start("SessionTokenStore: " + this.toPathString());
        this.checkExpirationTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)CHECK_EXPIRATION_INTERVAL, (Action)checkForExpiredTokens, null);
        this.checkForExpiredTokens();
    }

    public void stopped() throws Exception {
        if (this.checkExpirationTicket != null) {
            this.checkExpirationTicket.cancel();
        }
        if (this.queue != null) {
            this.queue.clear();
            this.queue = null;
        }
        if (this.worker != null) {
            this.worker.stop();
            this.worker = null;
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BISigningTransport;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BSessionToken;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BSessionToken) {
            if (context != null && context.getUser() != null) {
                throw new LocalizableRuntimeException("signingService", "signing.service.illegalManualAdd", new Object[]{BSessionToken.TYPE.getDisplayName(context)});
            }
            if (this.isRunning()) {
                SigningServiceUtils.checkSecurity();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    private static void checkForExpiredToken(BSessionToken sessionToken) {
        boolean sessionTokenGenerated = !sessionToken.getProfile().isEmpty() && !sessionToken.getTokenExpiration().equals((Object)BAbsTime.DEFAULT);
        BAbsTime now = BAbsTime.now();
        if (!sessionTokenGenerated && now.getMillis() >= sessionToken.getTemporaryCodeExpiration().getMillis() || sessionTokenGenerated && now.getMillis() >= sessionToken.getTokenExpiration().getMillis()) {
            sessionToken.setState(BApprovalState.expired);
        }
    }

    private void postAsyncWork(ICoalesceable work) {
        if (this.queue == null) {
            throw new IllegalStateException("Queue not available to process work: " + work);
        }
        this.queue.enqueue((Object)work);
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"Session Token Store", 2);
            out.prop((Object)"checkExpirationTicket", (Object)this.checkExpirationTicket);
            out.endProps();
            if (this.worker != null) {
                this.worker.spy(out);
            }
        }
        super.spy(out);
    }
}

