/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.profile;

import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.BSigningCertificateState;
import com.tridium.signing.BSigningRequestState;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BAbstractSigningProfile;
import com.tridium.signing.profile.BISigningServiceStore;
import com.tridium.signing.profile.ExpiringRecordsReport;
import com.tridium.util.CompUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.alarm.BSourceState;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="unfulfilledRequestExpirationPeriod", type="BRelTime", defaultValue="BRelTime.DAY", facets={@Facet(name="BFacets.MIN", value="BRelTime.SECOND")}), @NiagaraProperty(name="expiredCertificateGracePeriod", type="BRelTime", defaultValue="BRelTime.DAY", facets={@Facet(name="BFacets.MIN", value="BRelTime.SECOND")}), @NiagaraProperty(name="certificateAlertsEnabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="proximityToCertificateExpirationForAlerts", type="BRelTime", defaultValue="BRelTime.makeDays(25)", facets={@Facet(name="BFacets.MIN", value="BRelTime.MINUTE")}), @NiagaraProperty(name="alertGenerationTime", type="BTimeTrigger", defaultValue="new BTimeTrigger(BDailyTriggerMode.make(BTime.make(9,0,0)))"), @NiagaraProperty(name="alarmSourceInfo", type="BAlarmSourceInfo", defaultValue="initAlarmSourceInfo()")})
@NiagaraActions(value={@NiagaraAction(name="updateRecordStates", flags=16), @NiagaraAction(name="generateCertificateExpirationAlerts", flags=16), @NiagaraAction(name="ackAlarm", parameterType="BAlarmRecord", defaultValue="new BAlarmRecord()", returnType="BBoolean", flags=4)})
public final class BSigningRecordStore
extends BComponent
implements BISigningServiceStore,
BIAlarmSource {
    @Generated
    public static final Property unfulfilledRequestExpirationPeriod = BSigningRecordStore.newProperty((int)0, (BValue)BRelTime.DAY, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property expiredCertificateGracePeriod = BSigningRecordStore.newProperty((int)0, (BValue)BRelTime.DAY, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.SECOND));
    @Generated
    public static final Property certificateAlertsEnabled = BSigningRecordStore.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property proximityToCertificateExpirationForAlerts = BSigningRecordStore.newProperty((int)0, (BValue)BRelTime.makeDays((int)25), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.MINUTE));
    @Generated
    public static final Property alertGenerationTime = BSigningRecordStore.newProperty((int)0, (BValue)new BTimeTrigger((BTriggerMode)BDailyTriggerMode.make((BTime)BTime.make((int)9, (int)0, (int)0))), null);
    @Generated
    public static final Property alarmSourceInfo = BSigningRecordStore.newProperty((int)0, (BValue)BSigningRecordStore.initAlarmSourceInfo(), null);
    @Generated
    public static final Action updateRecordStates = BSigningRecordStore.newAction((int)16, null);
    @Generated
    public static final Action generateCertificateExpirationAlerts = BSigningRecordStore.newAction((int)16, null);
    @Generated
    public static final Action ackAlarm = BSigningRecordStore.newAction((int)4, (BValue)new BAlarmRecord(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSigningRecordStore.class);
    private static final BIcon ICON = BIcon.make((BIcon)BIcon.std((String)"keys.png"), (BIcon)BIcon.std((String)"badges/db.png"));
    private static final BRelTime UPDATE_RECORDS_INTERVAL = BRelTime.makeSeconds((int)30);
    private static final String ALERT_GENERATION_TRIGGER_LINK_NAME = "alertGenerationTriggerLink";
    private static final Lexicon LEX = Lexicon.make(BSigningRecordStore.class);
    private static final int MAX_ALARM_DATA_BYTE_SIZE = 60000;
    private Clock.Ticket updateRecordStatesTicket;
    private CoalesceQueue queue;
    private Worker worker;
    private AlarmSupport alarmSupport;
    private Queue<BCertificateSigningRecord> removedCertsNeedingAlert;

    @Generated
    public BRelTime getUnfulfilledRequestExpirationPeriod() {
        return (BRelTime)this.get(unfulfilledRequestExpirationPeriod);
    }

    @Generated
    public void setUnfulfilledRequestExpirationPeriod(BRelTime v) {
        this.set(unfulfilledRequestExpirationPeriod, (BValue)v, null);
    }

    @Generated
    public BRelTime getExpiredCertificateGracePeriod() {
        return (BRelTime)this.get(expiredCertificateGracePeriod);
    }

    @Generated
    public void setExpiredCertificateGracePeriod(BRelTime v) {
        this.set(expiredCertificateGracePeriod, (BValue)v, null);
    }

    @Generated
    public boolean getCertificateAlertsEnabled() {
        return this.getBoolean(certificateAlertsEnabled);
    }

    @Generated
    public void setCertificateAlertsEnabled(boolean v) {
        this.setBoolean(certificateAlertsEnabled, v, null);
    }

    @Generated
    public BRelTime getProximityToCertificateExpirationForAlerts() {
        return (BRelTime)this.get(proximityToCertificateExpirationForAlerts);
    }

    @Generated
    public void setProximityToCertificateExpirationForAlerts(BRelTime v) {
        this.set(proximityToCertificateExpirationForAlerts, (BValue)v, null);
    }

    @Generated
    public BTimeTrigger getAlertGenerationTime() {
        return (BTimeTrigger)this.get(alertGenerationTime);
    }

    @Generated
    public void setAlertGenerationTime(BTimeTrigger v) {
        this.set(alertGenerationTime, (BValue)v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmSourceInfo() {
        return (BAlarmSourceInfo)this.get(alarmSourceInfo);
    }

    @Generated
    public void setAlarmSourceInfo(BAlarmSourceInfo v) {
        this.set(alarmSourceInfo, (BValue)v, null);
    }

    @Generated
    public void updateRecordStates() {
        this.invoke(updateRecordStates, null, null);
    }

    @Generated
    public void generateCertificateExpirationAlerts() {
        this.invoke(generateCertificateExpirationAlerts, null, null);
    }

    @Generated
    public BBoolean ackAlarm(BAlarmRecord parameter) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void store(String requesterId, BCertificateSigningRecord certRecord) throws SigningServiceException {
        String slotName;
        BValue slotVal;
        SigningServiceUtils.checkRequestPermitted();
        if (!certRecord.getRequesterId().equals(requesterId)) {
            certRecord.setString(BCertificateSigningRecord.requesterId, requesterId, BCertificateSigningRecord.SKIP_UPDATE_CX);
        }
        if ((slotVal = this.get(slotName = SlotPath.escape((String)requesterId))) instanceof BCertificateSigningRecord) {
            BCertificateSigningRecord existingCertRec = (BCertificateSigningRecord)slotVal;
            existingCertRec.copyFrom((BComplex)certRecord, BCertificateSigningRecord.SKIP_UPDATE_CX);
            existingCertRec.updateProperties();
            return;
        }
        if (slotVal != null) {
            this.set(slotName, (BValue)certRecord);
            certRecord.updateProperties();
            return;
        }
        this.add(slotName, (BValue)certRecord);
    }

    @Override
    public Optional<BCertificateSigningRecord> getRecord(String requesterId) throws SigningServiceException {
        BCertificateSigningRecord signingRecord;
        SigningServiceUtils.checkRequestPermitted();
        String slotName = SlotPath.escape((String)requesterId);
        BValue val = this.get(slotName);
        if (val instanceof BCertificateSigningRecord && this.updateAndGetRecordValidity(signingRecord = (BCertificateSigningRecord)val)) {
            return Optional.of((BCertificateSigningRecord)signingRecord.newCopy(true));
        }
        return Optional.empty();
    }

    @Override
    public Iterator<BCertificateSigningRecord> getAllRecords() throws SigningServiceException {
        SigningServiceUtils.checkRequestPermitted();
        return Arrays.stream(this.getChildren(BCertificateSigningRecord.class)).filter(rec -> this.updateAndGetRecordValidity((BCertificateSigningRecord)((Object)rec))).map(rec -> (BCertificateSigningRecord)rec.newCopy(true)).iterator();
    }

    public List<BCertificateSigningRecord> recentlyRemovedCerts() {
        return this.removedCertsNeedingAlert != null ? Collections.unmodifiableList(new ArrayList<BCertificateSigningRecord>(this.removedCertsNeedingAlert)) : Collections.emptyList();
    }

    public void doUpdateRecordStates() {
        for (BCertificateSigningRecord signingRecord : (BCertificateSigningRecord[])this.getChildren(BCertificateSigningRecord.class)) {
            this.updateAndGetRecordValidity(signingRecord);
        }
    }

    public void doGenerateCertificateExpirationAlerts() throws IOException {
        if (!this.getCertificateAlertsEnabled()) {
            if (this.removedCertsNeedingAlert != null) {
                this.removedCertsNeedingAlert.clear();
            }
            return;
        }
        ExpiringRecordsReport report = new ExpiringRecordsReport(this);
        this.generateAlerts(report.getCertsPendingExpiration(), "signing.store.certsPendingExpiration", "signing.store.pendingExpCertSummary");
        this.generateAlerts(report.getExpiredCertsInGracePeriod(), "signing.store.certsInGracePeriod", "signing.store.gracePeriodCertSummary");
        this.generateAlerts(this.removedCertsNeedingAlert, "signing.store.expiredCertsRemoved", "signing.store.expiredCertRemovedSummary");
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) {
        try {
            return BBoolean.make((boolean)this.alarmSupport.ackAlarm(ackRequest));
        }
        catch (Throwable e) {
            if (SigningServiceUtils.LOG.isLoggable(Level.WARNING)) {
                SigningServiceUtils.LOG.log(Level.WARNING, "Failed to ack alarm for " + this.getAlarmSourceInfo().toPathString(), e);
            }
            return BBoolean.FALSE;
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.postAsyncWork((ICoalesceable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public void started() throws Exception {
        this.stopped();
        CompUtil.setOrAdd((BComponent)this, (String)ALERT_GENERATION_TRIGGER_LINK_NAME, (BValue)new BLink(this.getAlertGenerationTime().getOrdInSession(), BTimeTrigger.fireTrigger.getName(), generateCertificateExpirationAlerts.getName(), true), (int)6, null, null);
        this.alarmSupport = new AlarmSupport((BIAlarmSource)this, this.getAlarmSourceInfo());
        this.removedCertsNeedingAlert = new ConcurrentLinkedQueue<BCertificateSigningRecord>();
        this.queue = new CoalesceQueue();
        this.worker = new Worker((Worker.ITodo)this.queue);
        this.worker.start("SigningRecordStore: " + this.toPathString());
        this.updateRecordStatesTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)UPDATE_RECORDS_INTERVAL, (Action)updateRecordStates, null);
        this.updateRecordStates();
    }

    public void stopped() throws Exception {
        CompUtil.removeIfPresent((BComponent)this, (String)ALERT_GENERATION_TRIGGER_LINK_NAME);
        if (this.updateRecordStatesTicket != null) {
            this.updateRecordStatesTicket.cancel();
        }
        if (this.queue != null) {
            this.queue.clear();
            this.queue = null;
        }
        if (this.worker != null) {
            this.worker.stop();
            this.worker = null;
        }
        this.removedCertsNeedingAlert = null;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property.equals(alertGenerationTime)) {
            CompUtil.setOrAdd((BComponent)this, (String)ALERT_GENERATION_TRIGGER_LINK_NAME, (BValue)new BLink(this.getAlertGenerationTime().getOrdInSession(), BTimeTrigger.fireTrigger.getName(), generateCertificateExpirationAlerts.getName(), true), (int)6, null, null);
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BAbstractSigningProfile;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BCertificateSigningRecord;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BCertificateSigningRecord) {
            if (context != null && context.getUser() != null) {
                throw new LocalizableRuntimeException("signingService", "signing.service.illegalManualAdd", new Object[]{BCertificateSigningRecord.TYPE.getDisplayName(context)});
            }
            if (this.isRunning()) {
                SigningServiceUtils.checkSecurity();
            }
        }
    }

    public BIcon getIcon() {
        return ICON;
    }

    private void generateAlerts(Queue<BCertificateSigningRecord> signingRecords, String overallLexKey, String recSummaryLexKey) throws IOException {
        if (signingRecords != null && !signingRecords.isEmpty()) {
            StringJoiner sj = new StringJoiner("\n\n");
            BCertificateSigningRecord signingRecord = signingRecords.poll();
            if (signingRecord == null) {
                return;
            }
            int count = 1;
            String recordSummary = SigningServiceUtils.makeExpiringCertSummary(recSummaryLexKey, count++, signingRecord);
            BSigningRecordStore.appendRecord(sj, recordSummary);
            BFacets tempAlertData = this.makeAlertData();
            BFacets alertData = tempAlertData = BFacets.make((BFacets)tempAlertData, (String)"msgText", (BIDataValue)BString.make((String)LEX.getText(overallLexKey, new Object[]{sj.toString()})));
            signingRecord = signingRecords.poll();
            while (signingRecord != null) {
                recordSummary = SigningServiceUtils.makeExpiringCertSummary(recSummaryLexKey, count++, signingRecord);
                BSigningRecordStore.appendRecord(sj, recordSummary);
                tempAlertData = BFacets.make((BFacets)tempAlertData, (String)"msgText", (BIDataValue)BString.make((String)LEX.getText(overallLexKey, new Object[]{sj.toString()})));
                if (tempAlertData.encodeToString().getBytes(StandardCharsets.UTF_8).length >= 60000) {
                    this.sendAlert(alertData);
                    tempAlertData = this.makeAlertData();
                    sj = new StringJoiner("\n\n");
                    count = 1;
                    recordSummary = SigningServiceUtils.makeExpiringCertSummary(recSummaryLexKey, count++, signingRecord);
                    BSigningRecordStore.appendRecord(sj, recordSummary);
                    tempAlertData = BFacets.make((BFacets)tempAlertData, (String)"msgText", (BIDataValue)BString.make((String)LEX.getText(overallLexKey, new Object[]{sj.toString()})));
                }
                alertData = tempAlertData;
                signingRecord = signingRecords.poll();
            }
            this.sendAlert(alertData);
        }
    }

    private static void appendRecord(StringJoiner data, String recordSummary) {
        if (recordSummary != null) {
            data.add(recordSummary);
        }
    }

    private BFacets makeAlertData() {
        BFacets alertData = this.getAlarmSourceInfo().makeAlarmData(BSourceState.offnormal);
        BOrd navOrd = this.getNavOrd();
        if (alertData.get("hyperlinkOrd") == null && navOrd != null) {
            alertData = BFacets.make((BFacets)alertData, (String)"hyperlinkOrd", (BIDataValue)BString.make((String)navOrd.relativizeToSession().toString()));
        }
        return alertData;
    }

    private void sendAlert(BFacets alertData) {
        block2: {
            try {
                this.alarmSupport.newAlert(alertData);
            }
            catch (Throwable e) {
                if (!SigningServiceUtils.LOG.isLoggable(Level.WARNING)) break block2;
                SigningServiceUtils.LOG.log(Level.WARNING, "Failed to send alert for " + this.getAlarmSourceInfo().toPathString(), e);
            }
        }
    }

    private static BAlarmSourceInfo initAlarmSourceInfo() {
        BAlarmSourceInfo asi = new BAlarmSourceInfo();
        asi.setSourceName(BFormat.make((String)"%parent.parent.displayName% %parent.displayName%"));
        return asi;
    }

    boolean updateAndGetRecordValidity(BCertificateSigningRecord signingRecord) {
        boolean recordValid;
        signingRecord.updateProperties();
        boolean bl = recordValid = !signingRecord.getCertificateState().equals((Object)BSigningCertificateState.expired) && (signingRecord.getRequestState().equals((Object)BSigningRequestState.complete) || BAbsTime.now().getMillis() < signingRecord.getAutoRemovalTime().getMillis());
        if (!recordValid && signingRecord.isRunning()) {
            this.remove(signingRecord.getPropertyInParent());
            if (this.removedCertsNeedingAlert != null && signingRecord.getCertificateState().equals((Object)BSigningCertificateState.expired)) {
                this.removedCertsNeedingAlert.add(signingRecord);
            }
        }
        return recordValid;
    }

    private void postAsyncWork(ICoalesceable work) {
        if (this.queue == null) {
            throw new IllegalStateException("Queue not available to process work: " + work);
        }
        this.queue.enqueue((Object)work);
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.trTitle((Object)"Signing Record Store", 2);
            out.prop((Object)"updateRecordStatesTicket", (Object)this.updateRecordStatesTicket);
            if (this.removedCertsNeedingAlert != null) {
                out.prop((Object)"removedCertsNeedingAlert Size", this.removedCertsNeedingAlert.size());
            }
            out.endProps();
            if (this.worker != null) {
                this.worker.spy(out);
            }
        }
        super.spy(out);
    }
}

