/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing.fox;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.CertificateKeyAlgorithm;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxString;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxCircuit;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.LocalizableExceptionTranslator;
import com.tridium.fox.sys.LocalizableServerException;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BApprovalState;
import com.tridium.signing.BCertificateSigningRecord;
import com.tridium.signing.BSigningRequestState;
import com.tridium.signing.BSigningService;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.fox.BFoxSigningTransport;
import com.tridium.signing.profile.BAbstractSigningProfile;
import com.tridium.signing.transport.BSessionToken;
import java.io.Reader;
import java.io.StringReader;
import java.security.AccessController;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.crypto.spec.SecretKeySpec;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

@NiagaraType
public class BSigningChannel
extends BFoxChannel {
    @Generated
    public static final Type TYPE = Sys.loadType(BSigningChannel.class);
    private static final Logger LOG = Logger.getLogger("signingService");
    private static final String SIGNING_CHANNEL_MODULE = "signingService";
    static final String ONBOARD_REJECTED_KEY = "channel.exception.onboardRequestRejected";
    static final String ONBOARD_EXPIRED_KEY = "channel.exception.onboardRequestExpired";
    public static final String CMD_ONBOARD = "onboard";
    public static final String CMD_GET_TOKEN = "getToken";
    public static final String CMD_GET_PARAMS = "getParams";
    public static final String CMD_SIGN_CERTIFICATE = "signCertificate";
    public static final String CMD_GET_CERTIFICATE_WITH_TOKEN = "getCertificateWithToken";
    public static final String CMD_GET_CERTIFICATE_WITH_CERT = "getCertificateWithCert";
    public static final String CMD_RENEW_CERTIFICATE = "renewCertificate";
    public static final String MSG_REQUESTER_ID = "requesterId";
    public static final String MSG_METADATA = "metadata";
    public static final String MSG_USERNAME = "username";
    public static final String MSG_STATION = "requestingStation";
    public static final String MSG_TEMP_CODE = "temporaryCode";
    public static final String MSG_TOKEN_STATE = "tokenState";
    public static final String MSG_TOKEN = "token";
    public static final String MSG_PARAMS = "certParams";
    public static final String MSG_CSR = "csr";
    public static final String MSG_JWT = "jwt";
    public static final String MSG_CERT_CHAIN = "certChain";
    public static final int JWT_EXPIRATION_TIME_IN_MINUTES = 5;
    public static final int JWT_MAX_ISSUED_AT_TIME_IN_PAST = 300;
    public static final String JWT_KEY_ID = "K1";
    public static final String JWT_ALGORITHM_ID_CERT = "RS256";
    public static final String JWT_ALGORITHM_ID_TOKEN = "HS256";
    private static final LocalizableExceptionTranslator EXCEPTION_TRANSLATOR = new LocalizableExceptionTranslator();
    private static int signingChannelUsersCount;
    private static final Object SIGNING_CHANNEL_USERS_COUNT_LOCK;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSigningChannel() {
        super("signing");
    }

    protected boolean useSharedKeyEncryption() {
        return true;
    }

    public void checkProcess(FoxRequest req) throws Throwable {
        super.checkProcess(req);
        this.checkSessionIsSecure();
    }

    public void checkProcessCircuit(FoxCircuit circuit) throws Throwable {
        super.checkProcessCircuit(circuit);
        this.checkSessionIsSecure();
    }

    public FoxResponse process(FoxRequest request) throws Exception {
        String command;
        switch (command = request.command) {
            case "onboard": {
                return this.onboard(request);
            }
            case "getToken": {
                return this.getToken(request);
            }
            case "getParams": {
                return this.getParams(request);
            }
            case "signCertificate": {
                return this.signCertificate(request);
            }
            case "getCertificateWithToken": {
                return this.getCertificate(request, true);
            }
            case "getCertificateWithCert": {
                return this.getCertificate(request, false);
            }
            case "renewCertificate": {
                return this.renewCertificate(request);
            }
        }
        throw new InvalidCommandException(command);
    }

    public BPassword onboard(String requesterId, Map<String, String> metadata, BPassword existingTempCode) throws SigningServiceException {
        try {
            Objects.requireNonNull(requesterId, "requesterId must not be null");
            Objects.requireNonNull(metadata, "metadata map must not be null");
            FoxRequest onboardingRequest = this.makeRequest(CMD_ONBOARD);
            onboardingRequest.add(MSG_REQUESTER_ID, requesterId);
            if (existingTempCode != null && !existingTempCode.isDefault()) {
                onboardingRequest.add(MSG_TEMP_CODE, this.encrypt(existingTempCode, null));
            }
            FoxMessage metadataMessage = new FoxMessage(MSG_METADATA);
            for (Map.Entry<String, String> entry : metadata.entrySet()) {
                metadataMessage.add(entry.getKey(), entry.getValue());
            }
            BUser authenticatedUser = BUser.getCurrentAuthenticatedUser();
            if (authenticatedUser != null) {
                metadataMessage.add(MSG_USERNAME, authenticatedUser.getUsername());
            }
            metadataMessage.add(MSG_STATION, Sys.getStation().getStationName());
            onboardingRequest.add((FoxTuple)metadataMessage);
            FoxResponse response = this.sendSync(onboardingRequest);
            if (response.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(response.getMessage("exception"));
            }
            String encodedTemporaryCode = response.getString(MSG_TEMP_CODE);
            return this.decrypt(encodedTemporaryCode, null);
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            if (e instanceof LocalizableRuntimeException) {
                throw (LocalizableRuntimeException)e;
            }
            if (e.getCause() instanceof SecurityException) {
                throw (SecurityException)e.getCause();
            }
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", (Throwable)e, e.getMessage());
        }
    }

    private FoxResponse onboard(FoxRequest request) throws Exception {
        BPassword temporaryCode;
        String requesterId = request.getString(MSG_REQUESTER_ID);
        String existingTempCodeStr = request.getString(MSG_TEMP_CODE, null);
        BPassword existingTempCode = existingTempCodeStr != null ? this.decrypt(existingTempCodeStr, null) : null;
        HashMap<String, String> metadata = new HashMap<String, String>();
        FoxMessage metadataMessage = request.getMessage(MSG_METADATA);
        for (FoxTuple metadataTuple : metadataMessage.tuples) {
            if (metadataTuple instanceof FoxString) {
                metadata.put(metadataTuple.name, ((FoxString)metadataTuple).value);
                continue;
            }
            if (metadataTuple == null || !LOG.isLoggable(Level.FINE)) continue;
            LOG.fine(String.format("Invalid metadata format for key %s. Ignoring.", metadataTuple.name));
        }
        FoxResponse response = new FoxResponse(request);
        try {
            temporaryCode = AccessController.doPrivileged(() -> SigningServiceUtils.getFoxSigningTransport().getSessionTokenStore().store(requesterId, metadata, existingTempCode));
        }
        catch (Exception e) {
            Exception ex;
            Exception exception = ex = e instanceof PrivilegedActionException ? ((PrivilegedActionException)e).getException() : e;
            if (ex instanceof LocalizableRuntimeException) {
                response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)BSigningChannel.createGenericException(requesterId))));
                return response;
            }
            throw ex;
        }
        response.add(MSG_TEMP_CODE, this.encrypt(temporaryCode, null));
        return response;
    }

    public BPassword getToken(String requesterId, BPassword temporaryCode) throws SigningServiceException {
        try {
            Objects.requireNonNull(requesterId, "requesterId must not be null");
            Objects.requireNonNull(temporaryCode, "temporaryCode must not be null");
            FoxRequest getTokenRequest = this.makeRequest(CMD_GET_TOKEN);
            getTokenRequest.add(MSG_REQUESTER_ID, requesterId);
            getTokenRequest.add(MSG_TEMP_CODE, this.encrypt(temporaryCode, null));
            FoxResponse response = this.sendSync(getTokenRequest);
            if (response.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(response.getMessage("exception"));
            }
            int tokenState = response.getInt(MSG_TOKEN_STATE);
            switch (tokenState) {
                case 1: {
                    throw new SigningServiceException(SIGNING_CHANNEL_MODULE, ONBOARD_REJECTED_KEY, requesterId);
                }
                case 2: {
                    throw new SigningServiceException(SIGNING_CHANNEL_MODULE, ONBOARD_EXPIRED_KEY, requesterId);
                }
                case 3: {
                    String encodedToken = response.getString(MSG_TOKEN);
                    return this.decrypt(encodedToken, null);
                }
            }
            return null;
        }
        catch (SigningServiceException | LocalizableRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            throw new LocalizableRuntimeException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", new Object[]{e.getMessage()}, (Throwable)e);
        }
    }

    private FoxResponse getToken(FoxRequest request) throws Exception {
        BApprovalState approvalState;
        String requesterId = request.getString(MSG_REQUESTER_ID);
        String encodedTemporaryCode = request.getString(MSG_TEMP_CODE);
        BPassword temporaryCode = this.decrypt(encodedTemporaryCode, this.getSessionContext());
        FoxResponse response = new FoxResponse(request);
        try {
            approvalState = AccessController.doPrivileged(() -> SigningServiceUtils.getFoxSigningTransport().getSessionTokenStore().getCurrentTokenState(requesterId, temporaryCode));
        }
        catch (PrivilegedActionException e) {
            response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)BSigningChannel.createGenericException(requesterId))));
            return response;
        }
        response.add(MSG_TOKEN_STATE, approvalState.getOrdinal());
        if (approvalState.equals((Object)BApprovalState.approved)) {
            BPassword accessToken;
            try {
                accessToken = SigningServiceUtils.getFoxSigningTransport().validateCode(requesterId, temporaryCode);
            }
            catch (SigningServiceException e) {
                response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)BSigningChannel.createGenericException(requesterId))));
                return response;
            }
            response.add(MSG_TOKEN, this.encrypt(accessToken, null));
        }
        return response;
    }

    public Map<String, BValue> getParams(String requesterId, BPassword token) throws SigningServiceException {
        try {
            Objects.requireNonNull(requesterId, "requesterId must not be null");
            Objects.requireNonNull(token, "token must not be null");
            FoxRequest getParamsRequest = this.makeRequest(CMD_GET_PARAMS);
            getParamsRequest.add(MSG_REQUESTER_ID, requesterId);
            getParamsRequest.add(MSG_TOKEN, this.encrypt(token, null));
            FoxResponse response = this.sendSync(getParamsRequest);
            if (response.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(response.getMessage("exception"));
            }
            FoxMessage paramMessage = response.getMessage(MSG_PARAMS);
            HashMap<String, BValue> params = new HashMap<String, BValue>();
            for (int i = 0; i < paramMessage.count; ++i) {
                params.put(paramMessage.tuples[i].name, this.unmarshal(((FoxString)paramMessage.tuples[i]).value));
            }
            return params;
        }
        catch (LocalizableServerException e) {
            throw e;
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", (Throwable)e, e.getMessage());
        }
    }

    private FoxResponse getParams(FoxRequest request) throws Exception {
        String profileId;
        FoxResponse response = new FoxResponse(request);
        String requesterId = request.getString(MSG_REQUESTER_ID);
        String encodedToken = request.getString(MSG_TOKEN);
        BPassword token = this.decrypt(encodedToken, this.getSessionContext());
        BSigningService signingService = (BSigningService)Sys.getService((Type)BSigningService.TYPE);
        try {
            SigningServiceUtils.getFoxSigningTransport().authorizeToken(requesterId, token);
            profileId = SigningServiceUtils.getProfileIdFromTokenStore(requesterId, signingService);
        }
        catch (SigningServiceException | PrivilegedActionException e) {
            BSigningChannel.log(Level.WARNING, "Could not acquire signing profile", (Exception)e);
            response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)BSigningChannel.createGenericException(requesterId))));
            return response;
        }
        Map params = AccessController.doPrivileged(() -> signingService.getCsrParameters(profileId, this.getSessionContext()));
        FoxMessage paramMessage = new FoxMessage(MSG_PARAMS);
        for (Map.Entry entry : params.entrySet()) {
            paramMessage.add((String)entry.getKey(), this.marshal((BValue)entry.getValue()));
        }
        response.add(MSG_PARAMS, paramMessage);
        return response;
    }

    public void signCertificate(String requesterId, BPassword token, NPKCS10CertificationRequest csr) throws SigningServiceException {
        try {
            Objects.requireNonNull(requesterId, "requesterId must not be null");
            Objects.requireNonNull(token, "token must not be null");
            Objects.requireNonNull(csr, "CSR must not be null");
            String jwt = this.getJwtWithTokenSignature(requesterId, token, csr);
            FoxRequest signingRequest = this.makeRequest(CMD_SIGN_CERTIFICATE);
            signingRequest.add(MSG_REQUESTER_ID, requesterId);
            signingRequest.add(MSG_JWT, jwt);
            FoxResponse response = this.sendSync(signingRequest);
            if (response.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(response.getMessage("exception"));
            }
        }
        catch (LocalizableServerException | SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", (Throwable)e, e.getMessage());
        }
    }

    private FoxResponse signCertificate(FoxRequest request) throws Exception {
        String profileId;
        JwtClaims jwtClaims;
        String requesterId = request.getString(MSG_REQUESTER_ID);
        String jwt = request.getString(MSG_JWT);
        BSigningService signingService = (BSigningService)Sys.getService((Type)BSigningService.TYPE);
        FoxResponse response = new FoxResponse(request);
        try {
            jwtClaims = BSigningChannel.validateJwtWithToken(requesterId, jwt);
            profileId = SigningServiceUtils.getProfileIdFromTokenStore(requesterId, signingService);
        }
        catch (SigningServiceException | PrivilegedActionException e) {
            BSigningChannel.log(Level.WARNING, "Failed to process JWT", (Exception)e);
            response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.jwtValidationFailure", requesterId))));
            return response;
        }
        try {
            String encodedCsr = (String)jwtClaims.getClaimValue(MSG_CSR, String.class);
            if (encodedCsr == null) {
                throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.invalidJwt.missingCsr", requesterId);
            }
            AccessController.doPrivileged(() -> {
                signingService.processCsr(encodedCsr, profileId, requesterId, SigningServiceUtils.getFoxSigningTransport().getSessionTokenStore().getSessionToken(requesterId).getMetadata(), false);
                return null;
            });
        }
        catch (SigningServiceException e) {
            throw e;
        }
        catch (MalformedClaimException e) {
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.invalidJwt.malformedClaim", (Throwable)e, requesterId);
        }
        catch (Exception e) {
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.processCsrFailed", requesterId);
        }
        return new FoxResponse(request);
    }

    public Optional<X509Certificate[]> getCertificate(String requesterId, BPassword token) throws SigningServiceException {
        try {
            Objects.requireNonNull(requesterId, "requesterId must not be null");
            Objects.requireNonNull(token, "token must not be null");
            String jwt = this.getJwtWithTokenSignature(requesterId, token);
            return this.getCertificateChain(this.makeRequest(CMD_GET_CERTIFICATE_WITH_TOKEN), requesterId, jwt);
        }
        catch (LocalizableServerException | SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", (Throwable)e, e.getMessage());
        }
    }

    public Optional<X509Certificate[]> getCertificate(String requesterId, String certificateAlias, BPassword certificatePassword, boolean renewal) throws SigningServiceException {
        try {
            Objects.requireNonNull(requesterId, "requesterId must not be null");
            Objects.requireNonNull(certificateAlias, "certificateAlias must not be null");
            this.getCertificate(certificateAlias, renewal);
            PrivateKey privateKey = this.getPrivateKey(certificateAlias, certificatePassword, renewal);
            String jwt = this.getJwtWithPrivateKeySignature(requesterId, privateKey);
            return this.getCertificateChain(this.makeRequest(CMD_GET_CERTIFICATE_WITH_CERT), requesterId, jwt);
        }
        catch (LocalizableServerException | SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", (Throwable)e, e.getMessage());
        }
    }

    private FoxResponse getCertificate(FoxRequest request, boolean tokenValidation) throws Exception {
        String profileId;
        String requesterId = request.getString(MSG_REQUESTER_ID);
        String jwt = request.getString(MSG_JWT);
        BSigningService signingService = (BSigningService)Sys.getService((Type)BSigningService.TYPE);
        FoxResponse response = new FoxResponse(request);
        try {
            if (tokenValidation) {
                BSigningChannel.validateJwtWithToken(requesterId, jwt);
            } else {
                BSigningChannel.validateJwtWithCertificate(requesterId, jwt);
            }
            profileId = signingService.findProfileId(requesterId).orElseThrow(() -> new SigningServiceException(SIGNING_CHANNEL_MODULE, "session.token.failureForRequester", requesterId));
        }
        catch (SigningServiceException | PrivilegedActionException e) {
            BSigningChannel.log(Level.WARNING, "Failed to process JWT", (Exception)e);
            response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.jwtValidationFailure", requesterId))));
            return response;
        }
        try {
            BAbstractSigningProfile profile = signingService.findProfile(profileId);
            Optional signingRecordOpt = AccessController.doPrivileged(() -> profile.getRecord(requesterId));
            if (signingRecordOpt.isPresent()) {
                BCertificateSigningRecord signingRecord = (BCertificateSigningRecord)((Object)signingRecordOpt.get());
                BSigningRequestState signingRequestState = signingRecord.getRequestState();
                if (signingRequestState.equals((Object)BSigningRequestState.complete)) {
                    if (!signingRecord.getCaFingerprint().equals(profile.getCaFingerprint())) {
                        LOG.warning("Certificate was signed with a different CA than the one currently configured");
                        response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.mismatchedCaFingerprint", requesterId))));
                        return response;
                    }
                    response.add(MSG_CERT_CHAIN, signingRecord.getCertificate().encodeToString() + CertUtils.encodeX509CertificateChain((X509Certificate[])profile.getCaCertificateChain(requesterId)));
                } else if (signingRequestState.equals((Object)BSigningRequestState.rejected)) {
                    response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.signingRequestRejected", requesterId))));
                    return response;
                }
            }
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        catch (SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.processCsrFailed", requesterId);
        }
        return response;
    }

    public void renewCertificate(String requesterId, String certificateAlias, BPassword certificatePassword, NPKCS10CertificationRequest csr) throws SigningServiceException {
        try {
            Objects.requireNonNull(requesterId, "requesterId must not be null");
            Objects.requireNonNull(certificateAlias, "certificateAlias must not be null");
            Objects.requireNonNull(csr, "CSR must not be null");
            PrivateKey privateKey = this.getPrivateKey(certificateAlias, certificatePassword, true);
            String jwt = this.getJwtWithPrivateKeySignature(requesterId, privateKey, csr);
            FoxRequest signingRequest = this.makeRequest(CMD_RENEW_CERTIFICATE);
            signingRequest.add(MSG_REQUESTER_ID, requesterId);
            signingRequest.add(MSG_JWT, jwt);
            FoxResponse response = this.sendSync(signingRequest);
            if (response.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(response.getMessage("exception"));
            }
        }
        catch (LocalizableServerException | SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", (Throwable)e, e.getMessage());
        }
    }

    private FoxResponse renewCertificate(FoxRequest request) throws Exception {
        String profileId;
        JwtClaims jwtClaims;
        String requesterId = request.getString(MSG_REQUESTER_ID);
        String jwt = request.getString(MSG_JWT);
        BSigningService signingService = (BSigningService)Sys.getService((Type)BSigningService.TYPE);
        FoxResponse response = new FoxResponse(request);
        try {
            jwtClaims = BSigningChannel.validateJwtWithCertificate(requesterId, jwt);
            profileId = signingService.findProfileId(requesterId).orElseThrow(() -> new SigningServiceException(SIGNING_CHANNEL_MODULE, "session.token.failureForRequester", requesterId));
        }
        catch (SigningServiceException e) {
            BSigningChannel.log(Level.WARNING, "Failed to process JWT", (Exception)((Object)e));
            response.add("exception", EXCEPTION_TRANSLATOR.exceptionToMessage((Throwable)((Object)new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.jwtValidationFailure", requesterId))));
            return response;
        }
        try {
            String encodedCsr = (String)jwtClaims.getClaimValue(MSG_CSR, String.class);
            if (encodedCsr == null) {
                throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.invalidJwt.missingCsr", requesterId);
            }
            AccessController.doPrivileged(() -> {
                signingService.processCsr(encodedCsr, profileId, requesterId, null, true);
                return null;
            });
        }
        catch (SigningServiceException e) {
            throw e;
        }
        catch (MalformedClaimException e) {
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.invalidJwt.malformedClaim", (Throwable)e, requesterId);
        }
        catch (Exception e) {
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.processCsrFailed", requesterId);
        }
        return new FoxResponse(request);
    }

    private static void log(Level requestedLevel, String message, Exception e) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(requestedLevel, message, e);
        } else {
            LOG.log(requestedLevel, message + ". Cause is: " + e.getMessage());
        }
    }

    private void checkSessionIsSecure() {
        if (!this.getConnection().session().isSecure()) {
            LOG.warning("The signing channel can only be used over TLS.");
            throw new LocalizableRuntimeException(SIGNING_CHANNEL_MODULE, "channel.exception.tlsRequired");
        }
    }

    private String getJwtWithTokenSignature(String requesterId, BPassword token) throws Exception {
        return this.getJwtWithTokenSignature(requesterId, token, null);
    }

    private String getJwtWithTokenSignature(String requesterId, BPassword token, NPKCS10CertificationRequest csr) throws Exception {
        try {
            JwtClaims jwtClaims = this.getJwtClaim(requesterId, csr);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(jwtClaims.toJson());
            AccessController.doPrivileged(() -> {
                try (SecretChars secretChars = token.getSecretChars();
                     SecretBytes secretBytes = secretChars.asSecretBytes();){
                    byte[] tokenBytes = secretBytes.get();
                    jws.setKey((Key)new SecretKeySpec(tokenBytes, 0, tokenBytes.length, "AES"));
                }
                return null;
            });
            jws.setKeyIdHeaderValue(JWT_KEY_ID);
            jws.setAlgorithmHeaderValue(JWT_ALGORITHM_ID_TOKEN);
            return jws.getCompactSerialization();
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Could not create JWT", e);
            throw new Exception("Could not create JWT", e);
        }
    }

    private String getJwtWithPrivateKeySignature(String requesterId, PrivateKey privateKey) throws Exception {
        return this.getJwtWithPrivateKeySignature(requesterId, privateKey, null);
    }

    private String getJwtWithPrivateKeySignature(String requesterId, PrivateKey privateKey, NPKCS10CertificationRequest csr) throws Exception {
        try {
            JwtClaims jwtClaims = this.getJwtClaim(requesterId, csr);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setPayload(jwtClaims.toJson());
            AccessController.doPrivileged(() -> {
                jws.setKey((Key)privateKey);
                return null;
            });
            jws.setKeyIdHeaderValue(JWT_KEY_ID);
            String headerAlg = BSigningChannel.getJwtHeaderAlg(privateKey);
            jws.setAlgorithmHeaderValue(headerAlg);
            return jws.getCompactSerialization();
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Could not create JWT", e);
            throw new Exception("Could not create JWT", e);
        }
    }

    private static String getJwtHeaderAlg(PrivateKey privateKey) throws SigningServiceException {
        String keyAlg = privateKey.getAlgorithm();
        if (keyAlg.equalsIgnoreCase(CertificateKeyAlgorithm.RSA.toString())) {
            return JWT_ALGORITHM_ID_CERT;
        }
        if (keyAlg.equalsIgnoreCase(CertificateKeyAlgorithm.EC.toString()) && privateKey instanceof ECPrivateKey) {
            int keySize = ((ECPrivateKey)privateKey).getParams().getOrder().bitLength();
            if (keySize == 256) {
                return "ES256";
            }
            if (keySize == 384) {
                return "ES384";
            }
            if (keySize == 521) {
                return "ES512";
            }
        }
        throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.unsupported.ec.key");
    }

    private JwtClaims getJwtClaim(String requesterId, NPKCS10CertificationRequest csr) throws Exception {
        JwtClaims jwtClaims = new JwtClaims();
        BNiagaraStation connectionStation = (BNiagaraStation)this.getConnection().getConnectionTarget(BNiagaraStation.class).orElseThrow(() -> new IllegalArgumentException("Unable to build JWT claim audience"));
        jwtClaims.setAudience(connectionStation.getStationName());
        jwtClaims.setExpirationTimeMinutesInTheFuture(5.0f);
        jwtClaims.setIssuedAtToNow();
        jwtClaims.setIssuer(requesterId);
        if (csr != null) {
            jwtClaims.setStringClaim(MSG_CSR, csr.encodeToString());
        }
        return jwtClaims;
    }

    private X509Certificate getCertificate(String certificateAlias, boolean useCoreKeystore) throws Exception {
        X509Certificate certificate;
        ICoreKeyStore keyStore = BAbstractSigningRequester.getKeyStore((boolean)useCoreKeystore);
        try {
            certificate = AccessController.doPrivileged(() -> keyStore.getCertificate(certificateAlias));
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        if (certificate == null) {
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.missingAlias", certificateAlias);
        }
        return certificate;
    }

    private PrivateKey getPrivateKey(String certificateAlias, BPassword certificatePassword, boolean useCoreKeystore) throws Exception {
        PrivateKey privateKey;
        block16: {
            ICoreKeyStore keyStore = BAbstractSigningRequester.getKeyStore((boolean)useCoreKeystore);
            try {
                if (certificatePassword != null) {
                    try (SecretChars secretChars = certificatePassword.getSecretChars();){
                        privateKey = AccessController.doPrivileged(() -> (PrivateKey)keyStore.getKey(certificateAlias, secretChars.get()));
                        break block16;
                    }
                }
                privateKey = AccessController.doPrivileged(() -> (PrivateKey)keyStore.getKey(certificateAlias, null));
            }
            catch (PrivilegedActionException e) {
                Exception cause = e.getException();
                if (cause instanceof UnrecoverableKeyException) {
                    throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.badPassword", (Throwable)cause, certificateAlias);
                }
                throw cause;
            }
        }
        return privateKey;
    }

    private Optional<X509Certificate[]> getCertificateChain(FoxRequest signingRequest, String requesterId, String jwt) throws SigningServiceException {
        try {
            signingRequest.add(MSG_REQUESTER_ID, requesterId);
            signingRequest.add(MSG_JWT, jwt);
            FoxResponse response = this.sendSync(signingRequest);
            if (response.getOptional("exception") != null) {
                throw EXCEPTION_TRANSLATOR.messageToException(response.getMessage("exception"));
            }
            String certificates = response.getString(MSG_CERT_CHAIN, null);
            if (certificates == null) {
                return Optional.empty();
            }
            return Optional.of(CertUtils.parsePemCertificates((Reader)new StringReader(certificates)));
        }
        catch (LocalizableServerException | SigningServiceException e) {
            throw e;
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Signing request failed", e);
            throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "channel.exception.genericFailure", (Throwable)e, e.getMessage());
        }
    }

    private String encrypt(BPassword password, Context context) throws Exception {
        return this.marshal((BValue)password, this.makeEncodingContext(context));
    }

    private BPassword decrypt(String cipher, Context context) throws Exception {
        try {
            return (BPassword)this.unmarshal(cipher, this.makeDecodingContext(context));
        }
        catch (Exception e) {
            BSigningChannel.log(Level.WARNING, "Could not decrypt token", e);
            throw new Exception("Could not decrypt token", e);
        }
    }

    private static SigningServiceException createGenericException(String requesterId) {
        return new SigningServiceException(SIGNING_CHANNEL_MODULE, "session.token.failureForRequester", requesterId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addSigningChannelUser() {
        Object object = SIGNING_CHANNEL_USERS_COUNT_LOCK;
        synchronized (object) {
            ++signingChannelUsersCount;
            BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
            if (registry.get("signing") == null) {
                registry.add("signing", (BValue)new BSigningChannel());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeSigningChannelUser() {
        Object object = SIGNING_CHANNEL_USERS_COUNT_LOCK;
        synchronized (object) {
            BFoxChannelRegistry registry;
            if (--signingChannelUsersCount < 0) {
                signingChannelUsersCount = 0;
            }
            if ((registry = BFoxChannelRegistry.getPrototype()).get("signing") != null && signingChannelUsersCount <= 0) {
                registry.remove("signing");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static JwtClaims validateJwtWithToken(String requesterId, String jwt) throws SigningServiceException, PrivilegedActionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static JwtClaims validateJwtWithCertificate(String requesterId, String jwt) throws SigningServiceException {
        BSigningService signingService = (BSigningService)Sys.getService((Type)BSigningService.TYPE);
        String profileId = signingService.findProfileId(requesterId).orElseThrow(() -> new SigningServiceException(SIGNING_CHANNEL_MODULE, "session.token.failureForRequester", requesterId));
        try {
            BCertificateSigningRecord signingRecord = (BCertificateSigningRecord)((Object)AccessController.doPrivileged(() -> signingService.findProfile(profileId).getRecord(requesterId)).orElseThrow(() -> new SigningServiceException(SIGNING_CHANNEL_MODULE, SIGNING_CHANNEL_MODULE, "session.token.failureForRequester", requesterId)));
            BX509Certificate certificate = signingRecord.getCertificate();
            PublicKey verificationKey = certificate.getX509Certificate().getPublicKey();
            try {
                return BSigningChannel.validateJwt(jwt, verificationKey, null);
            }
            catch (InvalidJwtException e) {
                throw new SigningServiceException(SIGNING_CHANNEL_MODULE, "transport.exception.invalidJwt", (Throwable)e, requesterId);
            }
        }
        catch (PrivilegedActionException pae) {
            throw (SigningServiceException)((Object)pae.getException());
        }
    }

    private static JwtClaims validateJwt(String jwt, Key verificationKey, String expectedIssuer) throws InvalidJwtException, SigningServiceException {
        BFoxSigningTransport transport = SigningServiceUtils.getFoxSigningTransport();
        BRelTime jwtMaxIatInFuture = transport.getJwtMaxIatInFuture();
        int jwtMaxIatSecondsInFuture = Math.max(1, jwtMaxIatInFuture.getSeconds());
        int jwtMaxIatSecondsInPast = Math.max(300, jwtMaxIatInFuture.getSeconds());
        JwtConsumerBuilder builder = new JwtConsumerBuilder().setVerificationKey(verificationKey).setExpectedAudience(new String[]{Sys.getStation().getStationName()}).setRequireExpirationTime().setRequireIssuedAt().setIssuedAtRestrictions(jwtMaxIatSecondsInFuture, jwtMaxIatSecondsInPast);
        if (expectedIssuer != null) {
            builder.setExpectedIssuer(expectedIssuer);
        }
        return builder.build().processToClaims(jwt);
    }

    private static /* synthetic */ BSessionToken lambda$validateJwtWithToken$14(String requesterId) throws Exception {
        return SigningServiceUtils.getFoxSigningTransport().getSessionTokenStore().getSessionToken(requesterId);
    }

    static {
        SIGNING_CHANNEL_USERS_COUNT_LOCK = new Object();
    }
}

