/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.signing.SigningServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="none"), @Range(value="active"), @Range(value="inGracePeriod"), @Range(value="expired")}, defaultValue="none")
public final class BSigningCertificateState
extends BFrozenEnum {
    @Generated
    public static final int NONE = 0;
    @Generated
    public static final int ACTIVE = 1;
    @Generated
    public static final int IN_GRACE_PERIOD = 2;
    @Generated
    public static final int EXPIRED = 3;
    @Generated
    public static final BSigningCertificateState none = new BSigningCertificateState(0);
    @Generated
    public static final BSigningCertificateState active = new BSigningCertificateState(1);
    @Generated
    public static final BSigningCertificateState inGracePeriod = new BSigningCertificateState(2);
    @Generated
    public static final BSigningCertificateState expired = new BSigningCertificateState(3);
    @Generated
    public static final BSigningCertificateState DEFAULT = none;
    @Generated
    public static final Type TYPE = Sys.loadType(BSigningCertificateState.class);
    private static final List<Set<BSigningCertificateState>> permittedTransitions = new ArrayList<Set<BSigningCertificateState>>();

    @Generated
    public static BSigningCertificateState make(int ordinal) {
        return (BSigningCertificateState)none.getRange().get(ordinal, false);
    }

    @Generated
    public static BSigningCertificateState make(String tag) {
        return (BSigningCertificateState)none.getRange().get(tag);
    }

    @Generated
    private BSigningCertificateState(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void checkTransitionPermitted(BSigningCertificateState newCertState) throws SigningServiceException {
        if (newCertState.equals((Object)this)) {
            return;
        }
        int ordinal = this.getOrdinal();
        if (permittedTransitions.get(ordinal) == null || !permittedTransitions.get(ordinal).contains((Object)newCertState)) {
            throw new SigningServiceException("signingService", "signing.service.transition.illegal", new Object[]{this, newCertState});
        }
    }

    static {
        permittedTransitions.add(0, Collections.unmodifiableSet(new HashSet<BSigningCertificateState>(Arrays.asList(active, inGracePeriod))));
        permittedTransitions.add(1, Collections.unmodifiableSet(new HashSet<BSigningCertificateState>(Arrays.asList(inGracePeriod, expired))));
        permittedTransitions.add(2, Collections.unmodifiableSet(new HashSet<BSigningCertificateState>(Arrays.asList(active, expired))));
        permittedTransitions.add(3, Collections.emptySet());
    }
}

