/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.signing;

import com.tridium.signing.BSigningCertificateState;
import com.tridium.signing.BSigningRequestState;
import com.tridium.signing.SigningServiceException;
import com.tridium.signing.SigningServiceUtils;
import com.tridium.signing.profile.BISigningServiceStore;
import com.tridium.signing.profile.BSigningRecordStore;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BX509Certificate;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.util.BAbsTimeRange;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="requesterId", type="String", defaultValue="", flags=1), @NiagaraProperty(name="requestState", type="BSigningRequestState", defaultValue="BSigningRequestState.pending", flags=1), @NiagaraProperty(name="certificateState", type="BSigningCertificateState", defaultValue="BSigningCertificateState.none", flags=1), @NiagaraProperty(name="message", type="String", defaultValue="", flags=1), @NiagaraProperty(name="metadata", type="String", defaultValue="", flags=1, facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="certificate", type="BX509Certificate", defaultValue="BX509Certificate.DEFAULT", flags=1), @NiagaraProperty(name="certificateValidityRange", type="BAbsTimeRange", defaultValue="new BAbsTimeRange(BAbsTime.DEFAULT, BAbsTime.DEFAULT)", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="requestSubmittedTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="lastRejectionTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="autoRemovalTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=1, facets={@Facet(name="BFacets.SHOW_SECONDS", value="true")}), @NiagaraProperty(name="caFingerprint", type="String", defaultValue="", flags=5)})
public final class BCertificateSigningRecord
extends BComponent
implements IPropertyValidator {
    @Generated
    public static final Property requesterId = BCertificateSigningRecord.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property requestState = BCertificateSigningRecord.newProperty((int)1, (BValue)BSigningRequestState.pending, null);
    @Generated
    public static final Property certificateState = BCertificateSigningRecord.newProperty((int)1, (BValue)BSigningCertificateState.none, null);
    @Generated
    public static final Property message = BCertificateSigningRecord.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property metadata = BCertificateSigningRecord.newProperty((int)1, (String)"", (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property certificate = BCertificateSigningRecord.newProperty((int)1, (BValue)BX509Certificate.DEFAULT, null);
    @Generated
    public static final Property certificateValidityRange = BCertificateSigningRecord.newProperty((int)1, (BValue)new BAbsTimeRange(BAbsTime.DEFAULT, BAbsTime.DEFAULT), (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Property requestSubmittedTime = BCertificateSigningRecord.newProperty((int)1, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Property lastRejectionTime = BCertificateSigningRecord.newProperty((int)1, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Property autoRemovalTime = BCertificateSigningRecord.newProperty((int)1, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Property caFingerprint = BCertificateSigningRecord.newProperty((int)5, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCertificateSigningRecord.class);
    private static final BIcon PENDING_ICON = BIcon.std((String)"shield.png");
    private static final BIcon ACTIVE_ICON = BIcon.make((BIcon)PENDING_ICON, (BIcon)BIcon.std((String)"badges/certificateGreen.png"));
    private static final BIcon REJECTED_OR_EXPIRED_ICON = BIcon.make((BIcon)PENDING_ICON, (BIcon)BIcon.std((String)"badges/certificateRed.png"));
    private static final BIcon GRACE_PERIOD_ICON = BIcon.make((BIcon)PENDING_ICON, (BIcon)BIcon.std((String)"badges/certificateYellow.png"));
    private static final Map<BSigningCertificateState, Set<BSigningRequestState>> permittedStates = new HashMap<BSigningCertificateState, Set<BSigningRequestState>>();
    private static final String SUMMARY_TEXT = "signing.record.summary.text";
    private static final String ERROR_TEXT = "signing.record.error.text";
    private static final String EXPIRING_SOON_TEXT = "signing.record.expiring.soon.text";
    public static final Context SKIP_UPDATE_CX;

    @Generated
    public String getRequesterId() {
        return this.getString(requesterId);
    }

    @Generated
    public void setRequesterId(String v) {
        this.setString(requesterId, v, null);
    }

    @Generated
    public BSigningRequestState getRequestState() {
        return (BSigningRequestState)this.get(requestState);
    }

    @Generated
    public void setRequestState(BSigningRequestState v) {
        this.set(requestState, (BValue)v, null);
    }

    @Generated
    public BSigningCertificateState getCertificateState() {
        return (BSigningCertificateState)this.get(certificateState);
    }

    @Generated
    public void setCertificateState(BSigningCertificateState v) {
        this.set(certificateState, (BValue)v, null);
    }

    @Generated
    public String getMessage() {
        return this.getString(message);
    }

    @Generated
    public void setMessage(String v) {
        this.setString(message, v, null);
    }

    @Generated
    public String getMetadata() {
        return this.getString(metadata);
    }

    @Generated
    public void setMetadata(String v) {
        this.setString(metadata, v, null);
    }

    @Generated
    public BX509Certificate getCertificate() {
        return (BX509Certificate)this.get(certificate);
    }

    @Generated
    public void setCertificate(BX509Certificate v) {
        this.set(certificate, (BValue)v, null);
    }

    @Generated
    public BAbsTimeRange getCertificateValidityRange() {
        return (BAbsTimeRange)this.get(certificateValidityRange);
    }

    @Generated
    public void setCertificateValidityRange(BAbsTimeRange v) {
        this.set(certificateValidityRange, (BValue)v, null);
    }

    @Generated
    public BAbsTime getRequestSubmittedTime() {
        return (BAbsTime)this.get(requestSubmittedTime);
    }

    @Generated
    public void setRequestSubmittedTime(BAbsTime v) {
        this.set(requestSubmittedTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastRejectionTime() {
        return (BAbsTime)this.get(lastRejectionTime);
    }

    @Generated
    public void setLastRejectionTime(BAbsTime v) {
        this.set(lastRejectionTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getAutoRemovalTime() {
        return (BAbsTime)this.get(autoRemovalTime);
    }

    @Generated
    public void setAutoRemovalTime(BAbsTime v) {
        this.set(autoRemovalTime, (BValue)v, null);
    }

    @Generated
    public String getCaFingerprint() {
        return this.getString(caFingerprint);
    }

    @Generated
    public void setCaFingerprint(String v) {
        this.setString(caFingerprint, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BCertificateSigningRecord make(String requesterId) {
        BCertificateSigningRecord record = new BCertificateSigningRecord();
        record.setRequesterId(requesterId);
        return record;
    }

    public void transitionState(BSigningRequestState newReqState) throws SigningServiceException {
        if (this.getRequestState().equals((Object)newReqState)) {
            return;
        }
        this.getRequestState().checkTransitionPermitted(newReqState);
        BCertificateSigningRecord.checkPermittedState(this.getCertificateState(), newReqState);
        this.setRequestState(newReqState);
    }

    public void transitionState(BSigningCertificateState newCertState) throws SigningServiceException {
        this.doTransitionState(newCertState, null);
    }

    private void doTransitionState(BSigningCertificateState newCertState, Context cx) throws SigningServiceException {
        if (this.getCertificateState().equals((Object)newCertState)) {
            return;
        }
        this.getCertificateState().checkTransitionPermitted(newCertState);
        BCertificateSigningRecord.checkPermittedState(newCertState, this.getRequestState());
        this.set(certificateState, (BValue)newCertState, cx);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BISigningServiceStore;
    }

    public boolean isChildLegal(BComponent child) {
        return false;
    }

    public void started() {
        if (Sys.isStationStarted()) {
            this.updateProperties();
        }
    }

    public void stationStarted() {
        if (this.getRequestState().equals((Object)BSigningRequestState.pending)) {
            AccessController.doPrivileged(() -> {
                this.setRequestState(BSigningRequestState.rejected);
                return null;
            });
        }
    }

    public void changed(Property prop, Context context) {
        if (this.isRunning()) {
            boolean requestStateChanged = prop.equals(requestState);
            if (requestStateChanged) {
                if (this.getRequestState().equals((Object)BSigningRequestState.pending)) {
                    AccessController.doPrivileged(() -> {
                        this.setRequestSubmittedTime(BAbsTime.now());
                        return null;
                    });
                } else if (this.getRequestState().equals((Object)BSigningRequestState.rejected)) {
                    AccessController.doPrivileged(() -> {
                        this.setLastRejectionTime(BAbsTime.now());
                        return null;
                    });
                }
            }
            if (context != SKIP_UPDATE_CX && (requestStateChanged || prop.equals(certificate) || prop.equals(certificateState))) {
                this.updateProperties();
            }
        }
        super.changed(prop, context);
    }

    public String toString(Context cx) {
        BFrozenEnum state;
        switch (this.getRequestState().getOrdinal()) {
            case 0: 
            case 1: {
                state = this.getRequestState();
                break;
            }
            default: {
                state = this.getCertificateState();
            }
        }
        String statusString = state.toString(cx);
        String stationName = SigningServiceUtils.readStationNameFromMetadataString(this.getMetadata());
        stationName = String.format("%1.25s", stationName);
        String msg = this.getMessage();
        if (!msg.isEmpty()) {
            return SigningServiceUtils.LEX.getText(ERROR_TEXT, new Object[]{stationName, statusString, msg});
        }
        if (state == BSigningCertificateState.active && this.getParent() instanceof BSigningRecordStore) {
            BSigningRecordStore store = (BSigningRecordStore)this.getParent().as(BSigningRecordStore.class);
            long millisRemaining = this.getCertificateValidityRange().getEndTime().getMillis() - BAbsTime.now().getMillis();
            millisRemaining = Math.max(0L, millisRemaining);
            if (store != null && millisRemaining <= store.getProximityToCertificateExpirationForAlerts().getMillis()) {
                long daysRemaining = BRelTime.make((long)millisRemaining).getDays();
                return SigningServiceUtils.LEX.getText(EXPIRING_SOON_TEXT, new Object[]{stationName, statusString, daysRemaining});
            }
        }
        return SigningServiceUtils.LEX.getText(SUMMARY_TEXT, new Object[]{stationName, statusString});
    }

    public BIcon getIcon() {
        switch (this.getRequestState().getOrdinal()) {
            case 1: {
                return REJECTED_OR_EXPIRED_ICON;
            }
            case 2: {
                if (this.getCertificateState().equals((Object)BSigningCertificateState.active)) {
                    return ACTIVE_ICON;
                }
                if (this.getCertificateState().equals((Object)BSigningCertificateState.inGracePeriod)) {
                    return GRACE_PERIOD_ICON;
                }
                if (!this.getCertificateState().equals((Object)BSigningCertificateState.expired)) break;
                return REJECTED_OR_EXPIRED_ICON;
            }
        }
        return PENDING_ICON;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        BCertificateSigningRecord.doValidateSet(context);
    }

    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        BCertificateSigningRecord.doValidateSet(context);
    }

    private static void doValidateSet(Context context) {
        if (context != null && context.getUser() != null) {
            throw new LocalizableRuntimeException("signingService", "signing.service.illegalManualPropertyChange");
        }
        SigningServiceUtils.checkSecurity();
    }

    public void updateProperties() {
        X509Certificate cert;
        if (!this.isRunning()) {
            return;
        }
        if (this.getRequestSubmittedTime().equals((Object)BAbsTime.DEFAULT)) {
            AccessController.doPrivileged(() -> {
                this.setRequestSubmittedTime(BAbsTime.now());
                return null;
            });
        }
        if (this.getRequestState().equals((Object)BSigningRequestState.rejected)) {
            if (this.getLastRejectionTime().equals((Object)BAbsTime.DEFAULT)) {
                AccessController.doPrivileged(() -> {
                    this.setLastRejectionTime(BAbsTime.now());
                    return null;
                });
            }
            BAbsTime newAutoRemovalTime = this.getLastRejectionTime().add(this.getUnfulfilledRequestExpirationPeriod());
            if (!this.getAutoRemovalTime().equals((Object)newAutoRemovalTime)) {
                AccessController.doPrivileged(() -> {
                    this.setAutoRemovalTime(newAutoRemovalTime);
                    return null;
                });
            }
        }
        BAbsTime computedAutoRemovalTime = null;
        if (this.getCertificate() != BX509Certificate.DEFAULT && (cert = this.getCertificate().getX509Certificate()) != null) {
            BAbsTime startValidity = BAbsTime.make((long)cert.getNotBefore().getTime());
            BAbsTime endValidity = BAbsTime.make((long)cert.getNotAfter().getTime());
            if (!startValidity.equals((Object)this.getCertificateValidityRange().getStartTime()) || !endValidity.equals((Object)this.getCertificateValidityRange().getEndTime())) {
                AccessController.doPrivileged(() -> {
                    this.setCertificateValidityRange(new BAbsTimeRange(startValidity, endValidity));
                    return null;
                });
            }
            computedAutoRemovalTime = endValidity.add(this.getExpiredCertificateGracePeriod());
            if (!this.getCertificateState().equals((Object)BSigningCertificateState.none)) {
                BAbsTime now = BAbsTime.now();
                if (now.getMillis() >= computedAutoRemovalTime.getMillis()) {
                    if (!this.getCertificateState().equals((Object)BSigningCertificateState.expired)) {
                        AccessController.doPrivileged(() -> {
                            block2: {
                                try {
                                    this.doTransitionState(BSigningCertificateState.expired, SKIP_UPDATE_CX);
                                }
                                catch (Exception e) {
                                    if (!SigningServiceUtils.LOG.isLoggable(Level.FINE)) break block2;
                                    SigningServiceUtils.LOG.log(Level.FINE, "Failed to transition to " + (Object)((Object)BSigningCertificateState.expired) + " for " + this.toPathString(), e);
                                }
                            }
                            return null;
                        });
                    }
                } else if (now.getMillis() >= endValidity.getMillis() && !this.getCertificateState().equals((Object)BSigningCertificateState.inGracePeriod)) {
                    AccessController.doPrivileged(() -> {
                        block2: {
                            try {
                                this.doTransitionState(BSigningCertificateState.inGracePeriod, SKIP_UPDATE_CX);
                            }
                            catch (Exception e) {
                                if (!SigningServiceUtils.LOG.isLoggable(Level.FINE)) break block2;
                                SigningServiceUtils.LOG.log(Level.FINE, "Failed to transition to " + (Object)((Object)BSigningCertificateState.inGracePeriod) + " for " + this.toPathString(), e);
                            }
                        }
                        return null;
                    });
                }
            }
        }
        if (!this.getRequestState().equals((Object)BSigningRequestState.rejected)) {
            if (this.getRequestState().equals((Object)BSigningRequestState.pending)) {
                BAbsTime requestExpirationTime = this.getRequestSubmittedTime().add(this.getUnfulfilledRequestExpirationPeriod());
                if (computedAutoRemovalTime == null || computedAutoRemovalTime.getMillis() < requestExpirationTime.getMillis()) {
                    computedAutoRemovalTime = requestExpirationTime;
                }
            }
            if (computedAutoRemovalTime != null && !this.getAutoRemovalTime().equals(computedAutoRemovalTime)) {
                BAbsTime newAutoRemovalTime = computedAutoRemovalTime;
                AccessController.doPrivileged(() -> {
                    this.setAutoRemovalTime(newAutoRemovalTime);
                    return null;
                });
            }
        }
    }

    private static void checkPermittedState(BSigningCertificateState certState, BSigningRequestState requestState) throws SigningServiceException {
        if (!permittedStates.get((Object)certState).contains((Object)requestState)) {
            throw new SigningServiceException("signingService", "signing.service.state.illegal", new Object[]{certState, requestState});
        }
    }

    private BRelTime getUnfulfilledRequestExpirationPeriod() {
        BComplex parent = this.getParent();
        if (parent instanceof BSigningRecordStore) {
            return ((BSigningRecordStore)parent).getUnfulfilledRequestExpirationPeriod();
        }
        return (BRelTime)BSigningRecordStore.unfulfilledRequestExpirationPeriod.getDefaultValue();
    }

    private BRelTime getExpiredCertificateGracePeriod() {
        BComplex parent = this.getParent();
        if (parent instanceof BSigningRecordStore) {
            return ((BSigningRecordStore)parent).getExpiredCertificateGracePeriod();
        }
        return (BRelTime)BSigningRecordStore.expiredCertificateGracePeriod.getDefaultValue();
    }

    public static void resetRecord(BCertificateSigningRecord record) {
        for (Property prop : record.getFrozenPropertiesArray()) {
            if (requesterId.equals(prop)) continue;
            record.set(prop, prop.getDefaultValue(), SKIP_UPDATE_CX);
        }
    }

    static {
        permittedStates.put(BSigningCertificateState.none, Collections.unmodifiableSet(new HashSet<BSigningRequestState>(Arrays.asList(BSigningRequestState.pending, BSigningRequestState.rejected))));
        permittedStates.put(BSigningCertificateState.active, Collections.unmodifiableSet(new HashSet<BSigningRequestState>(Arrays.asList(BSigningRequestState.pending, BSigningRequestState.rejected, BSigningRequestState.complete))));
        permittedStates.put(BSigningCertificateState.inGracePeriod, Collections.unmodifiableSet(new HashSet<BSigningRequestState>(Arrays.asList(BSigningRequestState.pending, BSigningRequestState.rejected, BSigningRequestState.complete))));
        permittedStates.put(BSigningCertificateState.expired, Collections.singleton(BSigningRequestState.complete));
        SKIP_UPDATE_CX = new BasicContext(){

            public boolean equals(Object obj) {
                return this == obj;
            }

            public int hashCode() {
                return this.toString().hashCode();
            }

            public String toString() {
                return "CertificateSigningRecord.skipUpdate";
            }
        };
    }
}

