/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.program.ui.batch;

import com.tridium.bql.BSelect;
import com.tridium.bql.SelectQuery;
import com.tridium.bql.expression.BPath;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.program.batch.BAddSlotBatchRoutine;
import com.tridium.program.batch.BAddTagBatchRoutine;
import com.tridium.program.batch.BBatchRoutine;
import com.tridium.program.batch.BEditSlotBatchRoutine;
import com.tridium.program.batch.BRemoveSlotBatchRoutine;
import com.tridium.program.batch.BSlotFlagsBatchRoutine;
import com.tridium.program.ui.batch.BAddDialog;
import com.tridium.program.ui.batch.BBatchEditor;
import com.tridium.program.ui.batch.BBatchTable;
import com.tridium.program.ui.batch.BRemoveDialog;
import com.tridium.program.ui.batch.BRenameDialog;
import com.tridium.program.ui.batch.BSetDialog;
import com.tridium.program.ui.batch.BSetFlagsDialog;
import com.tridium.workbench.bql.builder.BBqlQueryBuilder;
import com.tridium.workbench.util.BEditTagDialog;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdQuery;
import javax.baja.query.BExpression;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.util.Columns;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;

public class BatchCommands {
    private static final Version MIN_REMOTE_BATCH_ROUTINE_VERSION = new Version("4.4.73.24.2");
    private static final Logger log = Logger.getLogger("program");
    private static BModule module = Sys.getModuleForClass(BBatchEditor.class);
    private static Lexicon lex = Lexicon.make((String)"program");
    private BBatchEditor editor;
    private BBqlQueryBuilder builder;
    FindObjects findObjects;
    Clear clear;
    ClearAll clearAll;
    SelectColumns selectCols;
    Rename rename;
    SlotAdd slotAdd;
    TagAdd tagAdd;
    SlotEdit slotEdit;
    SlotRename slotRename;
    SlotRemove slotRemove;
    SlotFlags slotFlags;
    Hyperlink hyperlink;

    public BatchCommands(BBatchEditor editor) {
        this.editor = editor;
        this.findObjects = new FindObjects();
        this.clear = new Clear();
        this.clearAll = new ClearAll();
        this.selectCols = new SelectColumns();
        this.rename = new Rename();
        this.slotAdd = new SlotAdd();
        this.tagAdd = new TagAdd();
        this.slotEdit = new SlotEdit();
        this.slotRename = new SlotRename();
        this.slotRemove = new SlotRemove();
        this.slotFlags = new SlotFlags();
        this.hyperlink = new Hyperlink();
    }

    public void updateCommands() {
        boolean a = this.editor.table.getModel().getRowCount() > 0;
        boolean b = this.editor.table.getSelection().getRows().length > 0;
        boolean c = this.editor.table.getSelection().getRows().length == 1;
        this.findObjects.setEnabled(true);
        this.clear.setEnabled(a && b);
        this.clearAll.setEnabled(a);
        this.selectCols.setEnabled(a);
        this.rename.setEnabled(a);
        this.slotAdd.setEnabled(a);
        this.tagAdd.setEnabled(a);
        this.slotEdit.setEnabled(a);
        this.slotRename.setEnabled(a);
        this.slotRemove.setEnabled(a);
        this.slotFlags.setEnabled(a);
        this.hyperlink.setEnabled(a && c);
    }

    public BMenu buildMenu() {
        BMenu menu = new BMenu(lex.getText("batchEditor"));
        menu.add(null, (Command)this.findObjects);
        menu.add(null, (Command)this.clear);
        menu.add(null, (Command)this.clearAll);
        menu.add(null, (Command)this.selectCols);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, (Command)new PasteCommand((BTransferWidget)this.editor.table));
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, (Command)this.rename);
        menu.add(null, (Command)this.slotAdd);
        menu.add(null, (Command)this.slotEdit);
        menu.add(null, (Command)this.slotRename);
        menu.add(null, (Command)this.slotRemove);
        menu.add(null, (Command)this.slotFlags);
        menu.add(null, (BValue)new BSeparator());
        menu.add(null, (Command)this.hyperlink);
        return menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchRoutine(BBatchRoutine routine) {
        this.editor.enterBusy();
        this.editor.disableCommands();
        BOrd[] ords = new BOrd[this.editor.table.model.kids.size()];
        for (int i = 0; i < ords.length; ++i) {
            ords[i] = this.editor.table.model.kids.get(i).getHandleOrd();
        }
        routine.setTargets(BOrdList.make((BOrd[])ords));
        try {
            String results;
            BFoxSession session = (BFoxSession)this.editor.getCurrentValueSession();
            Version remoteVersion = (Version)session.fw(404, (Object)"program", (Object)"rt", null, null);
            if (remoteVersion != null && remoteVersion.compareTo(MIN_REMOTE_BATCH_ROUTINE_VERSION) > -1) {
                results = this.editor.service.runBatchRoutine(routine).getString();
            } else {
                log.fine(lex.getText("batchEditor.runClientSide", new Object[]{remoteVersion, MIN_REMOTE_BATCH_ROUTINE_VERSION}));
                Subscriber subscriber = Subscriber.make(event -> {});
                try {
                    BComponent[] components = this.editor.table.model.kids.toArray(new BComponent[0]);
                    subscriber.subscribe(components, 0, null);
                    results = this.editor.service.doRunBatchRoutine(routine, null).getString();
                }
                finally {
                    subscriber.unsubscribeAll();
                }
            }
            this.editor.exitBusy();
            this.editor.enableCommands();
            BTextEditor out = new BTextEditor(results, false);
            BTextEditorPane pane = new BTextEditorPane(out, 20, 100);
            BDialog.open((BWidget)this.editor, (String)"BatchEditor Results", (Object)pane, (int)1);
        }
        catch (Exception e) {
            this.editor.exitBusy();
            this.editor.enableCommands();
            BDialog.error((BWidget)this.editor, (String)"Error", (Object)"Commit Failed", (Throwable)e);
        }
    }

    static void lease(BComponent[] comps) {
        try {
            BComponent.lease((BComponent[])comps, (int)0, (long)60000L);
        }
        catch (Throwable e) {
            System.out.println("Error leasing Components...");
            e.printStackTrace();
            for (BComponent comp : comps) {
                try {
                    comp.lease(0, 60000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    class Hyperlink
    extends BatchCommand {
        public Hyperlink() {
            super("hyperlink");
        }

        public CommandArtifact doInvoke() {
            int[] rows = ((BatchCommands)BatchCommands.this).editor.table.getSelection().getRows();
            BComponent c = ((BatchCommands)BatchCommands.this).editor.table.model.kids.get(rows[0]);
            BOrd ord = BOrd.make((String)("station:|" + c.getSlotPath()));
            BatchCommands.this.editor.getWbShell().hyperlink(ord);
            return null;
        }
    }

    class TagAdd
    extends BatchCommand {
        public TagAdd() {
            super("tagAdd");
        }

        public CommandArtifact doInvoke() {
            BComponent tags = BEditTagDialog.open((BWbShell)BatchCommands.this.editor.getWbShell(), (String)"AddTag", (BComponent)((BatchCommands)BatchCommands.this).editor.service, (boolean)true);
            if (tags != null) {
                BAddTagBatchRoutine routine = BAddTagBatchRoutine.make((BComponent)tags);
                BatchCommands.this.runBatchRoutine((BBatchRoutine)routine);
            }
            return null;
        }
    }

    class SlotFlags
    extends BatchCommand {
        public SlotFlags() {
            super("slotFlags");
        }

        public CommandArtifact doInvoke() {
            BSlotFlagsBatchRoutine routine = BSetFlagsDialog.open(BatchCommands.this.editor);
            if (routine != null) {
                BatchCommands.this.runBatchRoutine((BBatchRoutine)routine);
            }
            return null;
        }
    }

    class SlotRemove
    extends BatchCommand {
        public SlotRemove() {
            super("slotRemove");
        }

        public CommandArtifact doInvoke() {
            BRemoveSlotBatchRoutine routine = BRemoveDialog.open(BatchCommands.this.editor);
            if (routine != null) {
                BatchCommands.this.runBatchRoutine((BBatchRoutine)routine);
            }
            return null;
        }
    }

    class SlotRename
    extends BatchCommand {
        public SlotRename() {
            super("slotRename");
        }

        public CommandArtifact doInvoke() {
            BBatchRoutine routine = BRenameDialog.open(BatchCommands.this.editor, true);
            if (routine != null) {
                BatchCommands.this.runBatchRoutine(routine);
            }
            return null;
        }
    }

    class SlotEdit
    extends BatchCommand {
        public SlotEdit() {
            super("slotEdit");
        }

        public CommandArtifact doInvoke() {
            BEditSlotBatchRoutine routine = BSetDialog.open(BatchCommands.this.editor);
            if (routine != null) {
                BatchCommands.this.runBatchRoutine((BBatchRoutine)routine);
            }
            return null;
        }
    }

    class SlotAdd
    extends BatchCommand {
        public SlotAdd() {
            super("slotAdd");
        }

        public CommandArtifact doInvoke() {
            BAddSlotBatchRoutine routine = BAddDialog.open(BatchCommands.this.editor);
            if (routine != null) {
                BatchCommands.this.runBatchRoutine((BBatchRoutine)routine);
            }
            return null;
        }
    }

    class Rename
    extends BatchCommand {
        public Rename() {
            super("rename");
        }

        public CommandArtifact doInvoke() {
            BBatchRoutine routine = BRenameDialog.open(BatchCommands.this.editor, false);
            if (routine != null) {
                BatchCommands.this.runBatchRoutine(routine);
            }
            return null;
        }
    }

    class SelectColumns
    extends BatchCommand {
        public SelectColumns() {
            super("selectColumns");
        }

        public CommandArtifact doInvoke() {
            String[] cols;
            BBatchTable.Model model = ((BatchCommands)BatchCommands.this).editor.table.model;
            BCheckList list = new BCheckList();
            for (String col : cols = model.getAllColumns()) {
                list.getModel().addItem((Object)col);
            }
            for (int i = 1; i < model.cols.size(); ++i) {
                int index = list.indexOfItem((Object)model.cols.get(i));
                if (index < 0) continue;
                list.getSelection().select(index);
            }
            BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)list, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
            pane.setMinWidth(300.0);
            pane.setMaxWidth(300.0);
            pane.setMinHeight(300.0);
            pane.setMaxHeight(400.0);
            if (1 == BDialog.open((BWidget)BatchCommands.this.editor, (String)lex.getText("batchEditor.commands.selectColumns.label"), (Object)pane, (int)3)) {
                int[] items;
                String path = ((BatchCommands)BatchCommands.this).editor.table.model.cols.get(0);
                model.cols.clear();
                model.cols.add(path);
                for (int item : items = list.getSelection().getItems()) {
                    model.cols.add((String)list.getItem(item));
                }
                ((BatchCommands)BatchCommands.this).editor.table.sizeColumnsToFit();
                ((BatchCommands)BatchCommands.this).editor.table.relayout();
            }
            return null;
        }
    }

    class ClearAll
    extends BatchCommand {
        public ClearAll() {
            super("clearAll");
        }

        public CommandArtifact doInvoke() {
            while (!((BatchCommands)BatchCommands.this).editor.table.model.kids.isEmpty()) {
                ((BatchCommands)BatchCommands.this).editor.table.model.kids.remove(0);
            }
            BatchCommands.this.updateCommands();
            ((BatchCommands)BatchCommands.this).editor.table.sizeColumnsToFit();
            ((BatchCommands)BatchCommands.this).editor.table.relayout();
            BatchCommands.this.editor.updateObjectCount(0);
            BatchCommands.this.editor.updateModel(((BatchCommands)BatchCommands.this).editor.table.model);
            return null;
        }
    }

    class Clear
    extends BatchCommand {
        public Clear() {
            super("clear");
        }

        public CommandArtifact doInvoke() {
            int rowCount = ((BatchCommands)BatchCommands.this).editor.table.model.kids.size();
            int[] rows = ((BatchCommands)BatchCommands.this).editor.table.getSelection().getRows();
            ((BatchCommands)BatchCommands.this).editor.table.getSelection().deselectAll();
            for (int i = 0; i < rows.length; ++i) {
                ((BatchCommands)BatchCommands.this).editor.table.getSelection().deselectAll();
                ((BatchCommands)BatchCommands.this).editor.table.model.kids.remove(rows[i] - i);
            }
            BatchCommands.this.updateCommands();
            ((BatchCommands)BatchCommands.this).editor.table.sizeColumnsToFit();
            ((BatchCommands)BatchCommands.this).editor.table.relayout();
            BatchCommands.this.editor.updateObjectCount(rowCount - rows.length);
            BatchCommands.this.editor.updateModel(((BatchCommands)BatchCommands.this).editor.table.model);
            return null;
        }
    }

    class FindObjects
    extends BatchCommand {
        public FindObjects() {
            super("findObjects");
        }

        public CommandArtifact doInvoke() {
            BOrd ord;
            if (BatchCommands.this.builder == null) {
                BatchCommands.this.builder = new BBqlQueryBuilder((BObject)((BatchCommands)BatchCommands.this).editor.service, BOrd.NULL, false);
            }
            if ((ord = BatchCommands.this.builder.open((BWidget)BatchCommands.this.editor)) != null && !ord.isNull()) {
                OrdQuery[] query = ord.parse();
                SelectQuery q = (SelectQuery)query[query.length - 1];
                BSelect s = q.getSelect();
                BPath path = new BPath("toPathString");
                if (s.hasProjection() && s.getProjection().isDistinct()) {
                    s.select(Columns.distinctProjection().add(Columns.make((BExpression)path)));
                } else {
                    s.select(Columns.projection((BProjectionColumn)Columns.make((BExpression)path)));
                }
                query[query.length - 1] = new SelectQuery(s);
                ord = BOrd.make((OrdQuery[])query);
                BITable table = (BITable)ord.resolve((BObject)((BatchCommands)BatchCommands.this).editor.service).get();
                ColumnList cols = table.getColumns();
                ArrayList<BComponent> toLease = new ArrayList<BComponent>();
                try (TableCursor c = table.cursor();){
                    while (c.next()) {
                        BOrd temp = BOrd.make((String)("station:|slot:" + c.cell(cols.get(0))));
                        temp = BOrd.make((BOrd)BatchCommands.this.editor.getWbShell().getActiveOrd(), (BOrd)temp).normalize();
                        BObject obj = temp.resolve().get();
                        if (!(obj instanceof BComponent) || ((BatchCommands)BatchCommands.this).editor.table.model.kids.contains(obj)) continue;
                        toLease.add((BComponent)obj);
                        ((BatchCommands)BatchCommands.this).editor.table.model.kids.add((BComponent)obj);
                    }
                }
                BatchCommands.lease(toLease.toArray(new BComponent[0]));
                ((BatchCommands)BatchCommands.this).editor.table.sizeColumnsToFit();
                ((BatchCommands)BatchCommands.this).editor.table.relayout();
                BatchCommands.this.editor.updateObjectCount(((BatchCommands)BatchCommands.this).editor.table.model.kids.size());
                BatchCommands.this.editor.updateModel(((BatchCommands)BatchCommands.this).editor.table.model);
                BatchCommands.this.updateCommands();
            }
            return null;
        }
    }

    abstract class BatchCommand
    extends Command {
        public BatchCommand(String lex) {
            super((BWidget)BatchCommands.this.editor, module, "batchEditor.commands." + lex);
        }
    }
}

