/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.point;

import com.tridium.csmgrbase.util.CsMgrBaseUtil;
import com.tridium.tls.datatypes.BInTankStaHistoryRecord;
import com.tridium.tls.datatypes.BInTankStatusEntry;
import com.tridium.tls.datatypes.BInTankStatusTable;
import com.tridium.tls.devices.BTls350FuelTankDevice;
import com.tridium.tls.job.BTlsReportToCsMgrJob;
import com.tridium.tls.messages.Tls350StatusReport;
import com.tridium.tls.messages.Tls350StatusReportResponse;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.point.BTls350DemuxedProxyExt;
import com.tridium.tls.point.BTls350FuelTankPointDeviceExt;
import com.tridium.tls.point.BTls350ItsDemuxedPointDeviceExt;
import com.tridium.tls.point.BTls350StringProxyExt;
import com.tridium.tls.util.TlsHistoryHelper;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.util.BIPollable;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStruct;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minimumPollInterval", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)"), @NiagaraProperty(name="inTankStatusTable", type="BInTankStatusTable", defaultValue="new BInTankStatusTable()"), @NiagaraProperty(name="maxOldEntriesSaved", type="int", defaultValue="8", facets={@Facet(value="BFacets.make(BFacets.PRECISION, BInteger.make(0))")})})
@NiagaraAction(name="purgeHashtable", flags=4)
public class BTls350InTankStaProxyExt
extends BTls350StringProxyExt
implements TlsMessageConst {
    @Generated
    public static final Property minimumPollInterval = BTls350InTankStaProxyExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), null);
    @Generated
    public static final Property inTankStatusTable = BTls350InTankStaProxyExt.newProperty((int)0, (BValue)new BInTankStatusTable(), null);
    @Generated
    public static final Property maxOldEntriesSaved = BTls350InTankStaProxyExt.newProperty((int)0, (int)8, (BFacets)BFacets.make((String)"precision", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Action purgeHashtable = BTls350InTankStaProxyExt.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350InTankStaProxyExt.class);
    private Vector<BInTankStatusEntry> iTSEntriesVector;
    private Hashtable<Long, BInTankStatusEntry> iTSHashtable;
    private Clock.Ticket purgeHashtableValuesTicket;
    private boolean purgeHashtableValuesFlag;

    @Generated
    public BRelTime getMinimumPollInterval() {
        return (BRelTime)this.get(minimumPollInterval);
    }

    @Generated
    public void setMinimumPollInterval(BRelTime v) {
        this.set(minimumPollInterval, (BValue)v, null);
    }

    @Generated
    public BInTankStatusTable getInTankStatusTable() {
        return (BInTankStatusTable)this.get(inTankStatusTable);
    }

    @Generated
    public void setInTankStatusTable(BInTankStatusTable v) {
        this.set(inTankStatusTable, (BValue)v, null);
    }

    @Generated
    public int getMaxOldEntriesSaved() {
        return this.getInt(maxOldEntriesSaved);
    }

    @Generated
    public void setMaxOldEntriesSaved(int v) {
        this.setInt(maxOldEntriesSaved, v, null);
    }

    @Generated
    public void purgeHashtable() {
        this.invoke(purgeHashtable, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public Type getDeviceExtType() {
        return BTls350FuelTankPointDeviceExt.TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.isRunning()) {
            BInTankStatusEntry[] saved = this.getInTankStatusTable().getEntries();
            this.iTSHashtable = new Hashtable(saved.length * 2);
            for (int i = 0; i < saved.length; ++i) {
                Long key = saved[i].getValueHashCode();
                this.iTSHashtable.put(key, saved[i]);
            }
            TlsHistoryHelper.initHistory(BInTankStaHistoryRecord.TYPE);
            this.reschedPurgeHashtable();
            this.network().getPollScheduler().subscribe((BIPollable)this);
        }
    }

    public void stopped() throws Exception {
        this.network().getPollScheduler().unsubscribe((BIPollable)this);
        this.iTSHashtable = null;
        super.stopped();
    }

    @Override
    public void poll() {
        if (!(this.getDevice().getEnabled() && this.getEnabled() && this.pollIntervalCheck(this.getMinimumPollInterval().getMillis()))) {
            return;
        }
        this.pollForDataNow();
    }

    public void pollForDataNow() {
        boolean pollDebug = this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1;
        int tankNumber = ((BTls350FuelTankDevice)this.device()).getTankNumber();
        Tls350StatusReport req = new Tls350StatusReport(tankNumber, this);
        Tls350StatusReportResponse rsp = (Tls350StatusReportResponse)this.network().sendSync(req);
        if (rsp != null) {
            if (rsp.getSuccessfulResponse()) {
                int[] alarmTypes;
                this.device().setPollSinceLastPingFlag();
                if (tankNumber == 0) {
                    System.out.println(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! proxy point's tank number not initialized... initialize tank number to valid tank\n\n");
                    return;
                }
                if (tankNumber != rsp.getMessageTank()) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... WARNING!!! poll response with entries has wrong tank number... entry for tankNumber=" + rsp.getMessageTank() + " may be lost\n\n");
                    }
                    return;
                }
                BAbsTime rt = rsp.getReadTime();
                if (rt == null) {
                    rt = BAbsTime.make();
                }
                if ((alarmTypes = rsp.getAlarmTypes()).length == 0) {
                    if (pollDebug) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + "... poll response contains no alarm entries... nothing to record tankNumber=" + rsp.getMessageTank() + " alarmTypes.length=" + alarmTypes.length);
                    }
                    return;
                }
                this.iTSEntriesVector = new Vector();
                boolean newEntryDetected = false;
                String stationName = Sys.getStation().getStationName();
                for (int i = alarmTypes.length - 1; i > -1; --i) {
                    BInTankStatusEntry newITSEntry = new BInTankStatusEntry(stationName, tankNumber, rt, alarmTypes[i]);
                    BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
                    if (newITSEntry.getReadTime().isBefore(previousTime)) {
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newITSEntry.createCommaDelimitedString() + " for " + this.getName());
                        continue;
                    }
                    Long newHtKey = newITSEntry.getValueHashCode();
                    if (this.iTSHashtable == null || this.iTSHashtable.get(newHtKey) == null || newEntryDetected) {
                        this.iTSHashtable.put(newHtKey, newITSEntry);
                        this.iTSEntriesVector.addElement(newITSEntry);
                        newEntryDetected = true;
                        if (!pollDebug) continue;
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow add... new entry = " + newITSEntry.createCommaDelimitedString());
                        continue;
                    }
                    if (!pollDebug) continue;
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow skip... old entry = " + newITSEntry.createCommaDelimitedString());
                }
                if (this.iTSEntriesVector.size() > 0) {
                    BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                    String newValue = rsp.createCommaDelimitedString();
                    if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                        this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :setValue... newest value = " + newValue);
                    }
                    sv.setValue(newValue);
                    this.readOk((BStatusValue)sv);
                    this.setValue(this.iTSEntriesVector);
                    return;
                }
                BStatusString sv = (BStatusString)this.getReadValue().newCopy();
                this.readOk((BStatusValue)sv);
                this.updateDemuxedProxyPoints();
            } else {
                if (pollDebug) {
                    this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... response is error!");
                }
                this.readFail("Error Response");
            }
        } else {
            if (pollDebug) {
                this.getLog().trace(this.device().getName() + " : " + this.getParentPoint().getName() + " :pollForDataNow... no response!");
            }
            this.readFail("No Response");
            this.device().ping();
        }
        if (this.purgeHashtableValuesFlag) {
            this.purgeOldHashtableValues();
        }
    }

    public void setValue(Vector<BInTankStatusEntry> values) {
        BInTankStatusEntry[] valuesCopy = new BInTankStatusEntry[values.size()];
        values.copyInto((Object[])valuesCopy);
        BInTankStatusTable sendToCsMgrCopy = new BInTankStatusTable();
        for (int i = 0; i < valuesCopy.length; ++i) {
            try {
                this.getInTankStatusTable().add("inTankStatusEntry?", (BValue)valuesCopy[i]);
                sendToCsMgrCopy.add("inTankStatusEntry?", (BValue)((BInTankStatusEntry)valuesCopy[i].newCopy()));
                BInTankStaHistoryRecord newrec = new BInTankStaHistoryRecord(BAbsTime.make((long)System.currentTimeMillis()), valuesCopy[i]);
                TlsHistoryHelper.appendTlsHistory((BStruct)newrec);
                continue;
            }
            catch (Exception e) {
                this.readFail(e.toString());
            }
        }
        this.updateDemuxedProxyPoints();
        BInTankStatusEntry[] sortedValues = this.getInTankStatusTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        int numRemoveEntries = sortedValues.length - this.getMaxOldEntriesSaved();
        if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
            this.getLog().trace("BTls350InTankStaProxyExt setValue sortedValues.length=" + sortedValues.length + " | getMaxOldEntriesSaved()=" + this.getMaxOldEntriesSaved());
        }
        if (numRemoveEntries > 0) {
            Vector<BInTankStatusEntry> removeEntries = new Vector<BInTankStatusEntry>();
            for (int i = 0; i < numRemoveEntries; ++i) {
                removeEntries.addElement(sortedValues[i]);
            }
            Enumeration re = removeEntries.elements();
            while (re.hasMoreElements()) {
                BInTankStatusEntry oldestEntryCopy = (BInTankStatusEntry)((Object)re.nextElement());
                if (this.isTraceOn() && this.device().getUserData().indexOf("poll") != -1) {
                    this.getLog().trace("BTls350InTankStaProxyExt setValue  maxEntriesForView=" + this.getMaxOldEntriesSaved() + " exceeded...remove oldest value = " + oldestEntryCopy.createCommaDelimitedString());
                }
                this.getInTankStatusTable().remove((BComplex)oldestEntryCopy);
            }
        }
        this.network().postWrite(new BTlsReportToCsMgrJob(this, sendToCsMgrCopy));
    }

    private void updateDemuxedProxyPoints() {
        BInTankStatusEntry[] sortedValues = this.getInTankStatusTable().getSortedCopy();
        if (sortedValues == null || sortedValues.length == 0) {
            return;
        }
        BInTankStatusEntry mostRecentValue = sortedValues[sortedValues.length - 1];
        String[] demuxedValueStrings = CsMgrBaseUtil.createStringArrayOfAllNames((String)mostRecentValue.createCommaDelimitedString());
        if (demuxedValueStrings != null && demuxedValueStrings.length > 0) {
            BControlPoint[] dCPA;
            BTls350ItsDemuxedPointDeviceExt itsdExt = null;
            BDeviceExt[] exts = this.getDevice().getDeviceExts();
            for (int k = 0; k < exts.length; ++k) {
                if (!(exts[k] instanceof BTls350ItsDemuxedPointDeviceExt)) continue;
                itsdExt = (BTls350ItsDemuxedPointDeviceExt)exts[k];
                break;
            }
            if (itsdExt != null && (dCPA = itsdExt.getPoints()) != null && dCPA.length > 0) {
                for (int k = 0; k < dCPA.length; ++k) {
                    if (dCPA[k].getProxyExt().getType() != BTls350DemuxedProxyExt.TYPE) continue;
                    ((BTls350DemuxedProxyExt)dCPA[k].getProxyExt()).updateValueFrom(demuxedValueStrings);
                }
            }
        }
    }

    @Override
    public void readDataNow() {
        this.pollForDataNow();
    }

    @Override
    public void clearDataNow() {
        this.getInTankStatusTable().lease(2);
        BInTankStatusEntry[] itse = (BInTankStatusEntry[])this.getInTankStatusTable().getChildren(BInTankStatusEntry.class);
        if (itse != null && itse.length > 0) {
            for (int i = 0; i < itse.length; ++i) {
                this.getInTankStatusTable().remove((BComplex)itse[i]);
            }
        }
        this.iTSHashtable = new Hashtable(20);
    }

    public void doPurgeHashtable(Context cx) throws Exception {
        this.purgeHashtableValuesFlag = true;
    }

    public void purgeOldHashtableValues() {
        Enumeration<Long> iTSkeys = this.iTSHashtable.keys();
        while (iTSkeys.hasMoreElements()) {
            Long nextKey = iTSkeys.nextElement();
            BInTankStatusEntry nextEntry = this.iTSHashtable.get(nextKey);
            BAbsTime previousTime = BAbsTime.now().subtract(this.network().getStaleDataTime());
            if (!nextEntry.getReadTime().isBefore(previousTime)) continue;
            this.iTSHashtable.remove(nextKey);
        }
        this.reschedPurgeHashtable();
    }

    private void reschedPurgeHashtable() {
        this.purgeHashtableValuesFlag = false;
        if (this.purgeHashtableValuesTicket != null) {
            this.purgeHashtableValuesTicket.cancel();
        }
        BAbsTime nextChangeOfDay = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)BTime.MIDNIGHT);
        this.purgeHashtableValuesTicket = Clock.schedule((BComponent)this, (BAbsTime)nextChangeOfDay, (Action)purgeHashtable, null);
    }
}

