/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350LiqSenDiagReportResponse;
import com.tridium.tls.messages.Tls350Message;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsReceivedMessage;
import com.tridium.tls.point.BTls350LiqSenStaProxyExt;
import javax.baja.nre.util.ByteArrayUtil;

public class Tls350LiqSenDiagReport
extends Tls350Message
implements TlsMessageConst {
    private BTls350LiqSenStaProxyExt ext;
    private boolean debug;

    public Tls350LiqSenDiagReport() {
        super("B01");
    }

    public Tls350LiqSenDiagReport(BTls350LiqSenStaProxyExt ext) {
        super("B01");
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    public Tls350LiqSenDiagReport(int sensor, BTls350LiqSenStaProxyExt ext) {
        super("B01", sensor);
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    @Override
    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        if (this.debug) {
            this.ext.getLog().trace("TlsLSSReponse :toResponse []=" + ByteArrayUtil.toHexString((byte[])rmBytes, (int)0, (int)rmBytes.length));
        }
        Tls350LiqSenDiagReportResponse rsp = new Tls350LiqSenDiagReportResponse(this.ext);
        rsp.readResponse(rmBytes);
        return rsp;
    }
}

