/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.messages.Tls350FuelManagementReportResponse;
import com.tridium.tls.messages.Tls350Message;
import com.tridium.tls.messages.TlsMessageConst;
import com.tridium.tls.messages.TlsReceivedMessage;
import com.tridium.tls.point.BTls350FuelMgmtProxyExt;
import javax.baja.nre.util.ByteArrayUtil;

public class Tls350FuelManagementReport
extends Tls350Message
implements TlsMessageConst {
    private BTls350FuelMgmtProxyExt ext;
    private boolean debug;

    public Tls350FuelManagementReport() {
    }

    public Tls350FuelManagementReport(int tank) {
        super("281", tank);
    }

    public Tls350FuelManagementReport(int tank, BTls350FuelMgmtProxyExt ext) {
        super("281", tank);
        this.ext = ext;
        this.debug = ext != null && ext.getLog().isTraceOn() && ext.device().getUserData().indexOf("msg") != -1;
    }

    @Override
    public Message toResponse(ReceivedMessage response) {
        TlsReceivedMessage rm = (TlsReceivedMessage)response;
        byte[] rmBytes = rm.getBytes();
        if (this.debug) {
            this.ext.getLog().trace("TlsFMReport :toResponse []=" + ByteArrayUtil.toHexString((byte[])rmBytes, (int)0, (int)rmBytes.length));
        }
        Tls350FuelManagementReportResponse rsp = new Tls350FuelManagementReportResponse(this.ext);
        rsp.readResponse(rmBytes);
        return rsp;
    }
}

