/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.devices;

import com.tridium.basicdriver.message.Message;
import com.tridium.tls.BTlsConsole;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.messages.TlsConsolePriorityAlarmHistoryReport;
import com.tridium.tls.messages.TlsConsolePriorityAlarmHistoryReportResponse;
import com.tridium.tls.point.BTls350ConsoleDevicePointDeviceExt;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="points", type="BTls350ConsoleDevicePointDeviceExt", defaultValue="new BTls350ConsoleDevicePointDeviceExt()")
public class BTls350ConsoleDevice
extends BTlsDevice {
    @Generated
    public static final Property points = BTls350ConsoleDevice.newProperty((int)0, (BValue)new BTls350ConsoleDevicePointDeviceExt(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTls350ConsoleDevice.class);

    @Generated
    public BTls350ConsoleDevicePointDeviceExt getPoints() {
        return (BTls350ConsoleDevicePointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BTls350ConsoleDevicePointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doPing() {
        if (this.pingForeignHardware()) {
            this.pingOk();
        } else {
            this.pingFail(this.getLexicon().getText("pingFail"));
        }
    }

    public boolean pingForeignHardware() {
        BTlsConsole network = this.network();
        boolean pingDebug = network.getLog().isTraceOn() && this.getUserData().indexOf("ping") != -1;
        String myId = network.getName() + "|" + this.getName();
        if (pingDebug) {
            network.getLog().trace("BTlsDevice entered ping method for " + myId);
        }
        if (!this.getMonitor().getPingEnabled()) {
            this.pollSinceLastPingFlag = false;
            if (pingDebug) {
                network.getLog().trace("BTlsDevice ping disabled.. ping skipped for " + myId);
            }
            return true;
        }
        if (this.pollSinceLastPingFlag) {
            this.pollSinceLastPingFlag = false;
            if (pingDebug) {
                network.getLog().trace("BTlsDevice ping skipped for " + myId);
            }
            return true;
        }
        Message rsp = network.sendSync(new TlsConsolePriorityAlarmHistoryReport());
        if (rsp == null || !(rsp instanceof TlsConsolePriorityAlarmHistoryReportResponse)) {
            if (pingDebug) {
                network.getLog().trace("BTlsDevice ping failed for " + myId);
            }
            return false;
        }
        if (pingDebug) {
            network.getLog().trace("BTlsDevice ping successful for " + myId);
        }
        return true;
    }
}

