/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.datatypes;

import com.tridium.tls.TlsConstants;
import com.tridium.tls.datatypes.BPriorityAlarmHistoryEntry;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BPriorityAlarmHistoryTable
extends BComponent
implements TlsConstants {
    @Generated
    public static final Type TYPE = Sys.loadType(BPriorityAlarmHistoryTable.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BPriorityAlarmHistoryEntry;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public synchronized BPriorityAlarmHistoryEntry[] getEntries() {
        BPriorityAlarmHistoryEntry[] known = (BPriorityAlarmHistoryEntry[])this.getChildren(BPriorityAlarmHistoryEntry.class);
        return known;
    }

    public BPriorityAlarmHistoryEntry[] getSortedCopy() {
        BPriorityAlarmHistoryEntry[] currentCopy = this.getEntries();
        if (currentCopy == null || currentCopy.length < 2) {
            return currentCopy;
        }
        Hashtable<Long, BPriorityAlarmHistoryEntry> ht = new Hashtable<Long, BPriorityAlarmHistoryEntry>(currentCopy.length * 2);
        for (int i = 0; i < currentCopy.length; ++i) {
            BAbsTime dt = currentCopy[i].getDateTimeOccurred();
            Long key = dt.getMillis() - TlsConstants.VR_DT_REFERENCE;
            boolean entryHashed = false;
            int hashTries = 10;
            while (!entryHashed) {
                if (!ht.containsKey(key)) {
                    ht.put(key, currentCopy[i]);
                    entryHashed = true;
                    continue;
                }
                if (--hashTries == 0) break;
                long tmp = key + 10L;
                key = tmp;
            }
            if (entryHashed) continue;
        }
        int sortCount = ht.size();
        Object[] sKeys = new String[sortCount];
        BPriorityAlarmHistoryEntry[] entries = new BPriorityAlarmHistoryEntry[sortCount];
        try {
            Enumeration eK = ht.keys();
            Enumeration eO = ht.elements();
            for (int i = 0; i < sortCount; ++i) {
                if (!eK.hasMoreElements() || !eO.hasMoreElements()) {
                    return null;
                }
                sKeys[i] = ((Long)eK.nextElement()).toString();
                entries[i] = (BPriorityAlarmHistoryEntry)((Object)eO.nextElement());
            }
            SortUtil.sort((Object[])sKeys, (Object[])entries);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entries;
    }
}

