/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.datatypes;

import com.tridium.tls.TlsConstants;
import com.tridium.tls.datatypes.BLiqSenAlmEntry;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BLiqSenAlmTable
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BLiqSenAlmTable.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BLiqSenAlmEntry;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public synchronized BLiqSenAlmEntry[] getEntries() {
        BLiqSenAlmEntry[] known = (BLiqSenAlmEntry[])this.getChildren(BLiqSenAlmEntry.class);
        return known;
    }

    public BLiqSenAlmEntry[] getSortedCopy() {
        BLiqSenAlmEntry[] currentCopy = this.getEntries();
        if (currentCopy == null || currentCopy.length < 2) {
            return currentCopy;
        }
        Hashtable<Long, BLiqSenAlmEntry> ht = new Hashtable<Long, BLiqSenAlmEntry>(currentCopy.length * 2);
        for (int i = 0; i < currentCopy.length; ++i) {
            BAbsTime dt = currentCopy[i].getAlarmDateTime();
            Long key = dt.getMillis() - TlsConstants.VR_DT_REFERENCE;
            boolean entryHashed = false;
            int hashTries = 10;
            while (!entryHashed) {
                if (!ht.containsKey(key)) {
                    ht.put(key, currentCopy[i]);
                    entryHashed = true;
                    continue;
                }
                if (--hashTries == 0) break;
                long tmp = key + 10L;
                key = tmp;
            }
            if (entryHashed) continue;
        }
        int sortCount = ht.size();
        Object[] sKeys = new String[sortCount];
        BLiqSenAlmEntry[] entries = new BLiqSenAlmEntry[sortCount];
        try {
            Enumeration eK = ht.keys();
            Enumeration eO = ht.elements();
            for (int i = 0; i < sortCount; ++i) {
                if (!eK.hasMoreElements() || !eO.hasMoreElements()) {
                    return null;
                }
                sKeys[i] = ((Long)eK.nextElement()).toString();
                entries[i] = (BLiqSenAlmEntry)((Object)eO.nextElement());
            }
            SortUtil.sort((Object[])sKeys, (Object[])entries);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entries;
    }
}

