/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.datatypes;

import com.tridium.tls.TlsConstants;
import com.tridium.tls.datatypes.BFuelManagementEntry;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BFuelManagementTable
extends BComponent {
    @Generated
    public static final Type TYPE = Sys.loadType(BFuelManagementTable.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return child instanceof BFuelManagementEntry;
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public synchronized BFuelManagementEntry[] getEntries() {
        BFuelManagementEntry[] known = (BFuelManagementEntry[])this.getChildren(BFuelManagementEntry.class);
        return known;
    }

    public BFuelManagementEntry[] getSortedCopy() {
        BFuelManagementEntry[] currentCopy = this.getEntries();
        if (currentCopy == null || currentCopy.length < 2) {
            return currentCopy;
        }
        Hashtable<Long, BFuelManagementEntry> ht = new Hashtable<Long, BFuelManagementEntry>(currentCopy.length * 2);
        for (int i = 0; i < currentCopy.length; ++i) {
            BAbsTime dt = currentCopy[i].getCurrentDateTime();
            Long key = dt.getMillis() - TlsConstants.VR_DT_REFERENCE;
            boolean entryHashed = false;
            int hashTries = 10;
            while (!entryHashed) {
                if (!ht.containsKey(key)) {
                    ht.put(key, currentCopy[i]);
                    entryHashed = true;
                    continue;
                }
                if (--hashTries == 0) break;
                long tmp = key + 10L;
                key = tmp;
            }
            if (entryHashed) continue;
        }
        int sortCount = ht.size();
        Object[] sKeys = new String[sortCount];
        BFuelManagementEntry[] entries = new BFuelManagementEntry[sortCount];
        try {
            Enumeration eK = ht.keys();
            Enumeration eO = ht.elements();
            for (int i = 0; i < sortCount; ++i) {
                if (!eK.hasMoreElements() || !eO.hasMoreElements()) {
                    return null;
                }
                sKeys[i] = ((Long)eK.nextElement()).toString();
                entries[i] = (BFuelManagementEntry)((Object)eO.nextElement());
            }
            SortUtil.sort((Object[])sKeys, (Object[])entries);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entries;
    }
}

