/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspPicPocUtil;

public abstract class CcnRspPocUtil
extends CcnRspPicPocUtil
implements CcnErrorCodes {
    public static int[] EXPECTED_POC_TBL_TYPES = new int[]{14, 15, 16, 18};

    public static byte[] convertTimeToByte(String timeValue) {
        byte[] bValue = new byte[]{-1, -1};
        int indexOfSemicolon = timeValue.indexOf(":");
        if (indexOfSemicolon == -1) {
            return bValue;
        }
        byte iMin = Byte.parseByte(timeValue.substring(0, indexOfSemicolon));
        byte iHour = Byte.parseByte(timeValue.substring(indexOfSemicolon + 1));
        if (iMin > 59 || iMin < 0 || iHour > 23 || iHour < 0) {
            return bValue;
        }
        bValue[0] = iMin;
        bValue[1] = iHour;
        return bValue;
    }

    public static int getDataTableType(CcnResponseMessage rsp) throws CcnException {
        CcnRspPocUtil.checkTableType(rsp.getTableType(), EXPECTED_POC_TBL_TYPES);
        int blockNo = CcnRspPocUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return ((buf[3] & 0xFF) << 8 | buf[4] & 0xFF) & 0xFFFF;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableType");
    }

    public static int getDataTableBlock(CcnResponseMessage rsp) throws CcnException {
        CcnRspPocUtil.checkTableType(rsp.getTableType(), EXPECTED_POC_TBL_TYPES);
        int blockNo = CcnRspPocUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[5] & 0xFF;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableBlock");
    }

    public static int getDataTableStrBlock(CcnResponseMessage rsp) throws CcnException {
        CcnRspPocUtil.checkTableType(rsp.getTableType(), EXPECTED_POC_TBL_TYPES);
        int blockNo = CcnRspPocUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[8] & 0xFF;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableStrBlock");
    }

    public static int getDataTableEndBlock(CcnResponseMessage rsp) throws CcnException {
        CcnRspPocUtil.checkTableType(rsp.getTableType(), EXPECTED_POC_TBL_TYPES);
        int blockNo = CcnRspPocUtil.parseBlockNo(rsp);
        if (6 == blockNo) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return buf[9] & 0xFF;
        }
        throw new CcnException(6488167, "PocTable - Need block 6 to getDataTableEndBlock");
    }
}

