/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnTimeScheduleEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.util.CcnErrorCodes;
import com.tridium.ccn.util.CcnRspPocUtil;

public final class CcnRspDataUtil
extends CcnRspPocUtil
implements CcnErrorCodes {
    public static String getValue(CcnResponseMessage rsp, int index, BCcnPointEntry entry) throws CcnException {
        if (rsp.getTableType() > 63) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return CcnRspDataUtil.getNextValue(buf, index, entry);
        }
        throw new CcnException(6488168, "DataTable: " + rsp.getTableType() + " - Data Table type not valid to getValue");
    }

    public static String getValue(CcnResponseMessage rsp, int index, BCcnProxyExt entry) throws CcnException {
        if (rsp.getTableType() > 63) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            return CcnRspDataUtil.getNextValue(buf, index, entry);
        }
        throw new CcnException(6488168, "DataTable: " + rsp.getTableType() + " - Data Table type not valid to getValue");
    }

    public static void setProxyReadValue(CcnResponseMessage rsp, int index, BCcnProxyExt proxy) {
        if (proxy instanceof BCcnInputProxy && rsp.getTableType() > 63) {
            byte[] buf = rsp.getResponseBuffer().getResponseData();
            String strValue = CcnRspDataUtil.getNextValue(buf, index, proxy);
            ((BCcnInputProxy)proxy).setValue(strValue);
        }
    }

    public static BCcnTimeScheduleEntry[] buildTimeSchedules(BCcnPointEntry[] pointEntries) {
        BCcnTimeScheduleEntry[] tsList = new BCcnTimeScheduleEntry[8];
        for (int i = 1; i <= 24; i += 3) {
            int j = (i - 1) / 3;
            int pointValue = 0;
            String tempValue = pointEntries[i].getPointValue();
            if (tempValue != null) {
                pointValue = Integer.parseInt(tempValue, 2);
            }
            boolean mon = (pointValue & 0x80) == 128;
            boolean tues = (pointValue & 0x40) == 64;
            boolean wed = (pointValue & 0x20) == 32;
            boolean thur = (pointValue & 0x10) == 16;
            boolean fri = (pointValue & 8) == 8;
            boolean sat = (pointValue & 4) == 4;
            boolean sun = (pointValue & 2) == 2;
            boolean holiday = (pointValue & 1) == 1;
            String from = pointEntries[i + 1].getPointValue();
            String to = pointEntries[i + 2].getPointValue();
            String period = "Period" + (j + 1);
            tsList[j] = new BCcnTimeScheduleEntry(mon, tues, wed, thur, fri, sat, sun, holiday, from, to, period);
        }
        return tsList;
    }
}

