/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.util;

import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.util.CcnErrorCodes;

public abstract class CcnBlkPicPocUtil
implements CcnErrorCodes,
CcnMessageConst {
    public static int[] EXPECTED_PICPOC_TBL_TYPES = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24};

    public static void setFieldName(byte[] block, int index, String name) throws CcnException {
        byte[] pointNameBA = name.getBytes();
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 0;
        int nBytes = 8;
        for (int i = 0; i < nBytes; ++i) {
            block[sBtye + i] = i <= pointNameBA.length - 1 ? pointNameBA[i] : (byte)0;
        }
    }

    public static void setDisplayType(byte[] block, int index, boolean dt) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 8;
        block[sBtye] = dt ? (byte)(block[sBtye] | 0x80) : (byte)(block[sBtye] & 0x7F);
    }

    public static void setDataType(byte[] block, int index, byte dt) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 8;
        block[sBtye] = (byte)(block[sBtye] & 0x80);
        block[sBtye] = (byte)(block[sBtye] | dt);
    }

    public static void setDisplayDigits(byte[] block, int index, byte dd, BCcnPointEntry pe) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 9;
        int dt = pe.getPointDataType();
        if (dt != 12 && (16 > dt || dt > 34) && dt != 51) {
            block[sBtye] = dd;
        }
    }

    public static void setFieldByteCount(byte[] block, int index, byte bc, BCcnPointEntry pe) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 9;
        int dt = pe.getPointDataType();
        if (dt == 16 || dt == 17 || 32 <= dt && dt <= 34) {
            block[sBtye] = bc;
        }
    }

    public static void setDiscreteTextOffset(byte[] block, int index, byte dto, BCcnPointEntry pe) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 9;
        int cf = pe.getConfigFlags();
        if ((cf & 0x80) != 0) {
            block[sBtye] = dto;
        }
    }

    public static void setConfigFlags(byte[] block, int index, byte cf) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 10;
        block[sBtye] = cf;
    }

    public static void setUnits(byte[] block, int index, int units) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 12) + 11;
        block[sBtye] = (byte)units;
    }

    public static void setDataTableType(byte[] block, int dtt) throws CcnException {
        block[0] = (byte)(dtt >> 8 & 0xFF);
        block[1] = (byte)(dtt & 0xFF);
    }

    public static void setDataBlock(byte[] block, int bn) throws CcnException {
        block[2] = (byte)(bn & 0xFF);
    }

    public static void setStrDataBlock(byte[] block, int bn) throws CcnException {
        block[5] = (byte)(bn & 0xFF);
    }

    public static void setEndDataBlock(byte[] block, int bn) throws CcnException {
        block[6] = (byte)(bn & 0xFF);
    }

    public static void setVariableNum(byte[] block, int index, int vn) throws CcnException {
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 2) + 0;
        block[sBtye] = (byte)(vn >> 8 & 0xFF);
        block[sBtye + 1] = (byte)(vn & 0xFF);
    }

    public static void setDescription(byte[] block, int index, String desc) throws CcnException {
        byte[] pointDescBA = desc.getBytes();
        int sBtye = CcnBlkPicPocUtil.getStartOffset(index, 24) + 0;
        int nBytes = 24;
        for (int i = 0; i < nBytes; ++i) {
            block[sBtye + i] = i <= pointDescBA.length - 1 ? pointDescBA[i] : (byte)0;
        }
    }

    protected static int getStartOffset(int index, int size) throws CcnException {
        if (0 <= index && index <= 59) {
            return index % (240 / size) * size;
        }
        throw new CcnException(6488269, "Field index must be between 0-59");
    }
}

