/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.job.BCcnAddPICPointsJob;
import com.tridium.ccn.job.BCcnLearnPICPointsJob;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnRspPicUtil;
import java.util.Vector;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pointList", type="BCcnPointList", defaultValue="new BCcnPointList()", flags=4), @NiagaraProperty(name="pointLearnCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="pointCreateCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="pointForceRefresh", type="boolean", defaultValue="false", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="submitPointDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="submitAddPointsJob", parameterType="BCcnPointList", defaultValue="new BCcnPointList()", returnType="BOrd", flags=4)})
public class BCcnPicTable
extends BCcnTable {
    @Generated
    public static final Property pointList = BCcnPicTable.newProperty((int)4, (BValue)new BCcnPointList(), null);
    @Generated
    public static final Property pointLearnCount = BCcnPicTable.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property pointCreateCount = BCcnPicTable.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property pointForceRefresh = BCcnPicTable.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Action submitPointDiscoveryJob = BCcnPicTable.newAction((int)4, null);
    @Generated
    public static final Action submitAddPointsJob = BCcnPicTable.newAction((int)4, (BValue)new BCcnPointList(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnPicTable.class);
    private boolean changingDisplay = false;
    private boolean forceRefresh = false;
    private long checkTime = 0L;
    private int forceRefreshInterval = 0;
    BCcnTableEntry entry;
    BCcnProxyExt[] exts = new BCcnProxyExt[0];
    Vector<BCcnProxyExt> pointsVector = new Vector(0);
    BCcnDevice ccnDevice;
    BCcnNetwork ccnNetwork;

    @Override
    @Generated
    public BCcnPointList getPointList() {
        return (BCcnPointList)this.get(pointList);
    }

    @Override
    @Generated
    public void setPointList(BCcnPointList v) {
        this.set(pointList, (BValue)v, null);
    }

    @Generated
    public int getPointLearnCount() {
        return this.getInt(pointLearnCount);
    }

    @Override
    @Generated
    public void setPointLearnCount(int v) {
        this.setInt(pointLearnCount, v, null);
    }

    @Generated
    public int getPointCreateCount() {
        return this.getInt(pointCreateCount);
    }

    @Generated
    public void setPointCreateCount(int v) {
        this.setInt(pointCreateCount, v, null);
    }

    @Generated
    public boolean getPointForceRefresh() {
        return this.getBoolean(pointForceRefresh);
    }

    @Generated
    public void setPointForceRefresh(boolean v) {
        this.setBoolean(pointForceRefresh, v, null);
    }

    @Generated
    public BOrd submitPointDiscoveryJob() {
        return (BOrd)this.invoke(submitPointDiscoveryJob, null, null);
    }

    @Generated
    public BOrd submitAddPointsJob(BCcnPointList parameter) {
        return (BOrd)this.invoke(submitAddPointsJob, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        try {
            super.started();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
    }

    public BCcnPicTable() {
    }

    public BCcnPicTable(BCcnTableEntry entry) {
        super(entry);
        this.entry = entry;
        this.setTableBlockCount(entry.getBlockCount());
        this.setTableType(entry.getTableType());
        this.setTableTypeString(entry.getTableTypeString());
        this.setTableInstance(entry.getTableInstance());
        this.setTableNum(entry.getTableNum());
        this.setTableName(entry.getTableName());
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        if (child instanceof BCcnPocTable || child instanceof BCcnDataTable) {
            throw new LocalizableRuntimeException("ccn", "CcnPocTable and CcnDataTable nodes may not be under a CcnPicTable node");
        }
        return true;
    }

    public BOrd doSubmitPointDiscoveryJob() {
        BCcnLearnPICPointsJob job = new BCcnLearnPICPointsJob(this);
        return job.submit(null);
    }

    public BOrd doSubmitAddPointsJob(BCcnPointList pointList) {
        BCcnAddPICPointsJob job = new BCcnAddPICPointsJob(this, pointList);
        return job.submit(null);
    }

    @Override
    public void getExistingObjectArray(BComponent n, Vector<BCcnProxyExt> pointsVector) {
        BComponent[] children = n.getChildComponents();
        for (int i = 0; i < children.length; ++i) {
            BCcnProxyExt child;
            if (children[i] instanceof BCcnProxyExt && !pointsVector.contains(child = (BCcnProxyExt)children[i])) {
                pointsVector.addElement(child);
            }
            this.getExistingObjectArray(children[i], pointsVector);
        }
    }

    @Override
    public void pollForData() {
        boolean statusTableType;
        BCcnDevice device = this.getCcnDevice();
        if (this.getCCNNetwork().isDiscoveryInProgress() || !device.isRunning() || this.getCCNNetwork().isChangingDisplay() || this.changingDisplay || this.getPointCreateCount() == 0) {
            return;
        }
        long startTime = BAbsTime.now().getTimeOfDayMillis();
        CcnResponseMessage rspData = null;
        CcnResponseMessage rspStatus = null;
        int tableType = this.getTableType();
        this.ccnSubscribedPointLog.trace("Number of subscribed points-->::Device::" + device.getDeviceName() + "::Table-->" + this.getTableName() + " are::" + this.vPollAttributeProxyExts.size());
        boolean bl = statusTableType = tableType == 17 || tableType == 18;
        if (this.vPollAttributeProxyExts.size() == 0) {
            return;
        }
        rspData = this.getReadTableResponse(5);
        this.ccnTablesLog.trace(this.getTableName() + " Poll Response for table type::" + tableType + "is" + (Object)((Object)rspData));
        if (rspData == null) {
            return;
        }
        if (statusTableType && (rspStatus = this.getReadTableResponse(6)) == null) {
            return;
        }
        this.ccnTablesLog.trace(this.getTableName() + " Poll Response status for table type::" + tableType + "is" + (Object)((Object)rspStatus));
        for (int i = 0; i < this.vPollAttributeProxyExts.size(); ++i) {
            try {
                BCcnProxyExt proxy = (BCcnProxyExt)this.vPollAttributeProxyExts.get(i);
                if (proxy == null) continue;
                CcnRspPicUtil.setProxyReadValue(rspData, proxy.getValueBlockOffset(), proxy);
                if (statusTableType) {
                    CcnRspPicUtil.setStatus(rspStatus, proxy);
                }
                proxy.setUnitsEnum(proxy.getUnitsEnum());
                continue;
            }
            catch (Exception ex) {
                System.out.println("Device->" + device.getName() + ", table->" + this.getTableName() + ", created points length->" + this.vPollAttributeProxyExts.size() + ", PIC poll for data exception::" + ex.getMessage());
            }
        }
        long endTime = BAbsTime.now().getTimeOfDayMillis();
        this.ccnTimeLog.trace("PIC_TABLE PollForData Device->" + device.getName() + ", table->" + this.getTableName() + ", polltime::" + (endTime - startTime) + "milli seconds");
    }
}

