/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.tables;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.BCcnNetwork;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BCcnPointList;
import com.tridium.ccn.components.BCcnTableEntry;
import com.tridium.ccn.components.BFidPointConfig;
import com.tridium.ccn.components.BFidPointList;
import com.tridium.ccn.enums.BCcnAlarmStatusEnum;
import com.tridium.ccn.enums.BCcnForceStatusEnum;
import com.tridium.ccn.exceptions.CcnException;
import com.tridium.ccn.job.BCcnAddFidPointsJob;
import com.tridium.ccn.job.BCcnLearnFidPointsJob;
import com.tridium.ccn.messages.CcnReadTableRequest;
import com.tridium.ccn.messages.CcnResponseMessage;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnNonForcableProxy;
import com.tridium.ccn.point.BCcnOutputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnPocTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnRspFidUtil;
import com.tridium.platCcn.CcnTableDef;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pointList", type="BCcnPointList", defaultValue="new BCcnPointList()", flags=4), @NiagaraProperty(name="fidPointList", type="BFidPointList", defaultValue="new BFidPointList()", flags=4), @NiagaraProperty(name="pointLearnCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="pointCreateCount", type="int", defaultValue="0", flags=1), @NiagaraProperty(name="setpointType", type="int", defaultValue="0"), @NiagaraProperty(name="learnedTimeSchedules", type="BFolder", defaultValue="new BFolder()", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="submitFidPointDiscoveryJob", returnType="BOrd", flags=4), @NiagaraAction(name="submitAddFidPointsJob", parameterType="BCcnPointList", defaultValue="new BCcnPointList()", returnType="BOrd", flags=4)})
public class BCcnFidTable
extends BCcnTable {
    @Generated
    public static final Property pointList = BCcnFidTable.newProperty((int)4, (BValue)new BCcnPointList(), null);
    @Generated
    public static final Property fidPointList = BCcnFidTable.newProperty((int)4, (BValue)new BFidPointList(), null);
    @Generated
    public static final Property pointLearnCount = BCcnFidTable.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property pointCreateCount = BCcnFidTable.newProperty((int)1, (int)0, null);
    @Generated
    public static final Property setpointType = BCcnFidTable.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property learnedTimeSchedules = BCcnFidTable.newProperty((int)4, (BValue)new BFolder(), null);
    @Generated
    public static final Action submitFidPointDiscoveryJob = BCcnFidTable.newAction((int)4, null);
    @Generated
    public static final Action submitAddFidPointsJob = BCcnFidTable.newAction((int)4, (BValue)new BCcnPointList(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnFidTable.class);
    private boolean changingDisplay = false;
    BCcnTableEntry entry;
    BCcnNetwork network;

    @Override
    @Generated
    public BCcnPointList getPointList() {
        return (BCcnPointList)this.get(pointList);
    }

    @Override
    @Generated
    public void setPointList(BCcnPointList v) {
        this.set(pointList, (BValue)v, null);
    }

    @Generated
    public BFidPointList getFidPointList() {
        return (BFidPointList)this.get(fidPointList);
    }

    @Generated
    public void setFidPointList(BFidPointList v) {
        this.set(fidPointList, (BValue)v, null);
    }

    @Generated
    public int getPointLearnCount() {
        return this.getInt(pointLearnCount);
    }

    @Override
    @Generated
    public void setPointLearnCount(int v) {
        this.setInt(pointLearnCount, v, null);
    }

    @Generated
    public int getPointCreateCount() {
        return this.getInt(pointCreateCount);
    }

    @Generated
    public void setPointCreateCount(int v) {
        this.setInt(pointCreateCount, v, null);
    }

    @Generated
    public int getSetpointType() {
        return this.getInt(setpointType);
    }

    @Generated
    public void setSetpointType(int v) {
        this.setInt(setpointType, v, null);
    }

    @Generated
    public BFolder getLearnedTimeSchedules() {
        return (BFolder)this.get(learnedTimeSchedules);
    }

    @Generated
    public void setLearnedTimeSchedules(BFolder v) {
        this.set(learnedTimeSchedules, (BValue)v, null);
    }

    @Generated
    public BOrd submitFidPointDiscoveryJob() {
        return (BOrd)this.invoke(submitFidPointDiscoveryJob, null, null);
    }

    @Generated
    public BOrd submitAddFidPointsJob(BCcnPointList parameter) {
        return (BOrd)this.invoke(submitAddFidPointsJob, (BValue)parameter, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCcnFidTable() {
    }

    public BCcnFidTable(BCcnTableEntry entry) {
        super(entry);
        this.entry = entry;
        this.setTableBlockCount(entry.getBlockCount());
        this.setTableInstance(entry.getTableInstance());
        this.setTableName(entry.getTableName());
        this.setTableNum(entry.getTableNum());
        this.setTableType(entry.getTableType());
        this.setTableTypeString(entry.getTableTypeString());
    }

    @Override
    public void started() {
        try {
            super.started();
            int[] newCommArray = new int[64];
            BCcnProxyExt[] createdPoints = this.getCreatedPoints();
            BCcnPointEntry[] pointList = (BCcnPointEntry[])this.getPointList().getChildren(BCcnPointEntry.class);
            if (pointList.length != 0 && this.getTableType() == 1281) {
                for (int i = 0; i < pointList.length; ++i) {
                    int fieldIndex = pointList[i].getFieldIndex();
                    if (createdPoints[fieldIndex] != null) {
                        if (!(createdPoints[fieldIndex] instanceof BCcnOutputProxy) && !(createdPoints[fieldIndex] instanceof BCcnNonForcableProxy)) continue;
                        if (!createdPoints[fieldIndex].isCommandable()) {
                            newCommArray[fieldIndex] = 1;
                            continue;
                        }
                        newCommArray[fieldIndex] = 0;
                        continue;
                    }
                    newCommArray[fieldIndex] = 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void stopped() throws Exception {
        super.stopped();
    }

    @Override
    public boolean isChildLegal(BComponent child) throws LocalizableRuntimeException {
        if (child instanceof BCcnPicTable || child instanceof BCcnPocTable || child instanceof BCcnDataTable) {
            throw new LocalizableRuntimeException("ccn", "CcnPicTable, CcnPocTable and CcnDataTable nodes may not be under a CcnFidTable node");
        }
        return true;
    }

    public BOrd doSubmitFidPointDiscoveryJob() {
        BCcnLearnFidPointsJob job = new BCcnLearnFidPointsJob(this);
        return job.submit(null);
    }

    public BOrd doSubmitAddFidPointsJob(BCcnPointList pointList) {
        BCcnAddFidPointsJob job = new BCcnAddFidPointsJob(this, pointList);
        return job.submit(null);
    }

    @Override
    public void pollForData() {
        BCcnDevice device = this.getCcnDevice();
        if (this.getCCNNetwork().isDiscoveryInProgress() || !device.isRunning() || this.getCCNNetwork().isChangingDisplay() || this.changingDisplay || this.getPointCreateCount() == 0) {
            return;
        }
        BCcnPointEntry[] pointList = (BCcnPointEntry[])this.getPointList().getChildren(BCcnPointEntry.class);
        int tableType = this.getTableType();
        int tableInstance = this.getTableInstance();
        long startTime = BAbsTime.now().getTimeOfDayMillis();
        if (this.vPollAttributeProxyExts.size() == 0) {
            return;
        }
        if (tableType == 1281) {
            CcnResponseMessage rsp = this.getReadTableResponse(1280, 1, 6);
            this.ccnTablesLog.trace(this.getTableName() + " Poll Resposne for tabletype::" + tableType + "is" + (Object)((Object)rsp));
            if (rsp == null) {
                return;
            }
            this.commSuccess(true);
            this.ccnSubscribedPointLog.trace("Number of subscribed points-->::Device::" + device.getDeviceName() + "::Table-->" + this.getTableName() + " are::" + this.vPollAttributeProxyExts.size());
            for (int i = 0; i < this.vPollAttributeProxyExts.size(); ++i) {
                BCcnProxyExt proxy = (BCcnProxyExt)this.vPollAttributeProxyExts.get(i);
                if (proxy == null || !(proxy instanceof BCcnInputProxy)) continue;
                try {
                    String currentValue;
                    byte currentForceLevel = 0;
                    byte currentStatus = 0;
                    String currentEUC = "";
                    BFidPointConfig fidConfig = this.getFidConfig(proxy.getFieldIndex());
                    if (fidConfig != null) {
                        currentEUC = fidConfig.getEUC();
                    }
                    if ((currentValue = CcnRspFidUtil.getValue(rsp, proxy.getFieldIndex(), currentEUC, proxy.getDisplayDigits())) == null) {
                        currentValue = "0";
                    }
                    currentStatus = CcnRspFidUtil.getStatus(rsp, proxy.getFieldIndex());
                    BCcnAlarmStatusEnum alarmStatus = BCcnAlarmStatusEnum.make(currentStatus);
                    ((BCcnInputProxy)proxy).setValue(currentValue);
                    currentForceLevel = CcnRspFidUtil.getForceLevel(rsp, proxy.getFieldIndex());
                    proxy.setForceLevel(CcnEnumsUtil.setProperForceLevel(BCcnForceStatusEnum.make(currentForceLevel).getTag()));
                    if (currentForceLevel == 4) {
                        ((BCcnInputProxy)proxy).setOverridden(true);
                    } else {
                        ((BCcnInputProxy)proxy).setOverridden(false);
                    }
                    String alarmStatusText = alarmStatus.getTag().equalsIgnoreCase("normal") ? "" : (alarmStatus.getTag().equalsIgnoreCase("HardwareCommError") ? "COMM..." : alarmStatus.getTag());
                    ((BCcnInputProxy)proxy).setFieldStatus(alarmStatusText);
                    continue;
                }
                catch (CcnException e) {
                    this.ccnTablesLog.error("<CcnFidTable: Fid table get No." + proxy.getFieldIndex() + " field from block 6 ERROR: " + (Object)((Object)e));
                }
            }
        } else {
            CcnResponseMessage rspData = null;
            if (tableType == 1284 || tableType == 1283 || tableType == 1285) {
                rspData = this.getReadTableResponse(2);
                this.ccnTablesLog.trace(this.getTableName() + " Poll Resposne for tabletype::" + tableType + "is" + (Object)((Object)rspData));
                if (rspData == null || this.vPollAttributeProxyExts.size() == 0) {
                    return;
                }
                this.ccnSubscribedPointLog.trace("Number of subscribed points-->::Device::" + device.getDeviceName() + "::Table-->" + this.getTableName() + " are::" + this.vPollAttributeProxyExts.size());
                for (int i = 0; i < this.vPollAttributeProxyExts.size(); ++i) {
                    try {
                        BCcnProxyExt proxy = (BCcnProxyExt)this.vPollAttributeProxyExts.get(i);
                        if (proxy == null || !(proxy instanceof BCcnInputProxy)) continue;
                        ((BCcnInputProxy)proxy).setValue(CcnRspFidUtil.getValue(rspData, proxy));
                        continue;
                    }
                    catch (Exception ex) {
                        this.ccnTablesLog.error("FID Poll value for device->" + device.getName() + ", table->" + this.getName() + ", point->" + pointList[i].getFieldName() + " error::" + ex.getMessage());
                    }
                }
            }
        }
        long endTime = BAbsTime.now().getTimeOfDayMillis();
        this.ccnTimeLog.trace("FID_TABLE PollForData Device->" + device.getName() + ", table->" + this.getTableName() + ", polltime::" + (endTime - startTime) + " milliseconds");
    }

    private BFidPointConfig getFidConfig(int pointIndex) {
        BFidPointConfig[] fidPointList = (BFidPointConfig[])this.getFidPointList().getChildren(BFidPointConfig.class);
        if (fidPointList != null) {
            for (int i = 0; i < fidPointList.length; ++i) {
                if (fidPointList[i].getPointIndex() != pointIndex) continue;
                return fidPointList[i];
            }
        }
        return null;
    }

    public void setProxyValueFromEntry(BCcnPointEntry curPointEntry, BCcnInputProxy curInput) {
        curInput.setValue(curPointEntry.getPointValue());
        curInput.setForceLevel(CcnEnumsUtil.setProperForceLevel(curPointEntry.getForceLevel().getTag()));
        curInput.setHiLimit(curPointEntry.getHiLimit());
        curInput.setLoLimit(curPointEntry.getLoLimit());
        curInput.setHiLimitBlock(curPointEntry.getHiLimitBlock());
        curInput.setLoLimitBlock(curPointEntry.getLoLimitBlock());
        curInput.setUnits(curPointEntry.getUnits());
        curInput.setUnitsEnum(curPointEntry.getUnitsEnum());
    }

    public CcnResponseMessage getReadTableResponse(int tableType, int tableInstance, int blockNo) {
        BCcnDevice ccnDevice = this.getCcnDevice();
        int busNum = ccnDevice.getBusNo();
        int localAddr = ccnDevice.getElemNo();
        this.network = this.getCCNNetwork();
        CcnResponseMessage rsp = new CcnResponseMessage();
        for (int i = 0; i < 3; ++i) {
            CcnTableDef tableDef = new CcnTableDef((byte)localAddr, (byte)busNum, null, (short)tableType, (byte)tableInstance, (byte)blockNo, 0, 0);
            CcnReadTableRequest req = new CcnReadTableRequest(tableDef);
            rsp = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp == null || rsp.getResponseCommand() != 6 || blockNo != rsp.getBlock() || tableInstance != rsp.getTableInstance() || tableType != rsp.getTableType()) continue;
            return rsp;
        }
        return null;
    }

    public BCcnPointEntry[] createDefaultTSConfigTable() {
        BCcnPointEntry[] pointEntries = new BCcnPointEntry[21];
        String[] entriesName = new String[]{"TS01", "TS02", "TS03", "TS04", "TS05", "TS06", "TS07", "TS08", "TS09", "TS10", "TS11", "TS12", "TS13", "TS14", "TS15", "TS16", "TS17", "TS18", "TS19", "TS20", "TS21"};
        String[] entriesDesc = new String[]{"Period 1: Occupied from", "Period 1: Occupied to", "Period 1: Day of Week", "Period 2: Occupied from", "Period 2: Occupied to", "Period 2: Day of Week", "Period 3: Occupied from", "Period 3: Occupied to", "Period 3: Day of Week", "Period 4: Occupied from", "Period 4: Occupied to", "Period 4: Day of Week", "Period 5: Occupied from", "Period 5: Occupied to", "Period 5: Day of Week", "Period 6: Occupied from", "Period 6: Occupied to", "Period 6: Day of Week", "Period 7: Occupied from", "Period 7: Occupied to", "Period 7: Day of Week"};
        for (int i = 0; i < 21; i += 3) {
            BCcnPointEntry pointEntry;
            pointEntries[i] = pointEntry = new BCcnPointEntry(i, entriesName[i], 12, false, 0, 1, 0, 0, 0, "", 2, i, 0, 0, "", 0, 0, "", 0, 0, 0, entriesDesc[i], false, "");
            pointEntries[i + 1] = pointEntry = new BCcnPointEntry(i + 1, entriesName[i + 1], 12, false, 0, 1, 0, 0, 0, "", 2, i + 1, 0, 0, "", 0, 0, "", 0, 0, 0, entriesDesc[i + 1], false, "");
            pointEntries[i + 2] = pointEntry = new BCcnPointEntry(i + 2, entriesName[i + 2], 0, false, -128, 1, 0, 0, 0, "", 2, i + 2, 0, 0, "0", 0, 0, "255", 0, 0, 0, entriesDesc[i + 2], false, "");
        }
        return pointEntries;
    }

    public BCcnPointEntry[] createDefaultHolConfigTable() {
        BCcnPointEntry[] pointEntries = new BCcnPointEntry[60];
        for (int i = 0; i < 30; ++i) {
            BCcnPointEntry pointEntry;
            pointEntries[i * 2] = pointEntry = new BCcnPointEntry(i * 2, "HOL" + CcnRspFidUtil.get2DigString(i * 2 + 1), 1, false, 32, 1, 0, 3, 0, "", 2, i * 2 + 0, 0, 0, "1", 0, 0, "12", 0, 0, 0, "Holiday " + (i + 1) + " - Month", false, "");
            pointEntries[i * 2 + 1] = pointEntry = new BCcnPointEntry(i * 2 + 1, "HOL" + CcnRspFidUtil.get2DigString(i * 2 + 2), 1, false, 32, 1, 0, 0, 0, "", 2, i * 2 + 1, 0, 0, "1", 0, 0, "31", 0, 0, 0, "Holiday " + (i + 1) + " - Day", false, "");
        }
        return pointEntries;
    }

    public CcnResponseMessage[] interrogateTableForPointData(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlockCount) {
        BCcnDevice ccnDevice = this.getCcnDevice();
        CcnResponseMessage[] curBlockResponses = new CcnResponseMessage[curBlockCount];
        if (!ccnDevice.isDeviceFID()) {
            for (int j = 2; j <= curBlockCount; ++j) {
                if ((20 <= curTableType && curTableType <= 22 || curTableType == 24) && (j == 5 || j == 9)) continue;
                ccnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
            }
        } else {
            for (int j = 1; j <= curBlockCount; ++j) {
                if (j == 1 && curTableType != 1281) continue;
                ccnDevice.getCcnNetwork().setDiscoveryInProgress(true);
                curBlockResponses[j - 1] = this.getBlockDataFromTable(curBusNo, curElemNo, curTableType, curTableInstance, j);
                if (curBlockResponses[j - 1] != null) continue;
                return null;
            }
        }
        return curBlockResponses;
    }

    private CcnResponseMessage getBlockDataFromTable(int curBusNo, int curElemNo, int curTableType, int curTableInstance, int curBlock) {
        CcnResponseMessage rsp = new CcnResponseMessage();
        for (int i = 0; i < 3; ++i) {
            rsp = new CcnResponseMessage();
            CcnReadTableRequest req = new CcnReadTableRequest(new CcnTableDef((byte)curElemNo, (byte)curBusNo, null, (short)curTableType, (byte)curTableInstance, (byte)curBlock, 0, 0));
            rsp = this.network.getCcnComm().ccnAsyncRequest().sendAsyncRequest(req);
            if (rsp != null && rsp.getResponseCommand() == 21) {
                return rsp;
            }
            if (rsp == null || rsp.getResponseCommand() != 6 || curBlock != rsp.getBlock() || curTableInstance != rsp.getTableInstance() || curTableType != rsp.getTableType()) continue;
            return rsp;
        }
        if (rsp != null) {
            this.ccnTablesLog.trace("\n****  createTablesRequest... return from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock + " blockLen= " + rsp.getBlockLen());
        }
        if (rsp == null) {
            this.ccnTablesLog.error("\n****  createTablesRequest... getBlockDataFromTable failed to get block from block read, device: " + curBusNo + "," + curElemNo + " for table= " + Integer.toHexString(curTableType) + "," + curTableInstance + " curBlock= " + curBlock);
        }
        return rsp;
    }
}

