/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.messages;

import com.tridium.ccn.BCcnDevice;
import com.tridium.ccn.components.BCcnPointEntry;
import com.tridium.ccn.components.BFidPointConfig;
import com.tridium.ccn.messages.CcnMessageConst;
import com.tridium.ccn.point.BCcnFidOutputProxy;
import com.tridium.ccn.point.BCcnInputProxy;
import com.tridium.ccn.point.BCcnNonForcableProxy;
import com.tridium.ccn.point.BCcnOutputProxy;
import com.tridium.ccn.point.BCcnProxyExt;
import com.tridium.ccn.tables.BCcnDataTable;
import com.tridium.ccn.tables.BCcnFidTable;
import com.tridium.ccn.tables.BCcnPicTable;
import com.tridium.ccn.tables.BCcnTable;
import com.tridium.ccn.util.AsynchronousRequest;
import com.tridium.ccn.util.CcnEnumsUtil;
import com.tridium.ccn.util.CcnUtil;
import com.tridium.ccn.util.TargetNameContainer;
import com.tridium.util.ObjectUtil;
import java.util.HashMap;
import java.util.Vector;
import javax.baja.control.BControlPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BNumber;
import javax.baja.sys.BValue;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;

public class CcnCreatePointsRequest
implements AsynchronousRequest,
CcnMessageConst {
    private BCcnPointEntry[] pointList;
    private BCcnPointEntry point;
    private BCcnDevice device;
    private BCcnTable table;
    private boolean refresh = false;
    private boolean upload = false;
    private BSimpleJob job;
    BControlPoint pnt;
    Log ccnMessageLog = Log.getLog((String)"CCNMessagesLog");

    public CcnCreatePointsRequest(BCcnTable table, BCcnPointEntry[] pointList, BSimpleJob job) {
        this.device = table.getCcnDevice();
        this.table = table;
        this.job = table instanceof BCcnPicTable ? job : (table instanceof BCcnDataTable ? job : null);
        this.pointList = pointList;
        this.refresh = false;
        this.upload = false;
    }

    public CcnCreatePointsRequest(BCcnTable table, BCcnPointEntry[] pointList, boolean refresh, boolean upload) {
        this.device = table.getCcnDevice();
        this.table = table;
        this.pointList = pointList;
        this.refresh = refresh;
        this.upload = upload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        if (!this.device.isDeviceStatusOk()) {
            throw new LocalizableRuntimeException("ccn", "CcnCreatePoint.add");
        }
        boolean curOverwriteState = false;
        if (this.refresh || this.upload) {
            curOverwriteState = this.table.getOverwriteExisting();
            this.table.setOverwriteExisting(true);
            for (int i = 0; i < 64; ++i) {
                this.table.addToPointArrays(null, i);
            }
        }
        int tableType = this.table.getTableType();
        int tableInstance = this.table.getTableInstance();
        String tableName = this.table.getTableName();
        this.table.setLearnStatus("Create: tableType:instance " + tableType + ":" + tableInstance + " CcnObjects... ");
        this.ccnMessageLog.trace("<CcnCreatePointsRequest: tableName:tableType:instance " + tableName + ":" + tableType + ":" + tableInstance + " CcnObjects... >");
        boolean lastPollDisabled = this.table.getDisablePoll();
        this.table.setDisablePoll(true);
        try {
            this.ccnMessageLog.trace("<CcnCreatePointsRequest: tableName:tableType:instance " + tableName + ":" + tableType + ":" + tableInstance + " CcnObjects... points " + this.pointList.length + " >");
            for (int i = 0; i < this.pointList.length; ++i) {
                int idx;
                String nam;
                block92: {
                    BCcnInputProxy[] iObj;
                    boolean isNewPoint;
                    block99: {
                        BCcnProxyExt[] existingObjects;
                        block97: {
                            BCcnFidTable fidTable;
                            TypeInfo pntType;
                            String controlPointType;
                            String pointName;
                            String hiLimit;
                            String loLimit;
                            block100: {
                                BCcnDataTable dataTable;
                                block98: {
                                    BCcnPicTable picTable;
                                    block90: {
                                        BCcnOutputProxy[] oObj;
                                        block95: {
                                            block93: {
                                                block96: {
                                                    block94: {
                                                        block91: {
                                                            int j;
                                                            BCcnFidOutputProxy[] foObj;
                                                            this.point = new BCcnPointEntry(this.pointList[i]);
                                                            this.ccnMessageLog.trace("<CcnCreatePointsRequest: tableName:point " + tableName + ":" + (Object)((Object)this.point) + " >");
                                                            nam = this.point.getFieldName().trim();
                                                            idx = this.point.getFieldIndex();
                                                            loLimit = this.point.getLoLimit();
                                                            hiLimit = this.point.getHiLimit();
                                                            if (nam == null || nam.length() == 0) {
                                                                this.ccnMessageLog.trace("<CcnCreatePointsRequest: skipping point create, name is null, table:point details are " + tableName + ":" + (Object)((Object)this.point) + " >");
                                                                continue;
                                                            }
                                                            if (this.job != null) {
                                                                this.job.progress((100 * i + 1) / (i + 1));
                                                            }
                                                            if (!(this.job == null || this.job.isAlive() && this.job.getJobState() != BJobState.canceled)) {
                                                                this.job.setJobState(BJobState.canceled);
                                                                break;
                                                            }
                                                            this.table.setLearnStatus("Create: tableName:tableType:instance " + tableName + ":" + tableType + ":" + tableInstance + " CcnObjects... PointEntry(" + (idx + 1) + ")" + nam);
                                                            pointName = ObjectUtil.generateUniqueName((String)nam, (ObjectUtil.NameContainer)new TargetNameContainer(this.table, new HashMap<String, BComponent>()));
                                                            if (!SlotPath.isValidName((String)pointName)) {
                                                                pointName = SlotPath.escape((String)pointName);
                                                            }
                                                            if ((existingObjects = this.findCcnObjects(this.table, idx)) != null) {
                                                                this.ccnMessageLog.trace("<CcnCreatePointsRequest: existingObjects found = " + existingObjects.length + " >");
                                                            }
                                                            isNewPoint = false;
                                                            if (existingObjects == null) {
                                                                String picType = this.device.getPicType();
                                                                if (picType.equalsIgnoreCase("64CC")) {
                                                                    existingObjects = this.findCcnObjects(this.table, -1);
                                                                    if (existingObjects == null) {
                                                                        if (this.upload || this.refresh) continue;
                                                                        isNewPoint = true;
                                                                    }
                                                                } else {
                                                                    if (this.upload || this.refresh) continue;
                                                                    isNewPoint = true;
                                                                }
                                                            }
                                                            if (!this.point.getForceableFlag()) break block90;
                                                            if (!(this.table instanceof BCcnFidTable) || this.table.getTableType() != 1281) break block91;
                                                            String controlPointType2 = "";
                                                            BCcnFidTable fidTable2 = (BCcnFidTable)this.table;
                                                            BFidPointConfig[] pointConfigs = (BFidPointConfig[])fidTable2.getFidPointList().getChildren(BFidPointConfig.class);
                                                            BFidPointConfig pointConfig = this.findDsFidPointConfig(pointConfigs, idx);
                                                            if (pointConfig == null) {
                                                                this.ccnMessageLog.trace("\n\n\n<CcnCreatePointsRequest CcnFidOutput: " + nam + " mismatch... fieldIndex=" + idx + " does not have a matching pointConfigIndex... cannot create point >");
                                                                this.ccnMessageLog.trace("\n<FidPointEntry: " + (Object)((Object)this.point));
                                                                this.ccnMessageLog.trace("\n<FidPointConfig: " + (Object)((Object)pointConfig) + "\n\n\n");
                                                                continue;
                                                            }
                                                            if (existingObjects == null && isNewPoint) {
                                                                foObj = new BCcnFidOutputProxy[1];
                                                                if (this.point.isDiscrete()) {
                                                                    switch (CcnUtil.getControlPointType(this.point)) {
                                                                        case 5: {
                                                                            controlPointType2 = "ccn:CcnBooleanWritable";
                                                                            foObj[0] = new BCcnFidOutputProxy(this.point);
                                                                        }
                                                                    }
                                                                } else {
                                                                    switch (CcnUtil.getControlPointType(this.point.getPointDataType())) {
                                                                        case 1: 
                                                                        case 2: {
                                                                            controlPointType2 = "ccn:CcnNumericWritable";
                                                                            foObj[0] = new BCcnFidOutputProxy(this.point);
                                                                            break;
                                                                        }
                                                                        case 5: {
                                                                            controlPointType2 = "ccn:CcnBooleanWritable";
                                                                            foObj[0] = new BCcnFidOutputProxy(this.point);
                                                                            break;
                                                                        }
                                                                        case 9: {
                                                                            controlPointType2 = "ccn:CcnStringWritable";
                                                                            foObj[0] = new BCcnFidOutputProxy(this.point);
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            controlPointType2 = "";
                                                                        }
                                                                    }
                                                                }
                                                                TypeInfo pntType2 = Sys.getRegistry().getType(controlPointType2);
                                                                this.pnt = (BControlPoint)pntType2.getInstance();
                                                                this.pnt.setProxyExt((BAbstractProxyExt)foObj[0]);
                                                                fidTable2.add(pointName, (BValue)this.pnt);
                                                                if (this.pnt instanceof BNumericWritable) {
                                                                    this.pnt.setFacets(BFacets.makeNumeric(null, (int)2, (double)Double.parseDouble(loLimit), (double)Double.parseDouble(hiLimit)));
                                                                }
                                                                fidTable2.setPointCreateCount(fidTable2.getPointCreateCount() + 1);
                                                            } else {
                                                                foObj = new BCcnFidOutputProxy[existingObjects.length];
                                                                for (j = 0; j < existingObjects.length; ++j) {
                                                                    foObj[j] = (BCcnFidOutputProxy)existingObjects[j];
                                                                }
                                                            }
                                                            this.ccnMessageLog.trace("<CcnCreatePointsRequest CcnFidOutput: " + nam + " isNewPoint=" + isNewPoint + " isOverwriteEnabled=" + this.table.getOverwriteExisting() + " number of Objects=" + foObj.length + " >");
                                                            for (j = 0; j < foObj.length; ++j) {
                                                                foObj[j].setFieldIndex(idx);
                                                                foObj[j].setFieldName(this.point.getFieldName());
                                                                foObj[j].setPointDataType(this.point.getPointDataType());
                                                                foObj[j].setDataTypeEnum(this.point.getDataTypeEnum());
                                                                foObj[j].setDisplayType(this.point.getDisplayType());
                                                                foObj[j].setDisplayDigits(this.point.getDisplayDigits());
                                                                foObj[j].setFieldByteCount(this.point.getFieldByteCount());
                                                                foObj[j].setDiscreteTextOffset(this.point.getDiscreteTextOffset());
                                                                foObj[j].setConfigFlags(this.point.getConfigFlags());
                                                                foObj[j].setUnits(this.point.getUnits());
                                                                foObj[j].setUnitsEnum(CcnEnumsUtil.setProperUnitsMappingEnum(this.point.getUnits()));
                                                                foObj[j].setValueBlock(this.point.getValueBlock());
                                                                foObj[j].setValueBlockOffset(this.point.getValueBlockOffset());
                                                                foObj[j].setForceLevel(CcnEnumsUtil.setProperForceLevel(this.point.getForceLevel().getTag()));
                                                                foObj[j].setLoLimit(this.point.getLoLimit());
                                                                foObj[j].setLoLimitBlock(this.point.getLoLimitBlock());
                                                                foObj[j].setLoLimitBlockOffset(this.point.getLoLimitBlockOffset());
                                                                foObj[j].setHiLimit(this.point.getHiLimit());
                                                                foObj[j].setHiLimitBlock(this.point.getHiLimitBlock());
                                                                foObj[j].setHiLimitBlockOffset(this.point.getHiLimitBlockOffset());
                                                                foObj[j].setVariableNo(this.point.getVariableNo());
                                                                foObj[j].setDescription(this.point.getDescription());
                                                                foObj[j].setForceableFlag(this.point.getForceableFlag());
                                                                foObj[j].setEUC(this.point.getEUC());
                                                                foObj[j].setDeviceType(pointConfig.getDeviceType());
                                                                foObj[j].setCtrlSensType(pointConfig.getCtrlSensType());
                                                                this.table.updateObject(null, 0, 0, foObj[j]);
                                                                this.table.addToPointArrays(foObj[j], idx);
                                                            }
                                                            this.ccnMessageLog.trace("<CcnCreatePointsRequest: 0 finished point " + i + " of " + this.pointList.length + " >");
                                                            break block92;
                                                        }
                                                        controlPointType = "";
                                                        if (existingObjects != null || !isNewPoint) break block93;
                                                        oObj = new BCcnOutputProxy[1];
                                                        if (nam.length() == 0) {
                                                            nam = "P";
                                                        }
                                                        if (!Character.isLetter(nam.charAt(0))) {
                                                            nam = "P_" + nam;
                                                        }
                                                        if (this.point.isDiscrete()) {
                                                            switch (CcnUtil.getControlPointType(this.point)) {
                                                                case 5: {
                                                                    controlPointType = "ccn:CcnBooleanWritable";
                                                                    oObj[0] = new BCcnOutputProxy(this.point);
                                                                }
                                                            }
                                                        } else {
                                                            switch (CcnUtil.getControlPointType(this.point.getPointDataType())) {
                                                                case 1: 
                                                                case 2: {
                                                                    controlPointType = "ccn:CcnNumericWritable";
                                                                    oObj[0] = new BCcnOutputProxy(this.point);
                                                                    break;
                                                                }
                                                                case 5: {
                                                                    controlPointType = "ccn:CcnBooleanWritable";
                                                                    oObj[0] = new BCcnOutputProxy(this.point);
                                                                    break;
                                                                }
                                                                case 9: {
                                                                    controlPointType = "ccn:CcnStringWritable";
                                                                    oObj[0] = new BCcnOutputProxy(this.point);
                                                                    break;
                                                                }
                                                                default: {
                                                                    controlPointType = "";
                                                                }
                                                            }
                                                        }
                                                        if (!(this.table instanceof BCcnPicTable)) break block94;
                                                        picTable = (BCcnPicTable)this.table;
                                                        pntType = Sys.getRegistry().getType(controlPointType);
                                                        this.pnt = (BControlPoint)pntType.getInstance();
                                                        this.pnt.setProxyExt((BAbstractProxyExt)oObj[0]);
                                                        picTable.add(pointName, (BValue)this.pnt);
                                                        if (this.pnt instanceof BNumericWritable) {
                                                            this.pnt.setFacets(BFacets.makeNumeric(null, (int)2, (double)Double.parseDouble(loLimit), (double)Double.parseDouble(hiLimit)));
                                                        }
                                                        picTable.setPointCreateCount(picTable.getPointCreateCount() + 1);
                                                        break block95;
                                                    }
                                                    if (!(this.table instanceof BCcnDataTable)) break block96;
                                                    dataTable = (BCcnDataTable)this.table;
                                                    pntType = Sys.getRegistry().getType(controlPointType);
                                                    this.pnt = (BControlPoint)pntType.getInstance();
                                                    this.pnt.setProxyExt((BAbstractProxyExt)oObj[0]);
                                                    dataTable.add(pointName, (BValue)this.pnt);
                                                    if (this.pnt instanceof BNumericWritable) {
                                                        this.pnt.setFacets(BFacets.makeNumeric(null, (int)2, (double)Double.parseDouble(loLimit), (double)Double.parseDouble(hiLimit)));
                                                    }
                                                    dataTable.setPointCreateCount(dataTable.getPointCreateCount() + 1);
                                                    break block95;
                                                }
                                                if (!(this.table instanceof BCcnFidTable)) break block95;
                                                fidTable = (BCcnFidTable)this.table;
                                                pntType = Sys.getRegistry().getType(controlPointType);
                                                this.pnt = (BControlPoint)pntType.getInstance();
                                                this.pnt.setProxyExt((BAbstractProxyExt)oObj[0]);
                                                if (this.pnt instanceof BNumericWritable) {
                                                    this.pnt.setFacets(BFacets.makeNumeric(null, (int)2, (double)Double.parseDouble(loLimit), (double)Double.parseDouble(hiLimit)));
                                                }
                                                fidTable.setPointCreateCount(fidTable.getPointCreateCount() + 1);
                                                break block95;
                                            }
                                            oObj = new BCcnOutputProxy[existingObjects.length];
                                            for (int j = 0; j < existingObjects.length; ++j) {
                                                oObj[j] = (BCcnOutputProxy)existingObjects[j];
                                            }
                                        }
                                        if (this.table.getOverwriteExisting() || isNewPoint) {
                                            this.ccnMessageLog.trace("<CcnCreatePointsRequest CcnOutput: " + nam + " isNewPoint=" + isNewPoint + " isOverwriteEnabled=" + this.table.getOverwriteExisting() + " number of Objects=" + oObj.length + " >");
                                            for (int j = 0; j < oObj.length; ++j) {
                                                oObj[j].setFieldIndex(this.point.getFieldIndex());
                                                oObj[j].setFieldName(this.point.getFieldName().trim());
                                                oObj[j].setPointDataType(this.point.getPointDataType());
                                                oObj[j].setDataTypeEnum(this.point.getDataTypeEnum());
                                                oObj[j].setDisplayType(this.point.getDisplayType());
                                                oObj[j].setDisplayDigits(this.point.getDisplayDigits());
                                                oObj[j].setFieldByteCount(this.point.getFieldByteCount());
                                                oObj[j].setDiscreteTextOffset(this.point.getDiscreteTextOffset());
                                                oObj[j].setConfigFlags(this.point.getConfigFlags());
                                                oObj[j].setUnits(this.point.getUnits());
                                                oObj[j].setUnitsEnum(this.point.getUnitsEnum());
                                                oObj[j].setValue(this.point.getPointValue());
                                                oObj[j].setValueBlock(this.point.getValueBlock());
                                                oObj[j].setValueBlockOffset(this.point.getValueBlockOffset());
                                                String alarmStatus = this.point.getAlrmStatus().getTag().equalsIgnoreCase("normal") ? "" : (this.point.getAlrmStatus().getTag().equalsIgnoreCase("hardwareCommError") ? "COMM..." : this.point.getAlrmStatus().getTag());
                                                oObj[j].setFieldStatus(alarmStatus);
                                                oObj[j].setForceLevel(CcnEnumsUtil.setProperForceLevel(this.point.getForceLevel().getTag()));
                                                oObj[j].setLoLimit(this.point.getLoLimit());
                                                oObj[j].setLoLimitBlock(this.point.getLoLimitBlock());
                                                oObj[j].setLoLimitBlockOffset(this.point.getLoLimitBlockOffset());
                                                oObj[j].setHiLimit(this.point.getHiLimit());
                                                oObj[j].setHiLimitBlock(this.point.getHiLimitBlock());
                                                oObj[j].setHiLimitBlockOffset(this.point.getHiLimitBlockOffset());
                                                oObj[j].setVariableNo(this.point.getVariableNo());
                                                oObj[j].setDescription(this.point.getDescription());
                                                oObj[j].setForceableFlag(this.point.getForceableFlag());
                                                oObj[j].setValue(this.point.getPointValue());
                                                oObj[j].setEUC(this.point.getEUC());
                                                this.table.updateObject(this.point, 0, 0, oObj[j]);
                                                this.table.addToPointArrays(oObj[j], oObj[j].getFieldIndex());
                                            }
                                        }
                                        break block92;
                                    }
                                    if (existingObjects != null || !isNewPoint) break block97;
                                    iObj = new BCcnInputProxy[1];
                                    controlPointType = "";
                                    if (this.table.isConfigurationType() || this.table.isSetpointType()) {
                                        if (this.point.isDiscrete()) {
                                            switch (CcnUtil.getControlPointType(this.point)) {
                                                case 5: {
                                                    controlPointType = "ccn:CcnBooleanWritable";
                                                    iObj[0] = new BCcnNonForcableProxy(this.point);
                                                }
                                            }
                                        } else {
                                            switch (CcnUtil.getControlPointType(this.point.getPointDataType())) {
                                                case 1: 
                                                case 2: {
                                                    controlPointType = "ccn:CcnNumericWritable";
                                                    iObj[0] = new BCcnNonForcableProxy(this.point);
                                                    break;
                                                }
                                                case 10: 
                                                case 11: {
                                                    controlPointType = "control:NumericPoint";
                                                    iObj[0] = new BCcnNonForcableProxy(this.point);
                                                    break;
                                                }
                                                case 5: {
                                                    controlPointType = "ccn:CcnBooleanWritable";
                                                    iObj[0] = new BCcnNonForcableProxy(this.point);
                                                    break;
                                                }
                                                case 14: {
                                                    controlPointType = "control:BooleanPoint";
                                                    iObj[0] = new BCcnNonForcableProxy(this.point);
                                                    break;
                                                }
                                                case 9: {
                                                    controlPointType = "ccn:CcnStringWritable";
                                                    iObj[0] = new BCcnNonForcableProxy(this.point);
                                                    break;
                                                }
                                                case 18: {
                                                    controlPointType = "control:StringPoint";
                                                    iObj[0] = new BCcnNonForcableProxy(this.point);
                                                    break;
                                                }
                                                default: {
                                                    controlPointType = "";
                                                    break;
                                                }
                                            }
                                        }
                                    } else if (this.point.isDiscrete()) {
                                        switch (CcnUtil.getControlPointType(this.point)) {
                                            case 5: 
                                            case 14: {
                                                controlPointType = "control:BooleanPoint";
                                                iObj[0] = new BCcnNonForcableProxy(this.point);
                                            }
                                        }
                                    } else {
                                        switch (CcnUtil.getControlPointType(this.point.getPointDataType())) {
                                            case 1: 
                                            case 2: 
                                            case 10: 
                                            case 11: {
                                                controlPointType = "control:NumericPoint";
                                                iObj[0] = new BCcnInputProxy(this.point);
                                                break;
                                            }
                                            case 5: {
                                                controlPointType = "ccn:CcnBooleanWritable";
                                                iObj[0] = new BCcnInputProxy(this.point);
                                                break;
                                            }
                                            case 14: {
                                                controlPointType = "control:BooleanPoint";
                                                iObj[0] = new BCcnInputProxy(this.point);
                                                break;
                                            }
                                            case 9: 
                                            case 18: {
                                                controlPointType = "control:StringPoint";
                                                iObj[0] = new BCcnInputProxy(this.point);
                                                break;
                                            }
                                            default: {
                                                controlPointType = "";
                                            }
                                        }
                                    }
                                    if (nam.length() == 0) {
                                        nam = "P";
                                    }
                                    if (!Character.isLetter(nam.charAt(0))) {
                                        nam = "P_" + nam;
                                    }
                                    if (!(this.table instanceof BCcnPicTable)) break block98;
                                    picTable = (BCcnPicTable)this.table;
                                    pntType = Sys.getRegistry().getType(controlPointType);
                                    this.pnt = (BControlPoint)pntType.getInstance();
                                    this.pnt.setProxyExt((BAbstractProxyExt)iObj[0]);
                                    picTable.add(pointName, (BValue)this.pnt);
                                    if (this.pnt instanceof BNumericWritable) {
                                        this.pnt.setFacets(BFacets.makeNumeric(null, (BInteger)BInteger.make((int)2), (BNumber)BDouble.make((String)loLimit), (BNumber)BDouble.make((String)hiLimit)));
                                    }
                                    picTable.setPointCreateCount(picTable.getPointCreateCount() + 1);
                                    break block99;
                                }
                                if (!(this.table instanceof BCcnDataTable)) break block100;
                                dataTable = (BCcnDataTable)this.table;
                                pntType = Sys.getRegistry().getType(controlPointType);
                                this.pnt = (BControlPoint)pntType.getInstance();
                                this.pnt.setProxyExt((BAbstractProxyExt)iObj[0]);
                                dataTable.add(pointName, (BValue)this.pnt);
                                if (this.pnt instanceof BNumericWritable) {
                                    this.pnt.setFacets(BFacets.makeNumeric(null, (int)2, (double)Double.parseDouble(loLimit), (double)Double.parseDouble(hiLimit)));
                                }
                                dataTable.setPointCreateCount(dataTable.getPointCreateCount() + 1);
                                break block99;
                            }
                            if (!(this.table instanceof BCcnFidTable)) break block99;
                            fidTable = (BCcnFidTable)this.table;
                            pntType = Sys.getRegistry().getType(controlPointType);
                            this.pnt = (BControlPoint)pntType.getInstance();
                            this.pnt.setProxyExt((BAbstractProxyExt)iObj[0]);
                            fidTable.add(pointName, (BValue)this.pnt);
                            if (this.pnt instanceof BNumericWritable) {
                                this.pnt.setFacets(BFacets.makeNumeric(null, (int)2, (double)Double.parseDouble(loLimit), (double)Double.parseDouble(hiLimit)));
                            }
                            fidTable.setPointCreateCount(fidTable.getPointCreateCount() + 1);
                            break block99;
                        }
                        iObj = new BCcnInputProxy[existingObjects.length];
                        for (int j = 0; j < existingObjects.length; ++j) {
                            iObj[j] = (BCcnInputProxy)existingObjects[j];
                        }
                    }
                    if (this.table.getOverwriteExisting() || isNewPoint) {
                        this.ccnMessageLog.trace("<CcnCreatePointsRequest CcnInput: " + nam + " isNewPoint=" + isNewPoint + " isOverwriteEnabled=" + this.table.getOverwriteExisting() + " number of Objects=" + iObj.length + " >");
                        for (int j = 0; j < iObj.length; ++j) {
                            iObj[j].setFieldIndex(this.point.getFieldIndex());
                            iObj[j].setFieldName(this.point.getFieldName().trim());
                            iObj[j].setDescription(this.point.getDescription());
                            iObj[j].setPointDataType(this.point.getPointDataType());
                            iObj[j].setDataTypeEnum(this.point.getDataTypeEnum());
                            iObj[j].setDisplayType(this.point.getDisplayType());
                            iObj[j].setDisplayDigits(this.point.getDisplayDigits());
                            iObj[j].setFieldByteCount(this.point.getFieldByteCount());
                            iObj[j].setDiscreteTextOffset(this.point.getDiscreteTextOffset());
                            iObj[j].setConfigFlags(this.point.getConfigFlags());
                            iObj[j].setUnits(this.point.getUnits());
                            iObj[j].setUnitsEnum(this.point.getUnitsEnum());
                            iObj[j].setValue(this.point.getPointValue());
                            iObj[j].setValueBlock(this.point.getValueBlock());
                            iObj[j].setValueBlockOffset(this.point.getValueBlockOffset());
                            String alarmStatus = this.point.getAlrmStatus().getTag().equalsIgnoreCase("Normal") ? "" : (this.point.getAlrmStatus().getTag().equalsIgnoreCase("hardwareCommError") ? "COMM..." : this.point.getAlrmStatus().getTag());
                            iObj[j].setFieldStatus(alarmStatus);
                            iObj[j].setForceLevel(CcnEnumsUtil.setProperForceLevel(this.point.getForceLevel().getTag()));
                            iObj[j].setLoLimit(this.point.getLoLimit());
                            iObj[j].setLoLimitBlock(this.point.getLoLimitBlock());
                            iObj[j].setLoLimitBlockOffset(this.point.getLoLimitBlockOffset());
                            iObj[j].setHiLimit(this.point.getHiLimit());
                            iObj[j].setHiLimitBlock(this.point.getHiLimitBlock());
                            iObj[j].setHiLimitBlockOffset(this.point.getHiLimitBlockOffset());
                            iObj[j].setVariableNo(this.point.getVariableNo());
                            iObj[j].setForceableFlag(this.point.getForceableFlag());
                            iObj[j].setValue(this.point.getPointValue());
                            iObj[j].setEUC(this.point.getEUC());
                            this.table.updateObject(null, 0, 0, iObj[j]);
                            this.table.addToPointArrays(iObj[j], iObj[j].getFieldIndex());
                        }
                    }
                }
                this.table.setLearnStatus("Create: tableType:instance " + tableType + ":" + tableInstance + " CcnObjects... PointEntry(" + (idx + 1) + ")" + nam + " complete");
            }
        }
        catch (Exception e) {
            this.ccnMessageLog.error("<CcnCreatePointsRequest: Exception " + e + " >");
            e.printStackTrace();
        }
        catch (Throwable t) {
            this.ccnMessageLog.error("<CcnCreatePointsRequest: Throwable " + t + " >");
        }
        finally {
            this.table.setLearnStatus("Create: tableType:instance " + tableType + ":" + tableInstance + " CcnObjects... complete");
            this.table.setDisablePoll(lastPollDisabled);
            this.table.setLearnStatus("Idle");
            if (this.refresh || this.upload) {
                this.table.setOverwriteExisting(curOverwriteState);
            }
        }
    }

    private BCcnProxyExt[] findCcnObjects(BComponent _tab, int _index) {
        Vector<BCcnProxyExt> objV = new Vector<BCcnProxyExt>();
        BComponent[] childrenHandles = _tab.getChildComponents();
        for (int i = 0; i < childrenHandles.length; ++i) {
            BComponent nextChild = childrenHandles[i];
            if (nextChild instanceof BCcnOutputProxy || nextChild instanceof BCcnInputProxy || nextChild instanceof BCcnNonForcableProxy) {
                BCcnProxyExt obj1 = (BCcnProxyExt)nextChild;
                int index = obj1.getFieldIndex();
                if (index != _index) continue;
                objV.addElement(obj1);
                continue;
            }
            BCcnProxyExt[] recursObj = this.findCcnObjects(nextChild, _index);
            if (recursObj == null) continue;
            for (int j = 0; j < recursObj.length; ++j) {
                objV.addElement(recursObj[j]);
            }
        }
        if (objV.size() == 0) {
            return null;
        }
        Object[] mObjA = new BCcnProxyExt[objV.size()];
        objV.copyInto(mObjA);
        return mObjA;
    }

    public BFidPointConfig findDsFidPointConfig(BFidPointConfig[] pointConfigs, int fieldIndex) {
        for (int i = 0; i < pointConfigs.length; ++i) {
            if (pointConfigs[i].getPointIndex() != fieldIndex) continue;
            return new BFidPointConfig(pointConfigs[i]);
        }
        return null;
    }
}

